/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart;

import fr.unistra.ibmc.paradise.core.utils.HD2PDB;
import fr.unistra.ibmc.paradise.core.utils.ParsingException;
import fr.unistra.ibmc.paradise.core.utils.SystemTools;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.IBMCRnartAnalysis;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.IncNuc;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.MgrNuc;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.NucLSQ;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.Nuclin;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.RnartException;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.Tool;

public class NucMult
extends Thread {
    public String tmpPath = null;
    public String inPath = null;
    public String outPath = null;
    public float oldV = Float.MAX_VALUE;
    public float curV = Float.MAX_VALUE;
    public float tmpV = Float.MAX_VALUE;
    public int npass = 0;
    public float value = 0.0f;
    public int pourcent = 0;
    private int passOver;

    public NucMult(IBMCRnartAnalysis analysis, String mode, String pass, String tmpPath) throws RnartException {
        int i;
        System.err.println("Starting rnart with " + mode + " " + pass + " " + tmpPath);
        analysis.setStatus("Starting rnart with " + mode + " " + pass);
        this.tmpPath = tmpPath;
        this.inPath = tmpPath;
        this.outPath = tmpPath;
        this.oldV = Float.MAX_VALUE;
        this.curV = Float.MAX_VALUE;
        this.tmpV = Float.MAX_VALUE;
        this.npass = 0;
        this.value = 0.0f;
        this.pourcent = 0;
        char flag = mode.toLowerCase().charAt(0);
        if (flag == 'n') {
            this.npass = Tool.parseInt(pass);
        }
        if (flag == 'v') {
            this.value = Tool.parseFloat(pass);
        }
        if (flag == 'p') {
            this.pourcent = Tool.parseInt(pass);
        }
        String lsqout = this.outPath + "LSQ.OUT";
        String atomshd = this.outPath + "ATOMS.hd";
        Nuclin nuclin = new Nuclin(this.tmpPath);
        for (i = 1; i < 101; ++i) {
            System.out.println("Iteration #" + i);
            analysis.setStatus("Iteration #" + i);
            String name1 = this.outPath + "LSQ_";
            String name2 = this.outPath + "ATOMS_";
            NucLSQ nucLSQ = new NucLSQ(this);
            IncNuc incNuc = new IncNuc(this.tmpPath);
            MgrNuc mgrNuc = new MgrNuc(this.tmpPath, nucLSQ);
            name1 = i < 10 ? name1 + "0" + i + ".OUT" : name1 + i + ".OUT";
            SystemTools.mv(lsqout, name1);
            name2 = i < 10 ? name2 + "0" + i + ".hd" : name2 + i + ".hd";
            SystemTools.cp(atomshd, name2);
            try {
                HD2PDB.convert(name2, name2 + ".pdb");
            }
            catch (ParsingException e) {
                throw new RnartException(e);
            }
            this.oldV = this.curV;
            this.curV = this.tmpV;
            if (flag == 'n' && i > this.npass - 1) {
                System.out.println("Stopping : number of iterations = " + i);
                break;
            }
            if (flag == 'p' && this.curV / this.oldV > (float)this.pourcent / 100.0f) {
                int tV = (int)(100.0f * this.curV / this.oldV);
                System.out.println("Stopping : average deviation between the 2 last iterations, are similar at  = " + tV + "% < " + this.pourcent + "%");
                break;
            }
            if (flag != 'v' || !(this.curV < this.value)) continue;
            System.out.println("Stopping : average deviation = " + this.curV + " > " + this.value);
            break;
        }
        this.passOver = i;
    }

    public int getNumberOfPass() {
        return this.passOver;
    }
}

