/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart;

import fr.unistra.ibmc.paradise.core.utils.HD;
import fr.unistra.ibmc.paradise.core.utils.NumberFormat;
import fr.unistra.ibmc.paradise.core.utils.OutputMode;
import fr.unistra.ibmc.paradise.core.utils.ParsingException;
import fr.unistra.ibmc.paradise.core.utils.Printing;
import fr.unistra.ibmc.paradise.core.utils.SystemTools;
import fr.unistra.ibmc.paradise.core.utils.TBMath;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.RnartException;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.Tool;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.parsing.NuclinDc;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.parsing.NuclinDcChiral;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnart.parsing.NuclinDcDistance;
import fr.unistra.ibmc.paradise.tools.Paradise;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Nuclin {
    public String tmpPath;
    public String inPath;
    public String outPath;
    String nuclindat;
    String abcdat;
    String atomsdat;
    String hbnddat;
    String nuclinout;
    String lsqdat;
    String lsqinp;
    String lsqpar;
    String scratch;
    String wrentmp;
    String distbin;
    String chirlsbin;
    String plansbin;
    String vdwdstbin;
    String torfixbin;
    String pseubin;
    String symtrybin;
    String chirls2bin;
    String bndtntmp;
    NuclinDc nuclinDc;
    public String nuclindc = Paradise.getTertiaryDataDirectory().getAbsolutePath() + System.getProperty("file.separator") + "dc" + System.getProperty("file.separator") + "NUCLIN.DC";
    public String restraintdc = Paradise.getTertiaryDataDirectory().getAbsolutePath() + System.getProperty("file.separator") + "dc" + System.getProperty("file.separator") + "RESTRAINT.DC";
    public String restmoddc = Paradise.getTertiaryDataDirectory().getAbsolutePath() + System.getProperty("file.separator") + "dc" + System.getProperty("file.separator") + "RESTMOD.DC";
    public String drugdc = Paradise.getTertiaryDataDirectory().getAbsolutePath() + System.getProperty("file.separator") + "dc2" + System.getProperty("file.separator") + "DRUG.DC";
    BufferedReader inscratch;
    BufferedReader innuclindat;
    BufferedReader inabcdat;
    BufferedReader innuclindc;
    BufferedReader inhbnddat;
    BufferedReader inwrentmp;
    BufferedReader indistbin;
    BufferedReader inlsqdat;
    BufferedReader inchirlsbin;
    BufferedReader inplansbin;
    BufferedReader invdwdstbin;
    BufferedReader intorfixbin;
    BufferedReader inpseubin;
    BufferedReader insymtrybin;
    BufferedReader inchirls2bin;
    BufferedReader inatomsdat;
    BufferedReader inrestraintdc;
    BufferedReader inrestmoddc;
    BufferedReader indrugdc;
    BufferedReader inbndtntmp;
    PrintWriter outnuclinout;
    PrintWriter outscratch;
    PrintWriter outhbnddat;
    PrintWriter outwrentmp;
    PrintWriter outdistbin;
    PrintWriter outlsqdat;
    PrintWriter outchirlsbin;
    PrintWriter outplansbin;
    PrintWriter outvdwdstbin;
    PrintWriter outtorfixbin;
    PrintWriter outpseubin;
    PrintWriter outsymtrybin;
    PrintWriter outlsqpar;
    PrintWriter outchirls2bin;
    PrintWriter outatomsdat;
    PrintWriter outlsqinp;
    PrintWriter outbndtntmp;
    private String blnk = "";
    private double rmx1 = 0.0;
    private double rmx2 = 0.0;
    private double rmx3 = 0.0;
    private double rmx4 = 0.0;
    private double rmx5 = 0.0;
    private double[] abc = new double[6];
    private int[][] restyp = new int[2][999];
    private String[][] idb = new String[27][10];
    private String[] ids = new String[100];
    private String l1 = "";
    private String l2 = "";
    private String l3 = "";
    private int kss = 0;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double[][] xyzr = new double[27][3];
    private int[] ksr = new int[27];
    private String[] lb2r = new String[27];
    private String[] lb1r = new String[27];
    private String[] lb3r = new String[27];
    private double[][] xyzb1 = new double[100][3];
    private double[][] xyzb2 = new double[100][3];
    private int[] ksb1 = new int[100];
    private int[] ksb2 = new int[100];
    private String[] lb1b1 = new String[100];
    private String[] lb2b1 = new String[100];
    private String[] lb1b2 = new String[100];
    private String[] lb2b2 = new String[100];
    private String[] lb3b1 = new String[100];
    private String[] lb3b2 = new String[100];
    private int[] nnb1 = new int[100];
    private int[] nnb2 = new int[100];
    private int[][] rrbnd = new int[2][70];
    private int[][][] rbbnd = new int[2][23][10];
    private int[][][] bbbnd = new int[2][800][11];
    private double[] rrdst = new double[70];
    private double[][] rbdst = new double[23][10];
    private double[][] bbdst = new double[800][11];
    private int nrr = 0;
    private int[] nrb = new int[10];
    private int[] nbb = new int[11];
    private int[][][] bbchr = new int[4][30][11];
    private int[][] rrchr = new int[4][3];
    private int[][] rbchr = new int[4][10];
    private double[][][] bbchv = new double[4][30][11];
    private double[] rbchv = new double[10];
    private double[] rrchv = new double[3];
    private int nch = 0;
    private int ncrr = 0;
    private int[] ncrb = new int[10];
    private int[] ncbb = new int[11];
    private int[][] iplan = new int[60][11];
    private double rr1 = 0.0;
    private double rr2 = 0.0;
    private double rr3 = 0.0;
    private double rr4 = 0.0;
    private double rr5 = 0.0;
    private double rr6 = 0.0;
    private double r1 = 1.0;
    private double r2 = 0.0;
    private double r3 = 0.0;
    private double r4 = 0.0;
    private double r5 = 1.0;
    private String[] idr = new String[15];
    private int[] nnr = new int[27];
    private int ioutds = 0;
    private int ioutpl = 0;
    private int ioutnb = 0;
    private int ioutin = 0;
    private int nnn = 0;

    public Nuclin(String tmpPath) throws RnartException {
        this.tmpPath = tmpPath;
        this.inPath = tmpPath;
        this.outPath = tmpPath;
        this.nuclindat = this.inPath + "NUCLIN.DAT";
        this.abcdat = this.inPath + "ABC.DAT";
        this.atomsdat = this.inPath + "ATOMS.DAT";
        this.hbnddat = this.inPath + "HBND.DAT";
        this.nuclinout = this.outPath + "NUCLIN.OUT";
        this.lsqdat = this.outPath + "LSQ.DAT";
        this.lsqinp = this.outPath + "LSQ.INP";
        this.lsqpar = this.outPath + "LSQ.PAR";
        this.scratch = tmpPath + "SCRATCH";
        this.wrentmp = tmpPath + "WREN.TMP";
        this.distbin = tmpPath + "DIST.BIN";
        this.chirlsbin = tmpPath + "CHIRLS.BIN";
        this.plansbin = tmpPath + "PLANS.BIN";
        this.vdwdstbin = tmpPath + "VDWDST.BIN";
        this.torfixbin = tmpPath + "TORFIX.BIN";
        this.pseubin = tmpPath + "PSEU.BIN";
        this.symtrybin = tmpPath + "SYMTRY.BIN";
        this.chirls2bin = tmpPath + "CHIRLS_2.BIN";
        this.bndtntmp = tmpPath + "BNDTN.TMP";
        Printing.setReadMode(OutputMode.off);
        Printing.setWriteMode(OutputMode.off);
        Printing.setDebugMode(OutputMode.off);
        Printing.setEnteredMode(OutputMode.off);
        Printing.debug("START");
        this.nuclinDc = new NuclinDc(this);
        try {
            String tmp;
            this.nuclinDc.parseNuclinDc();
            this.outnuclinout = new PrintWriter(new FileWriter(this.nuclinout));
            String bid = "Systeme orthogonal";
            String abcS = "1.0,1.0,1.0,90.0,90.0,90.0";
            StringTokenizer tok = new StringTokenizer(abcS, ",");
            this.abc = new double[6];
            for (int i = 0; i < 6; ++i) {
                this.abc[i] = Tool.parseDouble(tok.nextToken());
            }
            this.innuclindat = new BufferedReader(new FileReader(this.nuclindat));
            Printing.debug("START");
            this.refinm();
            Printing.debug("START");
            this.bnds2();
            String line = "";
            while (line.length() < 4) {
                line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
            }
            String amod = line.substring(0, 4);
            int itemp = 0;
            if (amod.toLowerCase().equals("mode")) {
                itemp = 0;
            }
            if (amod.toLowerCase().equals("xray")) {
                itemp = 1;
            }
            line = this.innuclindat.readLine();
            Printing.justRead(line, this.nuclindat);
            tok = new StringTokenizer(line);
            int ip = Tool.parseInt(tok.nextToken());
            int ig = Tool.parseInt(tok.nextToken());
            int it = Tool.parseInt(tok.nextToken());
            int is = Tool.parseInt(tok.nextToken());
            int io = Tool.parseInt(tok.nextToken());
            if (ip == 1) {
                tmp = "\n Pseudorotation will be restrained ";
                this.outnuclinout.println(tmp);
                Printing.justWritten(tmp, this.nuclinout);
            }
            if (ig > 1) {
                tmp = "\n Sugar chiral volumes will be restrained ";
                this.outnuclinout.println(tmp);
                Printing.justWritten(tmp, this.nuclinout);
            }
            if (it == 1) {
                tmp = "\n Torsion angles will be restrained ";
                this.outnuclinout.println(tmp);
                Printing.justWritten(tmp, this.nuclinout);
            }
            if (is == 1) {
                tmp = "\n Symmetry restraints are on ";
                this.outnuclinout.println(tmp);
                Printing.justWritten(tmp, this.nuclinout);
            }
            if (io == 1) {
                tmp = "\n Fixed but variable occupancies ";
                this.outnuclinout.println(tmp);
                Printing.justWritten(tmp, this.nuclinout);
            }
            this.bndsrt();
            this.nblist(this.ioutnb);
            if (ip == 1) {
                this.pseu();
            }
            if (ig == 1) {
                this.sugr(ip);
            }
            if (ig == 2) {
                this.sugar();
            }
            if (it == 1) {
                this.torfix();
            }
            if (is == 1) {
                this.symtry();
            }
            double qf1 = 0.0;
            int nbg1 = 0;
            int ned1 = 0;
            int nbg2 = 0;
            int ned2 = 0;
            if (io == 1) {
                line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
                tok = new StringTokenizer(line);
                nbg1 = Tool.parseInt(tok.nextToken());
                ned1 = Tool.parseInt(tok.nextToken());
                nbg2 = Tool.parseInt(tok.nextToken());
                ned2 = Tool.parseInt(tok.nextToken());
                qf1 = Tool.parseDouble(tok.nextToken());
            }
            Printing.debug("fcvt");
            this.fcvt(ip, ig, it, is, io, nbg1, ned1, nbg2, ned2, qf1, itemp, amod);
            this.outnuclinout.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void refinm() throws RnartException {
        Printing.entered();
        boolean n = false;
        boolean m = false;
        int nn = 0;
        int mpl = 0;
        int ires = 0;
        int ires1 = 0;
        int ibs2 = 0;
        int irib2 = 0;
        int ibs1 = 0;
        int irib1 = 0;
        int ibr1 = 0;
        int ibr2 = 0;
        boolean npl = false;
        String ll1 = "";
        String ll2 = "";
        this.refins();
        Printing.debug("out refins");
        try {
            HD tmp;
            int i;
            this.inatomsdat = new BufferedReader(new FileReader(this.atomsdat));
            this.outbndtntmp = new PrintWriter(new FileWriter(this.bndtntmp));
            this.outplansbin = new PrintWriter(new FileWriter(this.plansbin));
            this.outchirlsbin = new PrintWriter(new FileWriter(this.chirlsbin));
            String tmpr = "Number of distances in sugar : " + this.nrr;
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
            tmpr = "Number of distances in sugar-base : " + this.nrb[0] + " " + this.nrb[1] + " " + this.nrb[2] + " " + this.nrb[3] + " " + this.nrb[4] + " " + this.nrb[5] + " " + this.nrb[6] + " " + this.nrb[7] + " " + this.nrb[8] + " " + this.nrb[9];
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
            tmpr = "Number of distances in bases/ions : " + this.nbb[0] + " " + this.nbb[1] + " " + this.nbb[2] + " " + this.nbb[3] + " " + this.nbb[4] + " " + this.nbb[5] + " " + this.nbb[6] + " " + this.nbb[7] + " " + this.nbb[8] + " " + this.nbb[9] + " " + this.nbb[10];
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
            tmpr = "Number of chirals in sugar : " + this.ncrr;
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
            tmpr = "Number of chirals in sugar-base : " + this.ncrb[0] + " " + this.ncrb[1] + " " + this.ncrb[2] + " " + this.ncrb[3] + " " + this.ncrb[4] + " " + this.ncrb[5] + " " + this.ncrb[6] + " " + this.ncrb[7] + " " + this.ncrb[8] + " " + this.ncrb[9];
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
            tmpr = "Number of chirals in bases/ions : " + this.ncbb[0] + " " + this.ncbb[1] + " " + this.ncbb[2] + " " + this.ncbb[3] + " " + this.ncbb[4] + " " + this.ncbb[5] + " " + this.ncbb[6] + " " + this.ncbb[7] + " " + this.ncbb[8] + " " + this.ncbb[9] + " " + this.ncbb[10];
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
            for (i = 0; i < 27; ++i) {
                this.nnr[i] = 0;
            }
            for (i = 0; i < 100; ++i) {
                this.nnb1[i] = 0;
                this.nnb2[i] = 0;
            }
            n = false;
            m = false;
            this.nnn = 1;
            mpl = 0;
            ires = 0;
            ibs2 = this.restyp[1][0];
            irib2 = this.restyp[0][0];
            i = 1;
            boolean doIt = true;
            String line = this.inatomsdat.readLine();
            try {
                tmp = new HD(line);
            }
            catch (ParsingException e) {
                throw new RnartException(e);
            }
            nn = tmp.atomNumber;
            this.l1 = tmp.residueName + "";
            this.l2 = tmp.residueNumber + "";
            this.l3 = tmp.atomName;
            this.kss = tmp.atomCode;
            this.x = tmp.x;
            this.y = tmp.y;
            this.z = tmp.z;
            double btmp = tmp.b;
            double qocc = tmp.q;
            block8: while (this.restyp[1][++ires - 1] != 0) {
                m = false;
                npl = false;
                ibs1 = ibs2;
                ibs2 = this.restyp[1][ires - 1];
                irib1 = irib2;
                irib2 = Math.abs(this.restyp[0][ires - 1]);
                ibr1 = ibr2;
                ibr2 = ibs2;
                ll1 = this.l1;
                ll2 = this.l2;
                tmpr = "   RESIDUE " + ll1 + " " + ll2 + "\n   STARTING WITH ATOM " + this.nnn + ", BACK BONE TYPE " + irib2 + ", SIDE CHAIN TYPE " + ibs2 + "\n\n";
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
                ires1 = ires - 1;
                if (ires1 <= 0) {
                    ires1 = 1;
                }
                if (this.restyp[1][ires - 1] != 0) {
                    doIt = false;
                }
                while (true) {
                    if (doIt) {
                        line = this.inatomsdat.readLine();
                        if (line == null) {
                            this.restyp[1][ires] = 0;
                            this.restyp[0][ires] = 0;
                            break;
                        }
                        try {
                            tmp = new HD(line);
                        }
                        catch (ParsingException e) {
                            throw new RnartException(e);
                        }
                        nn = tmp.atomNumber;
                        this.l1 = tmp.residueName + "";
                        this.l2 = tmp.residueNumber + "";
                        this.l3 = tmp.atomName;
                        this.kss = tmp.atomCode;
                        this.x = tmp.x;
                        this.y = tmp.y;
                        this.z = tmp.z;
                        btmp = tmp.b;
                        qocc = tmp.q;
                        if (!this.l1.equals(ll1) || !this.l2.equals(ll2)) break;
                    }
                    doIt = true;
                    this.atomid(ll1, ll2, irib2, ibs2);
                }
                while (true) {
                    int j;
                    this.disget(irib1, irib2, ibs1, ibs2);
                    int[] param = new int[]{irib1, irib2, ibs1, ibs2, mpl, ires};
                    this.plnchr(param);
                    irib1 = param[0];
                    irib2 = param[1];
                    ibs1 = param[2];
                    ibs2 = param[3];
                    mpl = param[4];
                    ires = param[5];
                    for (i = 0; i < 14; ++i) {
                        for (j = 0; j < 3; ++j) {
                            this.xyzr[i][j] = this.xyzr[i + 13][j];
                        }
                        this.nnr[i] = this.nnr[i + 13];
                        this.nnr[i + 13] = 0;
                        this.ksr[i] = this.ksr[i + 13];
                        this.lb1r[i] = this.lb1r[i + 13];
                        this.lb2r[i] = this.lb2r[i + 13];
                        this.lb3r[i] = this.lb3r[i + 13];
                    }
                    for (i = 0; i < 100; ++i) {
                        for (j = 0; j < 3; ++j) {
                            this.xyzb1[i][j] = this.xyzb2[i][j];
                        }
                        this.nnb1[i] = this.nnb2[i];
                        this.nnb2[i] = 0;
                        this.ksb1[i] = this.ksb2[i];
                        this.lb1b1[i] = this.lb1b2[i];
                        this.lb2b1[i] = this.lb2b2[i];
                        this.lb3b1[i] = this.lb3b2[i];
                    }
                    if (this.restyp[0][ires - 1] > 0) continue block8;
                    npl = false;
                    m = false;
                    ibs1 = ibs2;
                    irib1 = irib2;
                    ibr1 = ibr2;
                    this.restyp[0][ires - 1] = 1;
                }
            }
            --this.nnn;
            this.inatomsdat.close();
            this.outplansbin.close();
            this.outchirlsbin.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void refins() throws RnartException {
        String stmp;
        String tmpr;
        String tmpr2;
        Printing.entered();
        int iin = 0;
        int ind = 0;
        int idd1 = 0;
        int idd2 = 0;
        int j = 1;
        int iq = 0;
        boolean nread = false;
        int i = 0;
        int j1 = 0;
        int j2 = 0;
        int j3 = 0;
        int nbs = 0;
        int nn = 0;
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;
        int nab = 0;
        char[] atyp = new char[999];
        for (int iz = 0; iz < 999; ++iz) {
            atyp[iz] = 32;
        }
        char[] bcode = new char[]{'G', 'g', 'A', 'a', 'U', 'u', 'C', 'c', 'T', 't', 'P', 'p', 'D', 'd', 'Y', 'y', 'S', 's', 'I', 'i', 'O', 'o', 'W', 'w', 'N', 'n'};
        String ad1 = "";
        String ad2 = "";
        double d = 0.0;
        Printing.debug("couin");
        String[] idp = new String[40];
        try {
            Object tm;
            String title = this.innuclindat.readLine();
            Printing.debug("couin");
            Printing.justRead(title, this.nuclindat);
            this.outnuclinout.println(title);
            Printing.justWritten(title, this.nuclinout);
            tmpr2 = "Unit cell parameters are : " + this.abc[0] + " " + this.abc[1] + " " + this.abc[2] + " " + this.abc[3] + " " + this.abc[4] + " " + this.abc[5];
            this.outnuclinout.println(tmpr2);
            Printing.justWritten(tmpr2, this.nuclinout);
            String line = this.innuclindat.readLine();
            Printing.justRead(line, this.nuclindat);
            StringTokenizer tok = new StringTokenizer(line);
            Printing.debug("couin + " + line);
            this.ioutin = tok.countTokens() == 0 ? 0 : Tool.parseInt(tok.nextToken());
            this.ioutds = tok.countTokens() == 0 ? 0 : Tool.parseInt(tok.nextToken());
            this.ioutpl = tok.countTokens() == 0 ? 0 : Tool.parseInt(tok.nextToken());
            this.ioutnb = tok.countTokens() == 0 ? 0 : Tool.parseInt(tok.nextToken());
            Printing.debug("couin over");
            if (this.ioutin == 1) {
                tmpr2 = "Print request for input";
                this.outnuclinout.println(tmpr2);
                Printing.justWritten(tmpr2, this.nuclinout);
            }
            if (this.ioutds == 1) {
                tmpr2 = "Print request for distances";
                this.outnuclinout.println(tmpr2);
                Printing.justWritten(tmpr2, this.nuclinout);
            }
            if (this.ioutpl == 1) {
                tmpr2 = "Print request for planes";
                this.outnuclinout.println(tmpr2);
                Printing.justWritten(tmpr2, this.nuclinout);
            }
            if (this.ioutnb == 1) {
                tmpr2 = "Print request for vdw distances";
                this.outnuclinout.println(tmpr2);
                Printing.justWritten(tmpr2, this.nuclinout);
            }
            this.outnuclinout.println();
            Printing.debug("couin");
            double cosa = Math.cos(this.abc[3]) * TBMath.DegreeToRadian;
            double cosb = Math.cos(this.abc[4]) * TBMath.DegreeToRadian;
            double cosc = Math.cos(this.abc[5]) * TBMath.DegreeToRadian;
            double deta = 1.0 - cosa * cosa - cosb * cosb - cosc * cosc + 2.0 * cosa * cosb * cosc;
            double sins = 1.0 - cosc * cosc;
            double sing = Math.sqrt(sins);
            this.rr1 = this.abc[0] * sing;
            this.rr2 = this.abc[2] * (cosb - cosa * cosc) / sing;
            this.rr3 = this.abc[0] * cosc;
            this.rr4 = this.abc[2] * cosa;
            this.rr5 = this.abc[2] * Math.sqrt(deta / sins);
            boolean kpr = false;
            int kturn = 0;
            int nresidu = 0;
            int atir = 92;
            Printing.debug("couin");
            while ((line = this.innuclindat.readLine()) != null && line.length() >= 1 && line.charAt(0) != ' ' && line.charAt(0) != '0') {
                atir = line.charAt(line.length() - 1);
                Printing.justRead(line, this.nuclindat);
                for (i = 0; i < line.length(); ++i) {
                    atyp[i] = line.charAt(i);
                }
                tmpr2 = line;
                this.outnuclinout.println(tmpr2);
                Printing.justWritten(tmpr2, this.nuclinout);
                ++kturn;
                for (i = 0; i < 70 && i < line.length(); ++i) {
                    if (line.charAt(i) == ' ') continue;
                    j = nresidu + i + 1;
                    for (int k = 1; k <= 26; ++k) {
                        if (line.charAt(i) != bcode[k - 1]) continue;
                        if (k <= 4) {
                            this.restyp[1][j - 1] = 1;
                        }
                        if (k > 4 && k <= 10) {
                            this.restyp[1][j - 1] = 2;
                        }
                        if (k == 11 || k == 12) {
                            this.restyp[1][j - 1] = 3;
                        }
                        if (k == 13 || k == 14) {
                            this.restyp[1][j - 1] = 4;
                        }
                        if (k == 15 || k == 16) {
                            this.restyp[1][j - 1] = 5;
                        }
                        if (k == 17 || k == 18) {
                            this.restyp[1][j - 1] = 6;
                        }
                        if (k == 19 || k == 20) {
                            this.restyp[1][j - 1] = 7;
                        }
                        if (k == 21 || k == 22) {
                            this.restyp[1][j - 1] = 8;
                        }
                        if (k == 23 || k == 24) {
                            this.restyp[1][j - 1] = 9;
                        }
                        if (k == 25 || k == 26) {
                            this.restyp[1][j - 1] = 11;
                            nread = true;
                        }
                        if (k <= 16) {
                            this.restyp[0][j - 1] = 1;
                            continue;
                        }
                        this.restyp[0][j - 1] = 0;
                        kpr = true;
                    }
                }
                nresidu = j;
                if (atir == 45) {
                    --kturn;
                    continue;
                }
                if (this.restyp[0][nresidu - 1] != 1) continue;
                this.restyp[0][nresidu - 1] = -1;
            }
            Printing.debug("couin");
            this.outnuclinout.println();
            if (kturn == 1) {
                tmpr2 = "Single-stranded nucleic acid";
                this.outnuclinout.println(tmpr2);
                Printing.justWritten(tmpr2, this.nuclinout);
            }
            if (kturn == 2) {
                if (!kpr) {
                    tmpr2 = "Double-stranded nucleic acid";
                    this.outnuclinout.println(tmpr2);
                    Printing.justWritten(tmpr2, this.nuclinout);
                } else {
                    tmpr2 = "Single-stranded nucleic acid with ligand";
                    this.outnuclinout.println(tmpr2);
                    Printing.justWritten(tmpr2, this.nuclinout);
                }
            }
            if (kturn == 3) {
                if (!kpr) {
                    tmpr2 = "Double-stranded with single-stranded";
                    this.outnuclinout.println(tmpr2);
                    Printing.justWritten(tmpr2, this.nuclinout);
                } else {
                    tmpr2 = "Double-stranded nucleic acid with ligand";
                    this.outnuclinout.println(tmpr2);
                    Printing.justWritten(tmpr2, this.nuclinout);
                }
            }
            if (kturn == 4) {
                if (!kpr) {
                    tmpr2 = "Two double-stranded nucleic acids";
                    this.outnuclinout.println(tmpr2);
                    Printing.justWritten(tmpr2, this.nuclinout);
                } else {
                    tmpr2 = "Double-stranded and single-stranded with ligand";
                    this.outnuclinout.println(tmpr2);
                    Printing.justWritten(tmpr2, this.nuclinout);
                }
            }
            if (kturn == 5) {
                tmpr2 = "Two double-stranded with ligands";
                this.outnuclinout.println(tmpr2);
                Printing.justWritten(tmpr2, this.nuclinout);
            }
            this.outnuclinout.println();
            if (nread) {
                this.indrugdc = new BufferedReader(new FileReader(this.drugdc));
            }
            Printing.debug("plop");
            String[] tmp = this.nuclinDc.names.get(0);
            for (int zzz = 0; zzz < tmp.length; ++zzz) {
                this.idr[zzz] = tmp[zzz];
            }
            for (int zz = 1; zz < this.nuclinDc.names.size(); ++zz) {
                tmp = this.nuclinDc.names.get(zz);
                for (int zzz = 0; zzz < tmp.length; ++zzz) {
                    this.idb[zzz][zz - 1] = tmp[zzz];
                }
            }
            if (nread) {
                for (int ii = 0; ii < 10; ++ii) {
                    line = this.indrugdc.readLine();
                    Printing.justRead(line, this.drugdc);
                    tok = new StringTokenizer(line);
                    for (i = 0; i < 10; ++i) {
                        this.ids[10 * ii + i] = tok.nextToken();
                    }
                }
            }
            for (i = 0; i < 70; ++i) {
                this.rrdst[i] = 0.0;
            }
            for (j = 0; j < 10; ++j) {
                for (i = 0; i < 23; ++i) {
                    this.rbdst[i][j] = 0.0;
                }
            }
            for (j = 0; j < 11; ++j) {
                for (i = 0; i < 800; ++i) {
                    this.bbdst[i][j] = 0.0;
                }
            }
            int iq1 = 1;
            int jq1 = 1;
            i = 0;
            int iin1 = -99;
            int limit = 0;
            boolean go65 = false;
            Printing.debug("plop");
            block24: while (true) {
                if (!go65) {
                    if (limit >= this.nuclinDc.distances.size()) break;
                    tm = this.nuclinDc.distances.get(limit);
                    ++limit;
                    iq = ((NuclinDcDistance)tm).iq;
                    j = ((NuclinDcDistance)tm).j;
                    iin = ((NuclinDcDistance)tm).iin;
                    ind = ((NuclinDcDistance)tm).ind;
                    ad1 = ((NuclinDcDistance)tm).ad1;
                    ad2 = ((NuclinDcDistance)tm).ad2;
                    d = ((NuclinDcDistance)tm).d;
                    idd1 = ((NuclinDcDistance)tm).idd1;
                    idd2 = ((NuclinDcDistance)tm).idd2;
                }
                if ((iq == 999 || go65) && !nread) {
                    iq = 0;
                }
                go65 = false;
                if (iq == 0 && j == 0) break;
                Printing.debug("plop");
                while (true) {
                    boolean bigbreak = false;
                    if (iq == iq1 && j == jq1) {
                        switch (iq1) {
                            case 1: {
                                if (iin != iin1) {
                                    this.rrbnd[0][++i - 1] = iin1 = iin;
                                    this.rrbnd[1][i - 1] = 0;
                                    this.rrdst[i - 1] = 0.0;
                                }
                                this.rrbnd[0][++i - 1] = ind;
                                this.rrbnd[1][i - 1] = idd1;
                                this.rrdst[i - 1] = d;
                                bigbreak = true;
                                break;
                            }
                            case 2: {
                                if (iin != iin1) {
                                    this.rbbnd[0][++i - 1][j - 1] = iin1 = iin;
                                    this.rbbnd[1][i - 1][j - 1] = 0;
                                    this.rbdst[i - 1][j - 1] = 0.0;
                                }
                                this.rbbnd[0][++i - 1][j - 1] = ind;
                                this.rbbnd[1][i - 1][j - 1] = idd1;
                                this.rbdst[i - 1][j - 1] = d;
                                bigbreak = true;
                                break;
                            }
                            case 4: {
                                j += 5;
                            }
                            case 3: {
                                if (iin != iin1) {
                                    this.bbbnd[0][++i - 1][j - 1] = iin1 = iin;
                                    this.bbbnd[1][i - 1][j - 1] = 0;
                                    this.bbdst[i - 1][j - 1] = 0.0;
                                }
                                this.bbbnd[0][++i - 1][j - 1] = ind;
                                this.bbbnd[1][i - 1][j - 1] = idd1;
                                this.bbdst[i - 1][j - 1] = d;
                                bigbreak = true;
                                break;
                            }
                            case 5: {
                                if (iin != iin1) {
                                    this.bbbnd[0][++i - 1][j - 1] = iin1 = iin;
                                    this.bbbnd[1][i - 1][j - 1] = 0;
                                    this.bbdst[i - 1][j - 1] = 0.0;
                                }
                                this.bbbnd[0][++i - 1][j - 1] = ind;
                                this.bbbnd[1][i - 1][j - 1] = idd1;
                                this.bbdst[i - 1][j - 1] = d;
                                bigbreak = true;
                                go65 = true;
                            }
                        }
                        if (bigbreak) continue block24;
                    }
                    i = 0;
                    iin1 = -99;
                    iq1 = iq;
                    jq1 = j;
                }
                break;
            }
            Printing.debug("plop");
            this.ncrr = 0;
            for (j = 0; j < 3; ++j) {
                tm = this.nuclinDc.chirals.get(j);
                this.rrchr[0][j] = ((NuclinDcChiral)tm).r1;
                this.rrchr[1][j] = ((NuclinDcChiral)tm).r2;
                this.rrchr[2][j] = ((NuclinDcChiral)tm).r3;
                this.rrchr[3][j] = ((NuclinDcChiral)tm).r4;
                this.rrchv[j] = ((NuclinDcChiral)tm).v;
                if (this.rrchr[0][j] == 0) continue;
                ++this.ncrr;
            }
            for (i = 0; i < 10; ++i) {
                this.ncrb[i] = 0;
                tm = this.nuclinDc.chirals.get(i + 3);
                this.rbchr[0][i] = ((NuclinDcChiral)tm).r1;
                this.rbchr[1][i] = ((NuclinDcChiral)tm).r2;
                this.rbchr[2][i] = ((NuclinDcChiral)tm).r3;
                this.rbchr[3][i] = ((NuclinDcChiral)tm).r4;
                this.rbchv[i] = ((NuclinDcChiral)tm).v;
                if (this.rbchr[0][i] == 0) continue;
                int n = i;
                this.ncrb[n] = this.ncrb[n] + 1;
            }
            for (i = 0; i < 10; ++i) {
                this.ncbb[i] = 0;
                for (j = 0; j < 30; ++j) {
                    this.bbchv[0][j][i] = 0.0;
                    for (int k = 0; k < 4; ++k) {
                        this.bbchr[k][j][i] = 0;
                    }
                }
            }
            Printing.debug("plop");
            for (i = 0; i < 10; ++i) {
                tm = this.nuclinDc.planes.get(i);
                for (int k = 0; k < 40; ++k) {
                    this.iplan[k][i] = (int)tm[k];
                }
            }
            if (nread) {
                i = 10;
                this.ncbb[i] = 0;
                for (j = 0; j < 145; ++j) {
                    line = this.indrugdc.readLine();
                    Printing.justRead(line, this.drugdc);
                    tok = new StringTokenizer(line);
                    for (int k = 0; k < 4; ++k) {
                        this.bbchr[k][j][i] = Tool.parseInt(tok.nextToken());
                    }
                    this.bbchv[0][j][i] = Tool.parseDouble(tok.nextToken());
                    if (this.bbchr[0][j][i] == 0) continue;
                    int n = i;
                    this.ncbb[n] = this.ncbb[n] + 1;
                }
                line = this.indrugdc.readLine();
                Printing.justRead(line, this.drugdc);
                tok = new StringTokenizer(line);
                for (int k = 0; k < 60; ++k) {
                    this.iplan[k][i] = Tool.parseInt(tok.nextToken());
                }
                this.indrugdc.close();
            }
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
        Printing.debug("plop");
        j = 1;
        this.nrr = 0;
        if (this.ioutin != 0) {
            tmpr = "????";
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
        }
        for (i = 1; i <= 70 && this.rrbnd[0][i - 1] != 0; ++i) {
            if (this.rrbnd[1][i - 1] <= 0) {
                j1 = this.rrbnd[0][i - 1];
                j3 = i;
                if (j1 > 13) {
                    j1 -= 13;
                }
                ++this.nrr;
                continue;
            }
            j2 = this.rrbnd[0][i - 1];
            if (j2 > 14) {
                j2 -= 13;
            }
            ++this.nrr;
            if (this.ioutin == 0) continue;
            tmpr = this.idr[j1 - 1] + " " + this.idr[j2 - 1] + " " + this.rrdst[i - 1] + " " + this.rrbnd[1][i - 1] + " " + j1 + " " + j2 + " " + j + " " + i;
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
        }
        i = 1;
        nn = this.ncrr;
        if (nn != 0) {
            for (j = 1; j <= nn; ++j) {
                i1 = this.rrchr[0][j - 1];
                i2 = this.rrchr[1][j - 1];
                i3 = this.rrchr[2][j - 1];
                i4 = this.rrchr[3][j - 1];
                if (this.ioutin == 0) continue;
                tmpr = "chiral center " + this.idr[i1 - 1] + " " + this.idr[i2 - 1] + " " + this.idr[i3 - 1] + " -- " + i1 + " " + i2 + " " + i3 + " " + i4 + " " + this.rrchv[j - 1];
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            }
        }
        Printing.debug("plop");
        for (nbs = 1; nbs <= 10; ++nbs) {
            j = 1;
            this.nrb[nbs - 1] = 0;
            if (this.ioutin != 0) {
                tmpr = "?????";
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            }
            for (i = 1; i <= 23 && this.rbbnd[0][i - 1][nbs - 1] != 0; ++i) {
                if (this.rbbnd[1][i - 1][nbs - 1] <= 0) {
                    j1 = this.rbbnd[0][i - 1][nbs - 1];
                    j3 = i;
                    int n = nbs - 1;
                    this.nrb[n] = this.nrb[n] + 1;
                    continue;
                }
                j2 = this.rbbnd[0][i - 1][nbs - 1];
                int n = nbs - 1;
                this.nrb[n] = this.nrb[n] + 1;
                if (this.ioutin == 0) continue;
                tmpr = this.idr[j1 - 1] + " " + this.idb[j2 - 1][nbs - 1] + " " + this.rbdst[0][nbs - 1] + " " + this.rbbnd[1][i - 1][nbs - 1] + " " + j1 + " " + j2 + " " + nbs + " " + i;
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            }
            i = nbs;
            nn = this.ncrb[i - 1];
            if (nn != 0) {
                for (j = 1; j <= nn; ++j) {
                    i1 = this.rbchr[0][j - 1];
                    i2 = this.rbchr[1][j - 1];
                    i3 = this.rbchr[2][j - 1];
                    i4 = this.rbchr[3][j - 1];
                    if (this.ioutin == 0) continue;
                    tmpr = this.idr[i1 - 1] + " " + this.idr[i2 - 1] + " " + this.idr[i3 - 1] + " " + this.idb[i4 - 1][i - 1] + " " + i1 + " " + i2 + " " + i3 + " " + i4 + " " + this.rbchv[j - 1];
                    this.outnuclinout.println(tmpr);
                    Printing.justWritten(tmpr, this.nuclinout);
                }
            }
            if (this.ioutin != 0) {
                tmpr = "???";
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            }
            nab = 150;
            this.nbb[nbs - 1] = 0;
            for (i = 1; i <= nab && this.bbbnd[0][i - 1][nbs - 1] != 0; ++i) {
                if (this.bbbnd[1][i - 1][nbs - 1] <= 0) {
                    j1 = this.bbbnd[0][i - 1][nbs - 1];
                    int n = nbs - 1;
                    this.nbb[n] = this.nbb[n] + 1;
                    j3 = i;
                    continue;
                }
                j2 = this.bbbnd[0][i - 1][nbs - 1];
                int n = nbs - 1;
                this.nbb[n] = this.nbb[n] + 1;
                if (this.ioutin == 0) continue;
                tmpr = this.idb[j1 - 1][nbs - 1] + " " + this.idb[j2 - 1][nbs - 1] + " " + this.bbdst[i - 1][nbs - 1] + " " + this.bbbnd[1][i - 1][nbs - 1] + " " + j1 + " " + j2 + " " + nbs + " " + i;
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            }
            i = nbs;
            nn = this.ncbb[i - 1];
            if (nn != 0) {
                for (j = 1; j <= nn; ++j) {
                    i1 = this.bbchr[0][j - 1][i - 1];
                    i2 = this.bbchr[1][j - 1][i - 1];
                    i3 = this.bbchr[2][j - 1][i - 1];
                    i4 = this.bbchr[3][j - 1][i - 1];
                    if (this.ioutin == 0) continue;
                    tmpr = this.idb[i1 - 1][i - 1] + " " + this.idb[i2 - 1][i - 1] + " " + this.idb[i3 - 1][i - 1] + " " + this.idb[i4 - 1][i - 1] + " " + i1 + " " + i2 + " " + i3 + " " + i4 + " " + this.bbchv[j - 1][i - 1];
                    this.outnuclinout.println(tmpr);
                    Printing.justWritten(tmpr, this.nuclinout);
                }
            }
            for (j = 1; j <= 40; ++j) {
                idp[j - 1] = this.blnk;
                if (this.iplan[j - 1][i - 1] == 0) continue;
                int k = this.iplan[j - 1][i - 1];
                if (k < 0) {
                    idp[j - 1] = this.idr[Math.abs(k)];
                }
                if (k >= 0) continue;
                idp[j - 1] = this.idb[j - 1][i - 1];
            }
            if (this.ioutin == 0) continue;
            stmp = idp[0] + "";
            for (int zz = 1; zz < 20; ++zz) {
                stmp = stmp + " " + idp[zz];
            }
            tmpr2 = "planar atoms " + stmp;
            this.outnuclinout.println(tmpr2);
            Printing.justWritten(tmpr2, this.nuclinout);
        }
        Printing.debug("plop");
        if (this.ioutin != 0) {
            tmpr = "???";
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
        }
        nbs = 11;
        this.nbb[nbs - 1] = 0;
        for (i = 1; i <= 800 && this.bbbnd[0][i - 1][nbs - 1] != 0; ++i) {
            if (this.bbbnd[1][i - 1][nbs - 1] <= 0) {
                j1 = this.bbbnd[0][i - 1][nbs - 1];
                int n = nbs - 1;
                this.nbb[n] = this.nbb[n] + 1;
                j3 = i;
                continue;
            }
            int n = nbs - 1;
            this.nbb[n] = this.nbb[n] + 1;
            if (this.ioutin == 0) continue;
            tmpr = this.ids[j1 - 1] + " " + this.ids[j2 - 1] + " " + this.bbdst[i - 1][nbs - 1] + " " + this.bbbnd[1][i - 1][nbs - 1] + " " + j1 + " " + j2 + " " + nbs + " " + i;
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
        }
        i = nbs;
        nn = this.ncbb[nbs - 1];
        if (nn != 0) {
            for (j = 1; j <= nn; ++j) {
                i1 = this.bbchr[0][j - 1][i - 1];
                i2 = this.bbchr[1][j - 1][i - 1];
                i3 = this.bbchr[2][j - 1][i - 1];
                i4 = this.bbchr[3][j - 1][i - 1];
                if (this.ioutin == 0) continue;
                tmpr = this.ids[i1 - 1] + " " + this.ids[i2 - 1] + " " + this.ids[i3 - 1] + " " + this.ids[i4 - 1] + " " + i1 + " " + i2 + " " + i3 + " " + i4 + " " + this.bbchv[j - 1][i - 1];
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            }
        }
        for (j = 1; j <= 40; ++j) {
            idp[j - 1] = this.blnk;
            if (this.iplan[j - 1][i - 1] == 0) continue;
            int k = this.iplan[j - 1][i - 1];
            if (k < 0) {
                idp[j - 1] = this.idr[Math.abs(k)];
            }
            if (k <= 0) continue;
            idp[j - 1] = this.ids[j - 1];
        }
        if (this.ioutin != 0) {
            stmp = idp[0] + "";
            for (int zz = 1; zz < idp.length; ++zz) {
                stmp = stmp + " " + idp[zz];
            }
            this.outnuclinout.println(stmp);
            Printing.justWritten(stmp, this.nuclinout);
        }
        Printing.debug("plop");
    }

    double[] ortho(double[] pt) {
        double[] ret = new double[3];
        ret[1] = this.abc[1] * pt[1] + this.r3 * pt[0] + this.r4 * pt[2];
        ret[0] = this.r1 * pt[0] + this.r2 * pt[2];
        ret[2] = this.r5 * pt[2];
        return ret;
    }

    double[] deorth(double[] pt) {
        double[] ret = new double[3];
        ret[2] = pt[2] / this.r5;
        ret[0] = (pt[0] - this.r2 * ret[2]) / this.r1;
        ret[1] = (pt[1] - this.r3 * ret[0] - this.r4 * ret[2]) / this.abc[1];
        return ret;
    }

    void atomid(String ll1, String ll2, int irib2, int ibs2) {
        int i;
        if (irib2 != 0) {
            int i2;
            boolean doIt = false;
            for (i2 = 0; i2 < 14; ++i2) {
                if (!this.l3.equals(this.idr[i2])) continue;
                doIt = true;
                break;
            }
            if (doIt) {
                int i13 = i2 + 13;
                double[] tmp = new double[]{this.x, this.y, this.z};
                this.xyzr[i13] = this.ortho(tmp);
                this.lb1r[i13] = this.l1;
                this.lb2r[i13] = this.l2;
                this.lb3r[i13] = this.l3;
                this.nnr[i13] = this.nnn++;
                return;
            }
            doIt = true;
            for (i2 = 0; i2 < 27; ++i2) {
                if (!this.l3.equals(this.idb[i2][ibs2 - 1])) continue;
                doIt = false;
                break;
            }
            if (doIt) {
                String tmpr = "no match for **** " + this.l1 + " " + this.l2 + " " + this.l3 + " ******";
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
                return;
            }
            double[] tmp = new double[]{this.x, this.y, this.z};
            this.xyzb2[i2] = this.ortho(tmp);
            this.ksb2[i2] = this.kss;
            this.lb1b2[i2] = this.l1;
            this.lb2b2[i2] = this.l2;
            this.lb3b2[i2] = this.idb[i2][ibs2 - 1];
            this.nnb2[i2] = this.nnn++;
            return;
        }
        int ibs = ibs2;
        if (ibs != 11) {
            int i3;
            boolean doIt = true;
            for (i3 = 1; i3 <= 27; ++i3) {
                if (!this.l3.equals(this.idb[i3 - 1][ibs - 1])) continue;
                doIt = false;
                break;
            }
            if (doIt) {
                String tmpr = this.l1 + " " + this.l2 + " " + this.l3;
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            } else {
                double[] tmp = new double[]{this.x, this.y, this.z};
                this.xyzb2[i3 - 1] = this.ortho(tmp);
                this.ksb2[i3 - 1] = this.kss;
                this.lb1b1[i3 - 1] = this.l1;
                this.lb2b2[i3 - 1] = this.l2;
                this.lb3b2[i3 - 1] = this.idb[i3 - 1][ibs - 1];
                this.nnb2[i3 - 1] = this.nnn++;
            }
            return;
        }
        boolean doIt = true;
        for (i = 1; i <= 100; ++i) {
            if (!this.l3.equals(this.ids[i - 1])) continue;
            doIt = false;
            break;
        }
        if (doIt) {
            String tmpr = this.l1 + " " + this.l2 + " " + this.l3;
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
        } else {
            double[] tmp = new double[]{this.x, this.y, this.z};
            this.ksb2[i - 1] = this.kss;
            this.lb1b2[i - 1] = this.l1;
            this.lb2b2[i - 1] = this.l2;
            this.lb3b2[i - 1] = this.ids[i - 1];
            this.nnb2[i - 1] = this.nnn++;
        }
    }

    void disget(int irib1, int irib2, int ibs1, int ibs2) {
        int ibss1;
        String tmpr;
        String outLine;
        double dst;
        int i;
        Printing.entered();
        int n = 0;
        int j1 = 0;
        int j2 = 0;
        int ibr1 = 0;
        boolean m = false;
        if (irib2 != 0) {
            int mrr = this.nrr;
            for (int i2 = 1; i2 <= mrr; ++i2) {
                if (this.rrbnd[1][i2 - 1] <= 0) {
                    j1 = this.rrbnd[0][i2 - 1];
                    continue;
                }
                j2 = this.rrbnd[0][i2 - 1];
                if (this.nnr[j1 - 1] == 0 || this.nnr[j2 - 1] == 0) continue;
                double dst2 = 0.0;
                for (int j = 0; j < 3; ++j) {
                    dst2 += (this.xyzr[j1 - 1][j] - this.xyzr[j2 - 1][j]) * (this.xyzr[j1 - 1][j] - this.xyzr[j2 - 1][j]);
                }
                dst2 = Math.sqrt(dst2);
                ++n;
                String outLine2 = this.nnr[j1 - 1] + " " + this.nnr[j2 - 1] + " " + this.rrdst[i2 - 1] + " " + this.rrbnd[1][i2 - 1];
                Printing.justWritten(outLine2, this.bndtntmp + "1");
                this.outbndtntmp.println(outLine2);
                if (this.ioutds == 0) continue;
                String tmpr2 = n + " " + this.nnr[j1 - 1] + " " + this.nnr[j2 - 1] + " " + this.lb1r[j1 - 1] + this.lb2r[j1 - 1] + " " + this.lb3r[j1 - 1] + " " + this.lb1r[j2 - 1] + " " + this.lb2r[j2 - 1] + " " + this.lb3r[j2 - 1] + " " + this.rrdst[i2 - 1] + " " + dst2 + " " + this.rrbnd[1][i2 - 1];
                this.outnuclinout.println(tmpr2);
                Printing.justWritten(tmpr2, this.nuclinout);
            }
            ibr1 = ibs1;
            int mrb = this.nrb[ibr1 - 1];
            for (i = 0; i < mrb; ++i) {
                if (this.rbbnd[1][i][ibr1 - 1] <= 0) {
                    j1 = this.rbbnd[0][i][ibr1 - 1];
                    continue;
                }
                j2 = this.rbbnd[0][i][ibr1 - 1];
                if (this.nnr[j1 - 1] == 0 || this.nnb1[j2 - 1] == 0) continue;
                dst = 0.0;
                for (int j = 0; j < 3; ++j) {
                    dst += (this.xyzr[j1 - 1][j] - this.xyzr[j2 - 1][j]) * (this.xyzr[j1 - 1][j] - this.xyzr[j2 - 1][j]);
                }
                ++n;
                outLine = this.nnr[j1 - 1] + " " + this.nnb1[j2 - 1] + " " + this.rbdst[i][ibr1 - 1] + " " + this.rbbnd[1][i][ibr1 - 1];
                Printing.justWritten(outLine, this.bndtntmp + "2");
                this.outbndtntmp.println(outLine);
                if (this.ioutds == 0) continue;
                tmpr = n + " " + this.nnr[j1 - 1] + " " + this.nnb1[j2 - 1] + " " + this.lb1r[j1 - 1] + this.lb2r[j1 - 1] + " " + this.lb3r[j1 - 1] + " - " + this.lb1b1[j2 - 1] + " " + this.lb2b1[j2 - 1] + " " + this.lb3b1[j2 - 1] + " " + this.rbdst[i][ibr1 - 1] + " " + dst + " " + this.rbbnd[1][i][ibr1 - 1];
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            }
        }
        if ((ibss1 = ibs1) == 0) {
            ++ibss1;
        }
        int mbb = this.nbb[ibss1 - 1];
        for (i = 0; i < mbb; ++i) {
            if (this.bbbnd[1][i][ibss1 - 1] <= 0) {
                j1 = this.bbbnd[0][i][ibss1 - 1];
                continue;
            }
            j2 = this.bbbnd[0][i][ibss1 - 1];
            if (this.nnb1[j1 - 1] == 0 || this.nnb1[j2 - 1] == 0) continue;
            dst = 0.0;
            for (int j = 0; j < 3; ++j) {
                dst += (this.xyzr[j1 - 1][j] - this.xyzr[j2 - 1][j]) * (this.xyzr[j1 - 1][j] - this.xyzr[j2 - 1][j]);
            }
            dst = Math.sqrt(dst);
            ++n;
            outLine = this.nnb1[j1 - 1] + " " + this.nnb1[j2 - 1] + " " + this.bbdst[i][ibss1 - 1] + " " + this.bbbnd[1][i][ibss1 - 1];
            Printing.justWritten(outLine, this.bndtntmp + "3");
            this.outbndtntmp.println(outLine);
            if (this.ioutds == 0) continue;
            tmpr = n + " " + this.nnr[j1 - 1] + " " + this.nnb1[j2 - 1] + " " + this.lb1r[j1 - 1] + this.lb2r[j1 - 1] + " " + this.lb3r[j1 - 1] + " - " + this.lb1b1[j2 - 1] + " " + this.lb2b1[j2 - 1] + " " + this.lb3b1[j2 - 1] + " " + this.rbdst[i][ibr1 - 1] + " " + dst + " " + this.rbbnd[1][i][ibr1 - 1];
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
        }
    }

    void plnchr(int[] param) {
        int ibss1;
        int mbb;
        Printing.entered();
        int irib1 = param[0];
        int irib2 = param[1];
        int ibs1 = param[2];
        int ibs2 = param[3];
        int mpl = param[4];
        int ires = param[5];
        int[] iin = new int[100];
        int npl = 0;
        int jp1 = 1;
        int jp2 = 59;
        int na = 0;
        if (ibs1 > 0) {
            for (int i = jp1; i <= jp2; ++i) {
                int j;
                if (this.iplan[i - 1][ibs1 - 1] != 0) {
                    int jp3;
                    int ip2;
                    int ip1;
                    if (this.iplan[i - 1][ibs1 - 1] > 0) {
                        ip1 = this.iplan[i - 1][ibs1 - 1];
                        if (this.nnb1[ip1 - 1] == 0) continue;
                        iin[++na - 1] = this.nnb1[ip1 - 1];
                    } else {
                        ip1 = this.iplan[i - 1][ibs1 - 1];
                        iin[++na - 1] = this.nnr[-(ip1 + 1)];
                    }
                    for (int i1 = jp3 = i + 1; i1 < 60 && (ip2 = this.iplan[i1 - 1][ibs1 - 1]) != 0; ++i1) {
                        if (this.nnb1[ip2 - 1] == 0) continue;
                        ++npl;
                    }
                    continue;
                }
                if (npl == 0) continue;
                ++mpl;
                if (this.ioutpl != 0) {
                    this.outnuclinout.println(" Planar atoms of " + this.lb1b1[0] + " " + this.lb2b1[0]);
                    String tmp = "";
                    for (j = 0; j < na; ++j) {
                        tmp = tmp + " " + iin[j];
                    }
                    this.outnuclinout.println(tmp);
                }
                String tmpr = mpl + " " + na;
                for (j = 0; j < na; ++j) {
                    tmpr = tmpr + " " + iin[j];
                }
                this.outplansbin.println(tmpr);
                Printing.justWritten(tmpr, this.plansbin);
                npl = 0;
                na = 0;
            }
        }
        if (irib2 != 0) {
            int ibr1;
            int mrb;
            irib1 = 1;
            int mrr = this.ncrr;
            if (mrr != 0) {
                for (int i = 1; i <= mrr; ++i) {
                    int j1 = this.rrchr[0][i - 1];
                    int j2 = this.rrchr[1][i - 1];
                    int j3 = this.rrchr[2][i - 1];
                    int j4 = this.rrchr[3][i - 1];
                    if (this.nnr[j1 - 1] == 0 || this.nnr[j2 - 1] == 0 || this.nnr[j3 - 1] == 0 || this.nnr[j4 - 1] == 0) continue;
                    ++this.nch;
                    if (this.ioutpl != 0) {
                        this.outnuclinout.println("Chiral centers of " + this.lb1b1[0] + " " + this.lb2b1[0] + " " + this.nnr[j1 - 1] + " " + this.nnr[j2 - 1] + " " + this.nnr[j3 - 1] + " " + this.nnr[j4 - 1] + " " + this.rrchv[i - 1]);
                    }
                    String tmpr = this.nnr[j1 - 1] + " " + this.nnr[j2 - 1] + " " + this.nnr[j3 - 1] + " " + this.nnr[j4 - 1] + " " + this.rrchv[i - 1];
                    this.outchirlsbin.println(tmpr);
                    Printing.justWritten(tmpr, this.chirlsbin);
                }
            }
            if ((mrb = this.ncrb[ibr1 = ibs1]) != 0) {
                for (int i = 1; i <= mrb; ++i) {
                    int j1 = this.rbchr[0][i - 1];
                    int j2 = this.rbchr[1][i - 1];
                    int j3 = this.rbchr[2][i - 1];
                    int j4 = this.rbchr[3][i - 1];
                    if (this.nnr[j1 - 1] == 0 || this.nnb1[j4 - 1] == 0 || this.nnr[j2 - 1] == 0 || this.nnr[j3 - 1] == 0) continue;
                    ++this.nch;
                    if (this.ioutpl != 0) {
                        this.outnuclinout.println("chiral centers of " + this.lb1b1[0] + " " + this.lb2b1[0] + " " + this.nnr[j1 - 1] + " " + this.nnr[j2 - 1] + " " + this.nnr[j3 - 1] + " " + this.nnb1[j4 - 1] + " " + this.rbchv[i - 1]);
                    }
                    String tmpr = this.nnr[j1 - 1] + " " + this.nnr[j2 - 1] + " " + this.nnr[j3 - 1] + " " + this.nnb1[j4 - 1] + " " + this.rbchv[i - 1];
                    this.outchirlsbin.println(tmpr);
                    Printing.justWritten(tmpr, this.chirlsbin);
                }
            }
        }
        if ((mbb = this.ncbb[(ibss1 = ibs1) - 1]) != 0) {
            for (int i = 1; i <= mbb; ++i) {
                int j1 = this.bbchr[0][i - 1][ibss1 - 1];
                int j2 = this.bbchr[1][i - 1][ibss1 - 1];
                int j3 = this.bbchr[2][i - 1][ibss1 - 1];
                int j4 = this.bbchr[3][i - 1][ibss1 - 1];
                if (this.nnb1[j1 - 1] == 0 || this.nnb1[j2 - 1] == 0 || this.nnb1[j3 - 1] == 0 || this.nnb1[j4 - 1] == 0) continue;
                ++this.nch;
                if (this.ioutpl != 0) {
                    this.outnuclinout.println("chiral centers of " + this.lb1b1[0] + " " + this.lb2b1[0] + " " + this.nnb1[j1 - 1] + " " + this.nnb1[j2 - 1] + " " + this.nnb1[j3 - 1] + " " + this.nnb1[j4 - 1] + " " + this.bbchv[i - 1][ibss1 - 1]);
                }
                String tmpr = this.nnb1[j1 - 1] + " " + this.nnb1[j2 - 1] + " " + this.nnb1[j3 - 1] + " " + this.nnb1[j4 - 1] + " " + this.bbchv[i - 1][ibss1 - 1];
                this.outchirlsbin.println(tmpr);
                Printing.justWritten(tmpr, this.chirlsbin);
            }
        }
        param[0] = irib1;
        param[1] = irib2;
        param[2] = ibs1;
        param[3] = ibs2;
        param[4] = mpl;
        param[5] = ires;
    }

    void bnds2() throws RnartException {
        Printing.entered();
        String[] id = new String[10000];
        double[][] xyz = new double[10000][3];
        int[][] ires = new int[2][999];
        String[] idres = new String[999];
        String[][] ib = new String[2][250];
        for (int i = 0; i < 250; ++i) {
            ib[1][i] = " ";
            ib[0][i] = " ";
        }
        int[][] ir = new int[2][250];
        double d = 0.0;
        float dd = 0.0f;
        int m = 0;
        String id1 = "";
        String id2 = "";
        String[] jd = new String[2];
        int ir1 = 0;
        int ir2 = 0;
        try {
            boolean bigbreak;
            String line;
            this.inatomsdat = new BufferedReader(new FileReader(this.atomsdat));
            int l0 = 0;
            int i = 0;
            while ((line = this.inatomsdat.readLine()) != null) {
                HD hd;
                try {
                    hd = new HD(line);
                }
                catch (ParsingException e) {
                    throw new RnartException(e);
                }
                int nn = hd.atomNumber;
                this.l1 = hd.residueName + "";
                int l2 = hd.residueNumber;
                String ida = hd.atomName;
                this.kss = hd.atomCode;
                this.x = hd.x;
                this.y = hd.y;
                this.z = hd.z;
                double bt = hd.b;
                double qocc = hd.q;
                while (l2 != l0) {
                    l2 = Math.abs(l2);
                    if (l0 > 0) {
                        ires[1][l0 - 1] = i;
                    }
                    l0 = l2;
                    idres[l0 - 1] = this.l1;
                    ires[0][l0 - 1] = i + 1;
                }
                id[++i - 1] = ida;
                double[] tmp = new double[]{this.x, this.y, this.z};
                xyz[i - 1] = this.ortho(tmp);
            }
            this.inatomsdat.close();
            boolean go219 = false;
            ires[1][l0 - 1] = i;
            this.outnuclinout.println();
            String tmpr = "Number of atoms and number of residues : " + i + " " + l0;
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
            tmpr = "List of hydrogen bonds restrained : ";
            this.outnuclinout.println(tmpr);
            Printing.justWritten(tmpr, this.nuclinout);
            double j11 = 0.0;
            int j1 = 1;
            int j2 = 5;
            int jend = 0;
            line = this.innuclindat.readLine();
            Printing.justRead(line, this.nuclindat);
            StringTokenizer tok = new StringTokenizer(line);
            int jcode = Tool.parseInt(tok.nextToken());
            if (jcode == 0) {
                go219 = true;
            } else {
                this.outscratch = new PrintWriter(new FileWriter(this.scratch));
                while (true) {
                    line = this.innuclindat.readLine();
                    Printing.justRead(line, this.nuclindat);
                    tok = new StringTokenizer(line);
                    for (int j = j1; j <= j2; ++j) {
                        if (tok.countTokens() > 3) {
                            ib[0][j - 1] = tok.nextToken();
                            ir[0][j - 1] = Tool.parseInt(tok.nextToken());
                            ib[1][j - 1] = tok.nextToken();
                            ir[1][j - 1] = Tool.parseInt(tok.nextToken());
                            continue;
                        }
                        ib[0][j - 1] = " ";
                    }
                    boolean go530 = false;
                    for (int j = j1; j <= j2; ++j) {
                        if (!ib[0][j - 1].equals(" ")) continue;
                        jend = j - 1;
                        go530 = true;
                        break;
                    }
                    if (go530) break;
                    j1 += 5;
                    j2 += 5;
                }
                d = 2.9;
                dd = 0.0f;
                int k1 = 1;
                int k2 = 2;
                for (int k = 1; k <= 2; ++k) {
                    for (int j = 1; j <= jend; ++j) {
                        if (ib[k1 - 1][j - 1].charAt(0) == 'G' || ib[k1 - 1][j - 1].charAt(0) == 'g') {
                            if (ib[k2 - 1][j - 1].charAt(0) == 'C' || ib[k2 - 1][j - 1].charAt(0) == 'c') {
                                ir1 = ir[k1 - 1][j - 1];
                                ir2 = ir[k2 - 1][j - 1];
                                jd[k1 - 1] = "O6";
                                jd[k2 - 1] = "N4";
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], d, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                                jd[k1 - 1] = "N1";
                                jd[k2 - 1] = "N3";
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], d, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                                jd[k1 - 1] = "N2";
                                jd[k2 - 1] = "O2";
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], d, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                                jd[k1 - 1] = "N1";
                                jd[k2 - 1] = "C4";
                                dd = 3.75f;
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], dd, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                                jd[k2 - 1] = "C2";
                                dd = 3.77f;
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], dd, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                            }
                            if (ib[k2 - 1][j - 1].charAt(0) == 'U' || ib[k2 - 1][j - 1].charAt(0) == 'u' || ib[k2 - 1][j - 1].charAt(0) == 'T' || ib[k2 - 1][j - 1].charAt(0) == 't') {
                                ir1 = ir[k1 - 1][j - 1];
                                ir2 = ir[k2 - 1][j - 1];
                                jd[k1 - 1] = "O6";
                                jd[k2 - 1] = "N3";
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], d, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                                jd[k1 - 1] = "N1";
                                jd[k2 - 1] = "O2";
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], d, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                                jd[k1 - 1] = "N1";
                                jd[k2 - 1] = "C2";
                                dd = 3.67f;
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], dd, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                                jd[k1 - 1] = "N1";
                                jd[k2 - 1] = "N3";
                                tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], dd, jcode);
                                this.outscratch.println(tmpr);
                                Printing.justWritten(tmpr, this.scratch);
                            }
                        }
                        if (ib[k1 - 1][j - 1].charAt(0) != 'A' && ib[k1 - 1][j - 1].charAt(0) != 'a' || ib[k2 - 1][j - 1].charAt(0) != 'U' && ib[k2 - 1][j - 1].charAt(0) != 'u' && ib[k2 - 1][j - 1].charAt(0) != 'T' && ib[k2 - 1][j - 1].charAt(0) != 't') continue;
                        ir1 = ir[k1 - 1][j - 1];
                        ir2 = ir[k2 - 1][j - 1];
                        jd[k1 - 1] = "N6";
                        jd[k2 - 1] = "O4";
                        tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], d, jcode);
                        this.outscratch.println(tmpr);
                        Printing.justWritten(tmpr, this.scratch);
                        jd[k1 - 1] = "N1";
                        jd[k2 - 1] = "N3";
                        tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], d, jcode);
                        this.outscratch.println(tmpr);
                        Printing.justWritten(tmpr, this.scratch);
                        jd[k1 - 1] = "N6";
                        jd[k2 - 1] = "C4";
                        dd = 3.7f;
                        tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], dd, jcode);
                        this.outscratch.println(tmpr);
                        Printing.justWritten(tmpr, this.scratch);
                        jd[k1 - 1] = "C6";
                        jd[k2 - 1] = "O4";
                        dd = 3.75f;
                        tmpr = this.scratch(ir1, jd[k1 - 1], ir2, jd[k2 - 1], dd, jcode);
                        this.outscratch.println(tmpr);
                        Printing.justWritten(tmpr, this.scratch);
                    }
                    k1 = 2;
                    k2 = 1;
                }
                this.outscratch.close();
                this.inhbnddat = new BufferedReader(new FileReader(this.scratch));
            }
            block12: do {
                boolean go222 = false;
                bigbreak = false;
                if (!go219) {
                    line = this.inhbnddat.readLine();
                    Printing.justRead(line, this.hbnddat);
                    if (line != null) {
                        tok = new StringTokenizer(line);
                        String tt = tok.nextToken();
                        int pos = TBMath.endOfInt(tt);
                        ir1 = Tool.parseInt(tt.substring(0, pos + 1));
                        id1 = tt.substring(pos + 1);
                        tt = tok.nextToken();
                        pos = TBMath.endOfInt(tt);
                        ir2 = Tool.parseInt(tt.substring(0, pos + 1));
                        id2 = tt.substring(pos + 1);
                        d = Tool.parseDouble(tok.nextToken());
                        j1 = Tool.parseInt(tok.nextToken());
                        go222 = true;
                    }
                    if (!go222) {
                        jcode = 999;
                    }
                }
                if (!go222 && !go219) {
                    this.inhbnddat.close();
                    this.inhbnddat = new BufferedReader(new FileReader(this.hbnddat));
                }
                while (true) {
                    if (!go222) {
                        line = this.inhbnddat.readLine();
                        Printing.justRead(line, this.hbnddat);
                        if (line == null) {
                            bigbreak = true;
                            continue block12;
                        }
                        ir1 = Tool.parseInt(line.substring(4, 7).replaceAll(" ", ""));
                        id1 = line.substring(7, 10).replaceAll(" ", "");
                        ir2 = Tool.parseInt(line.substring(13, 16).replaceAll(" ", ""));
                        id2 = line.substring(16, 19).replaceAll(" ", "");
                        d = Tool.parseDouble(line.substring(23, 26));
                        j1 = (int)Tool.parseDouble(line.substring(32, 33));
                    }
                    if (ir1 == 0 && ir2 == 0) {
                        bigbreak = true;
                        continue block12;
                    }
                    int i11 = ires[0][ir1 - 1];
                    int i12 = ires[1][ir1 - 1];
                    int i21 = ires[0][ir2 - 1];
                    int i22 = ires[1][ir2 - 1];
                    int i1 = 0;
                    int i2 = 0;
                    boolean go232 = false;
                    for (i1 = i11; i1 <= i12; ++i1) {
                        if (i1 == 0) {
                            go222 = false;
                            break;
                        }
                        if (!id1.equals(id[i1 - 1])) continue;
                        go232 = true;
                        break;
                    }
                    if (!go232) {
                        tmpr = idres[ir1 - 1] + " " + ir1 + " " + id1 + " not found";
                        this.outnuclinout.println(tmpr);
                        Printing.justWritten(tmpr, this.nuclinout);
                        continue;
                    }
                    go232 = false;
                    boolean go242 = false;
                    for (i2 = i21; i2 <= i22; ++i2) {
                        if (!id2.equals(id[i2 - 1])) continue;
                        go242 = true;
                        break;
                    }
                    if (!go242) {
                        tmpr = idres[ir2 - 1] + " " + ir2 + " " + id2 + " not found";
                        this.outnuclinout.println(tmpr);
                        Printing.justWritten(tmpr, this.nuclinout);
                        continue;
                    }
                    go242 = false;
                    dd = 0.0f;
                    for (int k = 0; k < 3; ++k) {
                        dd = (float)((double)dd + (xyz[i1 - 1][k] - xyz[i2 - 1][k]) * (xyz[i1 - 1][k] - xyz[i2 - 1][k]));
                    }
                    dd = (float)Math.sqrt(dd);
                    tmpr = ++m + " " + i1 + " " + i2 + " " + idres[ir1 - 1] + " " + ir1 + " " + id1 + " - " + idres[ir2 - 1] + " " + ir2 + " " + id2 + " " + d + " " + dd + " " + j1;
                    this.outnuclinout.println(tmpr);
                    Printing.justWritten(tmpr, this.nuclinout);
                    int i1i4 = i1;
                    int i2i4 = i2;
                    int j1i4 = j1;
                    String outLine = i1i4 + " " + i2i4 + " " + d + " " + j1i4;
                    Printing.justWritten(outLine, this.bndtntmp);
                    this.outbndtntmp.println(outLine);
                    if (jcode == 999) {
                        jcode = 0;
                        go219 = true;
                        continue block12;
                    }
                    if (jcode != 0) break;
                }
            } while (!bigbreak);
            this.inhbnddat.close();
            this.outbndtntmp.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void bndsrt() throws RnartException {
        Printing.entered();
        Printing.setVerboseMode(OutputMode.off);
        int h = 0;
        boolean blanks = false;
        int nn = 0;
        int nmax = 100000;
        int[] iatm1 = new int[nmax + 1];
        int[] iatm2 = new int[nmax + 1];
        int[] ibndt = new int[nmax + 1];
        double[] bnddst = new double[nmax + 1];
        int jatm1 = 0;
        int jatm2 = 0;
        int jbndt = 0;
        double dx = 0.0;
        int nd1 = 1;
        int nd2 = nmax;
        int nd3 = 1;
        int idx = 0;
        int isort = 0;
        boolean isym = false;
        boolean go351 = false;
        boolean end = true;
        boolean go550 = false;
        boolean inited = false;
        nd1 = nmax;
        nd2 = 1;
        nd3 = -1;
        isort = -1;
        try {
            this.outwrentmp = new PrintWriter(new FileWriter(this.wrentmp));
            this.outbndtntmp.close();
            this.inbndtntmp = new BufferedReader(new FileReader(this.bndtntmp));
            boolean go4 = false;
            while (go4 || idx < nmax) {
                go4 = false;
                String line = this.inbndtntmp.readLine();
                Printing.justRead(line, this.bndtntmp);
                if (line == null) {
                    this.inbndtntmp.close();
                    this.outbndtntmp = new PrintWriter(new FileWriter(this.bndtntmp));
                    break;
                }
                StringTokenizer tok = new StringTokenizer(line);
                jatm1 = Tool.parseInt(tok.nextToken());
                jatm2 = Tool.parseInt(tok.nextToken());
                double dst = Tool.parseDouble(tok.nextToken());
                jbndt = Tool.parseInt(tok.nextToken());
                if (jatm1 == 0 || jatm2 == 0 || jatm1 == jatm2) {
                    String tmpr = h + " " + jatm1 + " " + jatm2 + " " + dst + " " + jbndt + " - bad bound";
                    this.outnuclinout.println(tmpr);
                    Printing.justWritten(tmpr, this.nuclinout);
                    Printing.warning(tmpr);
                    go4 = true;
                    continue;
                }
                if (jatm1 > jatm2) {
                    h = jatm1;
                    jatm1 = jatm2;
                    jatm2 = h;
                }
                dx += 1.0;
                iatm1[++idx - 1] = jatm1;
                bnddst[idx - 1] = dst;
                iatm2[idx - 1] = jatm2;
                ibndt[idx - 1] = jbndt;
                if (jbndt != 21) continue;
                throw new RnartException("idx = " + idx + " iatm1 = " + jatm1 + " bnddst = " + dst + " iatmn2 = " + jatm2);
            }
            if (idx != 0) {
                int id1 = 1;
                int id2 = idx;
                int id3 = -1;
                this.sort(idx, iatm1, iatm2, bnddst, ibndt);
                id1 = idx;
                id2 = 1;
                id3 = -1;
                for (int i = id1; i >= id2; i += id3) {
                    nn = i;
                    String line = iatm1[i - 1] + " " + iatm2[nn - 1] + " " + bnddst[nn - 1] + " " + ibndt[nn - 1];
                    this.outwrentmp.println(line);
                    Printing.justWritten(line, this.wrentmp);
                }
            }
            idx = 0;
            int ncycle = 0;
            int nend = 0;
            int nturn = 0;
            boolean go667 = false;
            while (true) {
                ncycle = (int)((dx - 1.0) / (double)nmax);
                nend = (int)(dx - (double)(ncycle * nmax));
                nturn = (int)((dx - (double)nend) / (double)nmax);
                if (ncycle <= 0) {
                    go667 = true;
                    break;
                }
                if (nend != 0) break;
                ++nmax;
            }
            if (!go667) {
                for (int i = 1; i <= ncycle; ++i) {
                    int jj;
                    StringTokenizer tok;
                    String line;
                    StringTokenizer tok2;
                    int j;
                    this.outwrentmp.close();
                    this.inwrentmp = new BufferedReader(new FileReader(this.wrentmp));
                    this.inbndtntmp.close();
                    this.outbndtntmp = new PrintWriter(new FileWriter(this.bndtntmp));
                    if (nend != 0) {
                        for (j = 1; j <= nend; ++j) {
                            String line2 = this.inwrentmp.readLine();
                            Printing.justRead(line2, this.wrentmp);
                            tok2 = new StringTokenizer(line2);
                            iatm1[j - 1] = Tool.parseInt(tok2.nextToken());
                            iatm2[j - 1] = Tool.parseInt(tok2.nextToken());
                            bnddst[j - 1] = Tool.parseDouble(tok2.nextToken());
                            ibndt[j - 1] = Tool.parseInt(tok2.nextToken());
                            Printing.justWritten(line2, this.bndtntmp);
                            this.outbndtntmp.println(line2);
                        }
                    }
                    for (j = 1; j <= nturn; ++j) {
                        int jj2;
                        for (jj2 = 1; jj2 <= nmax; ++jj2) {
                            line = this.inwrentmp.readLine();
                            Printing.justRead(line, this.wrentmp);
                            tok = new StringTokenizer(line);
                            iatm1[jj2 - 1] = Tool.parseInt(tok.nextToken());
                            iatm2[jj2 - 1] = Tool.parseInt(tok.nextToken());
                            bnddst[jj2 - 1] = Tool.parseDouble(tok.nextToken());
                            ibndt[jj2 - 1] = Tool.parseInt(tok.nextToken());
                        }
                        this.sort(nmax, iatm1, iatm2, bnddst, ibndt);
                        for (jj2 = nd1; jj2 >= nd2; jj2 += nd3) {
                            nn = jj2;
                            String outLine = iatm1[jj2 - 1] + " " + iatm2[nn - 1] + " " + bnddst[nn - 1] + " " + ibndt[nn - 1];
                            Printing.justWritten(outLine, this.bndtntmp);
                            this.outbndtntmp.println(outLine);
                        }
                    }
                    this.inwrentmp.close();
                    this.outwrentmp = new PrintWriter(new FileWriter(this.wrentmp));
                    this.outbndtntmp.close();
                    this.inbndtntmp = new BufferedReader(new FileReader(this.bndtntmp));
                    for (j = 1; j <= nturn; ++j) {
                        int jj3;
                        for (jj3 = 1; jj3 <= nmax; ++jj3) {
                            line = this.inbndtntmp.readLine();
                            Printing.justRead(line, this.bndtntmp);
                            tok = new StringTokenizer(line);
                            iatm1[jj3 - 1] = Tool.parseInt(tok.nextToken());
                            iatm2[jj3 - 1] = Tool.parseInt(tok.nextToken());
                            bnddst[jj3 - 1] = Tool.parseDouble(tok.nextToken());
                            ibndt[jj3 - 1] = Tool.parseInt(tok.nextToken());
                        }
                        this.sort(nmax, iatm1, iatm2, bnddst, ibndt);
                        for (jj3 = nd1; jj3 >= nd2; jj3 += nd3) {
                            nn = jj3;
                            String tmpr = iatm1[jj3 - 1] + " " + iatm2[nn - 1] + " " + bnddst[nn - 1] + " " + ibndt[nn - 1];
                            this.outwrentmp.println(tmpr);
                            Printing.justWritten(tmpr, this.wrentmp);
                        }
                    }
                    for (jj = 1; jj <= nend; ++jj) {
                        String line3 = this.inbndtntmp.readLine();
                        Printing.justRead(line3, this.bndtntmp);
                        tok2 = new StringTokenizer(line3);
                        iatm1[jj - 1] = Tool.parseInt(tok2.nextToken());
                        iatm2[jj - 1] = Tool.parseInt(tok2.nextToken());
                        bnddst[jj - 1] = Tool.parseDouble(tok2.nextToken());
                        ibndt[jj - 1] = Tool.parseInt(tok2.nextToken());
                    }
                    for (jj = 1; jj <= nend; ++jj) {
                        String tmpr = iatm1[jj - 1] + " " + iatm2[jj - 1] + " " + bnddst[jj - 1] + " " + ibndt[jj - 1];
                        this.outwrentmp.println(tmpr);
                        Printing.justWritten(tmpr, this.wrentmp);
                    }
                }
            }
            this.outwrentmp.close();
            this.inwrentmp = new BufferedReader(new FileReader(this.wrentmp));
            this.inbndtntmp.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
        Printing.setWriteMode(OutputMode.off);
    }

    void sort(int idx, int[] a, int[] b, double[] c, int[] d) {
        Printing.entered();
        this.sort(a, b, c, d, 0, idx - 1);
    }

    void sort(int[] a, int[] b, double[] c, int[] d, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (lo >= hi) {
            return;
        }
        if (lo == hi - 1) {
            if (a[lo] < a[hi] || a[lo] == a[hi] && b[lo] <= b[hi]) {
                int T = a[lo];
                a[lo] = a[hi];
                a[hi] = T;
                int T2 = b[lo];
                b[lo] = b[hi];
                b[hi] = T2;
                double T3 = c[lo];
                c[lo] = c[hi];
                c[hi] = T3;
                int T4 = d[lo];
                d[lo] = d[hi];
                d[hi] = T4;
            }
            return;
        }
        int pivot1 = a[(lo + hi) / 2];
        a[(lo + hi) / 2] = a[hi];
        a[hi] = pivot1;
        int pivot2 = b[(lo + hi) / 2];
        b[(lo + hi) / 2] = b[hi];
        b[hi] = pivot2;
        double pivot3 = c[(lo + hi) / 2];
        c[(lo + hi) / 2] = c[hi];
        c[hi] = pivot2;
        int pivot4 = d[(lo + hi) / 2];
        d[(lo + hi) / 2] = d[hi];
        d[hi] = pivot4;
        while (lo < hi) {
            while ((a[lo] > pivot1 || a[lo] == pivot1 && b[lo] >= pivot2) && lo < hi) {
                ++lo;
            }
            while ((pivot1 > a[hi] || pivot1 == a[hi] && pivot2 >= b[hi]) && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            int T = a[lo];
            a[lo] = a[hi];
            a[hi] = T;
            int T2 = b[lo];
            b[lo] = b[hi];
            b[hi] = T2;
            double T3 = c[lo];
            c[lo] = c[hi];
            c[hi] = T3;
            int T4 = d[lo];
            d[lo] = d[hi];
            d[hi] = T4;
        }
        a[hi0] = a[hi];
        b[hi0] = b[hi];
        c[hi0] = c[hi];
        d[hi0] = d[hi];
        a[hi] = pivot1;
        b[hi] = pivot2;
        c[hi] = pivot3;
        d[hi] = pivot4;
        this.sort(a, b, c, d, lo0, lo - 1);
        this.sort(a, b, c, d, hi + 1, hi0);
    }

    void nblist(int ioutnb) throws RnartException {
        Printing.entered();
        String[] l3 = new String[10000];
        double[][] xyz = new double[10000][3];
        int[] ks = new int[10000];
        double[] dddst = new double[20];
        int[] ibnd = new int[20];
        int[] ibndt = new int[20];
        char[] l1 = new char[10000];
        int[] l2 = new int[10000];
        int na = 0;
        int nb = 0;
        int ntyp = 0;
        int ii4 = 0;
        int i2i4 = 0;
        int iti4 = 0;
        double[][] bdst = new double[][]{{3.4, 3.2, 3.1, 3.7, 3.6, 3.6}, {3.2, 3.0, 3.0, 3.5, 2.2, 2.6}, {3.1, 3.0, 3.1, 3.5, 2.2, 2.6}, {3.7, 3.5, 3.5, 3.8, 3.6, 3.6}, {3.6, 2.2, 2.2, 3.6, 3.6, 3.6}, {3.6, 2.6, 2.6, 3.6, 3.6, 3.6}};
        double dstmx = 16.0;
        boolean go1401 = false;
        try {
            this.inatomsdat = new BufferedReader(new FileReader(this.atomsdat));
            int i = 0;
            for (i = 1; i <= 10000; ++i) {
                HD hd;
                String line = this.inatomsdat.readLine();
                if (line == null) {
                    --i;
                    break;
                }
                try {
                    hd = new HD(line);
                }
                catch (ParsingException e) {
                    throw new RnartException(e);
                }
                l1[i - 1] = hd.residueName;
                l2[i - 1] = hd.residueNumber;
                l3[i - 1] = hd.atomName;
                ks[i - 1] = hd.atomCode;
                double[] tmp = new double[]{hd.x, hd.y, hd.z};
                xyz[i - 1] = this.ortho(tmp);
            }
            int in = ++i - 1;
            this.inatomsdat.close();
            this.outdistbin = new PrintWriter(new FileWriter(this.distbin));
            this.outvdwdstbin = new PrintWriter(new FileWriter(this.vdwdstbin));
            if (ioutnb == 1) {
                this.outnuclinout.println();
                this.outnuclinout.println(" List of van der waals contacts : \n");
            }
            int in1 = in - 1;
            int i1 = 0;
            int jn = 0;
            String line = this.inwrentmp.readLine();
            Printing.justRead(line, this.wrentmp);
            if (line != null) {
                StringTokenizer tok = new StringTokenizer(line);
                na = Tool.parseInt(tok.nextToken());
                nb = Tool.parseInt(tok.nextToken());
                double ddst = Tool.parseDouble(tok.nextToken());
                ntyp = Tool.parseInt(tok.nextToken());
                if (ddst == 0.0) {
                    this.outnuclinout.println("Distance is zero between " + na + " " + nb + "\n");
                }
                if (na != 0 || nb != 0) {
                    if (ntyp <= 5 || ntyp == 8) {
                        this.outdistbin.println(line);
                        Printing.justWritten(line, this.distbin);
                    }
                    na = Math.abs(na);
                    int nn = 0;
                    for (i = 1; i <= in1; ++i) {
                        while (na == i) {
                            if (++jn > 20) {
                                throw new RnartException("Bug jn > 20");
                            }
                            ibnd[jn - 1] = nb;
                            ibndt[jn - 1] = ntyp;
                            dddst[jn - 1] = ddst;
                            line = this.inwrentmp.readLine();
                            Printing.justRead(line, this.wrentmp);
                            if (line != null) {
                                go1401 = false;
                                tok = new StringTokenizer(line);
                                na = Tool.parseInt(tok.nextToken());
                                nb = Tool.parseInt(tok.nextToken());
                                ddst = Tool.parseDouble(tok.nextToken());
                                ntyp = Tool.parseInt(tok.nextToken());
                                if (ddst == 0.0) {
                                    this.outnuclinout.println(" Distance is zero between " + na + " " + nb + "\n");
                                }
                                if (ntyp <= 5 || ntyp == 8) {
                                    this.outdistbin.println(line);
                                    Printing.justWritten(line, this.distbin);
                                }
                                na = Math.abs(na);
                                continue;
                            }
                            go1401 = true;
                            break;
                        }
                        if (!go1401) {
                            block7: for (int i2 = i1 = i + 1; i2 <= in; ++i2) {
                                double dst = 0.0;
                                for (int k = 0; k < 3; ++k) {
                                    dst += (xyz[i - 1][k] - xyz[i2 - 1][k]) * (xyz[i - 1][k] - xyz[i2 - 1][k]);
                                }
                                boolean doIt = false;
                                if (dst <= dstmx) {
                                    doIt = true;
                                }
                                while (doIt) {
                                    int ii2;
                                    int ii1;
                                    doIt = false;
                                    dst = Math.sqrt(dst);
                                    int it = 2;
                                    if (jn != 0) {
                                        int j = 0;
                                        boolean skip = false;
                                        for (j = 1; j <= jn; ++j) {
                                            if (ibnd[j - 1] != i2) continue;
                                            skip = true;
                                            break;
                                        }
                                        if (skip) {
                                            if (ibndt[j - 1] <= 5) continue block7;
                                            if (ibndt[j - 1] == 7) {
                                                it = 3;
                                            }
                                            if (ibndt[j - 1] == 8 || ibndt[j - 1] == 6) {
                                                it = 1;
                                            }
                                        }
                                    }
                                    if ((ii1 = ks[i - 1]) > 6) {
                                        ii1 = 4;
                                    }
                                    if ((ii2 = ks[i2 - 1]) > 6) {
                                        ii2 = 4;
                                    }
                                    ++nn;
                                    ii4 = i;
                                    i2i4 = i2;
                                    iti4 = it;
                                    String tmpr = ii4 + " " + i2i4 + " " + bdst[ii1 - 1][ii2 - 1] + " " + iti4;
                                    this.outvdwdstbin.println(tmpr);
                                    Printing.justWritten(tmpr, this.vdwdstbin);
                                    if (it == 2 && dst <= bdst[ii1 - 1][ii2 - 1] + 0.4 && ioutnb != 0) {
                                        this.outnuclinout.println(nn + " " + l1[i - 1] + " " + l2[i - 1] + " " + l3[i - 1] + " - " + l1[i2 - 1] + " " + l2[i2 - 1] + " " + l3[i2 - 1] + bdst[ii1 - 1][ii2 - 1] + " " + dst + " " + it + " " + i + " " + i2 + " " + ii1 + " " + ii2);
                                    }
                                    if (it != 2 && dst <= bdst[ii1 - 1][ii2 - 1] && ioutnb != 0) {
                                        this.outnuclinout.println(nn + " " + l1[i - 1] + " " + l2[i - 1] + " " + l3[i - 1] + " - " + l1[i2 - 1] + " " + l2[i2 - 1] + " " + l3[i2 - 1] + bdst[ii1 - 1][ii2 - 1] + " " + dst + " " + it + " " + i + " " + i2 + " " + ii1 + " " + ii2);
                                    }
                                    if (dst != 0.0) continue;
                                    this.outnuclinout.println(" Distance is zero between " + i + " " + i2);
                                }
                            }
                        }
                        jn = 0;
                    }
                }
            }
            this.inwrentmp.close();
            this.outdistbin.close();
            this.outvdwdstbin.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
        Printing.setReadMode(OutputMode.off);
    }

    void nblist2(int ioutnb) throws RnartException {
        Printing.entered();
        String[] l3 = new String[10000];
        String[] l1 = new String[10000];
        String[] l2 = new String[10000];
        double[][] xyz = new double[10000][3];
        int[] ks = new int[10000];
        double[] dddst = new double[20];
        int[] ibnd = new int[20];
        double[] ibndt = new double[20];
        double[][] bdst = new double[][]{{3.4, 3.2, 3.1, 3.7, 3.6, 3.6}, {3.2, 3.0, 3.0, 3.5, 2.2, 2.6}, {3.1, 3.0, 3.1, 3.5, 2.2, 2.6}, {3.7, 3.5, 3.5, 3.8, 3.6, 3.6}, {3.6, 2.2, 2.2, 3.6, 3.6, 3.6}, {3.6, 2.6, 2.6, 3.6, 3.6, 3.6}};
        double dstmx = 16.0;
        try {
            String line;
            this.inatomsdat = new BufferedReader(new FileReader(this.atomsdat));
            int i = 0;
            boolean secBreak = false;
            while ((line = this.inatomsdat.readLine()) != null) {
                HD hd;
                Printing.justRead(line, this.atomsdat);
                try {
                    hd = new HD(line);
                }
                catch (ParsingException e) {
                    throw new RnartException(e);
                }
                l1[i] = hd.residueName + "";
                l2[i] = hd.residueNumber + "";
                l3[i] = hd.atomName;
                ks[i] = hd.atomCode;
                double x = hd.x;
                double y = hd.y;
                double z = hd.z;
                double[] tmp = new double[]{x, y, z};
                xyz[i] = this.ortho(tmp);
                ++i;
            }
            int in = i;
            this.inatomsdat.close();
            this.outdistbin = new PrintWriter(new FileWriter(this.distbin));
            this.outvdwdstbin = new PrintWriter(new FileWriter(this.vdwdstbin));
            if (ioutnb == 1) {
                this.outnuclinout.println("");
                String tmpr = "(' List of van der waals contacts : ',/)";
                this.outnuclinout.println(tmpr);
                Printing.justWritten(tmpr, this.nuclinout);
            }
            int in1 = in - 1;
            int jn = 0;
            line = this.inwrentmp.readLine();
            Printing.justRead(line, this.wrentmp);
            if (line != null) {
                StringTokenizer tok = new StringTokenizer(line);
                int na = Tool.parseInt(tok.nextToken());
                int nb = Tool.parseInt(tok.nextToken());
                double ddst = Tool.parseDouble(tok.nextToken());
                double ntyp = Tool.parseDouble(tok.nextToken());
                if (ddst == 0.0) {
                    String tmpr = "(' Distance is zero between ' " + na + " " + nb + " /)";
                    this.outnuclinout.println(tmpr);
                    Printing.justWritten(tmpr, this.nuclinout);
                }
                if (na != 0 || nb != 0) {
                    if (ntyp < 5.0 || ntyp == 8.0) {
                        this.outdistbin.println(line);
                        Printing.justWritten(line, this.distbin);
                    }
                    na = Math.abs(na);
                    int nn = 0;
                    for (i = 1; i <= in1; ++i) {
                        while (na == i) {
                            if (++jn > 20) {
                                throw new RnartException(i + " bug in nblist(" + ioutnb + ") jn = " + jn + " > 20");
                            }
                            ibnd[jn - 1] = nb;
                            ibndt[jn - 1] = ntyp;
                            dddst[jn - 1] = ddst;
                            line = this.inwrentmp.readLine();
                            Printing.justRead(line, this.wrentmp);
                            if (line == null) {
                                secBreak = true;
                                break;
                            }
                            tok = new StringTokenizer(line);
                            na = Tool.parseInt(tok.nextToken());
                            nb = Tool.parseInt(tok.nextToken());
                            ddst = Tool.parseDouble(tok.nextToken());
                            ntyp = Tool.parseDouble(tok.nextToken());
                            if (ddst == 0.0) {
                                String tmpr = " Distance is zero between  " + na + " " + nb + "\n";
                                this.outnuclinout.println(tmpr);
                                Printing.justWritten(tmpr, this.nuclinout);
                            }
                            if (ntyp < 5.0 || ntyp == 8.0) {
                                this.outdistbin.println(line);
                                Printing.justWritten(line, this.distbin);
                            }
                            na = Math.abs(na);
                        }
                        if (!secBreak) {
                            int i1;
                            for (int i2 = i1 = i + 1; i2 <= in; ++i2) {
                                int ii2;
                                int ii1;
                                double dst = 0.0;
                                for (int k = 0; k < 3; ++k) {
                                    dst += (xyz[i - 1][k] - xyz[i2 - 1][k]) * (xyz[i - 1][k] - xyz[i2 - 1][k]);
                                }
                                if (dst > dstmx) continue;
                                dst = Math.sqrt(dst);
                                int it = 2;
                                boolean bigbreak = false;
                                if (jn == 0) {
                                    for (int j = 0; j < jn; ++j) {
                                        if (ibnd[j] != i2) continue;
                                        if (ibndt[j] < 5.0) {
                                            bigbreak = true;
                                        }
                                        if (ibndt[j] == 7.0) {
                                            it = 3;
                                        }
                                        if (ibndt[j] != 8.0 && ibndt[j] != 6.0) break;
                                        it = 1;
                                        break;
                                    }
                                    if (bigbreak) break;
                                }
                                if ((ii1 = ks[i - 1]) > 6) {
                                    ii1 = 4;
                                }
                                if ((ii2 = ks[i2 - 1]) > 6) {
                                    ii2 = 4;
                                }
                                ++nn;
                                int ii4 = i - 1;
                                int i2i4 = i2 - 1;
                                int iti4 = it;
                                String tmpr = ii4 + " " + i2i4 + " " + bdst[ii1][ii2] + " " + iti4;
                                this.outvdwdstbin.println(tmpr);
                                Printing.justWritten(tmpr, this.vdwdstbin);
                                if (it == 2 && dst <= bdst[ii1][ii2] + 0.4 && ioutnb != 0 || it != 2 && dst <= bdst[ii1][ii2] && ioutnb != 0) {
                                    tmpr = nn + " " + l1[i - 1] + " " + l2[i - 1] + " " + l3[i - 1] + " " + l1[i2 - 1] + " " + l2[i2 - 1] + " " + l3[i2 - 1] + " " + bdst[ii1][ii2] + " " + dst + " " + it + " " + i + " " + i2 + " " + ii1 + " " + ii2;
                                    this.outnuclinout.println(tmpr);
                                    Printing.justWritten(tmpr, this.nuclinout);
                                }
                                if (dst != 0.0) continue;
                                tmpr = " Distance is zero between  " + i + " " + i2 + "\n";
                                this.outnuclinout.println(tmpr);
                                Printing.justWritten(tmpr, this.nuclinout);
                            }
                        }
                        secBreak = false;
                        jn = 0;
                    }
                }
            }
            this.inwrentmp.close();
            this.outdistbin.close();
            this.outvdwdstbin.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void sugr(int ip) throws RnartException {
        Printing.entered();
        int[] iatom = new int[4];
        int[][] iat = new int[4][4];
        int[] it = new int[9];
        int[] nn = new int[30];
        double[] vn = new double[]{0.018, -1.198, 1.969, -1.884, 1.096};
        double[] vids = new double[]{2.52, 2.49, 2.74, 2.44};
        double[] vs = new double[]{-1.106, 1.835, -1.955, 1.24, -0.013};
        try {
            String line = this.innuclindat.readLine();
            Printing.justRead(line, this.nuclindat);
            int nucl = Tool.parseInt(line);
            line = this.innuclindat.readLine();
            Printing.justRead(line, this.nuclindat);
            StringTokenizer tok = new StringTokenizer(line);
            int ntim = Tool.parseInt(tok.nextToken());
            for (int i = 0; i < ntim; ++i) {
                nn[i] = Tool.parseInt(tok.nextToken());
            }
            if (ntim != 0) {
                this.inchirlsbin = new BufferedReader(new FileReader(this.chirlsbin));
                this.outchirls2bin = new PrintWriter(new FileWriter(this.chirls2bin));
                int ninc = 3;
                if (ip == 1) {
                    ninc = 4;
                }
                for (int k = 0; k < ntim; k += ninc) {
                    int kj;
                    int ik;
                    int j;
                    int n1 = nn[k];
                    int n2 = nn[k + 1];
                    int n3 = nn[k + 2];
                    int n4 = 1;
                    if (ip == 1) {
                        n4 = nn[k + 3];
                    }
                    if (n1 != 0) {
                        for (j = 0; j < n1; ++j) {
                            for (ik = 0; ik < nucl; ++ik) {
                                line = this.inchirlsbin.readLine();
                                Printing.justRead(line, this.chirlsbin);
                                this.outchirls2bin.println(line);
                                tok = new StringTokenizer(line);
                                iatom[0] = Tool.parseInt(tok.nextToken());
                                iatom[1] = Tool.parseInt(tok.nextToken());
                                iatom[2] = Tool.parseInt(tok.nextToken());
                                iatom[3] = Tool.parseInt(tok.nextToken());
                                int vid = Tool.parseInt(tok.nextToken());
                                for (int kj2 = 0; kj2 < 4; ++kj2) {
                                    iat[ik][kj2] = iatom[kj2];
                                }
                            }
                            it[0] = iat[0][3];
                            it[1] = iat[1][1];
                            it[2] = iat[1][0];
                            it[3] = iat[0][2];
                            it[4] = iat[0][0];
                            if (nucl == 4) {
                                it[1] = iat[2][0];
                                it[2] = iat[2][2];
                            }
                            for (kj = 0; kj < 4; ++kj) {
                                it[kj + 5] = it[kj];
                            }
                            for (ik = 0; ik < 5; ++ik) {
                                this.outchirls2bin.println(it[ik + 1] + " " + it[ik + 2] + " " + it[ik + 4] + " " + it[ik] + " " + vn[ik]);
                            }
                        }
                    }
                    if (n2 != 0) {
                        for (j = 0; j < n2; ++j) {
                            for (ik = 0; ik < nucl; ++ik) {
                                line = this.inchirlsbin.readLine();
                                Printing.justRead(line, this.chirlsbin);
                                tok = new StringTokenizer(line);
                                for (int i = 0; i < 4; ++i) {
                                    iatom[i] = Tool.parseInt(tok.nextToken());
                                }
                                double vid = Tool.parseDouble(tok.nextToken());
                                if (nucl == 4) {
                                    this.outchirls2bin.println(iatom[0] + " " + iatom[1] + " " + iatom[2] + " " + iatom[3] + " " + vids[ik]);
                                } else if (ik >= 0 && ik < 3) {
                                    this.outchirls2bin.println(iatom[0] + " " + iatom[1] + " " + iatom[2] + " " + iatom[3] + " " + vids[ik]);
                                }
                                for (int kj3 = 0; kj3 < 4; ++kj3) {
                                    iat[ik][kj3] = iatom[kj3];
                                }
                            }
                            it[0] = iat[0][3];
                            it[1] = iat[1][1];
                            it[2] = iat[1][0];
                            it[3] = iat[0][2];
                            it[4] = iat[0][0];
                            if (nucl != 4) {
                                it[1] = iat[2][0];
                                it[2] = iat[2][2];
                            }
                            for (kj = 0; kj < 4; ++kj) {
                                it[kj + 5] = it[kj];
                            }
                            for (ik = 0; ik < 5; ++ik) {
                                this.outchirls2bin.println(it[ik + 1] + " " + it[ik + 2] + " " + it[ik + 4] + " " + it[ik] + " " + vs[ik]);
                            }
                        }
                    }
                    if (ip == 0 || n4 == 0) continue;
                    for (j = 0; j < n4; ++j) {
                        int ncl = nucl + 5;
                        for (int ik2 = 0; ik2 < ncl; ++ik2) {
                            line = this.inchirlsbin.readLine();
                            Printing.justRead(line, this.chirlsbin);
                            this.outchirls2bin.println(line);
                        }
                    }
                }
                while ((line = this.inchirlsbin.readLine()) != null) {
                    Printing.justRead(line, this.chirlsbin);
                    this.outchirls2bin.println(line);
                }
                this.inchirlsbin.close();
                this.outchirls2bin.close();
                this.outchirlsbin.close();
                this.inchirls2bin.close();
                SystemTools.mv(this.chirls2bin, this.chirlsbin);
                this.inchirls2bin = new BufferedReader(new FileReader(this.chirlsbin));
            }
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void fcvt(int ip, int ig, int it, int is, int io, int nbg1, int ned1, int nbg2, int ned2, double qf1, int temp, String amod) throws RnartException {
        Printing.entered();
        Printing.setWriteMode(OutputMode.off);
        Printing.setReadMode(OutputMode.off);
        int[] lat4 = new int[20];
        int[] iatom4 = new int[4];
        int[] idist4 = new int[10];
        int[] ns4 = new int[4];
        int[] iat4 = new int[150];
        int[] it4 = new int[6];
        int nx4 = 0;
        int[] id4 = new int[8];
        int mpl4 = 0;
        double[] shell = new double[]{5.0, 3.5, 2.8, 2.2, 1.9, 1.65, 1.4};
        int[] no = new int[200000];
        int[] nt = new int[200000];
        double[] rest = new double[10];
        int noat4 = 0;
        int nochrl4 = 0;
        int novdw4 = 0;
        int itemp = 0;
        int id = 0;
        int iat1 = 0;
        try {
            int i;
            int iwt4;
            int ires4;
            int i2;
            int iat2;
            int l;
            int m;
            int na4;
            StringTokenizer tok;
            String line;
            this.innuclindat = new BufferedReader(new FileReader(this.nuclindat));
            String title = this.innuclindat.readLine();
            Printing.justRead(title, this.nuclindat);
            this.innuclindat.close();
            this.outlsqinp = new PrintWriter(new FileWriter(this.lsqinp));
            this.inatomsdat = new BufferedReader(new FileReader(this.atomsdat));
            int noat = 0;
            while ((line = this.inatomsdat.readLine()) != null) {
                HD hd;
                Printing.justRead(line, this.atomsdat);
                String label = line.substring(7, 15);
                try {
                    hd = new HD(line);
                }
                catch (ParsingException e) {
                    throw new RnartException(e);
                }
                int ksatm = hd.atomCode;
                double xf = hd.x;
                double yf = hd.y;
                double zf = hd.z;
                double bt = hd.b;
                double qocc = hd.q;
                ++noat;
                if (qocc == 0.0) {
                    qocc = 1.0;
                }
                if (io != 0) {
                    if (noat >= nbg1 && noat <= ned1) {
                        qocc = qf1;
                    }
                    if (noat >= nbg2 && noat <= ned2) {
                        qocc = 1.0 - qf1;
                    }
                }
                noat4 = noat;
                int ksatm4 = ksatm;
                char resName = label.charAt(0);
                int resNum = Tool.parseInt(label.substring(1, 4).replaceAll(" ", ""));
                String atomName = label.substring(4);
                try {
                    line = HD.getAtomString(noat4, resName, resNum, atomName, ksatm4, xf, yf, zf, bt, qocc);
                }
                catch (ParsingException e) {
                    throw new RnartException(e);
                }
                this.outlsqinp.println(line);
            }
            this.inatomsdat.close();
            this.indistbin = new BufferedReader(new FileReader(this.distbin));
            int nip4 = 0;
            while ((line = this.indistbin.readLine()) != null) {
                Printing.justRead(line, this.distbin);
                tok = new StringTokenizer(line);
                int na = Tool.parseInt(tok.nextToken());
                int nb = Tool.parseInt(tok.nextToken());
                double ddst = Tool.parseDouble(tok.nextToken());
                double ntyp = Tool.parseDouble(tok.nextToken());
                if (ddst == 0.0) break;
                ++nip4;
                if (ntyp == 8.0) {
                    ntyp = 0.0;
                }
                na4 = na;
                int nb4 = nb;
                double ntyp4 = ntyp;
                this.outlsqinp.println(nip4 + " " + na4 + " " + nb4 + " " + ddst + " " + (int)ntyp4);
                no[nip4 - 1] = na4;
                nt[nip4 - 1] = nb4;
            }
            this.indistbin.close();
            this.inplansbin = new BufferedReader(new FileReader(this.plansbin));
            while ((line = this.inplansbin.readLine()) != null) {
                int j;
                Printing.justRead(line, this.plansbin);
                tok = new StringTokenizer(line);
                int mpl = Tool.parseInt(tok.nextToken());
                int na = Tool.parseInt(tok.nextToken());
                int[] lat = new int[na];
                for (j = 0; j < na; ++j) {
                    lat[j] = Tool.parseInt(tok.nextToken());
                }
                mpl4 = mpl;
                na4 = na;
                for (j = 0; j < na; ++j) {
                    lat4[j] = lat[j];
                }
                String tmp = mpl4 + " " + na4;
                for (int j2 = 0; j2 < na; ++j2) {
                    tmp = tmp + " " + lat4[j2];
                }
                this.outlsqinp.println(tmp);
            }
            this.inplansbin.close();
            this.inchirlsbin = new BufferedReader(new FileReader(this.chirlsbin));
            int nochrl = 0;
            for (int i3 = 0; i3 < 10; ++i3) {
                idist4[i3] = 0;
            }
            while ((line = this.inchirlsbin.readLine()) != null) {
                Printing.justRead(line, this.chirlsbin);
                StringTokenizer tok2 = new StringTokenizer(line);
                int[] iatom = new int[4];
                for (int i4 = 0; i4 < 4; ++i4) {
                    iatom[i4] = Tool.parseInt(tok2.nextToken());
                }
                double videal = Tool.parseDouble(tok2.nextToken());
                nochrl4 = ++nochrl;
                for (int i5 = 0; i5 < 4; ++i5) {
                    iatom4[i5] = iatom[i5];
                }
                m = 0;
                for (int ia = 1; ia <= 3; ++ia) {
                    l = ia + 1;
                    iat1 = iatom4[ia - 1];
                    block17: for (int ja = l; ja <= 4; ++ja) {
                        ++m;
                        iat2 = iatom4[ja - 1];
                        for (int j1 = 1; j1 <= nip4; ++j1) {
                            if (no[j1 - 1] == iat1 && nt[j1 - 1] == iat2) {
                                idist4[m - 1] = j1;
                                continue block17;
                            }
                            if (no[j1 - 1] != iat2 || nt[j1 - 1] != iat1) continue;
                            idist4[m - 1] = -j1;
                            continue block17;
                        }
                    }
                }
                this.outlsqinp.println(nochrl4 + " " + iatom4[0] + " " + iatom4[1] + " " + iatom4[2] + " " + iatom4[3] + " " + idist4[0] + " " + idist4[1] + " " + idist4[2] + " " + idist4[3] + " " + idist4[4] + " " + idist4[5] + " " + videal);
            }
            this.inchirlsbin.close();
            this.invdwdstbin = new BufferedReader(new FileReader(this.vdwdstbin));
            int novdw = 0;
            while ((line = this.invdwdstbin.readLine()) != null) {
                Printing.justRead(line, this.vdwdstbin);
                StringTokenizer tok3 = new StringTokenizer(line);
                int ia1 = Tool.parseInt(tok3.nextToken());
                int ja1 = Tool.parseInt(tok3.nextToken());
                double dnbc = Tool.parseDouble(tok3.nextToken());
                int ktyp = Tool.parseInt(tok3.nextToken());
                if (dnbc == 0.0) break;
                novdw4 = ++novdw;
                int ia4 = ia1;
                int ja4 = ja1;
                int ktyp4 = ktyp;
                this.outlsqinp.println(novdw4 + " " + ia4 + " " + ja4 + " " + dnbc + " " + ktyp4);
            }
            this.invdwdstbin.close();
            for (i2 = 0; i2 < 10; ++i2) {
                idist4[i2] = 0;
            }
            int ntor4 = 0;
            ns4[0] = 0;
            ns4[1] = 0;
            ns4[2] = 0;
            ns4[3] = 0;
            if (it != 0) {
                this.intorfixbin = new BufferedReader(new FileReader(this.torfixbin));
                while ((line = this.intorfixbin.readLine()) != null) {
                    int i6;
                    Printing.justRead(line, this.torfixbin);
                    StringTokenizer tok4 = new StringTokenizer(line);
                    nx4 = Tool.parseInt(tok4.nextToken());
                    ires4 = Tool.parseInt(tok4.nextToken());
                    int iang4 = Tool.parseInt(tok4.nextToken());
                    for (i6 = 0; i6 < 4; ++i6) {
                        iatom4[i6] = Tool.parseInt(tok4.nextToken());
                    }
                    for (i6 = 0; i6 < 6; ++i6) {
                        idist4[i6] = Tool.parseInt(tok4.nextToken());
                    }
                    iwt4 = Tool.parseInt(tok4.nextToken());
                    int tag = Tool.parseInt(tok4.nextToken());
                    m = 0;
                    boolean bigbreak = false;
                    block24: for (int ia = 1; ia <= 3; ++ia) {
                        for (int ja = l = ia + 1; ja <= 4; ++ja) {
                            ++m;
                            iat2 = iatom4[ja - 1];
                            for (int j1 = 1; j1 <= nip4; ++j1) {
                                if (no[j1 - 1] == iat1 && nt[j1 - 1] == iat2) {
                                    idist4[m - 1] = j1;
                                    bigbreak = true;
                                    break;
                                }
                                if (no[j1 - 1] != iat2 || nt[j1 - 1] != iat1) continue;
                                idist4[m - 1] = -j1;
                                bigbreak = true;
                                break;
                            }
                            if (bigbreak) continue block24;
                        }
                    }
                    ++ntor4;
                    this.outlsqinp.println(nx4 + " " + ires4 + " " + iang4 + " " + iatom4[0] + " " + iatom4[1] + " " + iatom4[2] + " " + iatom4[3] + " " + idist4[0] + " " + idist4[1] + " " + idist4[2] + " " + idist4[3] + " " + idist4[4] + " " + idist4[5] + " " + iwt4 + " " + tag);
                }
                this.intorfixbin.close();
                for (i2 = 0; i2 < 10; ++i2) {
                    idist4[i2] = 0;
                }
            }
            int nps4 = 0;
            if (ip != 0) {
                this.inpseubin = new BufferedReader(new FileReader(this.pseubin));
                while ((line = this.inpseubin.readLine()) != null) {
                    Printing.justRead(line, this.pseubin);
                    StringTokenizer tok5 = new StringTokenizer(line);
                    nx4 = Tool.parseInt(tok5.nextToken());
                    ires4 = Tool.parseInt(tok5.nextToken());
                    for (int i7 = 0; i7 < 5; ++i7) {
                        it4[i7] = Tool.parseInt(tok5.nextToken());
                    }
                    int iwp4 = Tool.parseInt(tok5.nextToken());
                    int iwtm4 = Tool.parseInt(tok5.nextToken());
                    int tagp = Tool.parseInt(tok5.nextToken());
                    int tagtm = Tool.parseInt(tok5.nextToken());
                    m = 0;
                    block30: for (int ia = 1; ia <= 4; ++ia) {
                        l = ia + 1;
                        iat1 = it4[ia - 1];
                        boolean bigbreak = false;
                        for (int ja = l; ja <= 5; ++ja) {
                            ++m;
                            iat2 = it4[ja - 1];
                            for (int j1 = 1; j1 <= nip4; ++j1) {
                                if (no[j1 - 1] == iat1 && nt[j1 - 1] == iat2) {
                                    idist4[m - 1] = j1;
                                    bigbreak = true;
                                    break;
                                }
                                if (no[j1 - 1] != iat2 || nt[j1 - 1] != iat1) continue;
                                idist4[m - 1] = -j1;
                                bigbreak = true;
                                break;
                            }
                            if (bigbreak) continue block30;
                        }
                    }
                    this.outlsqinp.println(nx4 + " " + ires4 + " " + it4[0] + " " + it4[1] + " " + it4[2] + " " + it4[3] + " " + it4[4] + " " + idist4[0] + " " + idist4[1] + " " + idist4[2] + " " + idist4[3] + " " + idist4[4] + " " + idist4[5] + " " + idist4[6] + " " + idist4[7] + " " + idist4[8] + " " + idist4[9] + " " + iwp4 + " " + iwtm4 + " " + tagp + " " + tagtm);
                }
                this.inpseubin.close();
                nps4 = nx4;
            }
            if (is != 0) {
                this.insymtrybin = new BufferedReader(new FileReader(this.symtrybin));
                line = this.insymtrybin.readLine();
                Printing.justRead(line, this.symtrybin);
                int igr4 = Tool.parseInt(line);
                for (int ik = 1; ik <= igr4; ++ik) {
                    line = this.insymtrybin.readLine();
                    Printing.justRead(line, this.symtrybin);
                    StringTokenizer tok6 = new StringTokenizer(line);
                    na4 = Tool.parseInt(tok6.nextToken());
                    iwt4 = Tool.parseInt(tok6.nextToken());
                    for (int j = 0; j <= na4; ++j) {
                        id4[j] = Tool.parseInt(tok6.nextToken());
                    }
                    this.outlsqinp.println(line);
                    if (iwt4 != 0) {
                        for (int ix = 1; ix <= na4; ++ix) {
                            line = this.insymtrybin.readLine();
                            Printing.justRead(line, this.symtrybin);
                        }
                        this.outlsqinp.println(line);
                    }
                    line = this.insymtrybin.readLine();
                    Printing.justRead(line, this.symtrybin);
                    ns4[ik - 1] = Tool.parseInt(line);
                    int ntot = ns4[ik - 1];
                    for (int i8 = 1; i8 <= ntot; ++i8) {
                        line = this.insymtrybin.readLine();
                        Printing.justRead(line, this.symtrybin);
                        this.outlsqinp.println(line);
                    }
                }
                this.insymtrybin.close();
            }
            this.outlsqinp.close();
            this.outlsqdat = new PrintWriter(new FileWriter(this.lsqdat));
            this.inrestraintdc = new BufferedReader(new FileReader(this.restraintdc));
            double dams = 0.35;
            if (amod.toLowerCase().equals("mode")) {
                this.inrestraintdc.close();
                this.inrestraintdc = new BufferedReader(new FileReader(this.restmoddc));
                dams = 0.75;
            }
            String bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            this.outlsqdat.println(title);
            int num = 0;
            if (itemp == 0) {
                id = 1;
            }
            String tmpr = num + " " + num + " " + num + " " + num + " " + num + " " + num + " " + num + " " + num + " " + id + " " + num + " " + num;
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            tmpr = noat4 + " " + nip4 + " " + mpl4 + " " + nochrl4 + " " + novdw4 + " " + ntor4 + " " + ns4[0] + " " + ns4[1] + " " + ns4[2] + " " + ns4[3] + " " + num + " " + itemp + " " + nps4;
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            tmpr = num + "";
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            tmpr = this.abc[0] + " " + this.abc[1] + " " + this.abc[2] + " " + this.abc[3] + " " + this.abc[4] + " " + this.abc[5];
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            int snum = 0;
            int sn = 1;
            int snu = 2;
            tmpr = num + " " + snum + " " + snum + " " + sn + " " + snu;
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            num = 7;
            tmpr = num + " " + shell[0] + " " + shell[1] + " " + shell[2] + " " + shell[3] + " " + shell[4] + " " + shell[5] + " " + shell[6];
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            StringTokenizer tok7 = new StringTokenizer(line, ", ");
            for (int i9 = 0; i9 < 6; ++i9) {
                rest[i9] = Tool.parseDouble(tok7.nextToken());
            }
            num = 3;
            int afsig = 0;
            int bfsig = 0;
            tmpr = num + " " + afsig + " " + bfsig + " " + rest[0] + " " + rest[1] + " " + rest[2] + " " + rest[3] + " " + rest[4] + " " + rest[5];
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            tok7 = new StringTokenizer(line, ", ");
            rest[0] = Tool.parseDouble(tok7.nextToken());
            rest[1] = Tool.parseDouble(tok7.nextToken());
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            tok7 = new StringTokenizer(line, ", ");
            rest[2] = Tool.parseDouble(tok7.nextToken());
            rest[3] = Tool.parseDouble(tok7.nextToken());
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            tok7 = new StringTokenizer(line, ", ");
            rest[4] = Tool.parseDouble(tok7.nextToken());
            rest[5] = Tool.parseDouble(tok7.nextToken());
            rest[6] = Tool.parseDouble(tok7.nextToken());
            rest[7] = Tool.parseDouble(tok7.nextToken());
            rest[8] = Tool.parseDouble(tok7.nextToken());
            rest[9] = Tool.parseDouble(tok7.nextToken());
            String tmp = rest[0] + "";
            for (i = 1; i < 10; ++i) {
                tmp = tmp + " " + rest[i];
            }
            this.outlsqdat.println(tmp);
            Printing.justWritten(tmp, this.lsqdat);
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            tok7 = new StringTokenizer(line, ", ");
            rest[0] = Tool.parseDouble(tok7.nextToken());
            rest[1] = Tool.parseDouble(tok7.nextToken());
            rest[2] = Tool.parseDouble(tok7.nextToken());
            rest[3] = Tool.parseDouble(tok7.nextToken());
            rest[4] = Tool.parseDouble(tok7.nextToken());
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            tok7 = new StringTokenizer(line, ", ");
            rest[5] = Tool.parseDouble(tok7.nextToken());
            rest[6] = Tool.parseDouble(tok7.nextToken());
            rest[7] = Tool.parseDouble(tok7.nextToken());
            rest[8] = Tool.parseDouble(tok7.nextToken());
            rest[9] = Tool.parseDouble(tok7.nextToken());
            tmp = rest[0] + "";
            for (i = 1; i < 10; ++i) {
                tmp = tmp + " " + rest[i];
            }
            this.outlsqdat.println(tmp);
            Printing.justWritten(tmp, this.lsqdat);
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            tok7 = new StringTokenizer(line, ", ");
            rest[0] = Tool.parseDouble(tok7.nextToken());
            rest[1] = Tool.parseDouble(tok7.nextToken());
            rest[2] = Tool.parseDouble(tok7.nextToken());
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            tok7 = new StringTokenizer(line, ", ");
            rest[3] = Tool.parseDouble(tok7.nextToken());
            rest[4] = Tool.parseDouble(tok7.nextToken());
            rest[5] = Tool.parseDouble(tok7.nextToken());
            rest[6] = Tool.parseDouble(tok7.nextToken());
            rest[7] = Tool.parseDouble(tok7.nextToken());
            rest[8] = Tool.parseDouble(tok7.nextToken());
            rest[9] = Tool.parseDouble(tok7.nextToken());
            tmp = rest[0] + "";
            for (i = 1; i < 10; ++i) {
                tmp = tmp + " " + rest[i];
            }
            this.outlsqdat.println(tmp);
            Printing.justWritten(tmp, this.lsqdat);
            bid = this.inrestraintdc.readLine();
            Printing.justRead(bid, this.restraintdc);
            line = this.inrestraintdc.readLine();
            Printing.justRead(line, this.restraintdc);
            tok7 = new StringTokenizer(line, ", ");
            rest[0] = Tool.parseDouble(tok7.nextToken());
            rest[1] = Tool.parseDouble(tok7.nextToken());
            rest[2] = Tool.parseDouble(tok7.nextToken());
            rest[3] = Tool.parseDouble(tok7.nextToken());
            rest[4] = Tool.parseDouble(tok7.nextToken());
            rest[5] = Tool.parseDouble(tok7.nextToken());
            tmp = rest[0] + "";
            for (i = 1; i < 6; ++i) {
                tmp = tmp + " " + rest[i];
            }
            this.outlsqdat.println(tmp);
            Printing.justWritten(tmp, this.lsqdat);
            snum = 0;
            num = 2;
            snu = 2;
            tmpr = snum + " " + num + " " + snum + " " + snu;
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            int jabn = 0;
            tmpr = jabn + " " + dams;
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            if (itemp == 1) {
                tmpr = dams + "";
                this.outlsqdat.println(tmpr);
                Printing.justWritten(tmpr, this.lsqdat);
            }
            tmpr = jabn + "";
            this.outlsqdat.println(tmpr);
            Printing.justWritten(tmpr, this.lsqdat);
            this.inrestraintdc.close();
            this.outlsqdat.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void torfix() throws RnartException {
        Printing.entered();
        double[] idist = new double[6];
        int[] nb = new int[9];
        double[] th = new double[6];
        String[] l3 = new String[10000];
        char[] l1 = new char[10000];
        String[] l3r = new String[]{"O3'", "P", "O5'", "C5'", "C4'", "C3'", "O3'", "P", "O5'", "O4'", "C1'"};
        String[] l3b = new String[]{"N9", "C8", "N1", "C6", "C6H2", "C5", "C2", "C4"};
        String[] l3d = new String[]{"N1", "C2", "N3", "C4", "C5H2", "C6H2"};
        char[] l1b = new char[]{'G', 'A', 'U', 'C', 'T', 'D', 'P'};
        int[] nr = new int[1000];
        int[] res_beg = new int[999];
        try {
            this.outtorfixbin = new PrintWriter(new FileWriter(this.torfixbin));
            this.inatomsdat = new BufferedReader(new FileReader(this.atomsdat));
            int nx = 0;
            int iold = 0;
            int i = 1;
            String line = this.inatomsdat.readLine();
            if (line != null) {
                Printing.justRead(line, this.atomsdat);
                StringTokenizer tok = new StringTokenizer(line);
                int nn = Tool.parseInt(tok.nextToken());
                l1[i - 1] = tok.nextToken().charAt(0);
                nr[i - 1] = Tool.parseInt(tok.nextToken());
                l3[i - 1] = tok.nextToken();
                int ks = Tool.parseInt(tok.nextToken());
                double x = Tool.parseDouble(tok.nextToken());
                double y = Tool.parseDouble(tok.nextToken());
                double z = Tool.parseDouble(tok.nextToken());
                double bt = Tool.parseDouble(tok.nextToken());
                double qocc = Tool.parseDouble(tok.nextToken());
                for (int j = 0; j < 7; ++j) {
                    if (l1[i - 1] != l1b[j]) continue;
                    if (nr[i - 1] != iold) {
                        iold = nr[i - 1];
                        res_beg[nr[i - 1] - 1] = i;
                    }
                    ++i;
                    break;
                }
            }
            int numb_atoms = i - 1;
            int last_res = nr[numb_atoms - 1];
            while ((line = this.innuclindat.readLine()) != null) {
                Printing.justRead(line, this.nuclindat);
                StringTokenizer tok = new StringTokenizer(line);
                int ires = Tool.parseInt(tok.nextToken());
                int iang = Tool.parseInt(tok.nextToken());
                int iwt = Tool.parseInt(tok.nextToken());
                double tag = Tool.parseDouble(tok.nextToken());
                if (ires == 0) break;
                int n1 = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int iatbeg = res_beg[ires - 1];
                int iatend = res_beg[ires];
                if (iang != 8) {
                    if (iang != 7) {
                        if (iang > 1 && iang < 5) {
                            iatbeg = res_beg[ires - 1];
                            iatend = ires != last_res ? res_beg[ires] - 1 : numb_atoms;
                            for (i = iatbeg - 1; i < iatend; ++i) {
                                if (l3[i].equals(l3r[iang - 1])) {
                                    n1 = i + 1;
                                }
                                if (l3[i].equals(l3r[iang])) {
                                    n1 = i + 1;
                                }
                                if (l3[i].equals(l3r[iang + 1])) {
                                    n1 = i + 1;
                                }
                                if (!l3[i].equals(l3r[iang + 2])) continue;
                                n1 = i + 1;
                            }
                        } else if (iang == 1) {
                            iatbeg = res_beg[ires - 1];
                            iatend = ires != last_res ? res_beg[ires] - 1 : numb_atoms;
                            for (i = iatbeg; i <= iatend; ++i) {
                                if (l3[i - 1].equals(l3r[iang])) {
                                    n2 = i;
                                }
                                if (l3[i - 1].equals(l3r[iang + 1])) {
                                    n3 = i;
                                }
                                if (!l3[i - 1].equals(l3r[iang + 2])) continue;
                                n4 = i;
                            }
                            if (ires != 1) {
                                iatbeg = res_beg[ires];
                                iatend = res_beg[ires - 1] - 1;
                                for (i = iatbeg; i <= iatend; ++i) {
                                    if (!l3[i - 1].equals(l3r[iang - 1])) continue;
                                    n1 = i;
                                }
                            }
                        } else if (iang == 5) {
                            iatbeg = res_beg[ires - 1];
                            iatend = ires != last_res ? res_beg[ires] - 1 : numb_atoms;
                            for (i = iatbeg; i <= iatend; ++i) {
                                if (l3[i - 1].equals(l3r[iang - 1])) {
                                    n1 = i;
                                }
                                if (l3[i - 1].equals(l3r[iang])) {
                                    n2 = i;
                                }
                                if (!l3[i - 1].equals(l3r[iang + 1])) continue;
                                n3 = i;
                            }
                            iatbeg = res_beg[ires];
                            iatend = ires != last_res - 1 ? res_beg[ires + 1] - 1 : numb_atoms;
                            for (i = iatbeg; i <= iatend; ++i) {
                                if (!l3[i - 1].equals(l3r[iang + 2])) continue;
                                n4 = i;
                            }
                        } else if (iang == 6) {
                            iatbeg = res_beg[ires - 1];
                            iatend = ires != last_res ? res_beg[ires] - 1 : numb_atoms;
                            for (i = iatbeg; i <= iatend; ++i) {
                                if (l3[i - 1].equals(l3r[iang - 1])) {
                                    n1 = i;
                                }
                                if (!l3[i - 1].equals(l3r[iang])) continue;
                                n2 = i;
                            }
                            iatbeg = res_beg[ires];
                            iatend = ires != last_res - 1 ? res_beg[ires + 1] - 1 : numb_atoms;
                            for (i = iatbeg; i <= iatend; ++i) {
                                if (l3[i - 1].equals(l3r[iang + 1])) {
                                    n3 = i;
                                }
                                if (!l3[i - 1].equals(l3r[iang + 2])) continue;
                                n4 = i;
                            }
                        }
                        this.outtorfixbin.println(++nx + " " + ires + " " + iang + " " + n1 + " " + n2 + " " + n3 + " " + n4 + " " + idist[0] + " " + idist[1] + " " + idist[2] + " " + idist[3] + " " + idist[4] + " " + idist[5] + " " + iwt + " " + tag);
                        continue;
                    }
                    iatbeg = res_beg[ires - 1];
                    iatend = ires != last_res ? res_beg[ires] - 1 : numb_atoms;
                    int j = res_beg[ires - 1];
                    if (l1[j - 1] == l1b[2] || l1[j - 1] == l1b[3] || l1[j - 1] == l1b[4]) {
                        for (i = iatbeg; i <= iatend; ++i) {
                            if (l3[i - 1].equals(l3r[9])) {
                                n1 = i;
                            }
                            if (l3[i - 1].equals(l3r[10])) {
                                n2 = i;
                            }
                            if (l3[i - 1].equals(l3b[2])) {
                                n3 = i;
                            }
                            if (l3[i - 1].equals(l3b[3])) {
                                n4 = i;
                            }
                            if (!l3[i - 1].equals(l3b[6])) continue;
                            n5 = i;
                        }
                    } else if (l1[j - 1] == l1b[0] || l1[j - 1] == l1b[1]) {
                        for (i = iatbeg; i <= iatend; ++i) {
                            if (l3[i - 1].equals(l3r[9])) {
                                n1 = i;
                            }
                            if (l3[i - 1].equals(l3r[10])) {
                                n2 = i;
                            }
                            if (l3[i - 1].equals(l3b[0])) {
                                n3 = i;
                            }
                            if (l3[i - 1].equals(l3b[1])) {
                                n4 = i;
                            }
                            if (!l3[i - 1].equals(l3b[7])) continue;
                            n5 = i;
                        }
                    } else if (l1[j - 1] == l1b[5]) {
                        for (i = iatbeg; i <= iatend; ++i) {
                            if (l3[i - 1].equals(l3r[9])) {
                                n1 = i;
                            }
                            if (l3[i - 1].equals(l3r[10])) {
                                n2 = i;
                            }
                            if (l3[i - 1].equals(l3b[2])) {
                                n3 = i;
                            }
                            if (l3[i - 1].equals(l3b[4])) {
                                n4 = i;
                            }
                            if (!l3[i - 1].equals(l3b[6])) continue;
                            n5 = i;
                        }
                    } else if (l1[j - 1] == l1b[6]) {
                        for (i = iatbeg; i <= iatend; ++i) {
                            if (l3[i - 1].equals(l3r[9])) {
                                n1 = i;
                            }
                            if (l3[i - 1].equals(l3r[10])) {
                                n2 = i;
                            }
                            if (l3[i - 1].equals(l3b[5])) {
                                n3 = i;
                            }
                            if (l3[i - 1].equals(l3b[3])) {
                                n4 = i;
                            }
                            if (!l3[i - 1].equals(l3b[7])) continue;
                            n5 = i;
                        }
                    }
                    this.outtorfixbin.println(++nx + " " + ires + " " + iang + " " + n1 + " " + n2 + " " + n3 + " " + n4 + " " + idist[0] + " " + idist[1] + " " + idist[2] + " " + idist[3] + " " + idist[4] + " " + idist[5] + " " + iwt + " " + tag);
                    this.outtorfixbin.println(++nx + " " + ires + " " + iang + " " + n1 + " " + n2 + " " + n3 + " " + n5 + " " + idist[0] + " " + idist[1] + " " + idist[2] + " " + idist[3] + " " + idist[4] + " " + idist[5] + " " + iwt + " " + tag);
                    continue;
                }
                line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
                tok = new StringTokenizer(line);
                for (i = 0; i < 6; ++i) {
                    th[i] = Tool.parseDouble(tok.nextToken());
                }
                for (int k = 0; k < 6; ++k) {
                    nb[k] = 0;
                }
                for (i = 0; i < 19; ++i) {
                    line = this.inatomsdat.readLine();
                    Printing.justRead(line, this.atomsdat);
                    tok = new StringTokenizer(line);
                    int nn = Tool.parseInt(tok.nextToken());
                    tok.nextToken();
                    tok.nextToken();
                    String il3 = tok.nextToken();
                    for (int k = 0; k < 6; ++k) {
                        if (!il3.equals(l3d[k])) continue;
                        nb[k] = nn;
                    }
                }
                nb[6] = nb[0];
                nb[7] = nb[1];
                nb[8] = nb[2];
                for (i = 0; i < 6; ++i) {
                    this.outtorfixbin.println(++nx + " " + ires + " " + iang + " " + nb[i] + " " + nb[i + 1] + " " + nb[i + 2] + " " + nb[i + 3] + " " + idist[0] + " " + idist[1] + " " + idist[2] + " " + idist[3] + " " + idist[4] + " " + idist[5] + " " + iwt + " " + th[i]);
                }
            }
            this.inatomsdat.close();
            this.outtorfixbin.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void symtry() throws RnartException {
        Printing.entered();
        int[] nbe = new int[8];
        int[] nen = new int[8];
        int[] id = new int[8];
        double[][] r = new double[3][3];
        double[] t = new double[3];
        int[][] iat = new int[10000][8];
        int[][] iw = new int[10000][8];
        int[] iwg = new int[3];
        String[] idr1 = new String[]{"P", "O5'", "O1P", "O2P", "O3'", "O3P"};
        String[] idr2 = new String[]{"C5'", "C4'", "C3'", "C2'", "C1'", "O4'", "O2'"};
        try {
            this.inatomsdat = new BufferedReader(new FileReader(this.atomsdat));
            this.outsymtrybin = new PrintWriter(new FileWriter(this.symtrybin));
            String line = this.innuclindat.readLine();
            Printing.justRead(line, this.nuclindat);
            int igr = Tool.parseInt(line);
            this.outsymtrybin.println(igr);
            for (int ikj = 0; ikj < igr; ++ikj) {
                int k;
                line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
                StringTokenizer tok = new StringTokenizer(line);
                int nchn = Tool.parseInt(tok.nextToken());
                int knownr = Tool.parseInt(tok.nextToken());
                for (k = 0; k < nchn; ++k) {
                    id[k] = Tool.parseInt(tok.nextToken());
                }
                this.outsymtrybin.println(line);
                line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
                tok = new StringTokenizer(line);
                for (k = 0; k < nchn; ++k) {
                    nbe[k] = Tool.parseInt(tok.nextToken());
                }
                for (k = 0; k < nchn; ++k) {
                    nen[k] = Tool.parseInt(tok.nextToken());
                }
                if (knownr != 0) {
                    for (k = 0; k < nchn; ++k) {
                        int ik;
                        line = this.innuclindat.readLine();
                        Printing.justRead(line, this.nuclindat);
                        tok = new StringTokenizer(line);
                        for (ik = 0; ik < 3; ++ik) {
                            for (int j = 0; j < 3; ++j) {
                                r[ik][j] = Tool.parseDouble(tok.nextToken());
                            }
                        }
                        for (ik = 0; ik < 3; ++ik) {
                            t[ik] = Tool.parseDouble(tok.nextToken());
                        }
                        this.outsymtrybin.println(line);
                    }
                }
                line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
                tok = new StringTokenizer(line);
                for (int i = 0; i < 3; ++i) {
                    iwg[i] = Tool.parseInt(tok.nextToken());
                }
                int nk = 0;
                for (int k2 = 0; k2 < nchn; ++k2) {
                    int nip = 0;
                    nk = 0;
                    int i1 = nbe[k2] - 1;
                    int i2 = nen[k2] - i1;
                    this.inatomsdat.close();
                    this.inatomsdat = new BufferedReader(new FileReader(this.atomsdat));
                    if (i1 != 0) {
                        for (int i = 0; i < i1; ++i) {
                            line = this.inatomsdat.readLine();
                            Printing.justRead(line, this.atomsdat);
                        }
                    }
                    do {
                        int j;
                        line = this.inatomsdat.readLine();
                        Printing.justRead(line, this.atomsdat);
                        tok = new StringTokenizer(line);
                        int nn = Tool.parseInt(tok.nextToken());
                        String l1 = tok.nextToken();
                        String l2 = tok.nextToken();
                        String l3 = tok.nextToken();
                        ++nip;
                        ++nk;
                        int iwt = 0;
                        boolean go1 = true;
                        boolean go2 = true;
                        for (j = 0; j < 6; ++j) {
                            if (!l3.equals(idr1[j])) continue;
                            iwt = iwg[0];
                            go1 = false;
                            break;
                        }
                        if (go1) {
                            for (j = 0; j < 7; ++j) {
                                if (!l3.equals(idr2[j])) continue;
                                iwt = iwg[1];
                                go2 = false;
                                break;
                            }
                            if (go2) {
                                iwt = iwg[2];
                            }
                        }
                        iw[nk][k2] = iwt;
                        iat[nk][k2] = nn;
                    } while (nip < i2);
                }
                this.outsymtrybin.println(nk);
                for (int n = 0; n < nk; ++n) {
                    int kt = nchn % 2 + 1;
                    String tmp = "" + iat[n][0];
                    for (int k3 = 1; k3 < nchn; ++k3) {
                        tmp = tmp + " " + iat[n][k3];
                    }
                    this.outsymtrybin.println(n + " " + iw[n][kt] + " " + tmp);
                }
            }
            this.inatomsdat.close();
            this.outsymtrybin.close();
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void pseu() throws RnartException {
        Printing.entered();
        int[] iatom = new int[9];
        int[] it = new int[5];
        int[][] iat = new int[4][4];
        double[] vn = new double[4];
        double[] dn = new double[5];
        double[] vp = new double[5];
        try {
            this.inchirlsbin = new BufferedReader(new FileReader(this.chirlsbin));
            this.indistbin = new BufferedReader(new FileReader(this.distbin));
            this.outpseubin = new PrintWriter(new FileWriter(this.pseubin));
            this.outchirls2bin = new PrintWriter(new FileWriter(this.chirls2bin));
            this.outdistbin = new PrintWriter(new FileWriter(this.distbin));
            int nx = 0;
            int nbg = 0;
            String line = this.innuclindat.readLine();
            Printing.justRead(line, this.nuclindat);
            int nucl = Tool.parseInt(line);
            block2: while (true) {
                int ik;
                line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
                StringTokenizer tok = new StringTokenizer(line);
                int ires = Tool.parseInt(tok.nextToken());
                int iwp = Tool.parseInt(tok.nextToken());
                int iwtm = Tool.parseInt(tok.nextToken());
                double tagp = Tool.parseDouble(tok.nextToken());
                double tagtm = Tool.parseDouble(tok.nextToken());
                if (ires == 0) break;
                this.vchrd(tagp, tagtm, vn, dn, vp);
                int ned = (ires - 1) * nucl - nbg;
                if (ned != 0) {
                    for (int j1 = 0; j1 < ned; ++j1) {
                        line = this.inchirlsbin.readLine();
                        Printing.justRead(line, this.chirlsbin);
                        tok = new StringTokenizer(line);
                        for (int i = 0; i < 4; ++i) {
                            iatom[i] = Tool.parseInt(tok.nextToken());
                        }
                        int vid = Tool.parseInt(tok.nextToken());
                        this.outchirls2bin.println(line);
                    }
                }
                for (ik = 0; ik < nucl; ++ik) {
                    line = this.inchirlsbin.readLine();
                    Printing.justRead(line, this.chirlsbin);
                    tok = new StringTokenizer(line);
                    for (int i = 0; i < 4; ++i) {
                        iatom[i] = Tool.parseInt(tok.nextToken());
                    }
                    double vid = Tool.parseInt(tok.nextToken());
                    if (ik == 0) {
                        vid = vn[3];
                    }
                    if (nucl == 4 && ik == 1) {
                        vid = vn[1];
                    }
                    if (nucl == 3 && ik == 1) {
                        vid = vn[2];
                    }
                    if (nucl == 4 && ik == 2) {
                        vid = vn[2];
                    }
                    if (nucl == 4 && ik == 2) {
                        vid = vn[0];
                    }
                    if (ik == 3) {
                        vid = vn[0];
                    }
                    this.outchirls2bin.println(iatom[0] + " " + iatom[1] + " " + iatom[2] + " " + iatom[3] + " " + vid);
                    for (int kj = 0; kj < 4; ++kj) {
                        iat[ik][kj] = iatom[kj];
                    }
                }
                it[0] = iat[0][3];
                it[1] = iat[1][1];
                it[2] = iat[1][0];
                it[3] = iat[0][2];
                it[4] = iat[0][0];
                if (nucl == 3) {
                    it[1] = iat[2][0];
                    it[2] = iat[2][2];
                }
                for (int kj = 0; kj < 4; ++kj) {
                    iatom[kj] = it[kj];
                    iatom[kj + 5] = it[kj];
                }
                iatom[4] = it[4];
                for (ik = 0; ik < 5; ++ik) {
                    this.outchirls2bin.println(iatom[ik + 1] + " " + iatom[ik + 2] + " " + iatom[ik + 4] + " " + iatom[ik] + " " + vp[ik]);
                }
                this.outpseubin.println(++nx + " " + ires + " " + it[0] + " " + it[1] + " " + it[2] + " " + it[3] + " " + iwp + " " + iwtm + " " + tagp + " " + tagtm);
                nbg += ned + nucl;
                int nct = 0;
                while (true) {
                    if ((line = this.indistbin.readLine()) == null) continue block2;
                    Printing.justRead(line, this.distbin);
                    tok = new StringTokenizer(line);
                    int na = Tool.parseInt(tok.nextToken());
                    int nb = Tool.parseInt(tok.nextToken());
                    int ddst = Tool.parseInt(tok.nextToken());
                    int ntyp = Tool.parseInt(tok.nextToken());
                    if (na == it[0] && nb == it[3]) {
                        this.outdistbin.println(na + " " + nb + " " + dn[0] + " " + ntyp);
                        if (++nct != 0) continue;
                        continue block2;
                    }
                    if (na == it[0] && nb == it[3]) {
                        this.outdistbin.println(na + " " + nb + " " + dn[3] + " " + ntyp);
                        if (++nct != 0) continue;
                        continue block2;
                    }
                    if (na == it[1] && nb == it[3]) {
                        this.outdistbin.println(na + " " + nb + " " + dn[1] + " " + ntyp);
                        if (++nct != 0) continue;
                        continue block2;
                    }
                    if (na == it[1] && nb == it[4]) {
                        this.outdistbin.println(na + " " + nb + " " + dn[4] + " " + ntyp);
                        if (++nct != 0) continue;
                        continue block2;
                    }
                    if (na == it[2] && nb == it[4]) {
                        this.outdistbin.println(na + " " + nb + " " + dn[2] + " " + ntyp);
                        if (++nct != 0) continue;
                        continue block2;
                    }
                    this.outdistbin.println(line);
                }
                break;
            }
            while ((line = this.inchirlsbin.readLine()) != null) {
                Printing.justRead(line, this.chirlsbin);
                this.outchirls2bin.println(line);
            }
            this.inchirlsbin.close();
            this.outpseubin.close();
            this.outchirls2bin.close();
            this.indistbin.close();
            this.outdistbin.close();
            this.outchirlsbin.close();
            this.inchirls2bin.close();
            SystemTools.mv(this.chirls2bin, this.chirlsbin);
            this.inchirls2bin = new BufferedReader(new FileReader(this.chirlsbin));
        }
        catch (IOException e) {
            throw new RnartException(e);
        }
    }

    void vchrd(double p, double tm, double[] vn, double[] dn, double[] vp) {
        int i;
        Printing.entered();
        double[][][] a = new double[][][]{new double[][]{{-2.4124, -0.0441, 0.0235, -0.4653}, {0.2933, 0.1274, 2.5618, 0.1488}}, new double[][]{{-0.0183, 0.02346, -0.0773, 0.02985}, {2.5911, -0.1252, -0.0158, 0.01986}}, new double[][]{{0.1158, 0.2719, -2.4699, 0.0293}, {-0.0033, -0.2371, -0.1246, 0.0014}}};
        double[][][] b = new double[][][]{new double[][]{{2.3906, -0.0092, -0.2593, 0.2305, 2.4502}, {0.0051, -0.439, 0.1902, 2.4589, 0.001}}, new double[][]{{-0.4218, 0.2247, 2.4064, 0.008, -0.3129}, {0.1982, 2.3819, -0.0031, -0.4344, 0.1963}}};
        double[][] c = new double[][]{{-0.6583, -7.4145, 0.7051, 7.8865, -0.7728}, {-8.372, -0.7287, -8.0725, 0.663, 7.432}};
        double cp = Math.cos(p * TBMath.DegreeToRadian);
        double tm2 = tm * tm * 1.0E-4;
        for (i = 0; i < 4; ++i) {
            vn[i] = a[0][0][i] + a[0][1][i] * tm2 + (a[1][0][i] + a[1][1][i] * tm2) * cp + (a[2][0][i] + a[2][1][i] * tm2) * cp * cp;
        }
        vn[0] = -vn[0];
        vn[3] = -vn[3];
        for (i = 0; i < 5; ++i) {
            dn[i] = b[0][0][i] + b[0][1][i] * tm2 + (b[1][0][i] + b[1][1][i]) * Math.cos((2.0 * p - (double)(72 * (i + 1))) * TBMath.DegreeToRadian);
        }
        for (i = 0; i < 3; ++i) {
            vp[i] = (c[0][i] + c[1][i] * tm2) * Math.cos((p - (double)(108 + 36 * i)) * TBMath.DegreeToRadian);
        }
        for (i = 3; i < 5; ++i) {
            vp[i] = (c[0][i] + c[1][i] * tm2) * Math.cos((p - (double)(36 * (i - 2))) * TBMath.DegreeToRadian);
        }
    }

    void sugar() throws RnartException {
        block28: {
            Printing.entered();
            int[] iatom = new int[4];
            int[][] iat = new int[4][4];
            int[] it = new int[9];
            double[] vn = new double[]{0.018, -1.198, 1.969, -1.884, 1.096};
            double[] vids = new double[]{2.52, 2.49, 2.74, 2.44};
            double[] vs = new double[]{-1.106, 1.835, -1.955, 1.24, -0.013};
            try {
                int i;
                String line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
                StringTokenizer tok = new StringTokenizer(line);
                int nucl = Tool.parseInt(tok.nextToken());
                int ntim = Tool.parseInt(tok.nextToken());
                if (ntim <= 0) break block28;
                int[] nn = new int[ntim];
                line = this.innuclindat.readLine();
                Printing.justRead(line, this.nuclindat);
                tok = new StringTokenizer(line);
                for (i = 0; i < ntim; ++i) {
                    if (tok.countTokens() == 0) {
                        line = this.innuclindat.readLine();
                        Printing.justRead(line, this.nuclindat);
                        tok = new StringTokenizer(line);
                    }
                    nn[i] = Tool.parseInt(tok.nextToken());
                }
                this.inchirlsbin = new BufferedReader(new FileReader(this.chirlsbin));
                this.outchirls2bin = new PrintWriter(new FileWriter(this.chirls2bin));
                for (int k = 0; k < ntim; ++k) {
                    int kj;
                    int kj2;
                    int ik;
                    if (nn[k] == 0) {
                        for (ik = 0; ik < nucl; ++ik) {
                            line = this.inchirlsbin.readLine();
                            Printing.justRead(line, this.chirlsbin);
                            if (line == null) continue;
                            tok = new StringTokenizer(line);
                            for (int i2 = 0; i2 < 4; ++i2) {
                                iatom[i2] = Tool.parseInt(tok.nextToken());
                            }
                            double vid = Tool.parseDouble(tok.nextToken());
                            this.outchirls2bin.println(line);
                            for (kj2 = 0; kj2 < 4; ++kj2) {
                                iat[ik][kj2] = iatom[kj2];
                            }
                        }
                        it[0] = iat[0][3];
                        it[1] = iat[1][1];
                        it[2] = iat[1][0];
                        it[3] = iat[0][2];
                        it[4] = iat[0][0];
                        if (nucl != 4) {
                            it[1] = iat[2][0];
                            it[2] = iat[2][2];
                        }
                        for (kj = 0; kj < 4; ++kj) {
                            it[kj + 5] = it[kj];
                        }
                        for (ik = 0; ik < 5; ++ik) {
                            this.outchirls2bin.println(it[ik + 1] + " " + it[ik + 2] + " " + it[ik + 4] + " " + it[ik] + " " + vn[ik]);
                        }
                        continue;
                    }
                    if (nn[k] != 2) {
                        for (ik = 0; ik < nucl; ++ik) {
                            line = this.inchirlsbin.readLine();
                            Printing.justRead(line, this.chirlsbin);
                            if (line == null) continue;
                            tok = new StringTokenizer(line);
                            for (int i3 = 0; i3 < 4; ++i3) {
                                iatom[i3] = Tool.parseInt(tok.nextToken());
                            }
                            double vid = Tool.parseDouble(tok.nextToken());
                            if (nucl == 4) {
                                this.outchirls2bin.println(iatom[0] + " " + iatom[1] + " " + iatom[2] + " " + iatom[3] + " " + vids[ik]);
                            } else {
                                if (ik == 0) {
                                    this.outchirls2bin.println(iatom[0] + " " + iatom[1] + " " + iatom[2] + " " + iatom[3] + " " + vids[0]);
                                }
                                if (ik == 1) {
                                    this.outchirls2bin.println(iatom[0] + " " + iatom[1] + " " + iatom[2] + " " + iatom[3] + " " + vids[2]);
                                }
                                if (ik == 2) {
                                    this.outchirls2bin.println(iatom[0] + " " + iatom[1] + " " + iatom[2] + " " + iatom[3] + " " + vids[3]);
                                }
                            }
                            for (kj2 = 0; kj2 < 4; ++kj2) {
                                iat[ik][kj2] = iatom[kj2];
                            }
                        }
                        it[0] = iat[0][3];
                        it[1] = iat[1][1];
                        it[2] = iat[1][0];
                        it[3] = iat[0][2];
                        it[4] = iat[0][0];
                        if (nucl != 4) {
                            it[1] = iat[2][0];
                            it[2] = iat[2][2];
                        }
                        for (kj = 0; kj < 4; ++kj) {
                            it[kj + 5] = it[kj];
                        }
                        for (ik = 0; ik < 5; ++ik) {
                            this.outchirls2bin.println(it[ik + 1] + " " + it[ik + 2] + " " + it[ik + 4] + " " + it[ik] + " " + vs[ik]);
                        }
                        continue;
                    }
                    for (ik = 0; ik < nucl; ++ik) {
                        line = this.inchirlsbin.readLine();
                        Printing.justRead(line, this.chirlsbin);
                        if (line == null) continue;
                        tok = new StringTokenizer(line);
                        for (int i4 = 0; i4 < 4; ++i4) {
                            iatom[i4] = Tool.parseInt(tok.nextToken());
                        }
                        int vid = Tool.parseInt(tok.nextToken());
                        this.outchirls2bin.println(line);
                    }
                }
                while ((line = this.inchirlsbin.readLine()) != null) {
                    Printing.justRead(line, this.chirlsbin);
                    tok = new StringTokenizer(line);
                    for (i = 0; i < 4; ++i) {
                        iatom[i] = Tool.parseInt(tok.nextToken());
                    }
                    double vid = Tool.parseDouble(tok.nextToken());
                    this.outchirls2bin.println(line);
                }
                this.inchirlsbin.close();
                this.outchirls2bin.close();
                this.outchirlsbin.close();
                SystemTools.mv(this.chirls2bin, this.chirlsbin);
            }
            catch (IOException e) {
                throw new RnartException(e);
            }
        }
    }

    public String scratch(int n1, String a1, int n2, String a2, double d, int j) {
        String ret = "";
        ret = ret + "    " + NumberFormat.intFormat(n1, 3) + a1;
        ret = ret + "    " + NumberFormat.intFormat(n2, 3) + a2;
        ret = ret + "     " + NumberFormat.doubleFormat(d, 5, 3);
        ret = ret + "    " + NumberFormat.intFormat(j, 1);
        return ret;
    }
}

