/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.varna;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCVarnaAnalysis
extends AbstractAnalysis {
    public IBMCVarnaAnalysis(MoleculeFactory factory) {
        super("VARNA (PARADISE Server)", factory);
        this.addCategory("2D drawing");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            SecondaryStructureDisplay display = null;
            SecondaryStructure ss = null;
            for (Molecule m : molecules) {
                if (ss == null) {
                    ss = m.getSelectedFeatures(SecondaryStructure.class).get(0);
                }
                if (display != null) continue;
                display = ss.getFactory().createSecondaryStructureDisplay(ss, m, new Location(1, m.getLength()));
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

