/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.tools;

import fr.unistra.ibmc.paradise.core.utils.IOUtils;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.services.ParadisePlatform;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseTool;
import fr.unistra.ibmc.paradise.tools.ParadiseAgent;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import groovy.lang.Binding;
import groovy.ui.Console;
import jade.wrapper.ControllerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import javax.swing.JLabel;
import org.jdesktop.swingworker.SwingWorker;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paradise
extends AbstractParadiseTool {
    public static boolean COPY_PSEUDOKNOTS_AND_INTER_MOLECULAR_HELICES = false;
    public static final String SECONDARY_STRUCTURE_PREDICTION = "2D prediction";
    public static final String SECONDARY_STRUCTURE_DRAWING = "2D drawing";
    public static final String STRUCTURAL_ALIGNMENT = "structural alignment";
    public static final String TERTIARY_STRUCTURE_PREDICTION = "3D prediction";
    public static final String APPLY_3D_FOLDS = "Apply 3D folds";
    public static final String TERTIARY_STRUCTURE_REFINEMENT = "3D refinement";
    public static final String TERTIARY_STRUCTURE_ANNOTATION = "3D annotation";
    public static final String NC_RNAS_CANDIDATES_SEARCHING = "non-coding RNAs candidates searching";
    public static final String SEND_STRUCTURAL_DATA = "send structural data to paradise tools";
    public static final String SEND_SELECTED_RESIDUES = "send selected residues to paradise tools";
    public static final List<String> functionnalities = Arrays.asList("2D prediction", "2D drawing", "structural alignment", "3D prediction", "Apply 3D folds", "3D refinement", "3D annotation", "non-coding RNAs candidates searching", "send structural data to paradise tools", "send selected residues to paradise tools");
    public static final String version = "1.0";
    public static int mainFeaturesCreatedCount = 0;
    private ProgressMonitor monitor = new DefaultProgressMonitor();
    private Console groovyConsole;
    protected static Map<String, String> modifiedNucleotides;

    public Paradise(ParadiseWorkingSession workingSession) {
        super("PARADISE 1.0", workingSession);
    }

    @Override
    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public void receiveSelectedResiduesFromTheOutside(Collection<Residue> residues) {
    }

    public static String getInstallPath() {
        return URLDecoder.decode(Paradise.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("paradise.jar")[0]);
    }

    public static void loadModifiedNucleotides() {
        modifiedNucleotides = new HashMap<String, String>();
        String line = null;
        try {
            BufferedReader buff = new BufferedReader(new FileReader(new File(Paradise.getTertiaryDataDirectory(), "modified_residues.dat")));
            while ((line = buff.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                String[] tokens = line.split("\\s+");
                modifiedNucleotides.put(tokens[0].trim(), tokens[1].trim().toUpperCase().replace('I', 'A').replace('T', 'U').replace('P', 'U'));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addModifiedResidue(String modifiedResidue, String unmodifiedResidue) {
        modifiedNucleotides.put(modifiedResidue, unmodifiedResidue);
    }

    public static Map<String, String> getModifiedNucleotides() {
        if (modifiedNucleotides == null) {
            Paradise.loadModifiedNucleotides();
        }
        return modifiedNucleotides;
    }

    public static File getTmpDirectory() {
        File tmpDir = new File(new StringBuffer(Paradise.getInstallPath()).append("tmp").toString());
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        return tmpDir;
    }

    public static File getTertiaryDataDirectory() {
        File tertiaryDataDir = new File(Paradise.getParadiseDirectory(), "tertiary_data");
        if (!tertiaryDataDir.exists() || tertiaryDataDir.listFiles().length == 0) {
            tertiaryDataDir.mkdir();
            File dataZipped = new File(Paradise.getInstallPath(), "tertiary_data.zip");
            try {
                IOUtils.extractArchivedFile(tertiaryDataDir.getAbsolutePath(), dataZipped, null);
                dataZipped.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return tertiaryDataDir;
    }

    public static File getDatabasesDirectory() {
        File sequencesDir = new File(Paradise.getParadiseDirectory(), "databases");
        if (!sequencesDir.exists()) {
            sequencesDir.mkdir();
        }
        return sequencesDir;
    }

    public static File getParadiseDirectory() {
        File f = new File(new StringBuffer(System.getProperty("user.home")).append(System.getProperty("file.separator")).append(".paradise").toString());
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(f, version)).exists()) {
            f.mkdir();
        }
        return f;
    }

    public static String getScriptsPath() {
        return new StringBuffer(Paradise.getInstallPath()).append("scripts").append(System.getProperty("file.separator")).toString();
    }

    public static void main(String[] args) throws IOException, ControllerException, JDOMException, BackingStoreException {
        if (args.length == 0) {
            ParadisePlatform.launchParadisePlatform();
            new Connect("localhost").execute();
        }
    }

    @Override
    public void launch() {
        Binding b = new Binding();
        b.setProperty("session", (Object)this.getWorkingSession());
        b.setProperty("agent", (Object)this.agent);
        this.groovyConsole = new Console(b);
        this.groovyConsole.setCurrentFileChooserDir(new File(Paradise.getInstallPath()));
        this.groovyConsole.setStatusLabel(new JLabel("Connected to " + ((ParadiseWorkingSession)this.moleculeFactory).getPlatformAddress() + ", ready for work..."));
        this.groovyConsole.run();
    }

    public Console getGroovyConsole() {
        return this.groovyConsole;
    }

    static class Connect
    extends SwingWorker {
        private String platformAddress;

        Connect(String platformAddress) {
            this.platformAddress = platformAddress;
        }

        protected Object doInBackground() throws Exception {
            ParadiseWorkingSession p = new ParadiseWorkingSession(this.platformAddress);
            new ParadiseAgent(p);
            return null;
        }
    }
}

