/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.core.Profile;
import jade.mtp.MTPException;
import jade.mtp.http.HTTPAddress;
import jade.mtp.http.https.HTTPSKeyManager;
import jade.mtp.http.https.HTTPSTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;

public class HTTPSocketFactory {
    private static HTTPSocketFactory _instance;
    private static final String PREFIX = "jade_mtp_http_https_";
    private SocketFactory _socketFactory;
    private ServerSocketFactory _serverSocketFactory;
    private boolean _needClientAuth = false;
    private boolean _usingHttps = false;

    public static HTTPSocketFactory getInstance() {
        if (_instance == null) {
            _instance = new HTTPSocketFactory();
        }
        return _instance;
    }

    public void configure(Profile profile, HTTPAddress hta) throws Exception {
        if (hta.getProto().equals("https")) {
            this._usingHttps = true;
            try {
                String trustManagerClass = profile.getParameter("jade_mtp_http_https_trustManagerClass", "jade.mtp.http.https.NoAuthentication");
                String keyManagerClass = profile.getParameter("jade_mtp_http_https_keyManagerClass", "jade.mtp.http.https.KeyStoreKeyManager");
                HTTPSTrustManager tm = (HTTPSTrustManager)Class.forName(trustManagerClass).newInstance();
                tm.init(profile);
                HTTPSKeyManager km = (HTTPSKeyManager)Class.forName(keyManagerClass).newInstance();
                km.init(profile);
                if (profile.getParameter("jade_mtp_http_https_needClientAuth", "no").equals("yes")) {
                    this._needClientAuth = true;
                }
                SSLContext sctx = SSLContext.getInstance("TLS");
                sctx.init(new KeyManager[]{km}, new TrustManager[]{tm}, null);
                this._socketFactory = sctx.getSocketFactory();
                this._serverSocketFactory = sctx.getServerSocketFactory();
            }
            catch (Exception e) {
                throw new MTPException("Error initializing secure conection", (Throwable)e);
            }
        } else {
            this._socketFactory = SocketFactory.getDefault();
            this._serverSocketFactory = ServerSocketFactory.getDefault();
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this._socketFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress dest, int outport) throws IOException {
        return this._socketFactory.createSocket(host, port, dest, outport);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket ss = this._serverSocketFactory.createServerSocket(port);
        if (this._usingHttps) {
            ((SSLServerSocket)ss).setNeedClientAuth(this._needClientAuth);
        }
        return ss;
    }

    private HTTPSocketFactory() {
    }
}

