/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.swingx.EnumerationValue;

public abstract class BeanInfoSupport
extends SimpleBeanInfo {
    private static Logger LOG = Logger.getLogger(BeanInfoSupport.class.getName());
    private static Map<Class, Boolean> introspectingState = new HashMap<Class, Boolean>();
    private Class beanClass;
    private int defaultPropertyIndex = -1;
    private int defaultEventIndex = -1;
    private Image iconColor16 = null;
    private Image iconColor32 = null;
    private Image iconMono16 = null;
    private Image iconMono32 = null;
    private String iconNameC16 = null;
    private String iconNameC32 = null;
    private String iconNameM16 = null;
    private String iconNameM32 = null;
    private BeanDescriptor beanDescriptor;
    private Map<String, PropertyDescriptor> properties = new TreeMap<String, PropertyDescriptor>();
    private Map<String, EventSetDescriptor> events = new TreeMap<String, EventSetDescriptor>();
    private Map<String, MethodDescriptor> methods = new TreeMap<String, MethodDescriptor>();

    public BeanInfoSupport(Class beanClass) {
        this.beanClass = beanClass;
        Boolean b = introspectingState.get(beanClass);
        if (!this.isIntrospecting()) {
            introspectingState.put(beanClass, Boolean.TRUE);
            try {
                BeanInfo info = Introspector.getBeanInfo(beanClass);
                this.beanDescriptor = info.getBeanDescriptor();
                if (this.beanDescriptor != null) {
                    Class<?> customizerClass = this.getCustomizerClass();
                    this.beanDescriptor = new BeanDescriptor(this.beanDescriptor.getBeanClass(), customizerClass == null ? this.beanDescriptor.getCustomizerClass() : customizerClass);
                } else {
                    this.beanDescriptor = new BeanDescriptor(beanClass, this.getCustomizerClass());
                }
                for (PropertyDescriptor propertyDescriptor : info.getPropertyDescriptors()) {
                    this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
                }
                for (FeatureDescriptor featureDescriptor : info.getEventSetDescriptors()) {
                    this.events.put(featureDescriptor.getName(), (EventSetDescriptor)featureDescriptor);
                }
                for (FeatureDescriptor featureDescriptor : info.getMethodDescriptors()) {
                    this.methods.put(featureDescriptor.getName(), (MethodDescriptor)featureDescriptor);
                }
                this.defaultPropertyIndex = info.getDefaultPropertyIndex();
                this.defaultEventIndex = info.getDefaultEventIndex();
                this.iconColor16 = this.loadStandardImage(info, 1);
                this.iconColor32 = this.loadStandardImage(info, 2);
                this.iconMono16 = this.loadStandardImage(info, 3);
                this.iconMono32 = this.loadStandardImage(info, 4);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            introspectingState.put(beanClass, Boolean.FALSE);
            this.initialize();
        }
    }

    private boolean isIntrospecting() {
        Boolean b = introspectingState.get(this.beanClass);
        return b == null ? false : b;
    }

    private Image loadStandardImage(BeanInfo info, int size) {
        String s = "";
        switch (size) {
            case 1: {
                s = "16";
                break;
            }
            case 2: {
                s = "32";
                break;
            }
            case 3: {
                s = "16-mono";
                break;
            }
            case 4: {
                s = "32-mono";
            }
        }
        String iconName = this.beanClass.getSimpleName() + s + ".png";
        Image image = null;
        try {
            image = this.loadImage("resources/" + iconName);
        }
        catch (Exception e) {
            LOG.info("No icon named " + iconName + " was found");
        }
        return image;
    }

    protected abstract void initialize();

    protected Class getCustomizerClass() {
        return null;
    }

    protected void setSmallColorIconName(String name) {
        this.iconNameC16 = name;
    }

    protected void setColorIconName(String name) {
        this.iconNameC32 = name;
    }

    protected void setSmallMonoIconName(String name) {
        this.iconNameM16 = name;
    }

    protected void setMonoIconName(String name) {
        this.iconNameM32 = name;
    }

    protected void setDisplayName(String displayName, String propertyName) {
        PropertyDescriptor pd = this.properties.get(propertyName);
        if (pd != null) {
            pd.setDisplayName(displayName);
        } else {
            LOG.log(Level.WARNING, "Failed to set display name for property '" + propertyName + "'. No such property was found");
        }
    }

    protected void setHidden(boolean hidden, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            PropertyDescriptor pd = this.properties.get(propertyName);
            if (pd != null) {
                pd.setHidden(hidden);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set hidden attribute for property '" + propertyName + "'. No such property was found");
        }
    }

    protected void setExpert(boolean expert, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            PropertyDescriptor pd = this.properties.get(propertyName);
            if (pd != null) {
                pd.setExpert(expert);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set expert attribute for property '" + propertyName + "'. No such property was found");
        }
    }

    protected void setPreferred(boolean preferred, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            PropertyDescriptor pd = this.properties.get(propertyName);
            if (pd != null) {
                pd.setPreferred(preferred);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set preferred attribute for property '" + propertyName + "'. No such property was found");
        }
    }

    protected void setBound(boolean bound, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            PropertyDescriptor pd = this.properties.get(propertyName);
            if (pd != null) {
                pd.setBound(bound);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set bound attribute for property '" + propertyName + "'. No such property was found");
        }
    }

    protected void setConstrained(boolean constrained, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            PropertyDescriptor pd = this.properties.get(propertyName);
            if (pd != null) {
                pd.setConstrained(constrained);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set constrained attribute for property '" + propertyName + "'. No such property was found");
        }
    }

    protected void setCategory(String categoryName, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            PropertyDescriptor pd = this.properties.get(propertyName);
            if (pd != null) {
                pd.setValue("category", categoryName);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set category for property '" + propertyName + "'. No such property was found");
        }
    }

    protected void setPropertyEditor(Class editorClass, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            PropertyDescriptor pd = this.properties.get(propertyName);
            if (pd != null) {
                pd.setPropertyEditorClass(editorClass);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set property editor for property '" + propertyName + "'. No such property was found");
        }
    }

    protected void setEnumerationValues(EnumerationValue[] values, String ... propertyNames) {
        if (values == null) {
            return;
        }
        Object[] enumValues = new Object[values.length * 3];
        int index = 0;
        for (EnumerationValue ev : values) {
            enumValues[index++] = ev.getName();
            enumValues[index++] = ev.getValue();
            enumValues[index++] = ev.getJavaInitializationString();
        }
        for (String propertyName : propertyNames) {
            PropertyDescriptor pd = this.properties.get(propertyName);
            if (pd != null) {
                pd.setValue("enumerationValues", enumValues);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to set enumeration values for property '" + (String)propertyName + "'. No such property was found");
        }
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.isIntrospecting() ? null : this.beanDescriptor;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.isIntrospecting() ? null : this.properties.values().toArray(new PropertyDescriptor[0]);
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.isIntrospecting() ? null : this.events.values().toArray(new EventSetDescriptor[0]);
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.isIntrospecting() ? null : this.methods.values().toArray(new MethodDescriptor[0]);
    }

    public int getDefaultPropertyIndex() {
        return this.isIntrospecting() ? -1 : this.defaultPropertyIndex;
    }

    public int getDefaultEventIndex() {
        return this.isIntrospecting() ? -1 : this.defaultEventIndex;
    }

    public Image getIcon(int iconKind) {
        switch (iconKind) {
            case 1: {
                return this.getImage(this.iconNameC16, this.iconColor16);
            }
            case 2: {
                return this.getImage(this.iconNameC32, this.iconColor32);
            }
            case 3: {
                return this.getImage(this.iconNameM16, this.iconMono16);
            }
            case 4: {
                return this.getImage(this.iconNameM32, this.iconMono32);
            }
        }
        return null;
    }

    private Image getImage(String name, Image img) {
        if (img == null && name != null) {
            img = this.loadImage(name);
        }
        return img;
    }
}

