/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.event.MessageEvent;
import org.jdesktop.swingx.event.MessageListener;
import org.jdesktop.swingx.event.MessageSource;
import org.jdesktop.swingx.event.ProgressEvent;
import org.jdesktop.swingx.event.ProgressListener;
import org.jdesktop.swingx.event.ProgressSource;

public class MessageSourceSupport
implements MessageSource,
ProgressSource {
    private EventListenerList listeners;
    private Object source;

    public MessageSourceSupport(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("source Object cannot be null");
        }
        this.source = source;
        this.listeners = new EventListenerList();
    }

    public void addMessageListener(MessageListener l) {
        if (l != null) {
            this.listeners.add(MessageListener.class, l);
        }
    }

    public void removeMessageListener(MessageListener l) {
        if (l != null) {
            this.listeners.remove(MessageListener.class, l);
        }
    }

    public MessageListener[] getMessageListeners() {
        return (MessageListener[])this.listeners.getListeners(MessageListener.class);
    }

    public void addProgressListener(ProgressListener l) {
        if (l != null) {
            this.listeners.add(ProgressListener.class, l);
        }
    }

    public void removeProgressListener(ProgressListener l) {
        if (l != null) {
            this.listeners.remove(ProgressListener.class, l);
        }
    }

    public ProgressListener[] getProgressListeners() {
        return (ProgressListener[])this.listeners.getListeners(ProgressListener.class);
    }

    public void fireProgressStarted(int minimum, int maximum) {
        this.fireProgressStarted(new ProgressEvent(this.source, minimum, maximum));
    }

    public void fireProgressIncremented(int progress) {
        this.fireProgressIncremented(new ProgressEvent(this.source, progress));
    }

    public void fireProgressEnded() {
        this.fireProgressEnded(new ProgressEvent(this.source));
    }

    public void fireException(Throwable t) {
        this.fireMessage(new MessageEvent(this.source, t, Level.SEVERE));
    }

    public void fireMessage(String message) {
        this.fireMessage(message, Level.INFO);
    }

    public void fireMessage(Object value, Level level) {
        this.fireMessage(value, level, 0L);
    }

    public void fireMessage(Object value, Level level, long when) {
        this.fireMessage(new MessageEvent(this.source, value, level, when));
    }

    public void fireMessage(MessageEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        MessageListener[] ls = this.getMessageListeners();
        for (int i = 0; i < ls.length; ++i) {
            ls[i].message(evt);
        }
    }

    public void fireProgressIncremented(ProgressEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] ls = this.getProgressListeners();
        for (int i = 0; i < ls.length; ++i) {
            ls[i].progressIncremented(evt);
        }
    }

    public void fireProgressStarted(ProgressEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] ls = this.getProgressListeners();
        for (int i = 0; i < ls.length; ++i) {
            ls[i].progressStarted(evt);
        }
    }

    public void fireProgressEnded(ProgressEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] ls = this.getProgressListeners();
        for (int i = 0; i < ls.length; ++i) {
            ls[i].progressEnded(evt);
        }
    }
}

