/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.core.Agent;
import jade.tools.gui.ACLAIDList;
import jade.tools.gui.AIDAddressList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ACLAIDDialog
extends JDialog {
    public JCheckBox localCheckBox = new JCheckBox();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel jLabel1 = new JLabel();
    private JTextField nameTextField = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private String OK = "ok";
    private String CANCELLED = "cancelled";
    private AIDAddressList addressesList = new AIDAddressList();
    private boolean editable = true;
    private String userAction = this.CANCELLED;
    private ACLAIDList resolverList;
    private Agent agent;
    private AID itsAID;

    public ACLAIDDialog(Agent agent) {
        this.agent = agent;
        this.setModal(true);
        try {
            this.resolverList = new ACLAIDList(agent);
            this.jbInit();
            this.setSize(350, 250);
            this.setItsAID(new AID("", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AID getItsAID() {
        return this.itsAID;
    }

    public boolean getOK() {
        return this.userAction.equals(this.OK);
    }

    public void setEditable(boolean theBool) {
        if (!theBool) {
            this.OK = "CLOSED";
            this.cancelButton.setVisible(false);
            this.nameTextField.setEnabled(false);
            this.localCheckBox.setEnabled(false);
            this.resolverList.setEditable(false);
            this.addressesList.setEditable(false);
        }
    }

    public void setItsAID(AID newItsAID) {
        this.itsAID = newItsAID;
        this.nameTextField.setText(this.itsAID.getName());
        this.addressesList.register(this.itsAID);
        this.resolverList.register(this.itsAID, "Resolvers");
        String name = this.itsAID.getName();
        if (name != null && !name.endsWith(this.agent.getHap())) {
            this.localCheckBox.setSelected(true);
        }
    }

    public void setUserAction(String newUserAction) {
        this.userAction = newUserAction;
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.setUserAction(this.OK);
        this.hide();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.setUserAction(this.CANCELLED);
        this.hide();
    }

    void nameTextField_focusLost(FocusEvent e) {
        this.updateSenderName();
    }

    void updateSenderName() {
        if (this.localCheckBox.isSelected()) {
            this.itsAID.setName(this.nameTextField.getText());
        } else {
            this.itsAID.setLocalName(this.nameTextField.getText());
        }
    }

    void localCheckBox_itemStateChanged(ItemEvent e) {
        this.updateSenderName();
    }

    private void jbInit() throws Exception {
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("sender:");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.nameTextField.setFont(new Font("Dialog", 0, 11));
        this.nameTextField.setDisabledTextColor(Color.black);
        this.nameTextField.setText("someagent");
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ACLAIDDialog.this.nameTextField_focusLost(e);
            }
        });
        this.getContentPane().setBackground(Color.white);
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setText("addresses:");
        this.jLabel3.setFont(new Font("Dialog", 0, 11));
        this.jLabel3.setText("resolvers");
        this.localCheckBox.setToolTipText("Select if the name is not a GUID.");
        this.localCheckBox.setBackground(Color.white);
        this.localCheckBox.setFont(new Font("Dialog", 0, 11));
        this.localCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ACLAIDDialog.this.localCheckBox_itemStateChanged(e);
            }
        });
        this.okButton.setBackground(Color.white);
        this.okButton.setFont(new Font("Dialog", 0, 12));
        this.okButton.setText("ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLAIDDialog.this.okButton_actionPerformed(e);
            }
        });
        this.cancelButton.setBackground(Color.white);
        this.cancelButton.setFont(new Font("Dialog", 0, 12));
        this.cancelButton.setText("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLAIDDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.buttonPanel.setBackground(Color.white);
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.addressesList, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.resolverList, new GridBagConstraints(2, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jLabel3, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.localCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

