/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.StringACLCodec;
import jade.tools.gui.ACLFrame;
import jade.tools.gui.ACLMessageNode;
import jade.tools.gui.ACLPerformativesRenderer;
import jade.tools.gui.ACLStatisticsFrame;
import jade.tools.sl.SLFormatter;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ACLTracePanel
extends JPanel {
    private Logger logger = Logger.getMyLogger((String)this.getClass().getName());
    public static final String DIRECTION_IN = "in";
    public static final String DIRECTION_OUT = "out";
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
    JLabel jLabel1 = new JLabel();
    ButtonGroup sortingButtonGroup = new ButtonGroup();
    JComboBox sortComboBox = new JComboBox();
    JRadioButton ascRadioButton = new JRadioButton();
    JRadioButton descRadioButton = new JRadioButton();
    JButton sortButton = new JButton();
    JMenuItem saveQMenuItem = new JMenuItem();
    JMenuItem openQMenuItem = new JMenuItem();
    JMenuItem clearQMenuItem = new JMenuItem();
    Border border2;
    Border border3;
    private boolean sorting = false;
    private JMenuItem deleteMenuItem = new JMenuItem();
    private int inMsgCount = 0;
    private int outMsgCount = 0;
    private int aclIndex = 0;
    private DefaultMutableTreeNode aclRoot = new DefaultMutableTreeNode("messagetrace");
    private DefaultTreeModel aclModel = new DefaultTreeModel(this.aclRoot);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JScrollPane aclTreeScrollPane = new JScrollPane();
    private JTree aclTree = new JTree();
    private ACLTreeRenderer aclTreeRenderer = new ACLTreeRenderer();
    private JPopupMenu thePopupMenu = new JPopupMenu();
    private JMenuItem systemMenuItem = new JMenuItem();
    private JMenuItem zoomMenuItem = new JMenuItem();
    private int currentSelection = 0;
    private JMenuItem saveMenuItem = new JMenuItem();
    private JMenuItem stasticsMenuItem = new JMenuItem();
    private JMenuItem aboutMenuItem = new JMenuItem();
    private ImageIcon sortIcon = new ImageIcon(this.getClass().getResource("images/sort.gif"));
    private DefaultComboBoxModel sortComboBoxModel = new DefaultComboBoxModel();
    private Agent agent;
    private File currentDir;
    private int x;
    private int y;
    private ACLMessage currentACL;
    private Border border1;
    private TitledBorder titledBorder1;

    public ACLTracePanel(Agent agent) {
        this.agent = agent;
        this.inMsgCount = 0;
        this.outMsgCount = 0;
        this.aclIndex = 0;
        try {
            this.jbInit();
            this.aclTree.setCellRenderer(this.aclTreeRenderer);
            this.fillSortComboBoxModel();
            this.sortComboBox.setModel(this.sortComboBoxModel);
            this.sortComboBox.setRenderer(new SortRenderer());
            this.sortComboBox.setSelectedIndex(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ACLMessage getCurrentACL() {
        return this.currentACL;
    }

    public void doSystemOut() {
        if (this.currentACL == null) {
            return;
        }
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "\n" + this.currentACL.toString() + "\n");
        }
    }

    public void addMessageNode(ACLMessageNode theNode) {
        this.addMessageNode(theNode.getDirection(), theNode.getTime(), theNode.getMessage());
    }

    public void addMessageNode(String direction, ACLMessage theACL) {
        String theTime = this.getTimeStamp();
        this.addMessageNode(direction, theTime, theACL);
    }

    public void addMessageNode(String direction, String theTime, ACLMessage theACL) {
        Properties prop;
        Date replyBy;
        String replywith;
        String inreplyto;
        String convId;
        String ontology;
        String encoding;
        String plainContent;
        String aclString = theACL.toString();
        aclString = aclString.replace('\n', ' ');
        String contentString = theACL.getContent() != null ? theACL.getContent().replace('\n', ' ') : "";
        String theSender = theACL.getSender().getLocalName();
        String theReceiver = "<none>";
        if (theACL.getAllReceiver().hasNext()) {
            theReceiver = ((AID)theACL.getAllReceiver().next()).getLocalName();
        }
        if (direction.startsWith("i")) {
            ++this.inMsgCount;
            aclString = ACLMessage.getPerformative((int)theACL.getPerformative()) + ": from  " + theSender + " - " + contentString + " ";
        } else {
            ++this.outMsgCount;
            aclString = ACLMessage.getPerformative((int)theACL.getPerformative()) + ": to  " + theReceiver + " - " + contentString + " ";
        }
        DefaultMutableTreeNode contentNode = new DefaultMutableTreeNode(":content");
        ACLMessageNode messageNode = new ACLMessageNode(theTime + " " + direction + ": " + aclString);
        messageNode.setMessage(theACL);
        messageNode.setDirection(direction);
        messageNode.setTime(theTime);
        this.aclModel.insertNodeInto(messageNode, this.aclRoot, this.aclIndex++);
        String contentLanguage = theACL.getLanguage() != null ? theACL.getLanguage() : "<unknown>";
        String string = plainContent = theACL.getContent() != null ? theACL.getContent() : "";
        if (contentLanguage.indexOf("SL") >= 0) {
            try {
                new SLFormatter();
                plainContent = SLFormatter.format(plainContent);
            }
            catch (Exception ex) {}
        }
        while (plainContent.indexOf(10) == 0) {
            plainContent = plainContent.substring(1);
        }
        StringTokenizer stok = new StringTokenizer(plainContent, "\n");
        while (stok.hasMoreTokens()) {
            contentNode.add(new DefaultMutableTreeNode(stok.nextToken()));
        }
        int i = 0;
        this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":act " + ACLMessage.getPerformative((int)theACL.getPerformative())), messageNode, i++);
        AID sender = theACL.getSender();
        if (sender != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":sender " + sender.toString()), messageNode, i++);
        }
        AID aid = new AID();
        Iterator it = theACL.getAllReceiver();
        while (it.hasNext()) {
            aid = (AID)it.next();
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":receiver " + aid.toString()), messageNode, i++);
        }
        Iterator replyItor = theACL.getAllReplyTo();
        while (replyItor.hasNext()) {
            aid = (AID)replyItor.next();
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":reply-to " + aid.toString()), messageNode, i++);
        }
        this.aclModel.insertNodeInto(new DefaultMutableTreeNode("--- Description of Content ---"), messageNode, i++);
        this.aclModel.insertNodeInto(contentNode, messageNode, i++);
        String language = theACL.getLanguage();
        if (language != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":language " + language), messageNode, i++);
        }
        if ((encoding = theACL.getEncoding()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":encoding " + encoding), messageNode, i++);
        }
        if ((ontology = theACL.getOntology()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":ontology " + ontology), messageNode, i++);
        }
        this.aclModel.insertNodeInto(new DefaultMutableTreeNode("--- Message control ---"), messageNode, i++);
        String protocol = theACL.getProtocol();
        if (protocol != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":protocol " + protocol), messageNode, i++);
        }
        if ((convId = theACL.getConversationId()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":conversation-id " + convId), messageNode, i++);
        }
        if ((inreplyto = theACL.getInReplyTo()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":in-reply-to " + inreplyto), messageNode, i++);
        }
        if ((replywith = theACL.getReplyWith()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":reply-with " + replywith), messageNode, i++);
        }
        if ((replyBy = theACL.getReplyByDate()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":reply-by " + replyBy.toString()), messageNode, i++);
        }
        if ((prop = theACL.getAllUserDefinedParameters()).size() > 0) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode("--- User Defined Parameters ---"), messageNode, i++);
            Enumeration enumeration = prop.elements();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = prop.getProperty(key);
                this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":X-" + key + " " + value), messageNode, i++);
            }
        }
        if (!this.sorting) {
            this.doSort();
        }
        this.aclTree.expandPath(new TreePath(this.aclRoot.getPath()));
    }

    public void deleteCurrent() {
        TreePath tp = this.aclTree.getSelectionPath();
        if (tp == null) {
            this.currentACL = null;
        } else {
            this.currentACL = ((ACLMessageNode)tp.getPathComponent(1)).getMessage();
            this.aclModel.removeNodeFromParent((ACLMessageNode)tp.getPathComponent(1));
            this.refresh();
            --this.aclIndex;
        }
    }

    public void doShowAbout() {
        new AboutFrame().show();
    }

    public void saveACL() {
        block5: {
            int returnVal;
            UIManager.put("FileChooser.saveButtonToolTipText", "Save ACLMessage");
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new ACLFileFilter());
            chooser.setSelectedFile(new File("itsmessage.acl"));
            chooser.setDialogTitle("Save ACLMessage");
            if (this.currentDir != null) {
                chooser.setCurrentDirectory(this.currentDir);
            }
            if ((returnVal = chooser.showSaveDialog(null)) != 0) break block5;
            this.currentDir = chooser.getCurrentDirectory();
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            try {
                FileWriter f = new FileWriter(fileName);
                StringACLCodec codec = new StringACLCodec(null, (Writer)f);
                codec.write(this.currentACL);
                f.close();
            }
            catch (FileNotFoundException e3) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Can't open file: " + fileName);
                }
            }
            catch (IOException e4) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block5;
                this.logger.log(Logger.WARNING, "IO Exception");
            }
        }
    }

    public void doShowCurrentACL() {
        this.showCurrentACL(this.x, this.y);
    }

    public void showStastistics() {
        ACLStatisticsFrame.show(this.aclModel);
    }

    public void saveQueue() {
        block7: {
            int returnVal;
            UIManager.put("FileChooser.saveButtonToolTipText", "Save ACLMessage Trace");
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new TraceFileFilter());
            chooser.setSelectedFile(new File("itsTrace.trc"));
            chooser.setDialogTitle("Save ACLMessage Trace");
            if (this.currentDir != null) {
                chooser.setCurrentDirectory(this.currentDir);
            }
            if ((returnVal = chooser.showSaveDialog(null)) != 0) break block7;
            this.currentDir = chooser.getCurrentDirectory();
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            if (!fileName.endsWith(".trc")) {
                fileName = fileName + ".trc";
            }
            try {
                FileWriter f = new FileWriter(fileName);
                BufferedWriter bw = new BufferedWriter(f);
                int size = this.aclModel.getChildCount(this.aclRoot);
                int i = 0;
                while (i < size) {
                    System.out.println("aclModel: " + this.aclModel.getChild(this.aclRoot, i).getClass());
                    ACLMessageNode theNode = (ACLMessageNode)this.aclModel.getChild(this.aclRoot, i);
                    String direction = theNode.getDirection();
                    String theTime = theNode.getTime();
                    ACLMessage theMsg = theNode.getMessage();
                    bw.newLine();
                    bw.write(direction);
                    bw.newLine();
                    bw.write(theTime);
                    bw.newLine();
                    bw.write(theMsg.toString());
                    bw.newLine();
                    ++i;
                }
                bw.flush();
                bw.close();
                f.close();
            }
            catch (FileNotFoundException e3) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Can't open file: " + fileName);
                }
            }
            catch (IOException e4) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block7;
                this.logger.log(Logger.WARNING, "IO Exception");
            }
        }
    }

    public void loadQueue() {
        block9: {
            int returnVal;
            UIManager.put("FileChooser.openButtonToolTipText", "Open ACLMessage Trace");
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new TraceFileFilter());
            chooser.setDialogTitle("Open ACLMessage Trace From File");
            if (this.currentDir != null) {
                chooser.setCurrentDirectory(this.currentDir);
            }
            if ((returnVal = chooser.showOpenDialog(null)) != 0) break block9;
            this.currentDir = chooser.getCurrentDirectory();
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            try {
                this.clearACLModel();
                FileReader f = new FileReader(fileName);
                BufferedReader br = new BufferedReader(f);
                String line = br.readLine();
                while (line != null) {
                    String direction = br.readLine();
                    String theTime = br.readLine();
                    String theMessageLine = "";
                    line = br.readLine();
                    while (line != null && !line.equals("")) {
                        theMessageLine = theMessageLine + "\n" + line;
                        line = br.readLine();
                    }
                    char[] chararray = theMessageLine.toCharArray();
                    StringACLCodec codec = new StringACLCodec((Reader)new StringReader(new String(chararray)), null);
                    ACLMessage theMsg = codec.decode();
                    this.addMessageNode(direction, theTime, theMsg);
                }
                br.close();
                f.close();
            }
            catch (FileNotFoundException e3) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Can't open file: " + fileName);
                }
            }
            catch (IOException e4) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "IO Exception");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void clearACLModel() {
        int size = this.aclModel.getChildCount(this.aclRoot);
        int i = size - 1;
        while (i >= 0) {
            ACLMessageNode theNode = (ACLMessageNode)this.aclModel.getChild(this.aclRoot, i);
            this.aclRoot.remove(theNode);
            --i;
        }
        this.aclIndex = 0;
        this.aclModel.reload();
        this.aclTree.validate();
        this.aclTree.repaint();
    }

    public void doSort() {
        int direction = this.sortComboBox.getSelectedIndex();
        int ascending = this.ascRadioButton.isSelected() ? 1 : -1;
        ACLMessageNodeComparator anc = new ACLMessageNodeComparator(direction, ascending);
        int size = this.aclModel.getChildCount(this.aclRoot);
        if (size < 2) {
            return;
        }
        Object[] theList = new Object[size];
        int i = 0;
        while (i < size) {
            ACLMessageNode theNode = (ACLMessageNode)this.aclModel.getChild(this.aclRoot, i);
            theList[i] = theNode;
            ++i;
        }
        Arrays.sort(theList, anc);
        this.clearACLModel();
        this.sorting = true;
        int i2 = 0;
        while (i2 < size) {
            ACLMessageNode theNode = (ACLMessageNode)theList[i2];
            this.addMessageNode(theNode);
            ++i2;
        }
        this.sorting = false;
        this.aclModel.reload();
        this.aclTree.validate();
        this.aclTree.repaint();
    }

    String getTimeStamp() {
        return dateFormat.format(new Date());
    }

    void refresh() {
        this.aclTree.validate();
        this.aclTree.updateUI();
    }

    void aclTree_mouseClicked(MouseEvent e) {
        try {
            TreePath tp = this.aclTree.getSelectionPath();
            this.currentACL = tp == null ? null : ((ACLMessageNode)tp.getPathComponent(1)).getMessage();
            if (e.getModifiers() == 4) {
                if (this.currentACL == null) {
                    JOptionPane.showMessageDialog(null, "No ACL", "Select a Message", 0);
                    return;
                }
                this.x = e.getX();
                this.y = e.getY();
                this.thePopupMenu.show(this, e.getX(), e.getY());
            }
            if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                if (this.currentACL == null) {
                    JOptionPane.showMessageDialog(null, "No ACL", "Select a Message", 0);
                    return;
                }
                this.showCurrentACL(e.getX(), e.getY());
            }
        }
        catch (Exception ex) {}
    }

    void systemMenuItem_actionPerformed(ActionEvent e) {
        if (this.currentACL == null) {
            return;
        }
    }

    void zoomMenuItem_actionPerformed(ActionEvent e) {
        this.doShowCurrentACL();
    }

    void saveMenuItem_actionPerformed(ActionEvent e) {
        this.saveACL();
    }

    void stasticsMenuItem_actionPerformed(ActionEvent e) {
        this.showStastistics();
    }

    void aclTree_keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.deleteCurrent();
        }
    }

    void deleteMenuItem_actionPerformed(ActionEvent e) {
        this.deleteCurrent();
    }

    void sortButton_actionPerformed(ActionEvent e) {
        this.doSort();
    }

    void sortComboBox_itemStateChanged(ItemEvent e) {
        this.doSort();
    }

    void ascRadioButton_itemStateChanged(ItemEvent e) {
        this.doSort();
    }

    void descRadioButton_itemStateChanged(ItemEvent e) {
        this.doSort();
    }

    void aboutMenuItem_mouseClicked(MouseEvent e) {
        this.doShowAbout();
    }

    void saveQMenuItem_actionPerformed(ActionEvent e) {
        this.saveQueue();
    }

    void clearQMenuItem_actionPerformed(ActionEvent e) {
        this.clearACLModel();
    }

    void openQMenuItem_actionPerformed(ActionEvent e) {
        this.loadQueue();
    }

    void aboutMenuItem_actionPerformed(ActionEvent e) {
        this.doShowAbout();
    }

    private void fillSortComboBoxModel() {
        this.sortComboBoxModel.addElement("date");
        this.sortComboBoxModel.addElement("direction");
        this.sortComboBoxModel.addElement("sender");
        this.sortComboBoxModel.addElement("receiver");
        this.sortComboBoxModel.addElement("performative");
        this.sortComboBoxModel.addElement("ontology");
    }

    private void showCurrentACL(int x, int y) {
        if (this.currentACL == null) {
            return;
        }
        ACLFrame.show(this.currentACL, this.agent);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(Color.black, 2);
        this.titledBorder1 = new TitledBorder(this.border1, "actions");
        this.border2 = BorderFactory.createLineBorder(Color.black, 0);
        this.border3 = BorderFactory.createLineBorder(Color.darkGray, 1);
        this.setLayout(this.gridBagLayout2);
        this.aclTree.setModel(this.aclModel);
        this.aclTree.addKeyListener(new ACLTreePanel_aclTree_keyAdapter(this));
        this.aclTree.addMouseListener(new ACLTreePanel_aclTree_mouseAdapter(this));
        this.addMouseListener(new ACLTreePanel_this_mouseAdapter(this));
        this.systemMenuItem.setBackground(Color.white);
        this.systemMenuItem.setFont(new Font("Dialog", 0, 11));
        this.systemMenuItem.setMnemonic('O');
        this.systemMenuItem.setText("System.out");
        this.systemMenuItem.addActionListener(new ACLTreePanel_systemMenuItem_actionAdapter(this));
        this.zoomMenuItem.setBackground(Color.white);
        this.zoomMenuItem.setFont(new Font("Dialog", 0, 11));
        this.zoomMenuItem.setMnemonic('V');
        this.zoomMenuItem.setText("View ACLMessage");
        this.zoomMenuItem.addActionListener(new ACLTreePanel_zoomMenuItem_actionAdapter(this));
        this.thePopupMenu.setBackground(Color.white);
        this.thePopupMenu.setBorder(BorderFactory.createLineBorder(Color.black));
        this.thePopupMenu.setOpaque(false);
        this.saveMenuItem.setBackground(Color.white);
        this.saveMenuItem.setFont(new Font("Dialog", 0, 11));
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setText("Save ACLMessage");
        this.saveMenuItem.addActionListener(new ACLTreePanel_saveMenuItem_actionAdapter(this));
        this.stasticsMenuItem.setBackground(Color.white);
        this.stasticsMenuItem.setFont(new Font("Dialog", 0, 11));
        this.stasticsMenuItem.setMnemonic('T');
        this.stasticsMenuItem.setText("Show Statistics");
        this.stasticsMenuItem.addActionListener(new ACLTreePanel_stasticsMenuItem_actionAdapter(this));
        this.aboutMenuItem.setBackground(Color.white);
        this.aboutMenuItem.setFont(new Font("Dialog", 0, 11));
        this.aboutMenuItem.setForeground(new Color(0, 0, 140));
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ACLTracePanel_aboutMenuItem_actionAdapter(this));
        this.deleteMenuItem.setBackground(Color.white);
        this.deleteMenuItem.setFont(new Font("Dialog", 0, 11));
        this.deleteMenuItem.setMnemonic('D');
        this.deleteMenuItem.setText("Delete ACLMessage");
        this.deleteMenuItem.addActionListener(new ACLTreePanel_deleteMenuItem_actionAdapter(this));
        this.jLabel1.setBackground(Color.white);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setOpaque(true);
        this.jLabel1.setText("sort by:");
        this.ascRadioButton.setSelected(true);
        this.ascRadioButton.setText("Ascending");
        this.ascRadioButton.setToolTipText("Sort ACLMessage Trace Ascending");
        this.ascRadioButton.setBackground(Color.white);
        this.ascRadioButton.setFont(new Font("Dialog", 0, 12));
        this.ascRadioButton.addItemListener(new ACLTracePanel_ascRadioButton_itemAdapter(this));
        this.descRadioButton.setText("Descending");
        this.descRadioButton.setToolTipText("Sort ACLMessage Trace Descending");
        this.descRadioButton.setBackground(Color.white);
        this.descRadioButton.setFont(new Font("Dialog", 0, 12));
        this.descRadioButton.addItemListener(new ACLTracePanel_descRadioButton_itemAdapter(this));
        this.sortButton.setForeground(Color.white);
        this.sortButton.setBorder(this.border2);
        this.sortButton.setMaximumSize(new Dimension(23, 20));
        this.sortButton.setPreferredSize(new Dimension(23, 20));
        this.sortButton.setToolTipText("Sort ACLMessage Trace");
        this.sortButton.setIcon(this.sortIcon);
        this.sortButton.addActionListener(new ACLTracePanel_sortButton_actionAdapter(this));
        this.sortButton.addActionListener(new ACLTracePanel_sortButton_actionAdapter(this));
        this.setBackground(Color.white);
        this.sortComboBox.setBackground(Color.white);
        this.sortComboBox.setFont(new Font("Dialog", 0, 12));
        this.sortComboBox.setForeground(Color.blue);
        this.sortComboBox.setToolTipText("Select on which field to sort the ACLMessage Trace");
        this.sortComboBox.addItemListener(new ACLTracePanel_sortComboBox_itemAdapter(this));
        this.aclTreeScrollPane.setBorder(this.border3);
        this.saveQMenuItem.setBackground(Color.white);
        this.saveQMenuItem.setFont(new Font("Dialog", 0, 11));
        this.saveQMenuItem.setMnemonic('A');
        this.saveQMenuItem.setText("Save ACLMessage Trace");
        this.saveQMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLTracePanel.this.saveQMenuItem_actionPerformed(e);
            }
        });
        this.openQMenuItem.setBackground(Color.white);
        this.openQMenuItem.setFont(new Font("Dialog", 0, 11));
        this.openQMenuItem.setMnemonic('P');
        this.openQMenuItem.setText("Open ACLMessage Trace");
        this.openQMenuItem.addActionListener(new ACLTracePanel_openQMenuItem_actionAdapter(this));
        this.clearQMenuItem.setBackground(Color.white);
        this.clearQMenuItem.setFont(new Font("Dialog", 0, 11));
        this.clearQMenuItem.setMnemonic('C');
        this.clearQMenuItem.setText("Clear ACLMessage Trace");
        this.clearQMenuItem.addActionListener(new ACLTracePanel_clearQMenuItem_actionAdapter(this));
        this.add((Component)this.aclTreeScrollPane, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sortComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.ascRadioButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.descRadioButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sortButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTreeScrollPane.getViewport().add((Component)this.aclTree, null);
        this.thePopupMenu.add(this.systemMenuItem);
        this.thePopupMenu.add(this.zoomMenuItem);
        this.thePopupMenu.addSeparator();
        this.thePopupMenu.add(this.saveMenuItem);
        this.thePopupMenu.add(this.deleteMenuItem);
        this.thePopupMenu.addSeparator();
        this.thePopupMenu.add(this.saveQMenuItem);
        this.thePopupMenu.add(this.openQMenuItem);
        this.thePopupMenu.add(this.clearQMenuItem);
        this.thePopupMenu.addSeparator();
        this.thePopupMenu.add(this.stasticsMenuItem);
        this.thePopupMenu.add(this.aboutMenuItem);
        this.sortingButtonGroup.add(this.ascRadioButton);
        this.sortingButtonGroup.add(this.descRadioButton);
    }

    private class ACLTracePanel_aboutMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTracePanel_aboutMenuItem_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.aboutMenuItem_actionPerformed(e);
        }
    }

    private class ACLTracePanel_openQMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTracePanel_openQMenuItem_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.openQMenuItem_actionPerformed(e);
        }
    }

    private class ACLTracePanel_clearQMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTracePanel_clearQMenuItem_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.clearQMenuItem_actionPerformed(e);
        }
    }

    private class ACLTracePanel_aboutMenuItem_mouseAdapter
    extends MouseAdapter {
        ACLTracePanel adaptee;

        ACLTracePanel_aboutMenuItem_mouseAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void mouseClicked(MouseEvent e) {
            this.adaptee.aboutMenuItem_mouseClicked(e);
        }
    }

    private class SortRenderer
    extends JLabel
    implements ListCellRenderer {
        public SortRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Dialog", 0, 10));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                String sValue = (String)value;
                this.setText((String)value);
                this.setBackground(isSelected ? Color.blue : Color.white);
                this.setForeground(isSelected ? Color.white : Color.blue);
            }
            return this;
        }
    }

    private class ACLTreeRenderer
    extends JLabel
    implements TreeCellRenderer {
        public ImageIcon rootIcon = new ImageIcon(this.getClass().getResource("images/inbox.gif"));
        public ImageIcon nodeIcon = new ImageIcon(this.getClass().getResource("images/service.gif"));
        public ImageIcon smallAgentIcon = new ImageIcon(this.getClass().getResource("images/smallagent.gif"));
        public ImageIcon messageTypeIcon = new ImageIcon(this.getClass().getResource("images/messagetype.gif"));
        public ImageIcon detailsIcon = new ImageIcon(this.getClass().getResource("images/details.gif"));
        public ImageIcon incomingIcon = new ImageIcon(this.getClass().getResource("images/incoming.gif"));
        public ImageIcon outgoingIcon = new ImageIcon(this.getClass().getResource("images/outgoing.gif"));

        ACLTreeRenderer() {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setText(((DefaultMutableTreeNode)value).toString());
            int depth = ((DefaultMutableTreeNode)value).getLevel();
            this.setFont(new Font("SansSerif", 0, 11));
            Color theColor = Color.black;
            String sValue = value.toString();
            switch (depth) {
                case 0: {
                    this.setIcon(this.rootIcon);
                    break;
                }
                case 1: {
                    if (sValue.indexOf("in:") > 0) {
                        this.setIcon(this.incomingIcon);
                        theColor = Color.red;
                        break;
                    }
                    this.setIcon(this.outgoingIcon);
                    theColor = Color.blue;
                    break;
                }
                case 2: {
                    this.setIcon(this.nodeIcon);
                    if (sValue.startsWith(":act ")) {
                        this.setIcon(this.messageTypeIcon);
                        String performative = sValue.substring(5, sValue.length());
                        theColor = ACLPerformativesRenderer.determineColor(performative);
                        this.setFont(new Font("SansSerif", 1, 11));
                    }
                    if (sValue.startsWith(":content")) {
                        this.setIcon(this.detailsIcon);
                    }
                    if (sValue.startsWith(":sender")) {
                        this.setIcon(this.smallAgentIcon);
                    }
                    if (!sValue.startsWith(":receiver") && !sValue.startsWith(":reply-to")) break;
                    this.setIcon(this.smallAgentIcon);
                    break;
                }
                case 3: {
                    this.setIcon(this.detailsIcon);
                }
            }
            this.setBackground(isSelected ? Color.blue : Color.white);
            this.setForeground(isSelected ? Color.white : theColor);
            return this;
        }

        private void jbInit() throws Exception {
            this.setFont(new Font("SansSerif", 0, 11));
            this.setOpaque(true);
        }
    }

    private class ACLTreePanel_deleteMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_deleteMenuItem_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.deleteMenuItem_actionPerformed(e);
        }
    }

    private class ACLTreePanel_aclTree_keyAdapter
    extends KeyAdapter {
        ACLTracePanel adaptee;

        ACLTreePanel_aclTree_keyAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void keyTyped(KeyEvent e) {
            this.adaptee.aclTree_keyTyped(e);
        }
    }

    private class ACLTreePanel_saveMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_saveMenuItem_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.saveMenuItem_actionPerformed(e);
        }
    }

    private class ACLTreePanel_zoomMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_zoomMenuItem_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.zoomMenuItem_actionPerformed(e);
        }
    }

    private class ACLTreePanel_systemMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_systemMenuItem_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.systemMenuItem_actionPerformed(e);
        }
    }

    private class ACLTreePanel_aclTree_mouseAdapter
    extends MouseAdapter {
        ACLTracePanel adaptee;

        ACLTreePanel_aclTree_mouseAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void mouseClicked(MouseEvent e) {
            this.adaptee.aclTree_mouseClicked(e);
        }
    }

    private class ACLTreePanel_this_mouseAdapter
    extends MouseAdapter {
        ACLTracePanel adaptee;

        ACLTreePanel_this_mouseAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    private class ACLTreePanel_stasticsMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_stasticsMenuItem_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.stasticsMenuItem_actionPerformed(e);
        }
    }

    private class AboutFrame
    extends JWindow {
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JPanel contentPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel logoLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        Border border1;

        public AboutFrame() {
            try {
                this.jbInit();
                this.setSize(400, 175);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void logoLabel_mouseClicked(MouseEvent e) {
            this.setVisible(false);
        }

        void logoLabel3_mousePressed(MouseEvent e) {
            this.setVisible(false);
        }

        void jLabel2_mouseClicked(MouseEvent e) {
            this.setVisible(false);
        }

        void logoLabel3_mouseClicked(MouseEvent e) {
            this.setVisible(false);
        }

        void logoLabel_mouseEntered(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void logoLabel_mouseExited(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void logoLabel3_mouseEntered(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void logoLabel3_mouseExited(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void jLabel2_mouseEntered(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void jLabel2_mouseExited(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void logoLabel_mousePressed(MouseEvent e) {
            this.setVisible(false);
        }

        void logoLabel_mouseReleased(MouseEvent e) {
            this.setVisible(false);
        }

        void jLabel2_mousePressed(MouseEvent e) {
            this.setVisible(false);
        }

        void jLabel2_mouseReleased(MouseEvent e) {
            this.setVisible(false);
        }

        void jLabel4_mouseClicked(MouseEvent e) {
            this.setVisible(false);
        }

        void contentPanel_mouseClicked(MouseEvent e) {
            this.setVisible(false);
        }

        void jLabel1_mouseClicked(MouseEvent e) {
            this.setVisible(false);
        }

        void jLabel4_mouseEntered(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void jLabel1_mouseEntered(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void contentPanel_mouseEntered(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void jLabel4_mouseExited(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void contentPanel_mouseExited(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        private void jbInit() throws Exception {
            this.border1 = new TitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 128), 1), "jade.tools.gui");
            this.getContentPane().setBackground(Color.white);
            this.getContentPane().setLayout(this.gridBagLayout1);
            this.contentPanel.setLayout(this.gridBagLayout2);
            this.jLabel1.setText("donated by Acklin B.V. to the Jade project");
            this.jLabel1.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$1.jLabel1_mouseClicked(e);
                }

                public void mouseEntered(MouseEvent e) {
                    this.this$1.jLabel1_mouseEntered(e);
                }
            });
            this.jLabel2.setFont(new Font("Dialog", 0, 12));
            this.jLabel2.setText("web: www.acklin.nl  |  email: info@acklin.nl");
            this.jLabel2.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$1.jLabel2_mouseClicked(e);
                }

                public void mouseEntered(MouseEvent e) {
                    this.this$1.jLabel2_mouseEntered(e);
                }

                public void mouseExited(MouseEvent e) {
                    this.this$1.jLabel2_mouseExited(e);
                }
            });
            this.contentPanel.setBackground(Color.white);
            this.contentPanel.setFont(new Font("Dialog", 0, 11));
            this.contentPanel.setBorder(this.border1);
            this.contentPanel.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$1.contentPanel_mouseClicked(e);
                }

                public void mouseEntered(MouseEvent e) {
                    this.this$1.contentPanel_mouseEntered(e);
                }

                public void mouseExited(MouseEvent e) {
                    this.this$1.contentPanel_mouseExited(e);
                }
            });
            this.logoLabel3.setFont(new Font("SansSerif", 1, 60));
            this.logoLabel3.setForeground(new Color(0, 0, 128));
            this.logoLabel3.setText("Acklin");
            this.logoLabel3.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$1.logoLabel3_mouseClicked(e);
                }

                public void mouseEntered(MouseEvent e) {
                    this.this$1.logoLabel3_mouseEntered(e);
                }

                public void mouseExited(MouseEvent e) {
                    this.this$1.logoLabel3_mouseExited(e);
                }
            });
            this.jLabel4.setFont(new Font("Dialog", 1, 20));
            this.jLabel4.setForeground(Color.darkGray);
            this.jLabel4.setText("agent based support");
            this.jLabel4.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$1.jLabel4_mouseClicked(e);
                }

                public void mouseEntered(MouseEvent e) {
                    this.this$1.jLabel4_mouseEntered(e);
                }

                public void mouseExited(MouseEvent e) {
                    this.this$1.jLabel4_mouseExited(e);
                }
            });
            this.getContentPane().add((Component)this.contentPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.contentPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.contentPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.contentPanel.add((Component)this.logoLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.contentPanel.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        }
    }

    private class TraceFileFilter
    extends FileFilter {
        private String[] extensions = new String[]{".trc"};

        public String getDescription() {
            return "ACLMessageTrace files (*.trc)";
        }

        public boolean accept(File pathName) {
            if (pathName.isDirectory()) {
                return true;
            }
            return pathName.isFile() && pathName.getName().endsWith(".trc");
        }
    }

    private class ACLFileFilter
    extends FileFilter {
        public String getDescription() {
            return "ACLMessage files (*.acl)";
        }

        public boolean accept(File pathName) {
            if (pathName.isDirectory()) {
                return true;
            }
            return pathName.isFile() && pathName.getName().endsWith(".acl");
        }
    }

    private class ACLTracePanel_sortButton_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTracePanel_sortButton_actionAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.sortButton_actionPerformed(e);
        }
    }

    private class ACLTracePanel_descRadioButton_itemAdapter
    implements ItemListener {
        ACLTracePanel adaptee;

        ACLTracePanel_descRadioButton_itemAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void itemStateChanged(ItemEvent e) {
            this.adaptee.descRadioButton_itemStateChanged(e);
        }
    }

    private class ACLTracePanel_ascRadioButton_itemAdapter
    implements ItemListener {
        ACLTracePanel adaptee;

        ACLTracePanel_ascRadioButton_itemAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void itemStateChanged(ItemEvent e) {
            this.adaptee.ascRadioButton_itemStateChanged(e);
        }
    }

    private class ACLTracePanel_sortComboBox_itemAdapter
    implements ItemListener {
        ACLTracePanel adaptee;

        ACLTracePanel_sortComboBox_itemAdapter(ACLTracePanel adaptee) {
            this.adaptee = adaptee;
        }

        public void itemStateChanged(ItemEvent e) {
            this.adaptee.sortComboBox_itemStateChanged(e);
        }
    }

    private class ACLMessageNodeComparator
    implements Comparator {
        static final int DATE = 0;
        static final int DIRECTION = 1;
        static final int SENDER = 2;
        static final int RECEIVER = 3;
        static final int PERFORMATIVE = 4;
        static final int ONTOLOGY = 5;
        static final int SORT_ASCENDING = 1;
        static final int SORT_DESCENDING = -1;
        private int sorting;
        private int mode;

        public ACLMessageNodeComparator(int mode, int sorting) {
            this.mode = mode;
            this.sorting = sorting;
        }

        public int compare(Object o1, Object o2) {
            ACLMessageNode node1 = (ACLMessageNode)o1;
            ACLMessageNode node2 = (ACLMessageNode)o2;
            String comp1 = "";
            String comp2 = "";
            switch (this.mode) {
                case 1: {
                    comp1 = node1.getDirection() != null ? node1.getDirection() : "";
                    comp2 = node2.getDirection() != null ? node2.getDirection() : "";
                    break;
                }
                case 0: {
                    Date date1 = node1.getTheDate();
                    Date date2 = node2.getTheDate();
                    return this.sorting * date1.compareTo(date2);
                }
                case 2: {
                    comp1 = node1.getMessage().getSender() != null ? node1.getMessage().getSender().getName() : "";
                    comp2 = node2.getMessage().getSender() != null ? node2.getMessage().getSender().getName() : "";
                    break;
                }
                case 3: {
                    comp1 = node1.getMessage().getAllReceiver().hasNext() ? ((AID)node1.getMessage().getAllReceiver().next()).getName() : "";
                    comp2 = node2.getMessage().getAllReceiver().hasNext() ? ((AID)node2.getMessage().getAllReceiver().next()).getName() : "";
                    break;
                }
                case 4: {
                    comp1 = ACLMessage.getPerformative((int)node1.getMessage().getPerformative());
                    comp2 = ACLMessage.getPerformative((int)node2.getMessage().getPerformative());
                    break;
                }
                case 5: {
                    comp1 = node1.getMessage().getOntology() != null ? node1.getMessage().getOntology() : "";
                    comp2 = node2.getMessage().getOntology() != null ? node2.getMessage().getOntology() : "";
                }
            }
            return this.sorting * comp1.compareTo(comp2);
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException("Method equals() not yet implemented.");
        }
    }
}

