/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.core.BehaviourID;
import jade.domain.introspection.AddedBehaviour;
import jade.domain.introspection.ChangedBehaviourState;
import jade.domain.introspection.RemovedBehaviour;
import jade.tools.introspector.gui.BehaviourPanel;
import jade.tools.introspector.gui.BehaviourTreeNode;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUpdater
implements Runnable {
    private BehaviourID behaviour;
    private BehaviourPanel gui;
    private int action;
    private String state;
    private static final int ADD_NODE = 0;
    private static final int REMOVE_NODE = 1;
    private static final int CHANGE_NODE = 2;

    public TreeUpdater(AddedBehaviour b, BehaviourPanel bp) {
        this.behaviour = b.getBehaviour();
        this.gui = bp;
        this.action = 0;
        this.state = "READY";
    }

    public TreeUpdater(RemovedBehaviour b, BehaviourPanel bp) {
        this.behaviour = b.getBehaviour();
        this.gui = bp;
        this.action = 1;
        this.state = "READY";
    }

    public TreeUpdater(ChangedBehaviourState b, BehaviourPanel bp) {
        this.behaviour = b.getBehaviour();
        this.gui = bp;
        this.action = 2;
        this.state = b.getTo();
    }

    public void createTree(DefaultMutableTreeNode r, Iterator v) {
        while (v.hasNext()) {
            BehaviourID b = (BehaviourID)v.next();
            DefaultMutableTreeNode rc = new DefaultMutableTreeNode(new BehaviourTreeNode(b, this.state));
            if (!b.isSimple()) {
                this.createTree(rc, (Iterator)b.getAllChildren());
            }
            r.add(rc);
        }
    }

    public void run() {
        JTree tree = this.gui.getBehaviourTree();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        if (this.action == 2) {
            boolean bFound = false;
            tree.clearSelection();
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            if (e.hasMoreElements()) {
                e.nextElement();
            }
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                BehaviourTreeNode bNode = (BehaviourTreeNode)node.getUserObject();
                BehaviourID b = bNode.getBehaviour();
                if (b.getCode() != this.behaviour.getCode() || !b.equals((Object)this.behaviour)) continue;
                Object[] o = node.getPath();
                TreePath tp = new TreePath(o);
                tree.setSelectionPath(tp);
                TreeUpdater.description(this.gui.getBehaviourText(), b);
                if (!this.state.equals(bNode.getState())) {
                    bNode.setState(this.state);
                    model.nodeChanged(node);
                }
                bFound = true;
                break;
            }
        }
        if (this.action == 0) {
            DefaultMutableTreeNode beh = new DefaultMutableTreeNode(new BehaviourTreeNode(this.behaviour, this.state));
            if (!this.behaviour.isSimple()) {
                this.createTree(beh, (Iterator)this.behaviour.getAllChildren());
            }
            model.insertNodeInto(beh, root, model.getChildCount(root));
        }
        if (this.action == 1) {
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            e.nextElement();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                BehaviourTreeNode b = (BehaviourTreeNode)node.getUserObject();
                if (!b.getBehaviour().equals((Object)this.behaviour)) continue;
                model.removeNodeFromParent(node);
                break;
            }
        }
    }

    public static void description(JTextArea t, BehaviourID b) {
        t.setText("Name:\t" + b.getName() + "\nClass:\t" + b.getClassName() + "\nKind:\t" + b.getKind());
    }
}

