/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.sniffer;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.core.AID;
import jade.core.ContainerID;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.SenderBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.SniffOff;
import jade.domain.JADEAgentManagement.SniffOn;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.Occurred;
import jade.domain.introspection.PostedMessage;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.ResetEvents;
import jade.domain.introspection.SentMessage;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.StringACLCodec;
import jade.proto.SimpleAchieveREInitiator;
import jade.proto.SimpleAchieveREResponder;
import jade.tools.ToolAgent;
import jade.tools.sniffer.ActionProcessor;
import jade.tools.sniffer.Agent;
import jade.tools.sniffer.DoNotSnifferAction;
import jade.tools.sniffer.DoSnifferAction;
import jade.tools.sniffer.MainWindow;
import jade.tools.sniffer.Message;
import jade.util.BasicProperties;
import jade.util.ExpandedProperties;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Sniffer
extends ToolAgent {
    public static final boolean SNIFF_ON = true;
    public static final boolean SNIFF_OFF = false;
    private Set allAgents = null;
    private Hashtable preload = null;
    private ExpandedProperties properties = null;
    private ArrayList agentsUnderSniff = new ArrayList();
    private SequentialBehaviour AMSSubscribe = new SequentialBehaviour();
    private MainWindow myGUI;
    private String myContainerName;

    protected String preloadContains(String agentName) {
        Enumeration enumeration = this.preload.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!this.isMatch(key, agentName)) continue;
            return key;
        }
        return null;
    }

    protected boolean isMatch(String aMatchExpression, String aString) {
        int expressionLength = aMatchExpression.length();
        int i = 0;
        while (i < expressionLength) {
            char expChar = aMatchExpression.charAt(i);
            if (expChar == '*') {
                return true;
            }
            if (i == aString.length()) {
                return false;
            }
            if (expChar != '?' && expChar != aString.charAt(i)) {
                return false;
            }
            ++i;
        }
        return expressionLength == aString.length();
    }

    public void toolSetup() {
        this.properties = new ExpandedProperties();
        Object[] arguments = this.getArguments();
        if (arguments != null && arguments.length > 0) {
            String s = "";
            int i = 0;
            while (i < arguments.length) {
                s = s + arguments[i].toString() + ' ';
                ++i;
            }
            this.properties.setProperty("preload", s);
        } else {
            String fileName = this.locateFile("sniffer.properties");
            if (fileName != null) {
                try {
                    this.properties.addFromFile(fileName);
                }
                catch (IOException ioe) {}
            } else {
                fileName = this.locateFile("sniffer.inf");
                if (fileName != null) {
                    this.loadSnifferConfigurationFile(fileName, this.properties);
                }
            }
        }
        this.allAgents = new HashSet();
        this.preload = new Hashtable();
        String preloadDescriptions = this.properties.getProperty("preload", null);
        if (preloadDescriptions != null) {
            StringTokenizer parser = new StringTokenizer(preloadDescriptions, ";");
            while (parser.hasMoreElements()) {
                this.parsePreloadDescription(parser.nextToken());
            }
        }
        this.AMSSubscribe.addSubBehaviour((Behaviour)new SenderBehaviour((jade.core.Agent)this, this.getSubscribe()));
        this.AMSSubscribe.addSubBehaviour((Behaviour)new SnifferAMSListenerBehaviour());
        this.addBehaviour((Behaviour)new RequestListenerBehaviour());
        this.addBehaviour((Behaviour)this.AMSSubscribe);
        this.addBehaviour((Behaviour)new SniffListenerBehaviour());
        this.myGUI = new MainWindow(this, (BasicProperties)this.properties);
        this.myGUI.ShowCorrect();
    }

    private void addAgent(AID id) {
        ActionProcessor ap = this.myGUI.actPro;
        DoSnifferAction sa = (DoSnifferAction)ActionProcessor.actions.get("DoSnifferAction");
        sa.doSniff(id.getName());
    }

    private void removeAgent(AID id) {
        ActionProcessor ap = this.myGUI.actPro;
        DoNotSnifferAction nsa = (DoNotSnifferAction)ActionProcessor.actions.get("DoNotSnifferAction");
        nsa.doNotSniff(id.getName());
    }

    private void loadSnifferConfigurationFile(String aFileName, ExpandedProperties theProperties) {
        StringBuffer sb = new StringBuffer();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(aFileName));
            boolean eof = false;
            while (!eof) {
                String line = in.readLine();
                boolean bl = eof = line == null;
                if (eof || (line = line.trim()).length() <= 0) continue;
                sb.append(line);
                sb.append(";");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
        }
        if (sb.length() > 0) {
            theProperties.setProperty("preload", sb.toString());
        }
    }

    private String locateFile(String aFileName) {
        try {
            String path = new File(".").getAbsolutePath();
            while (path != null) {
                File dir;
                File theFile;
                if ((path = path.replace('\\', '/')).endsWith(".")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((theFile = new File(dir = new File(path), aFileName)).exists()) {
                    return theFile.getCanonicalPath();
                }
                path = dir.getParent();
            }
        }
        catch (Exception any) {}
        return null;
    }

    private void parsePreloadDescription(String aDescription) {
        int atPos;
        StringTokenizer st = new StringTokenizer(aDescription);
        String name = st.nextToken();
        if (!name.endsWith("*") && (atPos = name.lastIndexOf(64)) == -1) {
            name = name + "@" + this.getHap();
        }
        int performativeCount = ACLMessage.getAllPerformativeNames().length;
        boolean[] filter = new boolean[performativeCount];
        boolean initVal = !st.hasMoreTokens();
        int i = 0;
        while (i < performativeCount) {
            filter[i] = initVal;
            ++i;
        }
        while (st.hasMoreTokens()) {
            int perfIndex = ACLMessage.getInteger((String)st.nextToken());
            if (perfIndex == -1) continue;
            filter[perfIndex] = true;
        }
        this.preload.put(name, filter);
    }

    protected void toolTakeDown() {
        List l = (List)this.agentsUnderSniff.clone();
        ACLMessage request = this.getSniffMsg(l, false);
        try {
            if (request != null) {
                FIPAService.doFipaRequestClient((jade.core.Agent)this, (ACLMessage)request);
            }
        }
        catch (FIPAException e) {
            // empty catch block
        }
        this.myGUI.mainPanel.panelcan.canvMess.ml.removeAllMessages();
        this.send(this.getCancel());
        this.myGUI.disposeAsync();
    }

    public void sniffMsg(List agents, boolean onFlag) {
        ACLMessage request = this.getSniffMsg(agents, onFlag);
        if (request != null) {
            this.addBehaviour((Behaviour)new AMSClientBehaviour(onFlag ? "SniffAgentOn" : "SniffAgentOff", request));
        }
    }

    public ACLMessage getSniffMsg(List agents, boolean onFlag) {
        block8: {
            Agent a;
            Iterator it;
            block7: {
                Agent a2;
                it = agents.iterator();
                if (!onFlag) break block7;
                SniffOn so = new SniffOn();
                so.setSniffer(this.getAID());
                boolean empty = true;
                while (it.hasNext()) {
                    a2 = (Agent)it.next();
                    AID agentID = new AID();
                    agentID.setName(a2.agentName + '@' + this.getHap());
                    if (this.agentsUnderSniff.contains((Object)a2)) continue;
                    this.agentsUnderSniff.add((Object)a2);
                    so.addSniffedAgents(agentID);
                    empty = false;
                }
                if (empty) break block8;
                try {
                    a2 = new Action();
                    a2.setActor(this.getAMS());
                    a2.setAction((Concept)so);
                    ACLMessage requestMsg = this.getRequest();
                    requestMsg.setOntology("JADE-Agent-Management");
                    this.getContentManager().fillContent(requestMsg, (ContentElement)a2);
                    return requestMsg;
                }
                catch (Exception fe) {
                    fe.printStackTrace();
                }
                break block8;
            }
            SniffOff so = new SniffOff();
            so.setSniffer(this.getAID());
            boolean empty = true;
            while (it.hasNext()) {
                a = (Agent)it.next();
                AID agentID = new AID();
                agentID.setName(a.agentName + '@' + this.getHap());
                if (!this.agentsUnderSniff.contains((Object)a)) continue;
                this.agentsUnderSniff.remove((Object)a);
                so.addSniffedAgents(agentID);
                empty = false;
            }
            if (!empty) {
                try {
                    a = new Action();
                    a.setActor(this.getAMS());
                    a.setAction((Concept)so);
                    ACLMessage requestMsg = this.getRequest();
                    requestMsg.setOntology("JADE-Agent-Management");
                    this.getContentManager().fillContent(requestMsg, (ContentElement)a);
                    requestMsg.setReplyWith(this.getName() + new Date().getTime());
                    return requestMsg;
                }
                catch (Exception fe) {
                    fe.printStackTrace();
                }
            }
        }
        return null;
    }

    static /* synthetic */ String access$1002(Sniffer x0, String x1) {
        x0.myContainerName = x1;
        return x0.myContainerName;
    }

    private class RequestListenerBehaviour
    extends SimpleAchieveREResponder {
        private Action requestAction;
        private AgentAction aa;

        RequestListenerBehaviour() {
            super((jade.core.Agent)Sniffer.this, MessageTemplate.and((MessageTemplate)MessageTemplate.MatchPerformative((int)16), (MessageTemplate)MessageTemplate.MatchOntology((String)"JADE-Agent-Management")));
        }

        protected ACLMessage prepareResponse(ACLMessage request) {
            ACLMessage response;
            block5: {
                response = request.createReply();
                try {
                    this.requestAction = (Action)Sniffer.this.getContentManager().extractContent(request);
                    this.aa = (AgentAction)this.requestAction.getAction();
                    if (this.aa instanceof SniffOn || this.aa instanceof SniffOff) {
                        if (Sniffer.this.getAID().equals((Object)this.requestAction.getActor())) {
                            response.setPerformative(1);
                            response.setContent(request.getContent());
                        } else {
                            response.setPerformative(14);
                            response.setContent("((unrecognised-parameter-value actor " + this.requestAction.getActor() + "))");
                        }
                        break block5;
                    }
                    response.setPerformative(14);
                    response.setContent("((unsupported-act " + this.aa.getClass().getName() + "))");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    response.setPerformative(10);
                }
            }
            return response;
        }

        protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) {
            int i;
            ArrayList agentsToSniff;
            if (this.aa instanceof SniffOn) {
                SniffOn requestSniffOn = (SniffOn)this.aa;
                agentsToSniff = requestSniffOn.getCloneOfSniffedAgents();
                i = 0;
                while (i < agentsToSniff.size()) {
                    AID aid = (AID)agentsToSniff.get(i);
                    if (Sniffer.this.allAgents.contains(aid)) {
                        Sniffer.this.addAgent(aid);
                    } else {
                        int performativeCount = ACLMessage.getAllPerformativeNames().length;
                        boolean[] filter = new boolean[performativeCount];
                        int j = 0;
                        while (j < performativeCount) {
                            filter[j] = true;
                            ++j;
                        }
                        Sniffer.this.preload.put(aid.getName(), filter);
                    }
                    ++i;
                }
            } else {
                SniffOff requestSniffOff = (SniffOff)this.aa;
                agentsToSniff = requestSniffOff.getCloneOfSniffedAgents();
                i = 0;
                while (i < agentsToSniff.size()) {
                    AID aid = (AID)agentsToSniff.get(i);
                    Sniffer.this.removeAgent(aid);
                    ++i;
                }
            }
            ACLMessage result = request.createReply();
            result.setPerformative(7);
            Done d = new Done((Concept)this.requestAction);
            try {
                this.myAgent.getContentManager().fillContent(result, (ContentElement)d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    class SnifferAMSListenerBehaviour
    extends ToolAgent.AMSListenerBehaviour {
        SnifferAMSListenerBehaviour() {
            super((ToolAgent)Sniffer.this);
        }

        protected void installHandlers(Map handlersTable) {
            handlersTable.put("meta_reset-events", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = this$1;
                }

                public void handle(Event ev) {
                    ResetEvents re = (ResetEvents)ev;
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$900(this.this$1)).resetTree();
                }
            });
            handlersTable.put("added-container", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = this$1;
                }

                public void handle(Event ev) {
                    AddedContainer ac = (AddedContainer)ev;
                    ContainerID cid = ac.getContainer();
                    String name = cid.getName();
                    String address = cid.getAddress();
                    try {
                        InetAddress addr = InetAddress.getByName(address);
                        Sniffer.access$000(SnifferAMSListenerBehaviour.access$900(this.this$1)).addContainer(name, addr);
                    }
                    catch (UnknownHostException uhe) {
                        Sniffer.access$000(SnifferAMSListenerBehaviour.access$900(this.this$1)).addContainer(name, null);
                    }
                }
            });
            handlersTable.put("removed-container", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = this$1;
                }

                public void handle(Event ev) {
                    RemovedContainer rc = (RemovedContainer)ev;
                    ContainerID cid = rc.getContainer();
                    String name = cid.getName();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$900(this.this$1)).removeContainer(name);
                }
            });
            handlersTable.put("born-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = this$1;
                }

                public void handle(Event ev) {
                    BornAgent ba = (BornAgent)ev;
                    ContainerID cid = ba.getWhere();
                    String container = cid.getName();
                    AID agent = ba.getAgent();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$900(this.this$1)).addAgent(container, agent);
                    if (agent.equals((Object)SnifferAMSListenerBehaviour.access$900(this.this$1).getAID())) {
                        Sniffer.access$1002(SnifferAMSListenerBehaviour.access$900(this.this$1), container);
                    }
                    if (!agent.equals((Object)SnifferAMSListenerBehaviour.access$900(this.this$1).getAID()) && SnifferAMSListenerBehaviour.access$900(this.this$1).preloadContains(agent.getName()) != null) {
                        ActionProcessor ap = Sniffer.access$000((Sniffer)SnifferAMSListenerBehaviour.access$900((SnifferAMSListenerBehaviour)this.this$1)).actPro;
                        DoSnifferAction sa = (DoSnifferAction)ActionProcessor.actions.get("DoSnifferAction");
                        sa.doSniff(agent.getName());
                    }
                }
            });
            handlersTable.put("dead-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = this$1;
                }

                public void handle(Event ev) {
                    DeadAgent da = (DeadAgent)ev;
                    ContainerID cid = da.getWhere();
                    String container = cid.getName();
                    AID agent = da.getAgent();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$900(this.this$1)).removeAgent(container, agent);
                }
            });
            handlersTable.put("moved-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = this$1;
                }

                public void handle(Event ev) {
                    MovedAgent ma = (MovedAgent)ev;
                    AID agent = ma.getAgent();
                    ContainerID from = ma.getFrom();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$900(this.this$1)).removeAgent(from.getName(), agent);
                    ContainerID to = ma.getTo();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$900(this.this$1)).addAgent(to.getName(), agent);
                }
            });
        }

        static /* synthetic */ Sniffer access$900(SnifferAMSListenerBehaviour x0) {
            return x0.Sniffer.this;
        }
    }

    private class SniffListenerBehaviour
    extends CyclicBehaviour {
        private MessageTemplate listenSniffTemplate;

        SniffListenerBehaviour() {
            this.listenSniffTemplate = MessageTemplate.MatchConversationId((String)(Sniffer.this.getName() + "-event"));
        }

        public void action() {
            block14: {
                ACLMessage current = Sniffer.this.receive(this.listenSniffTemplate);
                if (current != null) {
                    try {
                        String agentName;
                        String key;
                        Occurred o = (Occurred)Sniffer.this.getContentManager().extractContent(current);
                        EventRecord er = o.getWhat();
                        Event ev = er.getWhat();
                        String content = null;
                        Envelope env = null;
                        AID unicastReceiver = null;
                        if (ev instanceof SentMessage) {
                            content = ((SentMessage)ev).getMessage().getPayload();
                            env = ((SentMessage)ev).getMessage().getEnvelope();
                            unicastReceiver = ((SentMessage)ev).getReceiver();
                        } else if (ev instanceof PostedMessage) {
                            content = ((PostedMessage)ev).getMessage().getPayload();
                            env = ((PostedMessage)ev).getMessage().getEnvelope();
                            unicastReceiver = ((PostedMessage)ev).getReceiver();
                        } else {
                            return;
                        }
                        StringACLCodec codec = new StringACLCodec();
                        String charset = null;
                        if (env == null || (charset = env.getPayloadEncoding()) == null) {
                            charset = "US-ASCII";
                        }
                        ACLMessage tmp = codec.decode(content.getBytes(charset), charset);
                        tmp.setEnvelope(env);
                        Message msg = new Message(tmp, unicastReceiver);
                        if (ev instanceof PostedMessage) {
                            Agent a = new Agent(msg.getSender());
                            if (Sniffer.this.agentsUnderSniff.contains((Object)a)) {
                                return;
                            }
                        }
                        if ((key = Sniffer.this.preloadContains(agentName = msg.getSender().getName())) != null) {
                            boolean[] filters = (boolean[])Sniffer.this.preload.get(key);
                            if (msg.getPerformative() >= 0 && filters[msg.getPerformative()]) {
                                ((Sniffer)Sniffer.this).myGUI.mainPanel.panelcan.canvMess.recMessage(msg);
                            }
                            break block14;
                        }
                        ((Sniffer)Sniffer.this).myGUI.mainPanel.panelcan.canvMess.recMessage(msg);
                    }
                    catch (Throwable e) {
                        Sniffer.this.myGUI.showError("An error occurred parsing the incoming message.\n          The message was lost.");
                        if (Sniffer.this.logger.isLoggable(Logger.WARNING)) {
                            Sniffer.this.logger.log(Logger.WARNING, "The sniffer lost the following message because of a parsing error:" + current);
                        }
                        e.printStackTrace();
                    }
                } else {
                    this.block();
                }
            }
        }
    }

    private class AMSClientBehaviour
    extends SimpleAchieveREInitiator {
        private String actionName;

        public AMSClientBehaviour(String an, ACLMessage request) {
            super((jade.core.Agent)Sniffer.this, request);
            this.actionName = an;
        }

        protected void handleNotUnderstood(ACLMessage reply) {
            Sniffer.this.myGUI.showError("NOT-UNDERSTOOD received during " + this.actionName);
        }

        protected void handleRefuse(ACLMessage reply) {
            Sniffer.this.myGUI.showError("REFUSE received during " + this.actionName);
        }

        protected void handleAgree(ACLMessage reply) {
            if (Sniffer.this.logger.isLoggable(Logger.FINE)) {
                Sniffer.this.logger.log(Logger.FINE, "AGREE received");
            }
        }

        protected void handleFailure(ACLMessage reply) {
            Sniffer.this.myGUI.showError("FAILURE received during " + this.actionName);
        }

        protected void handleInform(ACLMessage reply) {
            if (Sniffer.this.logger.isLoggable(Logger.FINE)) {
                Sniffer.this.logger.log(Logger.FINE, "INFORM received");
            }
        }
    }
}

