/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.DockedContainer;
import org.noos.xing.mydoggy.plaf.ui.MyDoggyToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.animation.AnimationListener;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.JModalFrame;
import org.noos.xing.mydoggy.plaf.ui.cmp.JModalWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.ModalWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingMoveMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingResizeMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingToolTransparencyListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class FloatingContainer
extends MyDoggyToolWindowContainer {
    protected ModalWindow window;
    protected FloatingResizeMouseInputHandler resizeMouseInputHandler;
    protected FloatingMoveMouseInputHandler moveMouseInputHandler;
    protected WindowComponentAdapter windowComponentAdapter;
    protected boolean settedListener = false;
    protected boolean valueAdjusting = false;
    protected Rectangle lastBounds;
    protected final FloatingAnimation floatingAnimation = new FloatingAnimation();
    protected boolean assignFocusOnAnimFinished = false;

    public FloatingContainer(DockedContainer dockedContainer) {
        super(dockedContainer);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        if (this.window != null) {
            this.window.getWindow().removeMouseMotionListener(this.resizeMouseInputHandler);
            this.window.getWindow().removeMouseListener(this.resizeMouseInputHandler);
            this.window.getWindow().dispose();
        }
        this.titleBarTabs.removeEventDispatcherlListener(this.moveMouseInputHandler);
        this.titleBar.removeMouseMotionListener(this.moveMouseInputHandler);
        this.titleBar.removeMouseListener(this.moveMouseInputHandler);
        this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).removePropertyChangeListener((PropertyChangeListener)this);
        super.cleanup();
    }

    public void setVisible(boolean visible) {
        this.initWindow();
        this.floatingAnimation.stop();
        Container content = this.dockedContainer.getContentContainer();
        content.setFocusCycleRoot(!visible);
        if (visible) {
            FloatingTypeDescriptor typeDescriptor;
            this.descriptor.setIdOnTitleBar();
            this.titleBarButtons.setType(ToolWindowType.FLOATING);
            this.window.getContentPane().removeAll();
            this.window.getContentPane().add((Component)content, "1,1,FULL,FULL");
            content.setVisible(true);
            if (this.lastBounds == null) {
                typeDescriptor = (FloatingTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
                if (typeDescriptor.getSize() == null) {
                    Component parentComponent = this.descriptor.getManager().getWindowAnchestor();
                    this.window.setSize(parentComponent.getWidth() / 2, (int)((double)parentComponent.getHeight() / 1.5));
                } else {
                    this.window.setSize(typeDescriptor.getSize());
                }
                if (typeDescriptor.getLocation() == null) {
                    SwingUtil.centrePositionOnScreen(this.window.getWindow());
                } else {
                    this.window.setLocation(typeDescriptor.getLocation());
                }
                SwingUtil.validateBounds(this.window.getWindow());
            } else {
                this.window.setBounds(this.lastBounds);
                this.lastBounds = null;
            }
            if (this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isAnimating()) {
                this.floatingAnimation.show(new Object[0]);
            } else {
                typeDescriptor = (FloatingTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
                this.window.setModal(typeDescriptor.isModal());
                this.window.setVisible(true);
                this.window.getContentPane().setVisible(true);
                SwingUtil.repaint(this.window.getWindow());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!FloatingContainer.this.window.isFocused() && FloatingContainer.this.toolWindow.isActive()) {
                            FloatingContainer.this.dockedContainer.assignFocus();
                        }
                    }
                });
            }
        } else {
            if (this.titleBarButtons.getFocusable().isFocusable()) {
                this.titleBarButtons.getFocusable().setFocusable(false);
            }
            this.lastBounds = this.window.getBounds();
            if (this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isAnimating()) {
                this.floatingAnimation.hide(new Object[0]);
            } else {
                this.window.getContentPane().setVisible(true);
                this.window.setVisible(false);
            }
        }
    }

    public boolean isAnimating() {
        return this.floatingAnimation.isAnimating();
    }

    protected void initComponents() {
    }

    protected void initListeners() {
        this.addPropertyChangeListener("type", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != FloatingContainer.this.descriptor || FloatingContainer.this.window == null) {
                    return;
                }
                if (evt.getNewValue() == ToolWindowType.FLOATING || evt.getNewValue() == ToolWindowType.FLOATING_FREE) {
                    FloatingContainer.this.initWindowListeners();
                } else {
                    if (!FloatingContainer.this.descriptor.getDockedTypeDescriptor().isIdVisibleOnTitleBar()) {
                        FloatingContainer.this.dockedContainer.disableIdOnTitleBar();
                    }
                    if (FloatingContainer.this.settedListener) {
                        FloatingContainer.this.lastBounds = FloatingContainer.this.window.getBounds();
                    }
                    FloatingContainer.this.window.getWindow().removeMouseMotionListener(FloatingContainer.this.resizeMouseInputHandler);
                    FloatingContainer.this.window.getWindow().removeMouseListener(FloatingContainer.this.resizeMouseInputHandler);
                    FloatingContainer.this.titleBarTabs.removeEventDispatcherlListener(FloatingContainer.this.moveMouseInputHandler);
                    FloatingContainer.this.titleBar.removeMouseMotionListener(FloatingContainer.this.moveMouseInputHandler);
                    FloatingContainer.this.titleBar.removeMouseListener(FloatingContainer.this.moveMouseInputHandler);
                    FloatingContainer.this.settedListener = false;
                }
            }
        });
        this.addPropertyChangeListener("location", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING) != evt.getSource() || FloatingContainer.this.window == null) {
                    return;
                }
                if (FloatingContainer.this.valueAdjusting) {
                    return;
                }
                if (FloatingContainer.this.window.isVisible()) {
                    Point location = (Point)evt.getNewValue();
                    FloatingContainer.this.window.setLocation(location);
                }
                FloatingContainer.this.lastBounds = null;
            }
        });
        this.addPropertyChangeListener("size", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING) != evt.getSource() || FloatingContainer.this.window == null) {
                    return;
                }
                if (FloatingContainer.this.valueAdjusting) {
                    return;
                }
                if (FloatingContainer.this.window.isVisible()) {
                    Dimension size = (Dimension)evt.getNewValue();
                    FloatingContainer.this.window.setSize(size);
                }
                FloatingContainer.this.lastBounds = null;
            }
        });
        this.addPropertyChangeListener("modal", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING) != evt.getSource() || FloatingContainer.this.window == null) {
                    return;
                }
                if (FloatingContainer.this.window.isVisible()) {
                    FloatingContainer.this.window.setModal((Boolean)evt.getNewValue());
                }
            }
        });
        this.addPropertyChangeListener("maximized", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING || FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        SwingUtil.setFullScreen(FloatingContainer.this.window.getWindow());
                    } else {
                        SwingUtil.restoreFullScreenWindow(FloatingContainer.this.window.getWindow());
                    }
                    SwingUtil.repaint(FloatingContainer.this.window.getWindow());
                }
            }
        });
        this.addPropertyChangeListener("active", new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent evt) {
                if ((FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING || FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE) && Boolean.TRUE.equals(evt.getNewValue())) {
                    FloatingAnimation floatingAnimation = FloatingContainer.this.floatingAnimation;
                    synchronized (floatingAnimation) {
                        if (FloatingContainer.this.floatingAnimation.isAnimating()) {
                            FloatingContainer.this.assignFocusOnAnimFinished = true;
                        } else {
                            FloatingContainer.this.dockedContainer.assignFocus();
                        }
                    }
                }
            }
        });
        this.addPropertyChangeListener("addToTaskBar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != FloatingContainer.this.descriptor) {
                    return;
                }
                if (FloatingContainer.this.window.isVisible()) {
                    ModalWindow oldWindow = FloatingContainer.this.window;
                    Component focusOwner = oldWindow.getWindow().getFocusOwner();
                    oldWindow.setVisible(false);
                    oldWindow.getWindow().removeMouseMotionListener(FloatingContainer.this.resizeMouseInputHandler);
                    oldWindow.getWindow().removeMouseListener(FloatingContainer.this.resizeMouseInputHandler);
                    oldWindow.getWindow().removeComponentListener(FloatingContainer.this.windowComponentAdapter);
                    FloatingContainer.this.window = (Boolean)evt.getNewValue() != false ? new JModalFrame((Dockable)FloatingContainer.this.toolWindow, FloatingContainer.this.resourceManager, FloatingContainer.this.resourceManager.getBoolean("dialog.owner.enabled", true) ? FloatingContainer.this.descriptor.getWindowAnchestor() : null, null, false) : new JModalWindow(FloatingContainer.this.resourceManager, FloatingContainer.this.resourceManager.getBoolean("dialog.owner.enabled", true) ? FloatingContainer.this.descriptor.getWindowAnchestor() : null, null, false);
                    FloatingContainer.this.window.setBounds(oldWindow.getBounds());
                    FloatingContainer.this.window.setName("toolWindow.floating.window." + FloatingContainer.this.toolWindow.getId());
                    FloatingContainer.this.window.setContentPane(oldWindow.getContentPane());
                    FloatingContainer.this.resizeMouseInputHandler = new FloatingResizeMouseInputHandler(FloatingContainer.this.window.getWindow());
                    FloatingContainer.this.moveMouseInputHandler = new FloatingMoveMouseInputHandler(FloatingContainer.this.window.getWindow());
                    FloatingContainer.this.window.getWindow().addMouseMotionListener(FloatingContainer.this.resizeMouseInputHandler);
                    FloatingContainer.this.window.getWindow().addMouseListener(FloatingContainer.this.resizeMouseInputHandler);
                    FloatingContainer.this.window.getWindow().addComponentListener(FloatingContainer.this.windowComponentAdapter);
                    oldWindow.getWindow().dispose();
                    FloatingContainer.this.window.setVisible(true);
                    if (focusOwner != null) {
                        SwingUtil.requestFocus(focusOwner);
                    }
                } else {
                    ModalWindow oldWindow = FloatingContainer.this.window;
                    oldWindow.getWindow().removeComponentListener(FloatingContainer.this.windowComponentAdapter);
                    oldWindow.getWindow().removeMouseMotionListener(FloatingContainer.this.resizeMouseInputHandler);
                    oldWindow.getWindow().removeMouseListener(FloatingContainer.this.resizeMouseInputHandler);
                    FloatingContainer.this.window = (Boolean)evt.getNewValue() != false ? new JModalFrame((Dockable)FloatingContainer.this.toolWindow, FloatingContainer.this.resourceManager, FloatingContainer.this.resourceManager.getBoolean("dialog.owner.enabled", true) ? FloatingContainer.this.descriptor.getWindowAnchestor() : null, null, false) : new JModalWindow(FloatingContainer.this.resourceManager, FloatingContainer.this.resourceManager.getBoolean("dialog.owner.enabled", true) ? FloatingContainer.this.descriptor.getWindowAnchestor() : null, null, false);
                    FloatingContainer.this.window.setName("toolWindow.floating.window." + FloatingContainer.this.toolWindow.getId());
                    FloatingContainer.this.window.setContentPane(oldWindow.getContentPane());
                    FloatingContainer.this.resizeMouseInputHandler = new FloatingResizeMouseInputHandler(FloatingContainer.this.window.getWindow());
                    FloatingContainer.this.moveMouseInputHandler = new FloatingMoveMouseInputHandler(FloatingContainer.this.window.getWindow());
                    FloatingContainer.this.window.getWindow().addMouseMotionListener(FloatingContainer.this.resizeMouseInputHandler);
                    FloatingContainer.this.window.getWindow().addMouseListener(FloatingContainer.this.resizeMouseInputHandler);
                    FloatingContainer.this.window.getWindow().addComponentListener(new WindowComponentAdapter());
                    oldWindow.getWindow().dispose();
                }
            }
        });
        this.addPropertyChangeListener("enabled", new TypeEnabledPropertyChangeListener());
        this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).addPropertyChangeListener((PropertyChangeListener)this);
        this.floatingAnimation.addAnimationListener(new AnimationListener(){

            public void onFinished() {
                if (FloatingContainer.this.assignFocusOnAnimFinished) {
                    FloatingContainer.this.dockedContainer.assignFocus();
                    FloatingContainer.this.assignFocusOnAnimFinished = false;
                }
            }
        });
    }

    protected void initWindow() {
        if (this.window != null) {
            return;
        }
        this.window = ((FloatingTypeDescriptor)this.toolWindow.getTypeDescriptor(FloatingTypeDescriptor.class)).isAddToTaskBar() ? new JModalFrame((Dockable)this.toolWindow, this.resourceManager, this.resourceManager.getBoolean("dialog.owner.enabled", true) ? this.descriptor.getWindowAnchestor() : null, null, false) : new JModalWindow(this.resourceManager, this.resourceManager.getBoolean("dialog.owner.enabled", true) ? this.descriptor.getWindowAnchestor() : null, null, false);
        this.window.setName("toolWindow.floating.window." + this.toolWindow.getId());
        JPanel contentPane = new JPanel((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{1.0, -1.0, 1.0}, {1.0, -1.0, 1.0}})));
        contentPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.window.setContentPane(contentPane);
        new FloatingToolTransparencyListener(this, this.descriptor, this.window.getWindow());
        this.resizeMouseInputHandler = new FloatingResizeMouseInputHandler(this.window.getWindow());
        this.moveMouseInputHandler = new FloatingMoveMouseInputHandler(this.window.getWindow());
        this.windowComponentAdapter = new WindowComponentAdapter();
        this.window.getWindow().addComponentListener(this.windowComponentAdapter);
        if (!this.settedListener) {
            this.initWindowListeners();
        }
    }

    protected void initWindowListeners() {
        this.descriptor.setIdOnTitleBar();
        this.window.getWindow().removeMouseMotionListener(this.resizeMouseInputHandler);
        this.window.getWindow().removeMouseListener(this.resizeMouseInputHandler);
        this.titleBarTabs.removeEventDispatcherlListener(this.moveMouseInputHandler);
        this.titleBar.removeMouseMotionListener(this.moveMouseInputHandler);
        this.titleBar.removeMouseListener(this.moveMouseInputHandler);
        this.window.getWindow().addMouseMotionListener(this.resizeMouseInputHandler);
        this.window.getWindow().addMouseListener(this.resizeMouseInputHandler);
        this.titleBarTabs.addEventDispatcherlListener(this.moveMouseInputHandler);
        this.titleBar.addMouseMotionListener(this.moveMouseInputHandler);
        this.titleBar.addMouseListener(this.moveMouseInputHandler);
        this.settedListener = true;
    }

    protected class WindowComponentAdapter
    extends ComponentAdapter
    implements Cleaner {
        public WindowComponentAdapter() {
            FloatingContainer.this.descriptor.getCleaner().addCleaner(this);
        }

        public void cleanup() {
            FloatingContainer.this.window.getWindow().removeComponentListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentResized(ComponentEvent e) {
            FloatingContainer.this.valueAdjusting = true;
            try {
                ((FloatingTypeDescriptor)FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING)).setSize(FloatingContainer.this.window.getWidth(), FloatingContainer.this.window.getHeight());
            }
            finally {
                FloatingContainer.this.valueAdjusting = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent e) {
            FloatingContainer.this.valueAdjusting = true;
            try {
                ((FloatingTypeDescriptor)FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING)).setLocation(FloatingContainer.this.window.getX(), FloatingContainer.this.window.getY());
            }
            finally {
                FloatingContainer.this.valueAdjusting = false;
            }
        }
    }

    protected class TypeEnabledPropertyChangeListener
    implements PropertyChangeListener {
        protected TypeEnabledPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            boolean newValue = (Boolean)evt.getNewValue();
            if (!newValue && FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING) {
                FloatingContainer.this.toolWindow.setType(ToolWindowType.DOCKED);
            }
        }
    }

    protected class FloatingAnimation
    extends AbstractAnimation {
        protected Rectangle originalBounds;
        protected int lastLenX;
        protected int lastLenY;

        public FloatingAnimation() {
            super(80.0f);
            this.lastLenX = 0;
            this.lastLenY = 0;
        }

        protected float onAnimating(float animationPercent) {
            int animatingLengthX = (int)(animationPercent * (float)this.originalBounds.width);
            int animatingLengthY = (int)(animationPercent * (float)this.originalBounds.height);
            if (this.getAnimationDirection() == AbstractAnimation.Direction.INCOMING) {
                FloatingContainer.this.window.setBounds(FloatingContainer.this.window.getX() - (animatingLengthX / 2 - this.lastLenX / 2), FloatingContainer.this.window.getY() - (animatingLengthY / 2 - this.lastLenY / 2), FloatingContainer.this.window.getWidth() + (animatingLengthX - this.lastLenX), FloatingContainer.this.window.getHeight() + (animatingLengthY - this.lastLenY));
            } else {
                FloatingContainer.this.window.setBounds(FloatingContainer.this.window.getX() + (animatingLengthX / 2 - this.lastLenX / 2), FloatingContainer.this.window.getY() + (animatingLengthY / 2 - this.lastLenY / 2), FloatingContainer.this.window.getWidth() - (animatingLengthX - this.lastLenX), FloatingContainer.this.window.getHeight() - (animatingLengthY - this.lastLenY));
            }
            this.lastLenX = animatingLengthX;
            this.lastLenY = animatingLengthY;
            return animationPercent;
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    FloatingContainer.this.window.getContentPane().setVisible(true);
                    FloatingContainer.this.window.setBounds(this.originalBounds);
                    SwingUtil.repaint(FloatingContainer.this.window.getWindow());
                    if (FloatingContainer.this.window.isFocused() || !FloatingContainer.this.toolWindow.isActive()) break;
                    FloatingContainer.this.dockedContainer.assignFocus();
                    break;
                }
                case OUTGOING: {
                    FloatingContainer.this.window.getContentPane().setVisible(true);
                    FloatingContainer.this.window.setVisible(false);
                    FloatingContainer.this.window.setBounds(this.originalBounds);
                }
            }
        }

        protected void onHide(Object ... params) {
            this.originalBounds = FloatingContainer.this.window.getBounds();
            FloatingContainer.this.window.getContentPane().setVisible(false);
        }

        protected void onShow(Object ... params) {
            this.originalBounds = FloatingContainer.this.window.getBounds();
            FloatingContainer.this.window.setBounds(new Rectangle(this.originalBounds.x + this.originalBounds.width / 2, this.originalBounds.y + this.originalBounds.height / 2, 0, 0));
            FloatingTypeDescriptor typeDescriptor = (FloatingTypeDescriptor)FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
            FloatingContainer.this.window.setModal(typeDescriptor.isModal());
            FloatingContainer.this.window.setVisible(true);
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
            this.lastLenX = 0;
            this.lastLenY = 0;
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
        }
    }
}

