/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.DockedContainer;
import org.noos.xing.mydoggy.plaf.ui.MyDoggyToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.animation.TransparencyAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.TranslucentPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingMoveMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingResizeMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class FloatingLiveContainer
extends MyDoggyToolWindowContainer {
    protected JLayeredPane layeredPane;
    protected JPanel mainPanel;
    protected TranslucentPanel sheet;
    protected FloatingResizeMouseInputHandler resizeMouseInputHandler;
    protected FloatingMoveMouseInputHandler moveMouseInputHandler;
    protected boolean settedListener = false;
    protected Rectangle lastBounds;
    protected boolean valueAdjusting;

    public FloatingLiveContainer(DockedContainer dockedContainer) {
        super(dockedContainer);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        this.sheet.removeMouseMotionListener(this.resizeMouseInputHandler);
        this.sheet.removeMouseListener(this.resizeMouseInputHandler);
        this.titleBarTabs.removeEventDispatcherlListener(this.moveMouseInputHandler);
        this.titleBar.removeMouseMotionListener(this.moveMouseInputHandler);
        this.titleBar.removeMouseListener(this.moveMouseInputHandler);
        this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).removePropertyChangeListener((PropertyChangeListener)this);
        this.layeredPane = null;
        super.cleanup();
    }

    public void setVisible(boolean visible) {
        Container content = this.dockedContainer.getContentContainer();
        this.sheet.remove(content);
        if (visible) {
            this.descriptor.setIdOnTitleBar();
            this.dockedContainer.getTitleBarButtons().setType(ToolWindowType.FLOATING_LIVE);
            TableLayout layout = (TableLayout)this.sheet.getLayout();
            layout.setColumn(0, 0.0);
            layout.setColumn(2, 0.0);
            layout.setRow(0, 0.0);
            layout.setRow(2, 0.0);
            content.setVisible(true);
            this.sheet.add((Component)content, "1,1,FULL,FULL");
            this.sheet.setBorder(BorderFactory.createEtchedBorder());
            if (this.lastBounds == null) {
                MyDoggyToolWindowManager managerCmp;
                FloatingLiveTypeDescriptor typeDescriptor = (FloatingLiveTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
                if (typeDescriptor.getSize() == null) {
                    managerCmp = this.descriptor.getManager();
                    switch (this.toolWindow.getAnchor()) {
                        case LEFT: 
                        case RIGHT: {
                            this.sheet.setSize(this.descriptor.getDockedTypeDescriptor().getDockLength(), (int)((double)((Component)managerCmp).getHeight() / 1.5));
                            break;
                        }
                        case TOP: 
                        case BOTTOM: {
                            this.sheet.setSize((int)((double)((Component)managerCmp).getWidth() / 1.5), this.descriptor.getDockedTypeDescriptor().getDockLength());
                        }
                    }
                } else {
                    this.sheet.setSize(typeDescriptor.getSize());
                }
                SwingUtil.validateBounds(this.sheet, this.descriptor.getManager().getMainContainer().getBounds());
                if (typeDescriptor.getLocation() == null || typeDescriptor.getLocation().x > this.descriptor.getManager().getWidth() || typeDescriptor.getLocation().y > this.descriptor.getManager().getHeight() || typeDescriptor.getLocation().x < 0 || typeDescriptor.getLocation().y < 0) {
                    managerCmp = this.descriptor.getManager();
                    switch (this.toolWindow.getAnchor()) {
                        case LEFT: {
                            this.sheet.setLocation(50, 50);
                            break;
                        }
                        case RIGHT: {
                            this.sheet.setLocation(((Component)managerCmp).getWidth() - 50 - this.sheet.getWidth(), 50);
                            break;
                        }
                        case TOP: {
                            this.sheet.setLocation(50, 50);
                            break;
                        }
                        case BOTTOM: {
                            this.sheet.setLocation(50, ((Component)managerCmp).getHeight() - 50 - this.sheet.getHeight());
                        }
                    }
                } else {
                    this.sheet.setLocation(typeDescriptor.getLocation());
                }
            } else {
                this.sheet.setBounds(this.lastBounds);
                this.lastBounds = null;
            }
            this.layeredPane.remove(this.sheet);
            this.layeredPane.setLayer(this.sheet, JLayeredPane.DEFAULT_LAYER + 3);
            this.layeredPane.add(this.sheet);
        } else {
            TableLayout layout = (TableLayout)this.sheet.getLayout();
            layout.setColumn(0, 2.0);
            layout.setColumn(2, 2.0);
            layout.setRow(0, 2.0);
            layout.setRow(2, 2.0);
            this.layeredPane.remove(this.sheet);
            this.sheet.setBorder(null);
            this.sheet.removeAll();
            SwingUtil.repaint(this.layeredPane);
        }
    }

    protected void initComponents() {
        this.mainPanel = new JPanel();
        this.sheet = new TranslucentPanel((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{2.0, -1.0, 2.0}, {2.0, -1.0, 2.0}})));
        this.layeredPane = this.descriptor.getManager().getLayeredPane();
    }

    protected void initListeners() {
        this.addPropertyChangeListener("type", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != FloatingLiveContainer.this.descriptor) {
                    return;
                }
                assert ("type".equals(evt.getPropertyName()));
                if (evt.getNewValue() == ToolWindowType.FLOATING_LIVE) {
                    if (FloatingLiveContainer.this.layeredPane != null) {
                        FloatingLiveContainer.this.descriptor.setIdOnTitleBar();
                        FloatingLiveContainer.this.sheet.removeMouseMotionListener(FloatingLiveContainer.this.resizeMouseInputHandler);
                        FloatingLiveContainer.this.sheet.removeMouseListener(FloatingLiveContainer.this.resizeMouseInputHandler);
                        FloatingLiveContainer.this.titleBarTabs.removeEventDispatcherlListener(FloatingLiveContainer.this.moveMouseInputHandler);
                        FloatingLiveContainer.this.titleBar.removeMouseMotionListener(FloatingLiveContainer.this.moveMouseInputHandler);
                        FloatingLiveContainer.this.titleBar.removeMouseListener(FloatingLiveContainer.this.moveMouseInputHandler);
                        FloatingLiveContainer.this.sheet.addMouseMotionListener(FloatingLiveContainer.this.resizeMouseInputHandler);
                        FloatingLiveContainer.this.sheet.addMouseListener(FloatingLiveContainer.this.resizeMouseInputHandler);
                        FloatingLiveContainer.this.titleBarTabs.addEventDispatcherlListener(FloatingLiveContainer.this.moveMouseInputHandler);
                        FloatingLiveContainer.this.titleBar.addMouseMotionListener(FloatingLiveContainer.this.moveMouseInputHandler);
                        FloatingLiveContainer.this.titleBar.addMouseListener(FloatingLiveContainer.this.moveMouseInputHandler);
                        FloatingLiveContainer.this.settedListener = true;
                    }
                } else if (evt.getOldValue() == ToolWindowType.FLOATING_LIVE && FloatingLiveContainer.this.layeredPane != null) {
                    if (!FloatingLiveContainer.this.descriptor.getDockedTypeDescriptor().isIdVisibleOnTitleBar()) {
                        FloatingLiveContainer.this.dockedContainer.disableIdOnTitleBar();
                    }
                    if (FloatingLiveContainer.this.settedListener) {
                        FloatingLiveContainer.this.lastBounds = FloatingLiveContainer.this.sheet.getBounds();
                    }
                    FloatingLiveContainer.this.sheet.removeMouseMotionListener(FloatingLiveContainer.this.resizeMouseInputHandler);
                    FloatingLiveContainer.this.sheet.removeMouseListener(FloatingLiveContainer.this.resizeMouseInputHandler);
                    FloatingLiveContainer.this.titleBarTabs.removeEventDispatcherlListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.titleBar.removeMouseMotionListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.titleBar.removeMouseListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.settedListener = false;
                }
            }
        });
        this.addPropertyChangeListener("active", new ActivePropertyChangeListener());
        this.addPropertyChangeListener("maximized", new PropertyChangeListener(){
            protected Rectangle oldBounds = null;

            public void propertyChange(PropertyChangeEvent evt) {
                if (FloatingLiveContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        this.oldBounds = FloatingLiveContainer.this.sheet.getBounds();
                        Rectangle bounds = FloatingLiveContainer.this.descriptor.getManager().getMainContainer().getBounds();
                        bounds = SwingUtilities.convertRectangle(FloatingLiveContainer.this.descriptor.getManager().getMainContainer(), bounds, FloatingLiveContainer.this.descriptor.getManager().getRootPane().getLayeredPane());
                        FloatingLiveContainer.this.sheet.setBounds(bounds);
                    } else {
                        FloatingLiveContainer.this.sheet.setBounds(this.oldBounds);
                    }
                    SwingUtil.repaint(FloatingLiveContainer.this.sheet);
                }
            }
        });
        this.addPropertyChangeListener("location", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FloatingLiveContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE) != evt.getSource()) {
                    return;
                }
                if (FloatingLiveContainer.this.valueAdjusting) {
                    return;
                }
                if (FloatingLiveContainer.this.sheet.isVisible()) {
                    Point location = (Point)evt.getNewValue();
                    FloatingLiveContainer.this.sheet.setLocation(location);
                }
                FloatingLiveContainer.this.lastBounds = null;
            }
        });
        this.addPropertyChangeListener("size", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FloatingLiveContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE) != evt.getSource()) {
                    return;
                }
                if (FloatingLiveContainer.this.valueAdjusting) {
                    return;
                }
                if (FloatingLiveContainer.this.sheet.isVisible()) {
                    Dimension size = (Dimension)evt.getNewValue();
                    FloatingLiveContainer.this.sheet.setSize(size);
                }
                FloatingLiveContainer.this.lastBounds = null;
            }
        });
        this.addPropertyChangeListener("enabled", new TypeEnabledPropertyChangeListener());
        this.addPropertyChangeListener("manager.window.anchestor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    FloatingLiveContainer.this.layeredPane = FloatingLiveContainer.this.descriptor.getManager().getLayeredPane();
                }
            }
        });
        this.sheet.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent e) {
                FloatingLiveContainer.this.valueAdjusting = true;
                try {
                    ((FloatingLiveTypeDescriptor)FloatingLiveContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE)).setSize(FloatingLiveContainer.this.sheet.getWidth(), FloatingLiveContainer.this.sheet.getHeight());
                }
                finally {
                    FloatingLiveContainer.this.valueAdjusting = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentMoved(ComponentEvent e) {
                FloatingLiveContainer.this.valueAdjusting = true;
                try {
                    ((FloatingLiveTypeDescriptor)FloatingLiveContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE)).setLocation(FloatingLiveContainer.this.sheet.getX(), FloatingLiveContainer.this.sheet.getY());
                }
                finally {
                    FloatingLiveContainer.this.valueAdjusting = false;
                }
            }
        });
        this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).addPropertyChangeListener((PropertyChangeListener)this);
        this.resizeMouseInputHandler = new FloatingResizeMouseInputHandler(this.sheet);
        this.moveMouseInputHandler = new FloatingMoveMouseInputHandler(this.sheet);
    }

    protected class TypeEnabledPropertyChangeListener
    implements PropertyChangeListener {
        protected TypeEnabledPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            boolean newValue = (Boolean)evt.getNewValue();
            if (!newValue && FloatingLiveContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                FloatingLiveContainer.this.toolWindow.setType(ToolWindowType.DOCKED);
            }
        }
    }

    protected class ActivePropertyChangeListener
    implements PropertyChangeListener,
    ActionListener {
        protected TransparencyAnimation animation;
        protected Timer timer;

        public ActivePropertyChangeListener() {
            this.animation = new TransparencyAnimation(FloatingLiveContainer.this.sheet, (Component)FloatingLiveContainer.this.sheet, 1.0f, 500.0f);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (FloatingLiveContainer.this.descriptor.getToolWindow().getType() == ToolWindowType.FLOATING_LIVE) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    if (this.timer != null) {
                        this.timer.stop();
                        if (this.animation.isAnimating()) {
                            this.animation.stop();
                        }
                    }
                    FloatingLiveContainer.this.layeredPane.setLayer(FloatingLiveContainer.this.sheet, JLayeredPane.DEFAULT_LAYER + 4);
                    FloatingLiveContainer.this.sheet.setAlphaModeRatio(1.0f);
                } else {
                    FloatingLiveTypeDescriptor floatingLiveTypeDescriptor = (FloatingLiveTypeDescriptor)FloatingLiveContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
                    if (floatingLiveTypeDescriptor.isTransparentMode()) {
                        this.timer = new Timer(floatingLiveTypeDescriptor.getTransparentDelay(), this);
                        this.timer.start();
                    }
                    FloatingLiveContainer.this.layeredPane.setLayer(FloatingLiveContainer.this.sheet, JLayeredPane.DEFAULT_LAYER + 3);
                }
                SwingUtil.repaint(FloatingLiveContainer.this.layeredPane);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                SlidingTypeDescriptor slidingTypeDescriptor = (SlidingTypeDescriptor)FloatingLiveContainer.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING);
                this.animation.setAlpha(slidingTypeDescriptor.getTransparentRatio());
                this.animation.show(new Object[0]);
            }
        }
    }

    protected class SlidingAnimation
    extends AbstractAnimation {
        protected int length;
        protected Rectangle bounds;
        protected int lastLen;

        public SlidingAnimation() {
            super(60.0f);
            this.lastLen = 0;
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
            this.lastLen = 0;
            switch (FloatingLiveContainer.this.toolWindow.getAnchor()) {
                case LEFT: 
                case RIGHT: {
                    this.length = this.bounds.width;
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    this.length = this.bounds.height;
                }
            }
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    FloatingLiveContainer.this.sheet.setBounds(this.bounds);
                    break;
                }
                case OUTGOING: {
                    FloatingLiveContainer.this.layeredPane.remove(FloatingLiveContainer.this.sheet);
                    FloatingLiveContainer.this.sheet.setBorder(null);
                    FloatingLiveContainer.this.sheet.removeAll();
                }
            }
        }

        protected void onHide(Object ... params) {
            this.bounds = (Rectangle)params[0];
        }

        protected void onShow(Object ... params) {
            this.bounds = (Rectangle)params[0];
            switch (FloatingLiveContainer.this.toolWindow.getAnchor()) {
                case LEFT: {
                    FloatingLiveContainer.this.sheet.setSize(0, FloatingLiveContainer.this.sheet.getHeight());
                    break;
                }
                case RIGHT: {
                    FloatingLiveContainer.this.sheet.setLocation(FloatingLiveContainer.this.sheet.getX() + FloatingLiveContainer.this.sheet.getWidth(), FloatingLiveContainer.this.sheet.getY());
                    FloatingLiveContainer.this.sheet.setSize(0, FloatingLiveContainer.this.sheet.getHeight());
                    break;
                }
                case TOP: {
                    FloatingLiveContainer.this.sheet.setSize(FloatingLiveContainer.this.sheet.getWidth(), 0);
                    break;
                }
                case BOTTOM: {
                    FloatingLiveContainer.this.sheet.setLocation(FloatingLiveContainer.this.sheet.getX(), FloatingLiveContainer.this.sheet.getY() + FloatingLiveContainer.this.sheet.getHeight());
                    FloatingLiveContainer.this.sheet.setSize(FloatingLiveContainer.this.sheet.getWidth(), 0);
                }
            }
        }

        protected float onAnimating(float animationPercent) {
            int animatingLength = 0;
            AbstractAnimation.Direction direction = this.getAnimationDirection();
            switch (FloatingLiveContainer.this.toolWindow.getAnchor()) {
                case LEFT: {
                    animatingLength = direction == AbstractAnimation.Direction.INCOMING ? (int)(animationPercent * (float)this.length) : (int)((1.0f - animationPercent) * (float)this.length);
                    FloatingLiveContainer.this.sheet.setSize(animatingLength, FloatingLiveContainer.this.sheet.getHeight());
                    break;
                }
                case RIGHT: {
                    animatingLength = (int)(animationPercent * (float)this.length);
                    if (direction == AbstractAnimation.Direction.INCOMING) {
                        FloatingLiveContainer.this.sheet.setLocation(FloatingLiveContainer.this.sheet.getX() - (animatingLength - this.lastLen), FloatingLiveContainer.this.sheet.getY());
                        FloatingLiveContainer.this.sheet.setSize(animatingLength, FloatingLiveContainer.this.sheet.getHeight());
                        break;
                    }
                    FloatingLiveContainer.this.sheet.setLocation(this.bounds.x + animatingLength, FloatingLiveContainer.this.sheet.getY());
                    FloatingLiveContainer.this.sheet.setSize((int)((1.0f - animationPercent) * (float)this.length), FloatingLiveContainer.this.sheet.getHeight());
                    break;
                }
                case TOP: {
                    animatingLength = direction == AbstractAnimation.Direction.INCOMING ? (int)(animationPercent * (float)this.length) : (int)((1.0f - animationPercent) * (float)this.length);
                    FloatingLiveContainer.this.sheet.setSize(FloatingLiveContainer.this.sheet.getWidth(), animatingLength);
                    break;
                }
                case BOTTOM: {
                    animatingLength = (int)(animationPercent * (float)this.length);
                    if (direction == AbstractAnimation.Direction.INCOMING) {
                        FloatingLiveContainer.this.sheet.setLocation(FloatingLiveContainer.this.sheet.getX(), FloatingLiveContainer.this.sheet.getY() - (animatingLength - this.lastLen));
                        FloatingLiveContainer.this.sheet.setSize(FloatingLiveContainer.this.sheet.getWidth(), animatingLength);
                        break;
                    }
                    FloatingLiveContainer.this.sheet.setLocation(FloatingLiveContainer.this.sheet.getX(), this.bounds.y + animatingLength);
                    FloatingLiveContainer.this.sheet.setSize(FloatingLiveContainer.this.sheet.getWidth(), (int)((1.0f - animationPercent) * (float)this.length));
                }
            }
            FloatingLiveContainer.this.sheet.validate();
            FloatingLiveContainer.this.sheet.repaint();
            this.lastLen = animatingLength;
            return animationPercent;
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.NONE : super.chooseFinishDirection(type);
        }
    }
}

