/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.animation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import org.noos.xing.mydoggy.plaf.ui.animation.AnimationListener;

public abstract class AbstractAnimation
implements ActionListener {
    public final Object SYNC = new Object();
    private static final int ANIMATION_SLEEP = 1;
    private boolean animating;
    private Direction animationDirection;
    private Timer animationTimer;
    private long animationStart;
    private float animationDuration;
    private EventListenerList listenerList;

    protected AbstractAnimation(float animationDuration) {
        this.animationDuration = animationDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void actionPerformed(ActionEvent e) {
        Object object = this.SYNC;
        synchronized (object) {
            if (this.animating) {
                float animationPercent = (float)(System.currentTimeMillis() - this.animationStart) / this.animationDuration;
                animationPercent = Math.min(1.0f, animationPercent);
                try {
                    animationPercent = this.onAnimating(animationPercent);
                }
                finally {
                    if (animationPercent >= 1.0f) {
                        this.stop();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show(Object ... params) {
        Object object = this.SYNC;
        synchronized (object) {
            if (this.animating && this.animationDirection == Direction.INCOMING) {
                return;
            }
            if (this.animating) {
                this.stopAnimation();
                this.animationDirection = this.chooseFinishDirection(Type.SHOW);
                if (this.animationDirection != Direction.NONE) {
                    this.onFinishAnimation();
                }
            }
            this.onShow(params);
            this.startAnimation(Direction.INCOMING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void hide(Object ... params) {
        Object object = this.SYNC;
        synchronized (object) {
            if (this.animating && this.animationDirection == Direction.OUTGOING) {
                return;
            }
            if (this.animating) {
                this.stopAnimation();
                this.animationDirection = this.chooseFinishDirection(Type.HIDE);
                if (this.animationDirection != Direction.NONE) {
                    this.onFinishAnimation();
                }
            }
            this.onHide(params);
            this.startAnimation(Direction.OUTGOING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.SYNC;
        synchronized (object) {
            if (this.isAnimating()) {
                this.stopAnimation();
                this.onFinishAnimation();
                this.fireOnFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAnimating() {
        Object object = this.SYNC;
        synchronized (object) {
            return this.animating;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Direction getAnimationDirection() {
        Object object = this.SYNC;
        synchronized (object) {
            return this.animationDirection;
        }
    }

    public void addAnimationListener(AnimationListener animationListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(AnimationListener.class, animationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAnimation(Direction direction) {
        Object object = this.SYNC;
        synchronized (object) {
            if (!this.animating) {
                this.onStartAnimation(direction);
                this.animationDirection = direction;
                this.animationStart = System.currentTimeMillis();
                if (this.animationTimer == null) {
                    this.animationTimer = new Timer(1, this);
                }
                this.animating = true;
                this.animationTimer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAnimation() {
        Object object = this.SYNC;
        synchronized (object) {
            if (this.animationTimer != null) {
                this.animationTimer.stop();
            }
            this.animating = false;
        }
    }

    protected abstract void onShow(Object ... var1);

    protected abstract void onHide(Object ... var1);

    protected abstract void onStartAnimation(Direction var1);

    protected abstract void onFinishAnimation();

    protected abstract float onAnimating(float var1);

    protected Direction chooseFinishDirection(Type type) {
        return this.getAnimationDirection();
    }

    protected void fireOnFinished() {
        if (this.listenerList != null) {
            for (AnimationListener listener : (AnimationListener[])this.listenerList.getListeners(AnimationListener.class)) {
                listener.onFinished();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Type {
        SHOW,
        HIDE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        INCOMING,
        OUTGOING,
        NONE;

    }
}

