/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ContentPanel
extends JPanel
implements PropertyChangeListener {
    protected String parentPrefix;
    protected TableLayout layout;
    protected Point mouseLocation;
    protected boolean dragActive;
    protected int threshold;

    public ContentPanel(String parentPrefix) {
        this(parentPrefix, 20);
    }

    public ContentPanel(String parentPrefix, int threshold) {
        this.parentPrefix = parentPrefix;
        this.threshold = threshold;
        this.layout = new TableLayout((double[][])new double[][]{{0.0, -1.0, 0.0}, {0.0, -1.0, 0.0}});
        this.setLayout((LayoutManager)this.layout);
        this.setOpaque(false);
        this.addPropertyChangeListener("dragStart", this);
        this.addPropertyChangeListener("dragOver", this);
        this.addPropertyChangeListener("dragExit", this);
        this.addPropertyChangeListener("dragEnd", this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("dragStart".equals(propertyName)) {
            this.dragActive = true;
        } else if ("dragOver".equals(propertyName)) {
            this.mouseLocation = (Point)evt.getNewValue();
        } else if ("dragExit".equals(propertyName)) {
            this.mouseLocation = null;
            this.resetLayout();
        } else if ("dragEnd".equals(propertyName)) {
            this.mouseLocation = null;
            this.dragActive = false;
            this.resetLayout();
        }
        SwingUtil.repaint(this);
    }

    public Component getComponent() {
        return this.getComponentCount() == 0 ? null : this.getComponent(0);
    }

    public void setComponent(Component component) {
        this.removeAll();
        this.add(component, "1,1,FULL,FULL");
    }

    public void resetComponent() {
        this.removeAll();
        this.resetLayout();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.dragActive && this.mouseLocation != null) {
            int xLimit = this.threshold;
            int yLimit = this.threshold;
            if (this.mouseLocation.x <= xLimit && this.mouseLocation.y > yLimit && this.mouseLocation.y < this.getHeight() - yLimit) {
                this.layout.setColumn(0, (double)xLimit);
                this.layout.setColumn(2, 0.0);
                this.layout.setRow(0, 0.0);
                this.layout.setRow(2, 0.0);
                g.setColor(Color.BLUE);
                GraphicsUtil.drawRect(g, 0, 0, 20, this.getHeight(), 3);
                this.putProperty("dragToolWindow");
                this.putClientProperty("dragAnchor", ToolWindowAnchor.LEFT);
            } else if (this.mouseLocation.y <= yLimit && this.mouseLocation.x > xLimit && this.mouseLocation.x < this.getWidth() - xLimit) {
                this.layout.setColumn(0, 0.0);
                this.layout.setColumn(2, 0.0);
                this.layout.setRow(0, 20.0);
                this.layout.setRow(2, 0.0);
                g.setColor(Color.BLUE);
                GraphicsUtil.drawRect(g, 0, 0, this.getWidth(), 20, 3);
                this.putProperty("dragToolWindow");
                this.putClientProperty("dragAnchor", ToolWindowAnchor.TOP);
            } else if (this.mouseLocation.x >= this.getWidth() - xLimit && this.mouseLocation.y > yLimit && this.mouseLocation.y < this.getHeight() - yLimit) {
                this.layout.setColumn(0, 0.0);
                this.layout.setColumn(2, 20.0);
                this.layout.setRow(0, 0.0);
                this.layout.setRow(2, 0.0);
                g.setColor(Color.BLUE);
                GraphicsUtil.drawRect(g, this.getWidth() - 20, 0, 20, this.getHeight(), 3);
                this.putProperty("dragToolWindow");
                this.putClientProperty("dragAnchor", ToolWindowAnchor.RIGHT);
            } else if (this.mouseLocation.y >= this.getHeight() - yLimit && this.mouseLocation.x > xLimit && this.mouseLocation.x < this.getWidth() - xLimit) {
                this.layout.setColumn(0, 0.0);
                this.layout.setColumn(2, 0.0);
                this.layout.setRow(0, 0.0);
                this.layout.setRow(2, 20.0);
                g.setColor(Color.BLUE);
                GraphicsUtil.drawRect(g, 0, this.getHeight() - 20, this.getWidth(), 20, 3);
                this.putProperty("dragToolWindow");
                this.putClientProperty("dragAnchor", ToolWindowAnchor.BOTTOM);
            } else {
                this.resetLayout();
                Component deepestCmp = SwingUtilities.getDeepestComponentAt(this, this.mouseLocation.x, this.mouseLocation.y);
                if (deepestCmp != null) {
                    JComponent toolWindowContainer = (JComponent)SwingUtil.getParent(deepestCmp, this.parentPrefix);
                    if (toolWindowContainer != null) {
                        Rectangle toolBounds = toolWindowContainer.getBounds();
                        Point point = SwingUtilities.convertPoint(toolWindowContainer, new Point(0, 0), this);
                        toolBounds.x = point.x;
                        toolBounds.y = point.y;
                        xLimit = toolBounds.width / 3;
                        yLimit = toolBounds.height / 3;
                        Point inToolLocation = SwingUtilities.convertPoint(this, this.mouseLocation, toolWindowContainer);
                        if (inToolLocation.x <= xLimit && inToolLocation.y > yLimit && inToolLocation.y < toolBounds.height - yLimit) {
                            g.setColor(Color.BLUE);
                            GraphicsUtil.drawRect(g, toolBounds.x, toolBounds.y, xLimit, toolBounds.height, 3);
                            this.putClientProperty("dragAnchor", ToolWindowAnchor.LEFT);
                        } else if (inToolLocation.y <= yLimit && inToolLocation.x > xLimit && inToolLocation.x < toolBounds.width - xLimit) {
                            g.setColor(Color.BLUE);
                            GraphicsUtil.drawRect(g, toolBounds.x, toolBounds.y, toolBounds.width, yLimit, 3);
                            this.putClientProperty("dragAnchor", ToolWindowAnchor.TOP);
                        } else if (inToolLocation.x >= toolBounds.width - xLimit && inToolLocation.y > yLimit && inToolLocation.y < toolBounds.height - yLimit) {
                            g.setColor(Color.BLUE);
                            GraphicsUtil.drawRect(g, toolBounds.x + toolBounds.width - xLimit, toolBounds.y, xLimit, toolBounds.height, 3);
                            this.putClientProperty("dragAnchor", ToolWindowAnchor.RIGHT);
                        } else if (inToolLocation.y >= toolBounds.height - yLimit && inToolLocation.x > xLimit && inToolLocation.x < toolBounds.width - xLimit) {
                            this.layout.setColumn(0, 0.0);
                            g.setColor(Color.BLUE);
                            GraphicsUtil.drawRect(g, toolBounds.x, toolBounds.y + toolBounds.height - yLimit, toolBounds.width, yLimit, 3);
                            this.putClientProperty("dragAnchor", ToolWindowAnchor.BOTTOM);
                        } else {
                            g.setColor(Color.BLUE);
                            GraphicsUtil.drawRect(g, toolBounds.x, toolBounds.y, toolBounds.width, toolBounds.height, 3);
                            this.putClientProperty("dragAnchor", null);
                        }
                    } else {
                        this.putClientProperty("dragAnchor", null);
                    }
                } else {
                    this.putClientProperty("dragAnchor", null);
                }
            }
        }
    }

    protected void resetLayout() {
        this.layout.setColumn(0, 0.0);
        this.layout.setColumn(2, 0.0);
        this.layout.setRow(0, 0.0);
        this.layout.setRow(2, 0.0);
    }

    protected void putProperty(String name) {
        Boolean value = (Boolean)this.getClientProperty(name);
        if (value != null) {
            this.putClientProperty(name, value == false);
        } else {
            this.putClientProperty(name, false);
        }
    }
}

