/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockablePanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitPane;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSplitDockableContainer
extends JPanel {
    protected MyDoggyToolWindowManager toolWindowManager;
    protected ResourceManager resourceManager;
    protected Map<String, byte[]> models;
    protected Map<Dockable, DockableEntry> entries;
    protected int orientation;
    protected AggregationPosition defaultAggregationPosition;
    protected MultiSplitPane multiSplitPane;
    protected MultiSplitLayout.Node multiSplitPaneModelRoot;
    protected boolean storeLayout;
    protected boolean useAlwaysContentWrapper;
    protected boolean jumpResetBounds;
    protected int leafNameCounter = 0;

    public MultiSplitDockableContainer(MyDoggyToolWindowManager toolWindowManager, int orientation) {
        this.orientation = orientation;
        this.toolWindowManager = toolWindowManager;
        this.resourceManager = toolWindowManager.getResourceManager();
        this.entries = new LinkedHashMap<Dockable, DockableEntry>();
        this.multiSplitPane = new MultiSplitPane();
        this.multiSplitPane.setDividerSize(5);
        this.multiSplitPane.setFocusable(false);
        this.storeLayout = true;
        this.defaultAggregationPosition = orientation != 0 ? AggregationPosition.RIGHT : AggregationPosition.BOTTOM;
        this.multiSplitPaneModelRoot = null;
        this.models = new Hashtable<String, byte[]>();
        this.useAlwaysContentWrapper = false;
        this.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{-1.0}, {-1.0}})));
    }

    public void addDockable(Dockable dockable, Component content, Dockable aggregationOnDockable, int aggregationIndexLocation, AggregationPosition aggregationPosition) {
        if (!this.checkModel()) {
            System.out.println("Check model fail. addDockable before");
        }
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(dockable.getId());
        if (aggregationOnDockable != null) {
            idBuilder.append(aggregationOnDockable.getId());
        }
        if (aggregationPosition != null) {
            idBuilder.append(aggregationPosition.toString());
        }
        String modelId = idBuilder.toString();
        String modelKey = null;
        if (this.storeLayout && this.entries.size() > 0) {
            idBuilder.setLength(0);
            for (DockableEntry entry : this.entries.values()) {
                idBuilder.append(entry.id);
            }
            this.models.put(idBuilder.toString(), this.encode());
            idBuilder.append(modelId);
            modelKey = idBuilder.toString();
        }
        if (this.entries.size() == 0) {
            DockableLeaf leaf = new DockableLeaf(this.getNextLeanName(), dockable.getId());
            leaf.setWeight(1.0);
            this.multiSplitPaneModelRoot = leaf;
            this.multiSplitPane.setModel(leaf);
            this.multiSplitPane.add(this.getWrapperForComponent(dockable, content, Action.ADD_DOCK), "1");
            this.setRootComponent(this.multiSplitPane);
            SwingUtil.repaint(this);
        } else {
            byte[] oldModel = modelKey != null ? this.models.get(modelKey) : null;
            boolean invalidAggregationPosition = false;
            if (aggregationPosition == AggregationPosition.DEFAULT || aggregationPosition == null) {
                invalidAggregationPosition = true;
                aggregationPosition = this.defaultAggregationPosition;
            }
            if (this.multiSplitPaneModelRoot instanceof DockableLeaf) {
                DockableLeaf rootLeaf = (DockableLeaf)this.multiSplitPaneModelRoot;
                if (aggregationOnDockable != null && (aggregationPosition == null || invalidAggregationPosition)) {
                    Component componentWrapper;
                    if (rootLeaf.getDockables().size() > 1) {
                        componentWrapper = this.multiSplitPane.getComponent(0);
                    } else {
                        Component rootLeafCmp = this.getComponentFromWrapper(this.multiSplitPane.getComponent(0));
                        this.multiSplitPane.removeAll();
                        componentWrapper = this.forceWrapperForComponent(this.entries.values().iterator().next().dockable, rootLeafCmp);
                        this.multiSplitPane.add(componentWrapper, rootLeaf.getName());
                    }
                    this.addToWrapper(componentWrapper, dockable, aggregationIndexLocation, content);
                    this.repaintMultiSplit(this.toolWindowManager.getClientProperty("PERSISTENCE_DELEGATE_PARSING") != null);
                    rootLeaf.addDockable(dockable.getId());
                } else {
                    Component wrapper;
                    DockableLeaf firstLeaf = rootLeaf;
                    DockableLeaf secondLeaf = null;
                    firstLeaf.setWeight(0.5);
                    secondLeaf = new DockableLeaf(this.getNextLeanName());
                    secondLeaf.setWeight(0.5);
                    secondLeaf.addDockable(dockable.getId());
                    List<MultiSplitLayout.Node> children = null;
                    switch (aggregationPosition) {
                        case LEFT: 
                        case TOP: {
                            children = Arrays.asList(secondLeaf, new MultiSplitLayout.Divider(), firstLeaf);
                            break;
                        }
                        case RIGHT: 
                        case BOTTOM: {
                            children = Arrays.asList(firstLeaf, new MultiSplitLayout.Divider(), secondLeaf);
                        }
                    }
                    boolean rowLayout = aggregationPosition == AggregationPosition.LEFT || aggregationPosition == AggregationPosition.RIGHT;
                    MultiSplitLayout.Split split = new MultiSplitLayout.Split();
                    split.setRowLayout(rowLayout);
                    split.setChildren(children);
                    this.multiSplitPaneModelRoot = split;
                    if (!this.multiSplitPane.getMultiSplitLayout().getFloatingDividers()) {
                        this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(true);
                    }
                    this.validateModel(this.multiSplitPaneModelRoot);
                    this.multiSplitPane.setModel(this.multiSplitPaneModelRoot);
                    if (rootLeaf.getDockables().size() > 1) {
                        wrapper = this.multiSplitPane.getComponent(0);
                    } else {
                        Dockable delegator = this.entries.values().iterator().next().dockable;
                        wrapper = this.getWrapperForComponent(delegator, this.getComponentFromWrapper(this.multiSplitPane.getComponent(0)), Action.ADD_DOCK);
                    }
                    this.multiSplitPane.removeAll();
                    this.multiSplitPane.add(wrapper, firstLeaf.getName());
                    this.multiSplitPane.add(this.getWrapperForComponent(dockable, content, Action.ADD_DOCK), secondLeaf.getName());
                }
            } else {
                MultiSplitLayout.Split splitRoot = (MultiSplitLayout.Split)this.multiSplitPaneModelRoot;
                boolean addCmp = true;
                String leafName = null;
                if (aggregationOnDockable != null) {
                    Stack<MultiSplitLayout.Split> stack = new Stack<MultiSplitLayout.Split>();
                    stack.push(splitRoot);
                    block24: while (!stack.isEmpty()) {
                        MultiSplitLayout.Split split = (MultiSplitLayout.Split)stack.pop();
                        for (MultiSplitLayout.Node child : split.getChildren()) {
                            if (child instanceof DockableLeaf) {
                                DockableLeaf leaf = (DockableLeaf)child;
                                if (!leaf.getDockables().contains(aggregationOnDockable.getId())) continue;
                                if (invalidAggregationPosition) {
                                    this.addToWrapper(this.multiSplitPane.getMultiSplitLayout().getChildMap().get(leaf.getName()), dockable, aggregationIndexLocation, content);
                                    leaf.addDockable(dockable.getId());
                                    addCmp = false;
                                } else {
                                    boolean finalize;
                                    leafName = this.getNextLeanName();
                                    boolean step1Failed = false;
                                    MultiSplitLayout.Split parent = leaf.getParent();
                                    boolean rowLayout = parent.isRowLayout();
                                    List<MultiSplitLayout.Node> parentChildren = parent.getChildren();
                                    int startIndex = parentChildren.indexOf(leaf);
                                    if (rowLayout) {
                                        finalize = false;
                                        switch (aggregationPosition) {
                                            case LEFT: {
                                                parentChildren.add(startIndex, new DockableLeaf(leafName, dockable.getId()));
                                                parentChildren.add(startIndex + 1, new MultiSplitLayout.Divider());
                                                finalize = true;
                                                break;
                                            }
                                            case RIGHT: {
                                                parentChildren.add(startIndex + 1, new MultiSplitLayout.Divider());
                                                parentChildren.add(startIndex + 2, new DockableLeaf(leafName, dockable.getId()));
                                                finalize = true;
                                                break;
                                            }
                                            default: {
                                                step1Failed = true;
                                            }
                                        }
                                        if (finalize) {
                                            this.forceWeight(parentChildren);
                                            parent.setChildren(parentChildren);
                                        }
                                    } else {
                                        finalize = false;
                                        switch (aggregationPosition) {
                                            case TOP: {
                                                parentChildren.add(startIndex, new DockableLeaf(leafName, dockable.getId()));
                                                parentChildren.add(startIndex + 1, new MultiSplitLayout.Divider());
                                                finalize = true;
                                                break;
                                            }
                                            case BOTTOM: {
                                                parentChildren.add(startIndex + 1, new MultiSplitLayout.Divider());
                                                parentChildren.add(startIndex + 2, new DockableLeaf(leafName, dockable.getId()));
                                                finalize = true;
                                                break;
                                            }
                                            default: {
                                                step1Failed = true;
                                            }
                                        }
                                        if (finalize) {
                                            this.forceWeight(parentChildren);
                                            parent.setChildren(parentChildren);
                                        }
                                    }
                                    if (step1Failed) {
                                        DockableLeaf newleaf = new DockableLeaf(leafName, dockable.getId());
                                        newleaf.setWeight(0.5);
                                        MultiSplitLayout.Split newSplit = new MultiSplitLayout.Split();
                                        newSplit.setRowLayout(aggregationPosition == AggregationPosition.LEFT || aggregationPosition == AggregationPosition.RIGHT);
                                        newSplit.setWeight(leaf.getWeight());
                                        leaf.getParent().removeNode(leaf);
                                        switch (aggregationPosition) {
                                            case LEFT: 
                                            case TOP: {
                                                newSplit.setChildren(Arrays.asList(newleaf, new MultiSplitLayout.Divider(), leaf));
                                                break;
                                            }
                                            default: {
                                                newSplit.setChildren(Arrays.asList(leaf, new MultiSplitLayout.Divider(), newleaf));
                                            }
                                        }
                                        leaf.setWeight(0.5);
                                        parentChildren.set(startIndex, newSplit);
                                        parent.setChildren(parentChildren);
                                    }
                                }
                                stack.clear();
                                continue block24;
                            }
                            if (!(child instanceof MultiSplitLayout.Split)) continue;
                            stack.push((MultiSplitLayout.Split)child);
                        }
                    }
                    if (!this.multiSplitPane.getMultiSplitLayout().getFloatingDividers()) {
                        this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(true);
                    }
                } else {
                    boolean rowLayout;
                    leafName = this.getNextLeanName();
                    boolean bl = rowLayout = aggregationPosition == AggregationPosition.LEFT || aggregationPosition == AggregationPosition.RIGHT;
                    if (splitRoot.isRowLayout() == rowLayout) {
                        List<MultiSplitLayout.Node> children = splitRoot.getChildren();
                        switch (aggregationPosition) {
                            case LEFT: 
                            case TOP: {
                                children.add(0, new DockableLeaf(leafName, dockable.getId()));
                                children.add(1, new MultiSplitLayout.Divider());
                                break;
                            }
                            case RIGHT: 
                            case BOTTOM: {
                                children.add(new MultiSplitLayout.Divider());
                                children.add(new DockableLeaf(leafName, dockable.getId()));
                            }
                        }
                        this.forceWeight(children);
                        splitRoot.setChildren(children);
                    } else {
                        MultiSplitLayout.Split newRoot = new MultiSplitLayout.Split();
                        newRoot.setRowLayout(rowLayout);
                        DockableLeaf leaf = new DockableLeaf(leafName, dockable.getId());
                        leaf.setWeight(0.5);
                        this.multiSplitPaneModelRoot.setWeight(0.5);
                        List<MultiSplitLayout.Node> children = null;
                        switch (aggregationPosition) {
                            case LEFT: 
                            case TOP: {
                                children = Arrays.asList(leaf, new MultiSplitLayout.Divider(), this.multiSplitPaneModelRoot);
                                break;
                            }
                            case RIGHT: 
                            case BOTTOM: {
                                children = Arrays.asList(this.multiSplitPaneModelRoot, new MultiSplitLayout.Divider(), leaf);
                            }
                        }
                        this.forceWeight(children);
                        newRoot.setChildren(children);
                        this.multiSplitPaneModelRoot = newRoot;
                    }
                    if (!this.multiSplitPane.getMultiSplitLayout().getFloatingDividers()) {
                        this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(true);
                    }
                }
                this.validateModel(this.multiSplitPaneModelRoot);
                this.multiSplitPane.setModel(this.multiSplitPaneModelRoot);
                if (addCmp) {
                    this.multiSplitPane.add(this.getWrapperForComponent(dockable, content, Action.ADD_DOCK), leafName);
                }
            }
            if (!this.checkModel()) {
                System.out.println("Check model fail. addDockable end");
            }
            if (this.storeLayout && oldModel != null) {
                final MultiSplitLayout.Split decodedModel = this.decode(oldModel);
                this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MultiSplitDockableContainer.this.setModel(decodedModel);
                    }
                });
            } else {
                this.repaintMultiSplit(this.toolWindowManager.getClientProperty("PERSISTENCE_DELEGATE_PARSING") == null);
            }
        }
        this.entries.put(dockable, new DockableEntry(dockable, content, modelId));
    }

    public void addDockable(Dockable dockable, Component component, Constraint constraint) {
        if (constraint == null) {
            this.addDockable(dockable, component, null, -1, AggregationPosition.DEFAULT);
        } else if (constraint.getNode() == null) {
            this.addDockable(dockable, component, null, constraint.getIndex(), constraint.getAggregationPosition());
        } else if (constraint.getNode() instanceof DockableLeaf) {
            DockableLeaf leaf = (DockableLeaf)constraint.getNode();
            for (String leafDockableId : leaf.getDockables()) {
                Dockable leafDockable = this.toolWindowManager.getDockable(leafDockableId);
                if (leafDockable == null || leafDockable.isDetached()) continue;
                this.addDockable(dockable, component, leafDockable, constraint.getIndex(), constraint.getAggregationPosition());
                return;
            }
            this.addDockable(dockable, component, null, constraint.getIndex(), constraint.getAggregationPosition());
        } else if (constraint.getNode() instanceof MultiSplitLayout.Split) {
            MultiSplitLayout.Split split = (MultiSplitLayout.Split)constraint.getNode();
            if (this.multiSplitPaneModelRoot == split) {
                this.addDockable(dockable, component, null, constraint.getIndex(), constraint.getAggregationPosition());
            } else {
                MultiSplitLayout.Split parent = split.getParent();
                if (!this.isNodeAttached(split) || parent == null) {
                    this.addDockable(dockable, component, null, constraint.getIndex(), constraint.getAggregationPosition());
                } else {
                    AggregationPosition aggregationPosition = constraint.getAggregationPosition();
                    switch (aggregationPosition) {
                        case LEFT: 
                        case TOP: {
                            List<MultiSplitLayout.Node> nodes = parent.getChildren();
                            DockableLeaf dockableLeaf = new DockableLeaf(this.getNextLeanName(), dockable.getId());
                            dockableLeaf.setWeight(0.5);
                            int index = nodes.indexOf(split);
                            nodes.add(index, dockableLeaf);
                            nodes.add(index + 1, new MultiSplitLayout.Divider());
                            parent.setChildren(nodes);
                            this.multiSplitPane.add(this.getWrapperForComponent(dockable, component, Action.ADD_DOCK), dockableLeaf.getName());
                            break;
                        }
                        case RIGHT: 
                        case BOTTOM: {
                            List<MultiSplitLayout.Node> nodes = parent.getChildren();
                            DockableLeaf dockableLeaf = new DockableLeaf(this.getNextLeanName(), dockable.getId());
                            dockableLeaf.setWeight(0.5);
                            int index = nodes.indexOf(split);
                            nodes.add(index, dockableLeaf);
                            nodes.add(index - 1, new MultiSplitLayout.Divider());
                            parent.setChildren(nodes);
                            this.multiSplitPane.add(this.getWrapperForComponent(dockable, component, Action.ADD_DOCK), dockableLeaf.getName());
                        }
                    }
                    this.entries.put(dockable, new DockableEntry(dockable, component, null));
                    this.validateModel(this.multiSplitPaneModelRoot);
                    this.repaintMultiSplit(this.toolWindowManager.getClientProperty("PERSISTENCE_DELEGATE_PARSING") != null);
                }
            }
        } else {
            this.addDockable(dockable, component, null, constraint.getIndex(), constraint.getAggregationPosition());
        }
    }

    public Constraint removeDockable(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("Cannot remove dockable. [dockable null]");
        }
        DockableEntry dockableEntry = this.entries.get(dockable);
        if (dockableEntry == null) {
            throw new IllegalArgumentException("Cannot remove the dockable. No Entry for it. [id : " + dockable.getId() + "]");
        }
        if (this.storeLayout) {
            StringBuilder builder = new StringBuilder();
            for (DockableEntry entry : this.entries.values()) {
                builder.append(entry.id);
            }
            this.models.put(builder.toString(), this.encode());
        }
        this.entries.remove(dockable);
        if (this.entries.size() == 0) {
            DockableLeaf dockableLeaf = this.getLeaf(dockable);
            Component cmp = this.multiSplitPane.getMultiSplitLayout().getChildMap().get(dockableLeaf.getName());
            if (this.isWrapper(cmp)) {
                this.removeFromWrapper(cmp, dockable);
            }
            this.multiSplitPaneModelRoot = null;
            this.multiSplitPane.removeAll();
            this.resetRootComponent();
            this.leafNameCounter = 0;
            SwingUtil.repaint(this);
            return null;
        }
        if (this.entries.size() == 1) {
            if (this.multiSplitPaneModelRoot instanceof DockableLeaf) {
                DockableLeaf leaf = (DockableLeaf)this.multiSplitPaneModelRoot;
                int index = this.removeFromWrapper(this.multiSplitPane.getComponent(0), dockable);
                leaf.getDockables().remove(dockable.getId());
                if (!this.useAlwaysContentWrapper) {
                    Component root = this.multiSplitPane.getComponent(0);
                    this.multiSplitPane.removeAll();
                    this.multiSplitPane.add(this.getComponentFromWrapper(root), "1");
                }
                return new Constraint(leaf, AggregationPosition.DEFAULT, index);
            }
            Component component = this.multiSplitPane.getMultiSplitLayout().getChildMap().get(this.getLeafName(dockable));
            if (this.isWrapper(component)) {
                this.removeFromWrapper(component, dockable);
            }
            this.multiSplitPane.remove(component);
            Dockable leftDockable = this.entries.keySet().iterator().next();
            DockableLeaf leftLeaf = this.getLeaf(leftDockable);
            Component masterLeftLeafCmp = this.multiSplitPane.getMultiSplitLayout().getChildMap().get(leftLeaf.getName());
            Component leftLeafCmp = this.getComponentFromWrapper(masterLeftLeafCmp);
            leftLeaf.setName("1");
            if (this.isWrapper(masterLeftLeafCmp)) {
                this.removeFromWrapper(masterLeftLeafCmp, leftDockable);
            }
            AggregationPosition constraintAggPosition = AggregationPosition.DEFAULT;
            MultiSplitLayout.Split rootSplit = (MultiSplitLayout.Split)this.multiSplitPaneModelRoot;
            List<MultiSplitLayout.Node> children = rootSplit.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                MultiSplitLayout.Node node = children.get(i);
                if (node != leftLeaf) continue;
                if (i == 0) {
                    if (rootSplit.isRowLayout()) {
                        constraintAggPosition = AggregationPosition.RIGHT;
                        break;
                    }
                    constraintAggPosition = AggregationPosition.BOTTOM;
                    break;
                }
                if (rootSplit.isRowLayout()) {
                    constraintAggPosition = AggregationPosition.LEFT;
                    break;
                }
                constraintAggPosition = AggregationPosition.TOP;
                break;
            }
            this.multiSplitPaneModelRoot = leftLeaf;
            this.multiSplitPaneModelRoot.setParent(null);
            this.multiSplitPane.setModel(this.multiSplitPaneModelRoot);
            this.multiSplitPane.removeAll();
            this.multiSplitPane.add(this.getWrapperForComponent(leftDockable, leftLeafCmp, Action.REMOVE_DOCK), "1");
            this.leafNameCounter = 1;
            SwingUtil.repaint(this);
            return new Constraint(leftLeaf, constraintAggPosition, -1);
        }
        Constraint constraint = null;
        DockableLeaf dockableLeaf = this.getLeaf(dockable);
        if (dockableLeaf == null) {
            throw new IllegalArgumentException("Cannot remove the dockable. Cannot find leaf. [id : " + dockable.getId() + "]");
        }
        if (dockableLeaf.getDockables().size() > 1) {
            dockableLeaf.getDockables().remove(dockable.getId());
            int index = this.removeFromWrapper(this.multiSplitPane.getMultiSplitLayout().getChildMap().get(dockableLeaf.getName()), dockable);
            return new Constraint(dockableLeaf, AggregationPosition.DEFAULT, index);
        }
        --this.leafNameCounter;
        String leafKey = dockableLeaf.getName();
        int leafValue = Integer.parseInt(leafKey);
        Component component = this.multiSplitPane.getMultiSplitLayout().getChildMap().get(leafKey);
        if (component != null) {
            String newKey;
            Integer keyValue;
            if (this.isWrapper(component)) {
                this.removeFromWrapper(component, dockable);
            }
            this.multiSplitPane.remove(component);
            Stack<MultiSplitLayout.Split> stack = new Stack<MultiSplitLayout.Split>();
            stack.push((MultiSplitLayout.Split)this.multiSplitPaneModelRoot);
            boolean setChild = true;
            while (!stack.isEmpty()) {
                MultiSplitLayout.Split split = (MultiSplitLayout.Split)stack.pop();
                List<MultiSplitLayout.Node> children = split.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    MultiSplitLayout.Node child = children.get(i);
                    if (child instanceof MultiSplitLayout.Leaf) {
                        MultiSplitLayout.Leaf leaf = (MultiSplitLayout.Leaf)child;
                        String leafName = leaf.getName();
                        if (leafName.equals(leafKey)) {
                            children.remove(i);
                            if (children.size() == 2) {
                                MultiSplitLayout.Split grandpa = split.getParent();
                                if (grandpa == null) {
                                    this.multiSplitPaneModelRoot = this.getFirstNotDivider(children);
                                    this.multiSplitPaneModelRoot.setParent(null);
                                    AggregationPosition position = children.get(0) == this.multiSplitPaneModelRoot ? (split.isRowLayout() ? AggregationPosition.RIGHT : AggregationPosition.BOTTOM) : (split.isRowLayout() ? AggregationPosition.LEFT : AggregationPosition.TOP);
                                    constraint = new Constraint(this.multiSplitPaneModelRoot, position, -1);
                                    setChild = false;
                                    continue;
                                }
                                List<MultiSplitLayout.Node> grenpaChildren = grandpa.getChildren();
                                if (children.get(0) instanceof MultiSplitLayout.Divider) {
                                    grenpaChildren.set(grenpaChildren.indexOf(split), children.get(1));
                                    constraint = new Constraint(children.get(1), split.isRowLayout() ? AggregationPosition.LEFT : AggregationPosition.TOP, -1);
                                } else {
                                    grenpaChildren.set(grenpaChildren.indexOf(split), children.get(0));
                                    constraint = new Constraint(children.get(0), split.isRowLayout() ? AggregationPosition.RIGHT : AggregationPosition.BOTTOM, -1);
                                }
                                grandpa.setChildren(grenpaChildren);
                                setChild = false;
                                continue;
                            }
                            if (i < children.size()) {
                                children.remove(i);
                                constraint = new Constraint(children.get(i), split.isRowLayout() ? AggregationPosition.LEFT : AggregationPosition.TOP, -1);
                            } else {
                                children.remove(i - 1);
                                constraint = new Constraint(children.get(i - 2), split.isRowLayout() ? AggregationPosition.RIGHT : AggregationPosition.BOTTOM, -1);
                            }
                            --i;
                            continue;
                        }
                        keyValue = Integer.parseInt(leafName);
                        if (keyValue <= leafValue) continue;
                        newKey = "" + (keyValue - 1);
                        leaf.setName(newKey);
                        continue;
                    }
                    if (!(child instanceof MultiSplitLayout.Split)) continue;
                    stack.push((MultiSplitLayout.Split)child);
                }
                if (setChild) {
                    split.setChildren(children);
                }
                if (this.checkModel()) continue;
                System.out.println("Check model fail. removeDockable inner");
            }
            Map<String, Component> childMap = this.multiSplitPane.getMultiSplitLayout().getChildMap();
            Object[] keys = childMap.keySet().toArray(new String[childMap.keySet().size()]);
            Arrays.sort(keys);
            for (Object key : keys) {
                keyValue = Integer.parseInt((String)key);
                if (keyValue <= leafValue) continue;
                newKey = "" + (keyValue - 1);
                Component oldCmpForLeaf = this.multiSplitPane.getMultiSplitLayout().getChildMap().get(key);
                this.multiSplitPane.remove(oldCmpForLeaf);
                this.multiSplitPane.add(oldCmpForLeaf, newKey);
            }
        } else {
            throw new IllegalArgumentException("Cannot find component on multisplit...");
        }
        this.validateModel(this.multiSplitPaneModelRoot);
        this.multiSplitPane.setModel(this.multiSplitPaneModelRoot);
        this.multiSplitPane.revalidate();
        if (!this.checkModel()) {
            System.out.println("Check model fail. removeDockable end");
        }
        this.repaintMultiSplit(this.toolWindowManager.getClientProperty("PERSISTENCE_DELEGATE_PARSING") == null);
        return constraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint removeDockable(Dockable dockable, boolean storeLayout) {
        boolean old = this.storeLayout;
        this.storeLayout = storeLayout;
        try {
            Constraint constraint = this.removeDockable(dockable);
            return constraint;
        }
        finally {
            this.storeLayout = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraints(Dockable dockable, Component content, Dockable aggregationOnDockable, int aggregationIndexLocation, AggregationPosition aggregationPosition) {
        boolean old = this.storeLayout;
        this.storeLayout = false;
        try {
            this.removeDockable(dockable);
            this.addDockable(dockable, content, aggregationOnDockable, aggregationIndexLocation, aggregationPosition);
        }
        finally {
            this.storeLayout = old;
        }
    }

    public MultiSplitLayout.Node getModel() {
        return this.multiSplitPaneModelRoot;
    }

    public void setModel(MultiSplitLayout.Node root) {
        Object dockIds;
        Stack<MultiSplitLayout.Split> stack;
        Object dockIds2;
        DockableLeaf leaf;
        MultiSplitLayout.Split split;
        if (root == null) {
            return;
        }
        if (root instanceof DockableLeaf) {
            DockableLeaf dockableLeaf = (DockableLeaf)root;
            if (!this.containsDockable(dockableLeaf) || dockableLeaf.getDockables().size() != this.entries.size()) {
                return;
            }
        } else if (root instanceof MultiSplitLayout.Split) {
            Stack<MultiSplitLayout.Split> stack2 = new Stack<MultiSplitLayout.Split>();
            stack2.push((MultiSplitLayout.Split)root);
            int dockCounter = 0;
            while (!stack2.isEmpty()) {
                split = (MultiSplitLayout.Split)stack2.pop();
                for (MultiSplitLayout.Node child : split.getChildren()) {
                    if (child instanceof MultiSplitLayout.Split) {
                        stack2.push((MultiSplitLayout.Split)child);
                        continue;
                    }
                    if (!(child instanceof DockableLeaf)) continue;
                    DockableLeaf dockableLeaf = (DockableLeaf)child;
                    if (!this.containsDockable(dockableLeaf)) {
                        return;
                    }
                    dockCounter += dockableLeaf.getDockables().size();
                }
            }
            if (dockCounter != this.entries.size()) {
                return;
            }
        } else {
            throw new RuntimeException("Invalid model. [model : " + root + "]");
        }
        Map<String, Component> currentChildMap = this.multiSplitPane.getMultiSplitLayout().getChildMap();
        if (this.multiSplitPaneModelRoot instanceof DockableLeaf) {
            leaf = (DockableLeaf)this.multiSplitPaneModelRoot;
            dockIds2 = leaf.getDockables().toArray(new String[leaf.getDockables().size()]);
            for (String dockId : dockIds2) {
                if (leaf.getDockables().size() != 1) {
                    Component component = currentChildMap.get(leaf.getName());
                    Dockable dockable = this.toolWindowManager.getDockable(dockId);
                    this.setConstraints(dockable, this.getComponentFromWrapper(component, dockable), null, -1, AggregationPosition.DEFAULT);
                    continue;
                }
                break;
            }
        } else {
            stack = new Stack<MultiSplitLayout.Split>();
            stack.push((MultiSplitLayout.Split)this.multiSplitPaneModelRoot);
            while (!stack.isEmpty()) {
                split = (MultiSplitLayout.Split)stack.pop();
                block4: for (MultiSplitLayout.Node child : split.getChildren()) {
                    if (child instanceof DockableLeaf) {
                        DockableLeaf leaf2 = (DockableLeaf)child;
                        dockIds = leaf2.getDockables().toArray(new String[leaf2.getDockables().size()]);
                        for (String dockId : dockIds) {
                            if (leaf2.getDockables().size() == 1) continue block4;
                            Component component = currentChildMap.get(leaf2.getName());
                            Dockable dockable = this.toolWindowManager.getDockable(dockId);
                            this.setConstraints(dockable, this.getComponentFromWrapper(component, dockable), null, -1, AggregationPosition.DEFAULT);
                        }
                        continue;
                    }
                    if (!(child instanceof MultiSplitLayout.Split)) continue;
                    stack.push((MultiSplitLayout.Split)child);
                }
            }
        }
        if (root instanceof MultiSplitLayout.Split) {
            stack = new Stack();
            stack.push((MultiSplitLayout.Split)root);
            while (!stack.isEmpty()) {
                split = (MultiSplitLayout.Split)stack.pop();
                for (MultiSplitLayout.Node child : split.getChildren()) {
                    if (child instanceof DockableLeaf) {
                        DockableLeaf leaf3 = (DockableLeaf)child;
                        dockIds = leaf3.getDockables();
                        Dockable masterDockable = this.toolWindowManager.getDockable(leaf3.getDockable());
                        for (int i = 1; i < dockIds.size(); ++i) {
                            String dockId = (String)dockIds.get(i);
                            Dockable dockable = this.toolWindowManager.getDockable(dockId);
                            this.setConstraints(dockable, this.getComponentFromWrapper(currentChildMap.get(this.getLeaf(dockable).getName()), dockable), masterDockable, -1, AggregationPosition.DEFAULT);
                        }
                        continue;
                    }
                    if (!(child instanceof MultiSplitLayout.Split)) continue;
                    stack.push((MultiSplitLayout.Split)child);
                }
            }
            HashMap<String, Component> newChildMap = new HashMap<String, Component>();
            stack = new Stack();
            stack.push((MultiSplitLayout.Split)root);
            while (!stack.isEmpty()) {
                MultiSplitLayout.Split split2 = (MultiSplitLayout.Split)stack.pop();
                for (MultiSplitLayout.Node child : split2.getChildren()) {
                    if (child instanceof DockableLeaf) {
                        DockableLeaf leaf4 = (DockableLeaf)child;
                        DockableLeaf currentLeaf = this.getLeaf(this.multiSplitPaneModelRoot, leaf4.getDockable());
                        newChildMap.put(leaf4.getName(), currentChildMap.get(currentLeaf.getName()));
                        continue;
                    }
                    if (!(child instanceof MultiSplitLayout.Split)) continue;
                    stack.push((MultiSplitLayout.Split)child);
                }
            }
            this.multiSplitPane.getMultiSplitLayout().setChildMap(newChildMap);
        } else {
            leaf = (DockableLeaf)root;
            dockIds2 = leaf.getDockables();
            Dockable masterDockable = this.toolWindowManager.getDockable(leaf.getDockable());
            for (int i = 1; i < dockIds2.size(); ++i) {
                String dockId = (String)dockIds2.get(i);
                Dockable dockable = this.toolWindowManager.getDockable(dockId);
                this.setConstraints(dockable, this.getComponentFromWrapper(currentChildMap.get(this.getLeaf(dockable).getName()), dockable), masterDockable, -1, AggregationPosition.DEFAULT);
            }
        }
        this.validateModel(root);
        this.multiSplitPaneModelRoot = root;
        this.multiSplitPaneModelRoot.setParent(null);
        this.multiSplitPane.setModel(this.multiSplitPaneModelRoot);
        this.repaintMultiSplit(false);
    }

    public boolean isEmpty() {
        return this.entries.size() == 0;
    }

    public int getContentCount() {
        return this.entries.size();
    }

    public List<DockableEntry> getContents() {
        return new ArrayList<DockableEntry>(this.entries.values());
    }

    public void clear() {
        this.resetRootComponent();
        this.multiSplitPane.removeAll();
        this.entries.clear();
    }

    public boolean isStoreLayout() {
        return this.storeLayout;
    }

    public void setStoreLayout(boolean storeLayout) {
        this.storeLayout = storeLayout;
    }

    public boolean isUseAlwaysContentWrapper() {
        return this.useAlwaysContentWrapper;
    }

    public void setUseAlwaysContentWrapper(boolean useAlwaysContentWrapper) {
        if (this.useAlwaysContentWrapper == useAlwaysContentWrapper) {
            return;
        }
        this.useAlwaysContentWrapper = useAlwaysContentWrapper;
        if (useAlwaysContentWrapper) {
            if (this.entries.size() == 1) {
                Component componentWrapper = this.getWrapperForComponent(this.entries.keySet().iterator().next(), this.multiSplitPane.getComponent(0), Action.REMOVE_DOCK);
                this.multiSplitPane.removeAll();
                this.multiSplitPane.add(componentWrapper, "1");
                SwingUtil.repaint(this);
            }
        } else if (this.entries.size() == 1) {
            Component wrappedComponent = this.getComponentFromWrapper(this.multiSplitPane.getComponent(0));
            this.multiSplitPane.removeAll();
            this.multiSplitPane.add(wrappedComponent, "1");
            SwingUtil.repaint(this);
        }
    }

    public Rectangle getBoundsRelativeToScreen(Dockable dockable) {
        DockableLeaf leaf = this.getLeaf(dockable);
        if (leaf != null) {
            Rectangle bounds = leaf.getBounds();
            Point location = bounds.getLocation();
            SwingUtilities.convertPointToScreen(location, this);
            bounds.setLocation(location);
            bounds.y += this.toolWindowManager.getJMenuBarExtraHeight();
            return bounds;
        }
        return null;
    }

    protected Component getRootComponent() {
        return this.getComponent(0);
    }

    protected void setRootComponent(Component component) {
        this.resetRootComponent();
        this.add(component, "0,0,FULL,FULL");
    }

    protected void resetRootComponent() {
        this.removeAll();
    }

    protected Component getWrapperForComponent(Dockable dockable, Component component, Action action) {
        return new DockablePanel(dockable, component);
    }

    protected Component forceWrapperForComponent(Dockable dockable, Component component) {
        return new DockablePanel(dockable, component);
    }

    protected Component getComponentFromWrapper(Component wrapper) {
        if (wrapper instanceof DockablePanel) {
            return ((DockablePanel)wrapper).getComponent(0);
        }
        return wrapper;
    }

    protected void addToWrapper(Component wrapperSource, Dockable dockable, int aggregationIndexLocation, Component content) {
        throw new IllegalStateException("Cannot call this method...");
    }

    protected int removeFromWrapper(Component wrapperSource, Dockable dockable) {
        throw new IllegalStateException("Cannot call this method...");
    }

    protected Component getComponentFromWrapper(Component wrapper, Dockable dockable) {
        throw new IllegalStateException("Cannot call this method...");
    }

    protected boolean isWrapRequest(Dockable dockable, Action action) {
        return this.useAlwaysContentWrapper;
    }

    protected boolean isWrapper(Component component) {
        return false;
    }

    protected byte[] encode() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(os);
        e.writeObject(this.multiSplitPaneModelRoot);
        e.flush();
        e.close();
        return os.toByteArray();
    }

    protected MultiSplitLayout.Split decode(byte[] bytes) {
        XMLDecoder d = new XMLDecoder(new ByteArrayInputStream(bytes));
        return (MultiSplitLayout.Split)d.readObject();
    }

    protected void validateModel(MultiSplitLayout.Node root) {
        if (root == null || !(root instanceof MultiSplitLayout.Split)) {
            return;
        }
        List<MultiSplitLayout.Node> children = ((MultiSplitLayout.Split)root).getChildren();
        double sum = 0.0;
        for (MultiSplitLayout.Node node : children) {
            if (!(node instanceof MultiSplitLayout.Divider)) {
                sum += node.getWeight();
            }
            if (node instanceof MultiSplitLayout.Split) {
                this.validateModel(node);
            }
            if (!(sum > 1.0)) continue;
            break;
        }
        if (sum != 1.0) {
            double w = 1.0 / (double)(children.size() / 2 + 1);
            for (MultiSplitLayout.Node node : children) {
                node.resetBounds();
                if (node instanceof MultiSplitLayout.Divider) continue;
                node.setWeight(w);
            }
            this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(true);
        }
    }

    protected void forceWeight(List<MultiSplitLayout.Node> children) {
        double w = 1.0 / (double)(children.size() / 2 + 1);
        for (MultiSplitLayout.Node node : children) {
            node.resetBounds();
            if (node instanceof MultiSplitLayout.Divider) continue;
            node.setWeight(w);
        }
        this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(true);
    }

    protected void resetBounds() {
        if (this.multiSplitPaneModelRoot == null || !(this.multiSplitPaneModelRoot instanceof MultiSplitLayout.Split)) {
            return;
        }
        Stack<MultiSplitLayout.Split> stack = new Stack<MultiSplitLayout.Split>();
        stack.push((MultiSplitLayout.Split)this.multiSplitPaneModelRoot);
        this.multiSplitPaneModelRoot.resetBounds();
        while (!stack.isEmpty()) {
            MultiSplitLayout.Split split = (MultiSplitLayout.Split)stack.pop();
            for (MultiSplitLayout.Node child : split.getChildren()) {
                child.resetBounds();
                if (!(child instanceof MultiSplitLayout.Split)) continue;
                stack.push((MultiSplitLayout.Split)child);
            }
        }
    }

    protected boolean checkModel() {
        if (this.multiSplitPaneModelRoot == null) {
            return true;
        }
        if (this.multiSplitPaneModelRoot.getParent() != null) {
            return false;
        }
        if (!(this.multiSplitPaneModelRoot instanceof MultiSplitLayout.Split)) {
            return true;
        }
        Stack<MultiSplitLayout.Split> stack = new Stack<MultiSplitLayout.Split>();
        stack.push((MultiSplitLayout.Split)this.multiSplitPaneModelRoot);
        while (!stack.isEmpty()) {
            MultiSplitLayout.Split split = (MultiSplitLayout.Split)stack.pop();
            if (split.getChildren().size() <= 2) {
                return false;
            }
            for (MultiSplitLayout.Node child : split.getChildren()) {
                if (child.getParent() == null || child.getParent() != split) {
                    return false;
                }
                if (!(child instanceof MultiSplitLayout.Split)) continue;
                stack.push((MultiSplitLayout.Split)child);
            }
        }
        return true;
    }

    protected void repaintMultiSplit(boolean resetBounds) {
        SwingUtilities.invokeLater(new RepaintRunnable(resetBounds));
    }

    protected MultiSplitLayout.Node getFirstNotDivider(List<MultiSplitLayout.Node> children) {
        for (MultiSplitLayout.Node child : children) {
            if (child instanceof MultiSplitLayout.Divider) continue;
            return child;
        }
        return null;
    }

    protected String getLeafName(Dockable dockable) {
        DockableLeaf leaf = this.getLeaf(this.multiSplitPaneModelRoot, dockable.getId());
        return leaf != null ? leaf.getName() : null;
    }

    protected DockableLeaf getLeaf(Dockable dockable) {
        return this.getLeaf(this.multiSplitPaneModelRoot, dockable.getId());
    }

    protected DockableLeaf getLeaf(MultiSplitLayout.Node root, String dockableId) {
        if (root == null || !(root instanceof MultiSplitLayout.Split)) {
            DockableLeaf leaf;
            if (root instanceof MultiSplitLayout.Leaf && (leaf = (DockableLeaf)root).getDockables().contains(dockableId)) {
                return leaf;
            }
            return null;
        }
        Stack<MultiSplitLayout.Split> stack = new Stack<MultiSplitLayout.Split>();
        stack.push((MultiSplitLayout.Split)root);
        while (!stack.isEmpty()) {
            MultiSplitLayout.Split split = (MultiSplitLayout.Split)stack.pop();
            for (MultiSplitLayout.Node child : split.getChildren()) {
                if (child instanceof DockableLeaf) {
                    DockableLeaf leaf = (DockableLeaf)child;
                    if (!leaf.getDockables().contains(dockableId)) continue;
                    return leaf;
                }
                if (!(child instanceof MultiSplitLayout.Split)) continue;
                stack.push((MultiSplitLayout.Split)child);
            }
        }
        return null;
    }

    protected String getNextLeanName() {
        return "" + ++this.leafNameCounter;
    }

    protected boolean isNodeAttached(MultiSplitLayout.Node node) {
        if (node == null) {
            return false;
        }
        if (this.multiSplitPaneModelRoot == node) {
            return true;
        }
        if (this.multiSplitPaneModelRoot instanceof MultiSplitLayout.Split) {
            Stack<MultiSplitLayout.Split> stack = new Stack<MultiSplitLayout.Split>();
            stack.push((MultiSplitLayout.Split)this.multiSplitPaneModelRoot);
            while (!stack.isEmpty()) {
                MultiSplitLayout.Split split = (MultiSplitLayout.Split)stack.pop();
                if (split.getChildren().size() <= 2) {
                    return false;
                }
                for (MultiSplitLayout.Node child : split.getChildren()) {
                    if (child == node) {
                        return true;
                    }
                    if (!(child instanceof MultiSplitLayout.Split)) continue;
                    stack.push(split);
                }
            }
        }
        return false;
    }

    protected boolean containsDockable(DockableLeaf leaf) {
        for (String dockId : leaf.getDockables()) {
            boolean found = false;
            for (Dockable dockable : this.entries.keySet()) {
                if (!dockable.getId().equals(dockId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public class Constraint {
        private MultiSplitLayout.Node node;
        private AggregationPosition aggregationPosition;
        private int index = -1;

        public Constraint(MultiSplitLayout.Node node, AggregationPosition aggregationPosition, int index) {
            this.node = node;
            this.aggregationPosition = aggregationPosition;
            this.index = index;
        }

        public MultiSplitLayout.Node getNode() {
            return this.node;
        }

        public AggregationPosition getAggregationPosition() {
            return this.aggregationPosition;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class DebugRepaintRunnable
    implements Runnable {
        protected Exception exception;

        public DebugRepaintRunnable(Exception exception) {
            this.exception = exception;
        }

        public void run() {
            try {
                MultiSplitDockableContainer.this.checkModel();
                if (MultiSplitDockableContainer.this.jumpResetBounds) {
                    MultiSplitDockableContainer.this.jumpResetBounds = false;
                } else {
                    MultiSplitDockableContainer.this.resetBounds();
                }
                MultiSplitDockableContainer.this.multiSplitPane.invalidate();
                MultiSplitDockableContainer.this.multiSplitPane.validate();
                MultiSplitDockableContainer.this.multiSplitPane.repaint();
                MultiSplitDockableContainer.this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(false);
            }
            catch (RuntimeException e) {
                System.out.println("-----------------------------------------------------------------------");
                this.exception.printStackTrace();
                System.out.println("-----------------------------------------------------------------------");
                throw e;
            }
        }
    }

    public class RepaintRunnable
    implements Runnable {
        protected boolean reset;

        public RepaintRunnable(boolean reset) {
            this.reset = reset;
        }

        public void run() {
            MultiSplitDockableContainer.this.checkModel();
            if (this.reset) {
                MultiSplitDockableContainer.this.resetBounds();
            }
            MultiSplitDockableContainer.this.multiSplitPane.invalidate();
            MultiSplitDockableContainer.this.multiSplitPane.validate();
            MultiSplitDockableContainer.this.multiSplitPane.repaint();
            MultiSplitDockableContainer.this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DockableLeaf
    extends MultiSplitLayout.Leaf {
        private List<String> dockables;

        public DockableLeaf() {
        }

        public DockableLeaf(String name) {
            super(name);
            this.dockables = new ArrayList<String>();
        }

        public DockableLeaf(String name, String dockableId) {
            super(name);
            this.dockables = new ArrayList<String>();
            this.dockables.add(dockableId);
        }

        public String getDockable() {
            return this.dockables.get(0);
        }

        public List<String> getDockables() {
            return this.dockables;
        }

        public void setDockables(List<String> dockables) {
            this.dockables = dockables;
        }

        public void addDockable(String dockableId) {
            this.dockables.add(dockableId);
        }

        public int getNameValue() {
            return Integer.parseInt(this.getName());
        }
    }

    public class DockableEntry {
        Dockable dockable;
        Component component;
        String id;

        DockableEntry(Dockable dockable, Component component, String id) {
            this.dockable = dockable;
            this.component = component;
            this.id = id;
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public Component getComponent() {
            return this.component;
        }

        public String getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ADD_DOCK,
        REMOVE_DOCK;

    }
}

