/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import org.noos.xing.mydoggy.plaf.ui.util.Colors;

public class LineBorder
extends AbstractBorder {
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;
    protected int arcHeight;
    protected int arcWidth;

    public LineBorder() {
        this(Colors.buttonBorder);
    }

    public LineBorder(Color color) {
        this(color, 1, false, 0, 0);
    }

    public LineBorder(Color color, int thickness) {
        this(color, thickness, false, 0, 0);
    }

    public LineBorder(Color lineColor, int thickness, boolean roundedCorners, int arcWidth, int arcHeight) {
        this.lineColor = lineColor;
        this.thickness = thickness;
        this.roundedCorners = roundedCorners;
        this.arcHeight = arcHeight;
        this.arcWidth = arcWidth;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            if (!this.roundedCorners) {
                g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                continue;
            }
            g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, this.arcWidth, this.arcHeight);
        }
        g.setColor(oldColor);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean getRoundedCorners() {
        return this.roundedCorners;
    }

    public boolean isBorderOpaque() {
        return !this.roundedCorners;
    }
}

