/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.event;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JMenuBar;
import javax.swing.event.MouseInputListener;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;

public class SlidingMouseInputHandler
implements MouseInputListener,
Cleaner {
    static final int BORDER_DRAG_THICKNESS = 5;
    static final int CORNER_DRAG_WIDTH = 16;
    static final int[] LEFT_CURSOR_MAPPING = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] RIGHT_CURSOR_MAPPING = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] TOP_CURSOR_MAPPING = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0};
    static final int[] BOTTOM_CURSOR_MAPPING = new int[]{0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected Cursor lastCursor = Cursor.getPredefinedCursor(0);
    protected int dragCursor;
    protected int dragOffsetX;
    protected int dragOffsetY;
    protected int dragWidth;
    protected int dragHeight;
    protected ToolWindowDescriptor descriptor;
    protected ToolWindow toolWindow;

    public SlidingMouseInputHandler(ToolWindowDescriptor descriptor) {
        this.descriptor = descriptor;
        this.toolWindow = descriptor.getToolWindow();
        descriptor.getCleaner().addCleaner(this);
    }

    public void cleanup() {
        this.descriptor = null;
        this.toolWindow = null;
    }

    public void mousePressed(MouseEvent ev) {
        Point dragWindowOffset = ev.getPoint();
        Component w = (Component)ev.getSource();
        this.dragOffsetX = dragWindowOffset.x;
        this.dragOffsetY = dragWindowOffset.y;
        this.dragWidth = w.getWidth();
        this.dragHeight = w.getHeight();
        this.dragCursor = this.getCursor(w, this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
    }

    public void mouseReleased(MouseEvent ev) {
        Component w = (Component)ev.getSource();
        this.dragCursor = 0;
        this.lastCursor = Cursor.getPredefinedCursor(0);
        w.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseMoved(MouseEvent ev) {
        Component w = (Component)ev.getSource();
        int cursor = this.getCursor(w, this.calculateCorner(w, ev.getX(), ev.getY()));
        if (cursor != 0) {
            w.setCursor(Cursor.getPredefinedCursor(cursor));
        } else {
            w.setCursor(this.lastCursor);
        }
    }

    public void mouseDragged(MouseEvent ev) {
        Point pt = ev.getPoint();
        Component component = ev.getComponent();
        if (this.dragCursor != 0) {
            Rectangle r = component.getBounds();
            Rectangle startBounds = new Rectangle(r);
            Dimension min = component.getMinimumSize();
            switch (this.toolWindow.getAnchor()) {
                case LEFT: {
                    if (this.dragCursor != 11) break;
                    this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                    break;
                }
                case TOP: {
                    if (this.dragCursor != 9) break;
                    this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                    break;
                }
                case RIGHT: {
                    if (this.dragCursor != 10) break;
                    this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                    break;
                }
                case BOTTOM: {
                    if (this.dragCursor != 8) break;
                    this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                }
            }
            if (!r.equals(startBounds)) {
                JMenuBar menuBar = this.descriptor.getManager().getRootPane().getJMenuBar();
                Rectangle containerRect = this.descriptor.getToolWindowManagerContainerBounds();
                switch (this.toolWindow.getAnchor()) {
                    case LEFT: {
                        if (r.width < 5) {
                            r.width = 5;
                        }
                        int maxWidth = containerRect.width;
                        maxWidth -= this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize();
                        if (r.width <= (maxWidth -= this.descriptor.getToolBar(ToolWindowAnchor.RIGHT).getSize())) break;
                        r.width = maxWidth;
                        break;
                    }
                    case RIGHT: {
                        int maxX;
                        int minX;
                        if (r.width < 5) {
                            r.width = 5;
                        }
                        if (r.x < (minX = containerRect.x + this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize())) {
                            r.x = minX;
                        }
                        if (r.x > (maxX = containerRect.x + containerRect.width - 5 - this.descriptor.getToolBar(ToolWindowAnchor.RIGHT).getSize())) {
                            r.x = maxX;
                        }
                        int maxWidth = containerRect.width;
                        maxWidth -= this.descriptor.getToolBar(ToolWindowAnchor.RIGHT).getSize();
                        if (r.width <= (maxWidth -= this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize())) break;
                        r.width = maxWidth;
                        break;
                    }
                    case TOP: {
                        if (r.height < 5) {
                            r.height = 5;
                        }
                        int maxHeight = containerRect.height;
                        maxHeight -= this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize();
                        if (r.height <= (maxHeight -= this.descriptor.getToolBar(ToolWindowAnchor.BOTTOM).getSize())) break;
                        r.height = maxHeight;
                        break;
                    }
                    case BOTTOM: {
                        int maxY;
                        if (r.height < 5) {
                            r.height = 5;
                        }
                        int diffMenu = menuBar != null ? menuBar.getHeight() : 0;
                        int minY = containerRect.y + this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize() + diffMenu;
                        if (r.y < minY) {
                            r.y = minY;
                        }
                        if (r.y > (maxY = containerRect.y + containerRect.height - 5 - this.descriptor.getToolBar(ToolWindowAnchor.BOTTOM).getSize() + diffMenu)) {
                            r.y = maxY;
                        }
                        int maxHeight = containerRect.height;
                        maxHeight -= this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize();
                        if (r.height <= (maxHeight -= this.descriptor.getToolBar(ToolWindowAnchor.BOTTOM).getSize())) break;
                        r.height = maxHeight;
                    }
                }
                component.setBounds(r);
                component.validate();
            }
        }
    }

    public void mouseEntered(MouseEvent ev) {
        Component w = (Component)ev.getSource();
        this.lastCursor = w.getCursor();
        this.mouseMoved(ev);
    }

    public void mouseExited(MouseEvent ev) {
        Component w = (Component)ev.getSource();
        w.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseClicked(MouseEvent ev) {
    }

    protected void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        bounds.x += deltaX;
        bounds.y += deltaY;
        bounds.width += deltaWidth;
        bounds.height += deltaHeight;
        if (min != null) {
            int correction;
            if (bounds.width < min.width) {
                correction = min.width - bounds.width;
                if (deltaX != 0) {
                    bounds.x -= correction;
                }
                bounds.width = min.width;
            }
            if (bounds.height < min.height) {
                correction = min.height - bounds.height;
                if (deltaY != 0) {
                    bounds.y -= correction;
                }
                bounds.height = min.height;
            }
        }
    }

    protected int calculateCorner(Component c, int x, int y) {
        int xPosition = this.calculatePosition(x, c.getWidth());
        int yPosition = this.calculatePosition(y, c.getHeight());
        if (xPosition == -1 || yPosition == -1) {
            return -1;
        }
        return yPosition * 5 + xPosition;
    }

    protected int getCursor(Component c, int corner) {
        if (corner == -1) {
            return 0;
        }
        switch (this.toolWindow.getAnchor()) {
            case LEFT: {
                if (corner == 10 && c.getWidth() <= 5) {
                    return 11;
                }
                return LEFT_CURSOR_MAPPING[corner];
            }
            case RIGHT: {
                if (corner == 10 && c.getWidth() <= 5) {
                    return 10;
                }
                return RIGHT_CURSOR_MAPPING[corner];
            }
            case TOP: {
                if (corner == 2 && c.getHeight() <= 5) {
                    return 9;
                }
                return TOP_CURSOR_MAPPING[corner];
            }
            case BOTTOM: {
                if (corner == 14 && c.getHeight() <= 5) {
                    return 10;
                }
                return BOTTOM_CURSOR_MAPPING[corner];
            }
        }
        return 0;
    }

    protected int calculatePosition(int spot, int width) {
        if (spot < 5) {
            return 0;
        }
        if (spot < 16) {
            return 1;
        }
        if (spot >= width - 5) {
            return 4;
        }
        if (spot >= width - 16) {
            return 3;
        }
        return 2;
    }
}

