/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.metal.MetalLabelUI;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.DockedContainer;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.GlassPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.TranslucentPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.drag.RepresentativeAnchorDragGesture;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.MutableColor;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowRepresentativeAnchorUI
extends MetalLabelUI
implements Cleaner {
    protected JComponent label;
    protected LineBorder labelBorder;
    protected ToolWindowDescriptor descriptor;
    protected ToolWindow toolWindow;
    protected ResourceManager resourceManager;
    protected DockedTypeDescriptor dockedTypeDescriptor;
    protected RepresentativeAnchorMouseAdapter adapter;
    protected Timer flashingTimer;
    protected int flasingDuration;
    protected boolean flashingState;
    protected MutableColor flashingAnimBackStart;
    protected MutableColor flashingAnimBackEnd;
    protected AbstractAnimation flashingAnimation;
    protected TranslucentPanel previewPanel;

    public ToolWindowRepresentativeAnchorUI(ToolWindowDescriptor descriptor) {
        this.descriptor = descriptor;
        this.toolWindow = descriptor.getToolWindow();
        this.resourceManager = descriptor.getResourceManager();
        this.flashingAnimation = new GradientAnimation();
        this.flasingDuration = -1;
        this.flashingAnimBackStart = new MutableColor(this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
        this.flashingAnimBackEnd = new MutableColor(this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
        this.dockedTypeDescriptor = (DockedTypeDescriptor)this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        this.dockedTypeDescriptor.addPropertyChangeListener((PropertyChangeListener)this);
        descriptor.getCleaner().addCleaner(this);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.label = c;
        this.labelBorder = new LineBorder(this.resourceManager.getColor("RAB_MOUSE_OUT_BORDER"), 1, true, 3, 3);
        c.setBorder(this.labelBorder);
        c.setForeground(this.resourceManager.getColor("RAB_FOREGROUND"));
        SwingUtil.registerDragGesture(c, new ToolWindowRepresentativeAnchorDragGesture(this.descriptor, this.label));
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removeMouseListener(this.adapter);
        c.removeMouseMotionListener(this.adapter);
        this.cleanup();
    }

    public void update(Graphics g, JComponent c) {
        if (this.toolWindow.isAvailable()) {
            c.setForeground(this.resourceManager.getColor("RAB_FOREGROUND"));
        } else {
            c.setForeground(this.resourceManager.getColor("RAB_FOREGROUND_UNAVAILABLE"));
        }
        if (this.isFlashing() && !this.toolWindow.isVisible()) {
            this.updateAnchor(g, c, this.flashingAnimBackStart, this.flashingAnimBackEnd, false, true);
            if (this.flashingTimer == null) {
                this.flashingTimer = new Timer(600, new ActionListener(){
                    long start = 0L;

                    public void actionPerformed(ActionEvent e) {
                        if (this.start == 0L) {
                            this.start = System.currentTimeMillis();
                        }
                        boolean bl = ToolWindowRepresentativeAnchorUI.this.flashingState = !ToolWindowRepresentativeAnchorUI.this.flashingState;
                        if (ToolWindowRepresentativeAnchorUI.this.flashingAnimation.isAnimating()) {
                            ToolWindowRepresentativeAnchorUI.this.flashingAnimation.stop();
                        }
                        if (ToolWindowRepresentativeAnchorUI.this.flashingState) {
                            ToolWindowRepresentativeAnchorUI.this.flashingAnimation.show(new Object[0]);
                        } else {
                            ToolWindowRepresentativeAnchorUI.this.flashingAnimation.hide(new Object[0]);
                        }
                        if (ToolWindowRepresentativeAnchorUI.this.flasingDuration != -1 && System.currentTimeMillis() - this.start > (long)ToolWindowRepresentativeAnchorUI.this.flasingDuration) {
                            ToolWindowRepresentativeAnchorUI.this.toolWindow.setFlashing(false);
                        }
                    }
                });
                this.flashingState = true;
                this.flashingAnimation.show(new Object[0]);
            }
            if (!this.flashingTimer.isRunning()) {
                this.flashingTimer.start();
            }
        } else {
            if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
            }
            this.updateAnchor(g, c, this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"), this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_END"), this.toolWindow.isVisible(), false);
        }
        this.paint(g, c);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("visible".equals(propertyName)) {
            boolean visible = (Boolean)e.getNewValue();
            this.label.setOpaque(visible);
            if (visible) {
                this.labelBorder.setLineColor(this.resourceManager.getColor("RAB_MOUSE_IN_BORDER"));
                this.descriptor.getToolBar().ensureVisible(this.label);
                this.toolWindow.setFlashing(false);
            } else {
                this.labelBorder.setLineColor(this.resourceManager.getColor("RAB_MOUSE_OUT_BORDER"));
            }
            SwingUtil.repaint(this.label);
        } else if ("flash".equals(propertyName)) {
            if (e.getNewValue() == Boolean.TRUE) {
                if (!this.toolWindow.isVisible()) {
                    this.flasingDuration = -1;
                    SwingUtil.repaint(this.label);
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                SwingUtil.repaint(this.label);
            }
        } else if ("flash.duration".equals(propertyName)) {
            if (e.getNewValue() == Boolean.TRUE) {
                if (!this.toolWindow.isVisible()) {
                    this.flasingDuration = (Integer)e.getNewValue();
                    SwingUtil.repaint(this.label);
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                SwingUtil.repaint(this.label);
            }
        }
    }

    public void cleanup() {
        this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED).removePropertyChangeListener((PropertyChangeListener)this);
        this.descriptor.getToolWindow().removePlafPropertyChangeListener(this);
        if (this.flashingTimer != null) {
            this.flashingTimer.stop();
        }
        this.flashingTimer = null;
        this.descriptor = null;
        this.toolWindow = null;
    }

    protected void installListeners(JLabel c) {
        super.installListeners(c);
        String oldText = c.getText();
        if (oldText != null) {
            c.setText(null);
            c.setText(oldText);
        }
        if ((oldText = c.getToolTipText()) != null) {
            c.setToolTipText(null);
            c.setToolTipText(oldText);
        }
        this.adapter = new RepresentativeAnchorMouseAdapter();
        c.addMouseListener(this.adapter);
        c.addMouseMotionListener(this.adapter);
        this.descriptor.getToolWindow().addPlafPropertyChangeListener(this);
    }

    protected void updateAnchor(Graphics g, JComponent c, Color backgroundStart, Color backgroundEnd, boolean active, boolean flashing) {
        Rectangle r = c.getBounds();
        r.y = 0;
        r.x = 0;
        if (flashing || active) {
            GraphicsUtil.fillRect(g, r, backgroundStart, backgroundEnd, null, 1);
        } else {
            g.setColor(this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
            g.fillRect(0, 0, r.width, r.height);
        }
    }

    protected void hideAllPreview() {
        if (this.previewPanel != null) {
            GlassPanel glassPane = this.descriptor.getManager().getGlassPanel();
            glassPane.remove(this.previewPanel);
        }
    }

    protected boolean isFlashing() {
        boolean result = this.toolWindow.isFlashing();
        if (!result) {
            for (ToolWindowTab tab : this.toolWindow.getToolWindowTabs()) {
                if (!tab.isFlashing()) continue;
                return true;
            }
        }
        return result;
    }

    protected class ToolWindowRepresentativeAnchorDragGesture
    extends RepresentativeAnchorDragGesture {
        public ToolWindowRepresentativeAnchorDragGesture(DockableDescriptor descriptor, Component component) {
            super(descriptor, component);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            ToolWindowRepresentativeAnchorUI.this.hideAllPreview();
            super.dragGestureRecognized(dge);
        }

        protected Transferable createTransferable() {
            return new MyDoggyTransferable(this.manager, MyDoggyTransferable.TOOL_WINDOW_ID_DF, ToolWindowRepresentativeAnchorUI.this.toolWindow.getId());
        }
    }

    protected class RepresentativeAnchorMouseAdapter
    extends MouseInputAdapter
    implements ActionListener,
    Cleaner {
        protected Timer previewTimer = new Timer(0, this);
        protected boolean firstPreview = true;

        public RepresentativeAnchorMouseAdapter() {
            ToolWindowRepresentativeAnchorUI.this.descriptor.getCleaner().addBefore(ToolWindowRepresentativeAnchorUI.this, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isAvailable()) {
                return;
            }
            this.previewTimer.stop();
            this.firstPreview = false;
            this.actionPerformed(new ActionEvent(this.previewTimer, 0, "stop"));
            if (SwingUtilities.isLeftMouseButton(e)) {
                int onmask = 64;
                if ((e.getModifiersEx() & onmask) == onmask) {
                    if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isVisible()) {
                        ToolWindowRepresentativeAnchorUI.this.toolWindow.setVisible(false);
                    } else {
                        if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isAggregateMode()) {
                            ToolWindowRepresentativeAnchorUI.this.toolWindow.setAggregateMode(false);
                            try {
                                ToolWindowRepresentativeAnchorUI.this.toolWindow.setVisible(true);
                            }
                            finally {
                                ToolWindowRepresentativeAnchorUI.this.toolWindow.setAggregateMode(true);
                            }
                        } else {
                            ToolWindowRepresentativeAnchorUI.this.toolWindow.aggregate();
                        }
                        ToolWindowRepresentativeAnchorUI.this.toolWindow.setActive(true);
                    }
                } else if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isVisible()) {
                    ToolWindowRepresentativeAnchorUI.this.toolWindow.setVisible(false);
                } else {
                    ToolWindowRepresentativeAnchorUI.this.toolWindow.setVisible(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ToolWindowRepresentativeAnchorUI.this.toolWindow.setActive(true);
                        }
                    });
                }
            } else if (SwingUtilities.isRightMouseButton(e) && ((DockedTypeDescriptor)ToolWindowRepresentativeAnchorUI.this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED)).isPopupMenuEnabled()) {
                ToolWindowRepresentativeAnchorUI.this.descriptor.getToolWindowContainer().showPopupMenu(e.getComponent(), e.getX(), e.getY());
            }
            ToolWindowRepresentativeAnchorUI.this.label.setBorder(ToolWindowRepresentativeAnchorUI.this.labelBorder);
            ToolWindowRepresentativeAnchorUI.this.labelBorder.setLineColor(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_MOUSE_IN_BORDER"));
            SwingUtil.repaint(ToolWindowRepresentativeAnchorUI.this.label);
        }

        public void mouseEntered(MouseEvent e) {
            if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isAvailable()) {
                return;
            }
            if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isVisible() && ToolWindowRepresentativeAnchorUI.this.previewPanel == null) {
                this.previewTimer.setInitialDelay(ToolWindowRepresentativeAnchorUI.this.dockedTypeDescriptor.getPreviewDelay());
                this.previewTimer.start();
            }
            if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isFlashing()) {
                return;
            }
            Component source = e.getComponent();
            if (!source.isOpaque()) {
                ToolWindowRepresentativeAnchorUI.this.labelBorder.setLineColor(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_MOUSE_IN_BORDER"));
                SwingUtil.repaint(source);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isAvailable()) {
                return;
            }
            if (e.getX() >= ToolWindowRepresentativeAnchorUI.this.label.getWidth() || e.getX() <= 0 || e.getY() >= ToolWindowRepresentativeAnchorUI.this.label.getHeight() || e.getY() <= 0) {
                this.firstPreview = false;
            }
            this.previewTimer.stop();
            this.actionPerformed(new ActionEvent(this.previewTimer, 0, "stop"));
            if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isFlashing()) {
                return;
            }
            Component source = e.getComponent();
            if (!source.isOpaque()) {
                ToolWindowRepresentativeAnchorUI.this.labelBorder.setLineColor(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_MOUSE_OUT_BORDER"));
                SwingUtil.repaint(source);
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.firstPreview = false;
            this.previewTimer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.previewTimer) {
                if ("stop".equals(e.getActionCommand())) {
                    Window windowAnchestor;
                    if (ToolWindowRepresentativeAnchorUI.this.previewPanel != null && !this.firstPreview && (windowAnchestor = SwingUtilities.getWindowAncestor(ToolWindowRepresentativeAnchorUI.this.label)) != null) {
                        GlassPanel glassPane = ToolWindowRepresentativeAnchorUI.this.descriptor.getManager().getGlassPanel();
                        glassPane.remove(ToolWindowRepresentativeAnchorUI.this.previewPanel);
                        glassPane.setVisible(false);
                        SwingUtil.repaint(glassPane);
                        SwingUtil.repaint(windowAnchestor);
                        ToolWindowRepresentativeAnchorUI.this.previewPanel = null;
                    }
                    this.firstPreview = false;
                } else if (ToolWindowRepresentativeAnchorUI.this.dockedTypeDescriptor.isPreviewEnabled() && ToolWindowRepresentativeAnchorUI.this.descriptor.getManager().getToolWindowManagerDescriptor().isPreviewEnabled()) {
                    Container contentContainer = ((DockedContainer)ToolWindowRepresentativeAnchorUI.this.descriptor.getToolWindowContainer()).getContentContainer();
                    int width = 176;
                    int height = 132;
                    RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(ToolWindowRepresentativeAnchorUI.this.label));
                    if (rootPaneContainer != null) {
                        JMenuBar jMenuBar = rootPaneContainer instanceof JFrame ? ((JFrame)rootPaneContainer).getJMenuBar() : null;
                        this.firstPreview = true;
                        this.previewTimer.stop();
                        GlassPanel glassPane = ToolWindowRepresentativeAnchorUI.this.descriptor.getManager().getGlassPanel();
                        if (ToolWindowRepresentativeAnchorUI.this.previewPanel != null) {
                            glassPane.remove(ToolWindowRepresentativeAnchorUI.this.previewPanel);
                        }
                        ToolWindowRepresentativeAnchorUI.this.previewPanel = new TranslucentPanel((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{2.0, -1.0, 2.0}, {2.0, -1.0, 2.0}})));
                        ToolWindowRepresentativeAnchorUI.this.previewPanel.setAlphaModeRatio(ToolWindowRepresentativeAnchorUI.this.dockedTypeDescriptor.getPreviewTransparentRatio());
                        ToolWindowRepresentativeAnchorUI.this.previewPanel.setSize(width + 4, height + 4);
                        Rectangle containerRect = ToolWindowRepresentativeAnchorUI.this.descriptor.getToolWindowManagerContainerBounds();
                        switch (ToolWindowRepresentativeAnchorUI.this.descriptor.getToolWindow().getAnchor()) {
                            case LEFT: {
                                ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + ToolWindowRepresentativeAnchorUI.this.label.getX() + ToolWindowRepresentativeAnchorUI.this.label.getWidth() + 3, (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + ToolWindowRepresentativeAnchorUI.this.label.getY() + ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize());
                                break;
                            }
                            case TOP: {
                                ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + ToolWindowRepresentativeAnchorUI.this.label.getX() + ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize(), (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + ToolWindowRepresentativeAnchorUI.this.label.getY() + ToolWindowRepresentativeAnchorUI.this.label.getHeight() + 3);
                                break;
                            }
                            case BOTTOM: {
                                ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + ToolWindowRepresentativeAnchorUI.this.label.getX() + ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize(), (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + containerRect.height - ToolWindowRepresentativeAnchorUI.this.previewPanel.getHeight() - 26);
                                break;
                            }
                            case RIGHT: {
                                ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + containerRect.width - ToolWindowRepresentativeAnchorUI.this.previewPanel.getWidth() - 26, (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + ToolWindowRepresentativeAnchorUI.this.label.getY() + ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize());
                            }
                        }
                        if ((double)(ToolWindowRepresentativeAnchorUI.this.previewPanel.getY() + ToolWindowRepresentativeAnchorUI.this.previewPanel.getHeight()) > containerRect.getY() + containerRect.getHeight() - 26.0) {
                            ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(ToolWindowRepresentativeAnchorUI.this.previewPanel.getX(), (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + containerRect.height - ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.BOTTOM).getSize() - ToolWindowRepresentativeAnchorUI.this.previewPanel.getHeight() - 3);
                        }
                        if ((double)(ToolWindowRepresentativeAnchorUI.this.previewPanel.getX() + ToolWindowRepresentativeAnchorUI.this.previewPanel.getWidth()) > (double)containerRect.x + containerRect.getWidth() - 26.0) {
                            ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + containerRect.width - ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.RIGHT).getSize() - ToolWindowRepresentativeAnchorUI.this.previewPanel.getWidth() - 3, ToolWindowRepresentativeAnchorUI.this.previewPanel.getY());
                        }
                        ToolWindowRepresentativeAnchorUI.this.previewPanel.add((Component)contentContainer, "1,1,FULL,FULL");
                        glassPane.add(ToolWindowRepresentativeAnchorUI.this.previewPanel);
                        glassPane.setVisible(true);
                        SwingUtil.repaint(glassPane);
                    }
                }
            }
        }

        public void cleanup() {
            this.actionPerformed(new ActionEvent(this.previewTimer, 0, "stop"));
            if (this.previewTimer != null) {
                this.previewTimer.stop();
                this.previewTimer = null;
            }
        }
    }

    protected class GradientAnimation
    extends AbstractAnimation {
        public GradientAnimation() {
            super(600.0f);
        }

        protected float onAnimating(float animationPercent) {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    GraphicsUtil.getInterpolatedColor(ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart, ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"), ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowRepresentativeAnchorUI.this.flashingAnimBackEnd, ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"), ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_END"), animationPercent);
                    break;
                }
                case OUTGOING: {
                    GraphicsUtil.getInterpolatedColor(ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart, ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"), ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowRepresentativeAnchorUI.this.flashingAnimBackEnd, ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_END"), ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"), animationPercent);
                }
            }
            SwingUtil.repaint(ToolWindowRepresentativeAnchorUI.this.label);
            return animationPercent;
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
                    break;
                }
                case OUTGOING: {
                    ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"));
                }
            }
            SwingUtil.repaint(ToolWindowRepresentativeAnchorUI.this.label);
        }

        protected void onHide(Object ... params) {
            ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_START"));
            ToolWindowRepresentativeAnchorUI.this.flashingAnimBackEnd.setRGB(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_ACTIVE_END"));
        }

        protected void onShow(Object ... params) {
            ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
            ToolWindowRepresentativeAnchorUI.this.flashingAnimBackEnd.setRGB(ToolWindowRepresentativeAnchorUI.this.resourceManager.getColor("RAB_BACKGROUND_INACTIVE"));
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
        }
    }
}

