/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.SplashScreen;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.ParadiseTool;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.tools.component.ParadiseTask;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import jade.util.leap.Iterator;
import jade.wrapper.StaleProxyException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import org.jdesktop.application.Application;

public class AssembleAgent
extends AbstractParadiseToolAgent {
    public AssembleAgent(ParadiseWorkingSession pws, SplashScreen splashScreen) throws StaleProxyException {
        super((ParadiseTool)new Assemble(pws, splashScreen), Arrays.asList("paradiseTool", "Secondary Viewer", "Tertiary Viewer"));
        this.addBehaviour((Behaviour)new LoadStructuralDataFromS2S());
    }

    protected void onGuiEvent(GuiEvent guiEvent) {
        if (guiEvent.getType() == Paradise.functionnalities.indexOf("send selected residues to paradise tools")) {
            this.addBehaviour(new Behaviour(){

                public void action() {
                    DFAgentDescription[] hits = null;
                    DFAgentDescription template = new DFAgentDescription();
                    ServiceDescription templateSd = new ServiceDescription();
                    templateSd.setType("Alignment Viewer");
                    template.addServices(templateSd);
                    try {
                        hits = DFService.search((Agent)((AbstractParadiseToolAgent)AssembleAgent.this.paradiseTool.getAgent()), (DFAgentDescription)template);
                        for (int i = 0; i < hits.length; ++i) {
                            if (hits[i].getName() == AssembleAgent.this.getAID()) continue;
                            ACLMessage query = new ACLMessage(16);
                            query.addReceiver(hits[i].getName());
                            ArrayList residues = new ArrayList();
                            List<Residue2D> residues2D = ((Assemble)AssembleAgent.this.paradiseTool).getMediator().getRna2DViewer().getSecondaryCanvas().getCurrentResidues();
                            for (Residue2D residue2D : residues2D) {
                                residues.add(residue2D.getResidue2DFeature().getResidues().iterator().next());
                            }
                            query.setContentObject(residues);
                            query.setConversationId("residues selected");
                            AssembleAgent.this.send(query);
                        }
                    }
                    catch (FIPAException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public boolean done() {
                    return true;
                }
            });
        } else {
            Iterator iterator = guiEvent.getAllParameter();
            AnswerBehaviour answerBehaviour = null;
            String targetedAgentName = null;
            AbstractParadiseToolAgent.ListAgentsBehaviour behaviour = null;
            if (iterator.hasNext()) {
                answerBehaviour = (AnswerBehaviour)iterator.next();
            }
            if (iterator.hasNext()) {
                targetedAgentName = (String)iterator.next();
            }
            if ((behaviour = targetedAgentName != null ? new AbstractParadiseToolAgent.ListAgentsBehaviour((AbstractParadiseToolAgent)this, targetedAgentName, (String)Paradise.functionnalities.get(guiEvent.getType()), answerBehaviour, this.paradiseTool.getProgressMonitor()) : new AbstractParadiseToolAgent.ListAgentsBehaviour((AbstractParadiseToolAgent)this, (String)Paradise.functionnalities.get(guiEvent.getType()), answerBehaviour, this.paradiseTool.getProgressMonitor())) != null) {
                this.addBehaviour((Behaviour)behaviour);
            }
        }
    }

    protected class LoadStructuralDataFromS2S
    extends CyclicBehaviour {
        protected LoadStructuralDataFromS2S() {
        }

        public void action() {
            ACLMessage message = this.myAgent.receive(MessageTemplate.and((MessageTemplate)MessageTemplate.MatchConversationId((String)"inferred 3D"), (MessageTemplate)MessageTemplate.MatchPerformative((int)16)));
            if (message != null) {
                ArrayList molecules;
                try {
                    molecules = (ArrayList)message.getContentObject();
                }
                catch (UnreadableException e) {
                    e.printStackTrace();
                    return;
                }
                Parameters parameters = new Parameters();
                Iterator properties = message.getEnvelope().getAllProperties();
                while (properties.hasNext()) {
                    Property prop = (Property)properties.next();
                    if (!prop.getName().equals("parameters")) continue;
                    for (Parameter p : ((Parameters)prop.getValue()).getParameters()) {
                        parameters.addParameter(p);
                    }
                }
                if (molecules != null && parameters != null) {
                    Parameters _parameters = parameters.getParameters("tool-name");
                    Parameters __parameters = parameters.getParameters("paradise-version");
                    if (_parameters.size() == 1 && __parameters.size() == 1) {
                        if (_parameters.getParameter(0).getValue().startsWith("S2S") && __parameters.getParameter(0).getValue().equals("1.0")) {
                            new ParadiseTask((Application)((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()), ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getProgressMonitor()){

                                protected Object doInBackground() {
                                    try {
                                        List tss = ((Molecule)molecules.get(0)).getSelectedFeatures(TertiaryStructure.class);
                                        List sss = ((Molecule)molecules.get(0)).getSelectedFeatures(SecondaryStructure.class);
                                        ArrayList<RNA> newMolecules = new ArrayList<RNA>();
                                        if (!tss.isEmpty()) {
                                            TertiaryStructure remoteTS = (TertiaryStructure)tss.get(0);
                                            SecondaryStructure remoteSS = (SecondaryStructure)remoteTS.getLinkedSecondaryStructures().get(0);
                                            for (Molecule m : remoteSS.getMolecules()) {
                                                if (((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool().getWorkingSession().getMolecules().contains(m)) continue;
                                                newMolecules.add(((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool().getWorkingSession().createRNA(new ParadiseID(m.getParadiseID().getValue()), m.getName(), m.getSource(), m.printSequence()));
                                            }
                                            StructuralFeatureFactory factory = ((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool().createStructuralFeatureFactory();
                                            TertiaryStructure localTS = factory.copyTertiaryStructure(newMolecules, remoteTS);
                                            SecondaryStructure localSS = factory.copySecondaryStructure(newMolecules, remoteSS, true);
                                            localTS.linkSecondaryStructure(localSS);
                                            ((Assemble)((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool()).getMediator().loadRNASecondaryStructure(localSS);
                                            ((Assemble)((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool()).getMediator().createModel(localSS, localTS);
                                            ((Assemble)((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool()).getMediator().startAnimator();
                                        } else if (!sss.isEmpty()) {
                                            SecondaryStructure remoteSS = (SecondaryStructure)sss.get(0);
                                            for (Molecule m : remoteSS.getMolecules()) {
                                                if (((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool().getWorkingSession().getMolecules().contains(m)) continue;
                                                newMolecules.add(((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool().getWorkingSession().createRNA(new ParadiseID(m.getParadiseID().getValue()), m.getName(), m.getSource(), m.printSequence()));
                                            }
                                            StructuralFeatureFactory factory = ((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool().createStructuralFeatureFactory();
                                            SecondaryStructure localSS = factory.copySecondaryStructure(newMolecules, remoteSS, true);
                                            ((Assemble)((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool()).getMediator().loadRNASecondaryStructure(localSS);
                                            ((Assemble)((ParadiseToolAgent)LoadStructuralDataFromS2S.this.myAgent).getParadiseTool()).getMediator().startAnimator();
                                        }
                                    }
                                    catch (BiologicalSymbolException e) {
                                        e.printStackTrace();
                                    }
                                    return null;
                                }
                            }.execute();
                        } else if (!__parameters.getParameter(0).getValue().equals("1.0")) {
                            JOptionPane.showMessageDialog(null, "Assemble cannot load the data sent by the S2S application: the paradise engines are different!!");
                        }
                    }
                }
            } else {
                this.block();
            }
        }
    }
}

