/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.behaviours;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.gui.event.SelectionTransmitter;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.ResidueNA;
import fr.unistra.ibmc.assemble.utils.ModelingUtils;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Apply3DFoldRequestAnswerBehaviour
extends AnswerBehaviour
implements SelectionTransmitter {
    private List<Residue> assembleResidues;

    public Apply3DFoldRequestAnswerBehaviour(ArrayList<Molecule> selectedMolecules, Parameters selectedParameters, List<Residue> assembleResidues) {
        super(selectedMolecules, selectedParameters);
        this.assembleResidues = assembleResidues;
    }

    public void action() {
        ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
        if (message != null && message.getPerformative() == 11) {
            try {
                List referenceResidues = ((TertiaryStructure)((Molecule)((ArrayList)message.getContentObject()).get(0)).getSelectedFeatures(TertiaryStructure.class).get(0)).getResidues3D();
                if (this.assembleResidues.contains(((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRenderer().getResidueContainingSelectionPivot())) {
                    ModelingUtils.applyFold(this.assembleResidues, referenceResidues, ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRenderer().getResidueContainingSelectionPivot());
                } else {
                    ModelingUtils.applyFold(this.assembleResidues, referenceResidues, this.assembleResidues.get(0));
                }
                for (Residue r : this.assembleResidues) {
                    Residue o = r.getNext();
                    if (o != null && !this.assembleResidues.contains(o)) {
                        ((ResidueNA)o).splitChain();
                    }
                    if ((o = r.getPrev()) == null || this.assembleResidues.contains(o)) continue;
                    ((ResidueNA)r).splitChain();
                }
                String name = JOptionPane.showInputDialog("Choose a name for your motif");
                if (name == null || name.length() == 0) {
                    name = "RNA motif";
                }
                UserSelection us = new UserSelection(((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator(), name);
                ArrayList<fr.unistra.ibmc.paradise.core.utils.Residue> paradiseResidues = new ArrayList<fr.unistra.ibmc.paradise.core.utils.Residue>();
                for (Residue r : this.assembleResidues) {
                    us.add(r);
                    paradiseResidues.add((fr.unistra.ibmc.paradise.core.utils.Residue)r.getResidue3D().getResidues().iterator().next());
                }
                ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().addUserSelection(us);
                ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().fireResiduesSelected(this, paradiseResidues, false);
                ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().fireModelModified();
                this.monitor.printMessage("End of Analysis");
            }
            catch (Exception e) {
                this.monitor.printException(e);
            }
            this.monitor.stopAnimation();
            this.done = true;
            this.selectedMolecules.clear();
            this.selectedParameters.clear();
        } else if (message != null && message.getPerformative() == 7) {
            this.monitor.printMessage(message.getContent());
        } else if (message != null && message.getPerformative() == 6) {
            try {
                this.monitor.printException((Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
        }
    }
}

