/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.behaviours;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.ParadiseToolAgent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TertiaryStructureRefinementAnswerBehaviour
extends AnswerBehaviour {
    public TertiaryStructureRefinementAnswerBehaviour(ArrayList<Molecule> selectedMolecules, Parameters selectedParameters) {
        super(selectedMolecules, selectedParameters);
    }

    public void action() {
        ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
        if (message != null && message.getPerformative() == 11) {
            try {
                ArrayList serverMolecules = (ArrayList)message.getContentObject();
                for (Molecule remoteMolecule : serverMolecules) {
                    Molecule localMolecule = null;
                    for (Molecule m : this.selectedMolecules) {
                        if (!m.getParadiseID().equals((Object)remoteMolecule.getParadiseID())) continue;
                        localMolecule = m;
                        break;
                    }
                    if (localMolecule == null) {
                        this.monitor.printMessage("Could not find a correspondance between remote molecules and local ones");
                        this.monitor.stopAnimation();
                        this.done = true;
                        return;
                    }
                    for (ParadiseFeature feature : remoteMolecule.getSelectedFeatures()) {
                        Residue3D remoteResidue = (Residue3D)feature;
                        Residue3D localResidue = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().getTertiaryStructure().getResidue3DAt(remoteResidue.getFullLocation(remoteMolecule).getStart(), localMolecule);
                        for (Residue3D.Atom remoteAtom : remoteResidue.getAtoms()) {
                            if (!remoteAtom.hasCoordinatesFilled()) continue;
                            localResidue.getAtom(remoteAtom.getName()).setCoordinates(remoteAtom.getX(), remoteAtom.getY(), remoteAtom.getZ());
                        }
                        Residue res = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().getResidueFor(localResidue);
                        if (res == null) continue;
                        res.updateCoordinatesFromParadise();
                    }
                    ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().fireModelModified();
                    ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
                }
                this.monitor.printMessage("End of Analysis");
            }
            catch (Exception e) {
                this.monitor.printException(e);
            }
            this.monitor.stopAnimation();
            this.done = true;
        } else if (message != null && message.getPerformative() == 7) {
            this.monitor.printMessage(message.getContent());
        } else if (message != null && message.getPerformative() == 6) {
            try {
                this.monitor.printException((Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
        }
    }
}

