/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.FPSAnimator;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import fr.unistra.ibmc.assemble.AssembleAgent;
import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.behaviours.Apply3DFoldRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.SecondaryStructurePredictionRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.TertiaryStructureAnnotationRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.TertiaryStructureLoadedFromMyPDBRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.gui.AssembleKeyListener;
import fr.unistra.ibmc.assemble.gui.RnartDialog;
import fr.unistra.ibmc.assemble.gui.SecondaryStructureNavigator;
import fr.unistra.ibmc.assemble.gui.SplashScreen;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.gui.event.SelectionTransmitter;
import fr.unistra.ibmc.assemble.gui.labels.AngleLabel;
import fr.unistra.ibmc.assemble.gui.labels.AtomLabel;
import fr.unistra.ibmc.assemble.gui.labels.DihedralLabel;
import fr.unistra.ibmc.assemble.gui.labels.DistanceLabel;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.gui.rendering.Renderer;
import fr.unistra.ibmc.assemble.maps.EDMap;
import fr.unistra.ibmc.assemble.mypdb.MyPDBHit;
import fr.unistra.ibmc.assemble.mypdb.MyPDBQuery;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Rna2DViewer;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.ResidueNA;
import fr.unistra.ibmc.assemble.utils.AssembleConfig;
import fr.unistra.ibmc.assemble.utils.AssembleModelParser;
import fr.unistra.ibmc.assemble.utils.RessourcesUtils;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.features.Uracil3D;
import fr.unistra.ibmc.paradise.core.io.BPSeqFileIO;
import fr.unistra.ibmc.paradise.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.core.io.FastaFileIO;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.io.ParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.ParadiseProjectIO;
import fr.unistra.ibmc.paradise.core.utils.GeneralUtils;
import fr.unistra.ibmc.paradise.core.utils.IOUtils;
import fr.unistra.ibmc.paradise.core.utils.JavaLibraryPath;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;
import fr.unistra.ibmc.paradise.core.utils.ZipExtractionPrintingDevice;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseGUITool;
import fr.unistra.ibmc.paradise.tools.Paradise;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.tools.component.FileParsingTask;
import fr.unistra.ibmc.paradise.tools.component.MemoryMonitor;
import fr.unistra.ibmc.paradise.tools.component.OpenFileFilter;
import fr.unistra.ibmc.paradise.tools.component.ParadiseTask;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import jade.core.Agent;
import jade.domain.DFService;
import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import javax.imageio.ImageIO;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;
import org.jdesktop.application.Application;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.PushAwayMode;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assemble
extends AbstractParadiseGUITool
implements SelectionTransmitter {
    public static final String version = "1.0";
    public static Color ADENINE_COLOR = Color.blue;
    public static Color URACILE_COLOR = Color.green;
    public static Color GUANINE_COLOR = Color.red;
    public static Color CYTOSINE_COLOR = Color.yellow;
    public static final int SELECT_ATOM = 0;
    public static final int SELECT_RESIDUE = 1;
    public static final int SELECT_CHAIN = 2;
    public static final int SELECT_INTERACTION = 3;
    public static final int SELECT_STRUCTURAL_DOMAIN = 4;
    public static boolean USE_ABSOLUTE_NUMBERING_SYSTEM = true;
    public static boolean DRAW_BACKBONE_BETWEEN_MOLECULAR_CHAINS = false;
    private static final String[] selectedStructures = new String[]{"157D", "1A34", "1A9N", "1C04", "1C0A", "1CSL", "1D4R", "1DDY", "1DFU", "1DI2", "1DPL", "1DQF", "1DRZ", "1E7K", "1E8O", "1EC6", "1EFW", "1EHZ", "1ET4", "1EVP", "1F1T", "1F27", "1F7U", "1FIR", "1FUF", "1G1X", "1GAX", "1GID", "1GRZ", "1H3E", "1H4S", "1HQ1", "1HR2", "1HVU", "1I2X", "1I2Y", "1I6U", "1I9V", "1I9X", "1ID9", "1IL2", "1J1U", "1J2B", "1J5E", "1J9H", "1JBR", "1JBS", "1JBT", "1JID", "1JJ2", "1JZV", "1K8W", "1K9W", "1KD3", "1KH6", "1KOG", "1KUQ", "1KXK", "1L2X", "1L9A", "1LNG", "1LNT", "1MFQ", "1MHK", "1MJI", "1MMS", "1MZP", "1N38", "1N78", "1NBS", "1NLC", "1NTA", "1OB2", "1OOA", "1P6V", "1PWF", "1Q96", "1Q9A", "1QA6", "1QBP", "1QC0", "1QF6", "1QTQ", "1QU2", "1QZW", "1R3E", "1R9F", "1RC7", "1RLG", "1RNA", "1S03", "1S72", "1SER", "1SZ1", "1T0E", "1T0K", "1TTT", "1U0B", "1U1Y", "1U63", "1U6B", "1U9S", "1UN6", "1URN", "1VFG", "1WSU", "1WZ2", "1X8W", "1XJR", "1XOK", "1XPE", "1Y0Q", "1Y26", "1Y69", "1Y77", "1YRJ", "1YTU", "1YYK", "1YYW", "1YZ9", "1YZD", "1Z7F", "1ZBH", "1ZCI", "1ZDJ", "1ZDK", "1ZEV", "1ZFT", "1ZH5", "1ZHO", "1ZSE", "205D", "246D", "259D", "280D", "2A0P", "2A2E", "2A43", "2A64", "2AB4", "2ANN", "2ANR", "2AO5", "2AVY", "2AW4", "2AZ0", "2AZX", "2B2D", "2B3J", "2B63", "2BH2", "2BQ5", "2BS0", "2BTE", "2BU1", "2C4Y", "2C4Z", "2C50", "2C51", "2CKY", "2CT8", "2CZJ", "2D6F", "2DER", "2DET", "2DLC", "2DR2", "2DR8", "2DU3", "2E9R", "2E9Z", "2EZ6", "2F8K", "2F8S", "2FCX", "2FCZ", "2FK6", "2FMT", "2FQN", "2G3S", "2G5K", "2G91", "2G9C", "2GDI", "2GIS", "2GXB", "2H1M", "2HOJ", "2HOP", "2HVY", "2HW8", "2I82", "2IL9", "2IPY", "2IY5", "2IZ9", "2IZN", "2J01", "2NPY", "2NR0", "2NRE", "2NUE", "2OE5", "2OEU", "2OIU", "2OIY", "2OUE", "2OZB", "2P7E", "2PJP", "2PWT", "2PXL", "2QBZ", "2QUX", "2R20", "2R22", "2R8S", "2R92", "2R93", "2RFK", "2TRA", "2UWM", "2V3C", "2V6W", "2Z75", "315D", "332D", "353D", "354D", "361D", "364D", "377D", "387D", "397D", "3B31", "3BSO", "3TRA", "402D", "409D", "418D", "419D", "420D", "422D", "430D", "433D", "438D", "439D", "472D", "480D", "485D", "488D", "5MSF", "6MSF", "7MSF"};
    private static final String[] selectedStructuresWithProblems = new String[]{"1B23", "1B7F", "1BY4", "1CVJ", "1DUQ", "1EGK", "1FEU", "1HMH", "1J8G", "1L3Z", "1M5O", "1M8V", "1MME", "1N35", "1N7A", "1NUJ", "1NYI", "1Q2R", "1R9S", "1RPU", "1SDR", "1TFW", "1TFY", "1T0D", "1UTD", "1YKV", "1YLS", "1YVP", "1ZE2", "1ZX7", "2A04", "2AWE", "2BGG", "2BJ6", "2DEU", "2E9T", "2EC0", "2G32", "2G92", "2GJW", "2GRB", "2I91", "2NOK", "2NQP", "2NUG", "2Q1O", "2NZ4", "2VAL", "398D", "429D", "434D", "435D", "466D"};
    private static List<PDBIcon> pdbIcons = new ArrayList<PDBIcon>();
    private static Map<String, List<RNAMotifIcon>> motifsIcons = new Hashtable<String, List<RNAMotifIcon>>();
    private MyRNAMotifsPanel myRNAMotifsPanel;
    private MyPDBPanel myPDBPanel;
    private SecondaryStructureNavigator secondaryStructureNavigator;
    public MessageBar messageBar;
    private StructuralFeatureFactory structuralFactory;
    private static int motifsIconSize = 200;
    FileMenu file;
    SecondaryModelMenu secondaryModel;
    TertiarySelectionMenu tertiarySelection;
    StereoMenu stereo;
    TertiaryModelMenu tertiaryModel;
    EditMenu edit;
    PluginsMenu plugins;
    HelpMenu help;
    private AssembleToolBar toolBar;
    private Mediator mediator;
    private Frame modelFrame;
    public static int NUMBERING_FREQUENCY = 5;

    public void tileVertically() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.setSize((int)screenSize.getWidth(), (int)screenSize.getHeight() / 2);
        this.window.setLocation(0, 0);
        this.window.validate();
        Rectangle r = this.window.getBounds();
        this.modelFrame.setSize((int)screenSize.getWidth(), (int)(screenSize.getHeight() - r.getHeight()));
        this.modelFrame.setLocation(0, (int)r.getHeight());
        this.modelFrame.validate();
    }

    public void tileHorizontally() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.setSize((int)screenSize.getWidth() / 2, (int)screenSize.getHeight());
        this.window.setLocation(0, 0);
        this.window.validate();
        Rectangle r = this.window.getBounds();
        this.modelFrame.setSize((int)(screenSize.getWidth() - r.getWidth()), (int)screenSize.getHeight());
        this.modelFrame.setLocation((int)r.getWidth(), 0);
        this.modelFrame.validate();
    }

    public SecondaryStructureNavigator getSecondaryStructureNavigator() {
        return this.secondaryStructureNavigator;
    }

    public static File getUserDir() {
        File f = new File(new StringBuffer(System.getProperty("user.home")).append(System.getProperty("file.separator")).append(".assemble").toString());
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(f, version)).exists()) {
            f.mkdir();
        }
        return f;
    }

    public static File getMyPDBDir() {
        File f = new File(Assemble.getUserDir(), "mypdb");
        if (!f.exists()) {
            f.mkdir();
        }
        return f;
    }

    public static String getInstallPath() {
        return URLDecoder.decode(Assemble.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("assemble.jar")[0]);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.messageBar;
    }

    public void setModelManagerTitle(String title) {
        ((JXFrame)this.window).setTitle(title);
    }

    public void set3DSceneTitle(String title) {
        this.modelFrame.setTitle(title);
    }

    public MainParadiseFeature getCurrentFeature() {
        if (this.mediator == null || this.mediator.get3DModel() == null && this.mediator.get2DModel() == null) {
            return null;
        }
        if (this.mediator.get3DModel() != null) {
            return this.mediator.get3DModel().getTertiaryStructure();
        }
        return this.mediator.get2DModel().getSecondaryStructure();
    }

    public Assemble(ParadiseWorkingSession pws, SplashScreen splashScreen) {
        super("Assemble 1.0", pws);
        File dataZipped = new File(Assemble.getInstallPath(), "mypdb.zip");
        if ((!Assemble.getMyPDBDir().exists() || Assemble.getMyPDBDir().listFiles().length == 0) && dataZipped.exists()) {
            splashScreen.label.setText("MyPDB initialization...");
            Assemble.getMyPDBDir().mkdir();
            splashScreen.setTotalFileToExtract(selectedStructures.length * 14);
            try {
                IOUtils.extractArchivedFile((String)Assemble.getMyPDBDir().getAbsolutePath(), (File)dataZipped, (ZipExtractionPrintingDevice)splashScreen);
                dataZipped.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        splashScreen.label.setText("Loading MyPDB and MyMotifs...");
        File[] pdbDirs = Assemble.getMyPDBDir().listFiles(new java.io.FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        splashScreen.progressBar.setIndeterminate(false);
        splashScreen.progressBar.setValue(0);
        splashScreen.progressBar.setMaximum(pdbDirs.length);
        int i = 0;
        for (File pdbDir : pdbDirs) {
            ++i;
            try {
                splashScreen.progressBar.setValue(i);
                pdbIcons.add(new PDBIcon(pdbDir.getName()));
                File motifsDir = pdbDir.listFiles(new java.io.FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() && "motifs".equals(f.getName());
                    }
                })[0];
                for (File motifDir : motifsDir.listFiles(new java.io.FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory();
                    }
                })) {
                    for (File motif : motifDir.listFiles(new java.io.FileFilter(){

                        public boolean accept(File f) {
                            return f.getName().endsWith(".rnaml");
                        }
                    })) {
                        if (motifsIcons.containsKey(motifDir.getName())) {
                            motifsIcons.get(motifDir.getName()).add(new RNAMotifIcon(pdbDir.getName(), motif.getName().split("\\.")[0], motifDir.getName()));
                            continue;
                        }
                        ArrayList<RNAMotifIcon> icons = new ArrayList<RNAMotifIcon>();
                        icons.add(new RNAMotifIcon(pdbDir.getName(), motif.getName().split("\\.")[0], motifDir.getName()));
                        motifsIcons.put(motifDir.getName(), icons);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        splashScreen.dispose();
    }

    public void updateTitle() {
        ((JXFrame)this.window).setTitle(((JXFrame)this.window).getTitle());
    }

    public void setComputeMode(boolean value) {
        if (value) {
            ((JFrame)this.window).getContentPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ((JFrame)this.window).getContentPane().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public StructuralFeatureFactory getStructuralFeatureFactory() {
        if (this.structuralFactory == null) {
            this.structuralFactory = this.createStructuralFeatureFactory();
        }
        return this.structuralFactory;
    }

    public Mediator getMediator() {
        return this.mediator;
    }

    public void synchronize() {
        if (this.mediator.get3DModel() != null) {
            this.mediator.get3DModel().saveCoordinatesToParadise();
            ArrayList<Residue3D> residuesDisplayed = new ArrayList<Residue3D>();
            for (fr.unistra.ibmc.assemble.structures.Residue r : this.mediator.get3DModel().getResidues()) {
                residuesDisplayed.add(r.getResidue3D());
            }
            for (fr.unistra.ibmc.assemble.structures.Residue r : this.mediator.get3DModel().getTertiaryStructure().getResidues3D()) {
                if (residuesDisplayed.contains(r)) continue;
                this.mediator.get3DModel().getTertiaryStructure().removeResidue3D((Residue3D)r);
            }
        }
    }

    public void receiveSelectedResiduesFromTheOutside(Collection<Residue> residues) {
        if (this.mediator.get2DModel() != null) {
            this.mediator.fireResiduesSelected(this, new ArrayList<Residue>(residues), false);
        }
    }

    public fr.unistra.ibmc.assemble.structures.Residue getAssembleResidue(Residue paradiseResidue) {
        return this.mediator.get3DModel().getResidue(paradiseResidue);
    }

    public List<Atom> getAtomsForStructuralDomain(StructuralDomain domain) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Residue r : domain.getResidues().getResidues()) {
            fr.unistra.ibmc.assemble.structures.Residue _r = this.mediator.getAssemble().getAssembleResidue(r);
            if (_r == null) continue;
            atoms.addAll(_r.getAtoms());
        }
        return atoms;
    }

    public void toForeGround() {
        this.window.toFront();
    }

    protected void startup() {
        this.window = new JXFrame(this.getDescription());
        JXFrame cfr_ignored_0 = (JXFrame)this.window;
        ((JXFrame)this.window).setDefaultCloseOperation(0);
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "macosx"));
            } else if (osName.startsWith("Windows")) {
                if (System.getProperty("sun.arch.data.model").equals("32")) {
                    System.out.println("Loading Windows 32 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "win32"));
                } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                    System.out.println("Loading Windows 64 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "win64"));
                } else {
                    System.err.println("Your Windows system is not recognized as either a 32bit nor a 64bit platform");
                    System.exit(1);
                }
            } else if (osName.startsWith("Linux") || osName.startsWith("FreeBSD")) {
                if (System.getProperty("sun.arch.data.model").equals("32")) {
                    System.out.println("Loading Linux32 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "linux32"));
                } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                    System.out.println("Loading Linux64 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "linux64"));
                } else {
                    System.err.println("Your linux system is not recognized as either a 32bit nor a 64bit platform");
                    System.exit(1);
                }
            } else {
                System.err.println("Your system in not recognized as Windows, MacOS or Linux : no appropriate 3D drivers available. sorry.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (JOptionPane.showConfirmDialog(null, "Are you sure you want to exit Assemble?", "Confirm exit", 0) == 0) {
                    try {
                        for (File f : new File(System.getProperty("user.dir")).listFiles()) {
                            if (!f.getName().startsWith("MTPs-") && !f.getName().equals("APDescription.txt")) continue;
                            f.delete();
                        }
                        AssembleConfig.save();
                        DFService.deregister((Agent)((GuiAgent)Assemble.this.agent));
                        Assemble.this.workingSession.getAgentContainer().kill();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    System.exit(0);
                }
            }
        });
        this.mediator = new Mediator(this);
        this.mediator.setToolWindowManager(new MyDoggyToolWindowManager());
        this.mediator.getToolWindowManager().getToolWindowManagerDescriptor().setPushAwayMode(PushAwayMode.HORIZONTAL);
        Rna2DViewer rna2dViewer = new Rna2DViewer(this.workingSession, this.mediator);
        rna2dViewer.addKeyListener(new AssembleKeyListener(this.mediator));
        ((JFrame)this.window).setTitle("Assemble: Model Manager");
        this.messageBar = new MessageBar();
        AssembleDisplayPanel assembleDisplayPanel = new AssembleDisplayPanel();
        JScrollPane assembleDisplayPanelScrollPane = new JScrollPane((Component)((Object)assembleDisplayPanel));
        assembleDisplayPanelScrollPane.getViewport().setBackground(Color.WHITE);
        AssembleSelectionPanel assembleSelectionPanel = new AssembleSelectionPanel();
        JScrollPane assembleSelectionPanelScrollPane = new JScrollPane((Component)((Object)assembleSelectionPanel));
        assembleSelectionPanelScrollPane.getViewport().setBackground(Color.WHITE);
        AssembleEditionPanel assembleEditionPanel = new AssembleEditionPanel();
        JScrollPane assembleEditionPanelScrollPane = new JScrollPane((Component)((Object)assembleEditionPanel));
        assembleEditionPanelScrollPane.getViewport().setBackground(Color.WHITE);
        CreateRNAMotifPanel rnamotifPanel = new CreateRNAMotifPanel();
        JScrollPane rnaMotifPanelScrollPane = new JScrollPane((Component)((Object)rnamotifPanel));
        rnaMotifPanelScrollPane.getViewport().setBackground(Color.WHITE);
        SecondaryStructureDisplayPanel ssDisplayPanel = new SecondaryStructureDisplayPanel();
        JScrollPane ssDisplayPanelScrollPane = new JScrollPane((Component)((Object)ssDisplayPanel));
        ssDisplayPanelScrollPane.getViewport().setBackground(Color.WHITE);
        this.secondaryStructureNavigator = new SecondaryStructureNavigator(rna2dViewer.getRna2DViewerMediator(), this.mediator);
        JScrollPane navigatorScrollPane = new JScrollPane((Component)((Object)this.secondaryStructureNavigator));
        navigatorScrollPane.getViewport().setBackground(Color.WHITE);
        this.mediator.getToolWindowManager().getContentManager().addContent("2DView", "2D Viewer", null, (Component)new JScrollPane(rna2dViewer));
        ToolWindow toolWindow = this.mediator.getToolWindowManager().registerToolWindow("Explorer", "Model Explorer", null, (Component)navigatorScrollPane, ToolWindowAnchor.LEFT);
        DockedTypeDescriptor descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(200);
        descriptor.setPreviewEnabled(false);
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("CreateRNAMotif", "Create RNA motif", null, (Component)rnaMotifPanelScrollPane, ToolWindowAnchor.RIGHT);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        this.myPDBPanel = new MyPDBPanel();
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("MyPDB", "My PDB", RessourcesUtils.getIcon("16/images.png"), (Component)this.myPDBPanel, ToolWindowAnchor.RIGHT);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        PreferencesPanel preferencesPanel = new PreferencesPanel();
        JScrollPane preferencesPanelScrollPane = new JScrollPane((Component)((Object)preferencesPanel));
        preferencesPanelScrollPane.getViewport().setBackground(Color.WHITE);
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("Preferences", "Preferences", RessourcesUtils.getIcon("16/preferences.png"), (Component)preferencesPanelScrollPane, ToolWindowAnchor.RIGHT);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("News", "News", RessourcesUtils.getIcon("16/feed.png"), (Component)((Object)new NewsPanel()), ToolWindowAnchor.BOTTOM);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(50);
        descriptor.setPreviewEnabled(false);
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("Search", "Search", null, (Component)((Object)new MyPDBSearchPanel()), ToolWindowAnchor.BOTTOM);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(200);
        descriptor.setPreviewEnabled(false);
        this.myRNAMotifsPanel = new MyRNAMotifsPanel();
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("MyMotifs", "My RNA Motifs", RessourcesUtils.getIcon("16/images.png"), (Component)this.myRNAMotifsPanel, ToolWindowAnchor.BOTTOM);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(200);
        descriptor.setPreviewEnabled(false);
        for (ToolWindow window : this.mediator.getToolWindowManager().getToolWindows()) {
            window.setAvailable(true);
        }
        this.window.add((Component)rna2dViewer.getToolbar(), "North");
        this.window.add((Component)this.mediator.getToolWindowManager(), "Center");
        this.window.add((Component)this.messageBar, "South");
        ((JXFrame)this.window).setJMenuBar((JMenuBar)new AssembleMenu());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.pack();
        Renderer r = this.mediator.getRenderer();
        r.addKeyListener(new AssembleKeyListener(this.mediator));
        r.setPreferredSize(new Dimension((int)((double)screenSize.width * 0.8), (int)((double)screenSize.height * 0.4)));
        FPSAnimator animator = new FPSAnimator(30);
        animator.add((GLAutoDrawable)r);
        this.mediator.setAnimator((Animator)animator);
        this.modelFrame = new Frame("Assemble: 3D Model");
        this.modelFrame.setLayout(new BorderLayout());
        this.modelFrame.add((Component)((Object)this.mediator.getRenderer()), "Center");
        this.toolBar = new AssembleToolBar();
        this.modelFrame.add((Component)this.toolBar, "North");
        this.mediator.getRenderer().setJFrame(this.modelFrame);
        this.modelFrame.pack();
        this.window.setSize(this.modelFrame.getSize());
        this.window.setLocation((int)((double)screenSize.width * 0.1), (int)((double)screenSize.height * 0.025));
        this.modelFrame.setLocation((int)this.window.getLocation().getX(), (int)(this.window.getLocation().getY() + (double)this.window.getHeight()));
        this.window.addKeyListener(new AssembleKeyListener(this.mediator));
        this.modelFrame.addKeyListener(new AssembleKeyListener(this.mediator));
        this.window.setVisible(true);
        this.modelFrame.setVisible(true);
        IOUtils.setLastWorkingDirectory((File)new File(Assemble.getInstallPath(), "samples"));
    }

    public void bringNextResidueCloser() {
        this.toolBar.previousMolecularChainCloser.doClick();
    }

    public void bringNextMolecularChainCloser() {
        this.toolBar.nextResiduesCloser.doClick();
    }

    public void bringNextStructuralDomainCloser() {
        this.toolBar.nextStructuralDomainCloser.doClick();
    }

    public void bringNextUserSelectionCloser() {
    }

    public void invertSelection() {
        List<fr.unistra.ibmc.assemble.structures.Residue> allResidues = this.mediator.get3DModel().getResidues();
        allResidues.removeAll(this.mediator.getGlobalSelection().getSelectedResidues());
        this.mediator.getGlobalSelection().clear();
        for (fr.unistra.ibmc.assemble.structures.Residue r : allResidues) {
            this.mediator.getGlobalSelection().add(r);
        }
        this.mediator.getGlobalSelection().fireRenderingModified();
    }

    public void showAll() {
        this.tertiaryModel.showAll.doClick();
    }

    public void showSelectionOnly() {
        this.tertiarySelection.showSelectionOnly.doClick();
    }

    public void hideSelectionOnly() {
        this.tertiarySelection.hideSelectionOnly.doClick();
    }

    public void showLabelsForSelection() {
        this.tertiarySelection.showLabels.doClick();
    }

    public void hideLabelsForSelection() {
        this.tertiarySelection.hideLabels.doClick();
    }

    public void cutChain() {
        this.toolBar.cut.doClick();
    }

    public void openTorsionAnglePanel() {
        this.toolBar.twist.doClick();
    }

    public void linkChains() {
        this.toolBar.link.doClick();
    }

    public void deleteResidues() {
        this.toolBar.deleteResidues.doClick();
    }

    public void storeSelection() {
        this.tertiarySelection.createUserSelection.doClick();
    }

    public void addToUndoHistory() {
        this.toolBar.acceptModel.doClick();
    }

    public void colorSelectionByResidueType() {
        this.tertiarySelection.colorByResidueType.doClick();
    }

    public void colorSelectionByAtomType() {
        this.tertiarySelection.colorByAtomType.doClick();
    }

    public void colorSelectionByCustomColor() {
        this.tertiarySelection.customColorMenu.doClick();
    }

    public JFrame getFrame() {
        return (JFrame)this.window;
    }

    public static boolean updateAssemble() {
        try {
            URL updates = new URL("http://ftp.bioinformatics.org/pub/assemble/updates.xml");
            URLConnection urlConnection = updates.openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.connect();
            InputStream stream = urlConnection.getInputStream();
            SAXBuilder sxb = new SAXBuilder();
            Document doc = sxb.build(stream);
            List versions = doc.getRootElement().getChildren("version");
            if (!versions.isEmpty()) {
                if ("Assemble 1.0".equals(((Element)versions.get(0)).getChild("name").getText())) {
                    JOptionPane.showMessageDialog(null, "Assemble is up to date");
                    return false;
                }
                new UpdateFrame(versions);
                return true;
            }
            JOptionPane.showMessageDialog(null, "Assemble is up to date");
            return false;
        }
        catch (Exception e) {
            ErrorInfo errorInfo = new ErrorInfo("Error", "Problem during the update", null, null, (Throwable)e, Level.SEVERE, null);
            JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
            return false;
        }
    }

    public static File getPluginsPath() {
        File f = new File(Assemble.getUserDir(), "plugins");
        if (!f.exists()) {
            f.mkdir();
        }
        return f;
    }

    private void load3DStructure(final String pdbID, final boolean displayInAssemble, final MyPDBHit hit) {
        File pdbFile;
        if (displayInAssemble) {
            if ((this.mediator.get3DModel() != null || this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(this.window, "Are you sure to remove your current Model?")) {
                return;
            }
            if (this.mediator.get3DModel() != null || this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                this.mediator.clearSession();
            }
            this.mediator.stopAnimator();
        }
        if ((pdbFile = new File(new File(Assemble.getMyPDBDir(), pdbID), pdbID + ".pdb")).exists()) {
            final PDBFileIO pdbParser = new PDBFileIO((MoleculeFactory)this.workingSession);
            new FileParsingTask((Application)this, pdbFile, (ParadiseFileIO)pdbParser, this.messageBar, this.workingSession){

                protected void finished() {
                    TertiaryStructure ts = (TertiaryStructure)pdbParser.getTertiaryStructures().get(0);
                    GuiEvent ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("3D annotation"));
                    ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                    for (Molecule m : ts.getMolecules()) {
                        m.removeAllSelectedFeatures();
                        for (Residue3D r : ts.getSubFeatures(Residue3D.class, m)) {
                            m.addSelectedFeature((ParadiseFeature)r);
                        }
                        molecules.add(m);
                    }
                    ArrayList<Residue> residuesToHightlight = new ArrayList<Residue>();
                    if (hit != null) {
                        for (Map.Entry<String, Location> entry : hit.getLocations().entrySet()) {
                            for (int pos : entry.getValue().getSinglePositions()) {
                                residuesToHightlight.add(new Residue(pos, Assemble.this.workingSession.getMolecule(new ParadiseID(Long.parseLong(entry.getKey())))));
                            }
                        }
                    }
                    ev.addParameter((Object)new TertiaryStructureLoadedFromMyPDBRequestAnswerBehaviour(new ArrayList<Molecule>(molecules), new Parameters(), pdbID, displayInAssemble, residuesToHightlight));
                    ((AssembleAgent)Assemble.this.getAgent()).postGuiEvent(ev);
                }
            }.execute();
        } else {
            ParadiseProjectIO parser = new ParadiseProjectIO((MoleculeFactory)this.workingSession);
            new FileParsingTask((Application)this, new File(new File(Assemble.getMyPDBDir(), pdbID), "model"), (ParadiseFileIO)parser, this.messageBar, this.workingSession, (ParadiseFileIO)parser, hit){
                final /* synthetic */ ParadiseFileIO val$parser;
                final /* synthetic */ MyPDBHit val$hit;
                {
                    this.val$parser = paradiseFileIO;
                    this.val$hit = myPDBHit;
                    super(x0, x1, x2, x3, x4);
                }

                protected void finished() {
                    new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                        protected Object doInBackground() {
                            block11: {
                                try {
                                    List tss = val$parser.getTertiaryStructures();
                                    if (tss.isEmpty()) break block11;
                                    if (tss.size() > 1) {
                                        Object[] names = new String[tss.size()];
                                        for (int i = 0; i < names.length; ++i) {
                                            names[i] = ((TertiaryStructure)tss.get(i)).getName();
                                        }
                                        String name = (String)JOptionPane.showInputDialog(Assemble.this.window, "Choose a 3D model", "Choose 3D model", -1, null, names, names[0]);
                                        if (name != null) {
                                            for (TertiaryStructure ts : tss) {
                                                if (!ts.getName().equals(name)) continue;
                                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0));
                                                Assemble.this.mediator.createModel((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0), ts);
                                                break;
                                            }
                                        }
                                    } else {
                                        Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0));
                                        Assemble.this.mediator.createModel((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0), (TertiaryStructure)tss.get(0));
                                    }
                                    Assemble.this.mediator.startAnimator();
                                    ArrayList<Residue> residuesToHightlight = new ArrayList<Residue>();
                                    if (val$hit != null) {
                                        for (Map.Entry<String, Location> entry : val$hit.getLocations().entrySet()) {
                                            for (int pos : entry.getValue().getSinglePositions()) {
                                                residuesToHightlight.add(new Residue(pos, Assemble.this.workingSession.getMolecule(new ParadiseID(Long.parseLong(entry.getKey())))));
                                            }
                                        }
                                    }
                                    if (!residuesToHightlight.isEmpty()) {
                                        Assemble.this.receiveSelectedResiduesFromTheOutside(residuesToHightlight);
                                        Assemble.this.mediator.getRenderer().setGeneralPivot(Assemble.this.mediator.getGlobalSelection().getSelectionCenter());
                                        Assemble.this.mediator.getGlobalSelection().fireRenderingModified();
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            return null;
                        }
                    }.execute();
                    super.finished();
                }
            }.execute();
        }
    }

    public static void main(String[] args) throws BackingStoreException, IOException, JDOMException {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (InstantiationException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (UnsupportedLookAndFeelException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (args.length == 0 || !"start".equals(args[0])) {
            JOptionPane.showMessageDialog(null, "To start Assemble, double-click on one of the launch files in the Assemble directory.");
            System.exit(0);
        } else {
            AssembleConfig.parseConfigFile();
            new SplashScreen();
        }
    }

    public void removeTertiaryStructureFromMyPDB(String pdbID) {
        try {
            FileUtils.deleteDirectory((File)new File(Assemble.getMyPDBDir(), pdbID));
            this.myRNAMotifsPanel.removeIconMotifsFromPDB(pdbID);
            for (PDBIcon icon : pdbIcons) {
                if (!icon.pdbID.equals(pdbID)) continue;
                this.myPDBPanel.iconsPanel.remove(icon);
                pdbIcons.remove(icon);
                break;
            }
            this.myPDBPanel.totalStructures--;
            this.myPDBPanel.iconsPanel.doLayout();
            this.myPDBPanel.iconsPanel.revalidate();
            this.myPDBPanel.iconsPanel.repaint();
            this.myPDBPanel.iconsPanelScrollPane.doLayout();
            this.myPDBPanel.iconsPanelScrollPane.revalidate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class MyPDBSearchPanel
    extends JXPanel {
        private DefaultTableModel model;
        private JPopupMenu popupMenu;

        private MyPDBSearchPanel() {
            this.setLayout(new BorderLayout());
            final JXTable table = new JXTable();
            this.model = new DefaultTableModel();
            this.model.addColumn("PDB ID");
            this.model.addColumn("Location");
            table.setModel((TableModel)this.model);
            table.setSelectionMode(0);
            table.setBackground(Color.WHITE);
            table.setEditable(false);
            TableColumn col = table.getColumnModel().getColumn(0);
            col.setMinWidth(100);
            col.setMaxWidth(100);
            col.setPreferredWidth(100);
            this.add(new JScrollPane((Component)table), "Center");
            table.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        MyPDBSearchPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Display Hit");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MyPDBHit hit = (MyPDBHit)MyPDBSearchPanel.this.model.getValueAt(table.convertRowIndexToModel(table.getSelectedRow()), 1);
                    if (Assemble.this.mediator.get3DModel() != null && Assemble.this.mediator.get3DModel().getTertiaryStructure().getAssociatedFile() != null && hit.getPdbID().equals(Assemble.this.mediator.get3DModel().getTertiaryStructure().getAssociatedFile().getParentFile().getParentFile().getParentFile().getName())) {
                        ArrayList<Residue> residuesToHightlight = new ArrayList<Residue>();
                        for (Map.Entry<String, Location> entry : hit.getLocations().entrySet()) {
                            for (int pos : entry.getValue().getSinglePositions()) {
                                residuesToHightlight.add(new Residue(pos, Assemble.this.workingSession.getMolecule(new ParadiseID(Long.parseLong(entry.getKey())))));
                            }
                        }
                        Assemble.this.receiveSelectedResiduesFromTheOutside(residuesToHightlight);
                        Assemble.this.mediator.getRenderer().setGeneralPivot(Assemble.this.mediator.getGlobalSelection().getSelectionCenter());
                        Assemble.this.mediator.getGlobalSelection().fireRenderingModified();
                    } else {
                        Assemble.this.load3DStructure(hit.getPdbID(), true, hit);
                    }
                }
            });
            this.popupMenu.add(menuItem);
            menuItem = new JMenuItem("Get PDB Details");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GeneralUtils.openBrowser((String)("http://www.rcsb.org/pdb/explore/explore.do?structureId=" + MyPDBSearchPanel.this.model.getValueAt(table.convertRowIndexToModel(table.getSelectedRow()), 0)));
                }
            });
            this.popupMenu.add(menuItem);
            JPanel buttons = new JPanel();
            buttons.setLayout(new BoxLayout(buttons, 0));
            buttons.add(Box.createRigidArea(new Dimension(20, -1)));
            final JComboBox<String> choices = new JComboBox<String>(new String[]{"Apical Loops", "Internal Loops", "Junctions", "PseudoKnots"});
            choices.setMaximumSize(new Dimension(100, 25));
            buttons.add(choices);
            buttons.add(Box.createRigidArea(new Dimension(10, -1)));
            JButton search = new JButton("Search");
            search.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String choice = (String)choices.getSelectedItem();
                    if ("PseudoKnots".equals(choice)) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() throws Exception {
                                try {
                                    Assemble.this.messageBar.printMessage("Searching for Pseudoknots...");
                                    Assemble.this.messageBar.startAnimation();
                                    int numrows = MyPDBSearchPanel.this.model.getRowCount();
                                    for (int i = numrows - 1; i >= 0; --i) {
                                        MyPDBSearchPanel.this.model.removeRow(i);
                                    }
                                    Assemble.this.myPDBPanel.clear();
                                    List<MyPDBHit> hits = MyPDBQuery.searchPseudoKnots();
                                    for (MyPDBHit hit : hits) {
                                        MyPDBSearchPanel.this.model.addRow(new Object[]{hit.getPdbID(), hit});
                                        Assemble.this.myPDBPanel.addNewPDBIcon(hit.getPdbID());
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                Assemble.this.messageBar.stopAnimation();
                                return null;
                            }
                        }.execute();
                    } else if ("Internal Loops".equals(choice)) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() throws Exception {
                                try {
                                    String input = JOptionPane.showInputDialog("Length Criteria", (Object)"length1 length2");
                                    if (input != null && input.trim().length() != 0) {
                                        String[] lengths = input.trim().split(" ");
                                        Assemble.this.messageBar.printMessage("Searching for Internal Loops...");
                                        Assemble.this.messageBar.startAnimation();
                                        int numrows = MyPDBSearchPanel.this.model.getRowCount();
                                        for (int i = numrows - 1; i >= 0; --i) {
                                            MyPDBSearchPanel.this.model.removeRow(i);
                                        }
                                        Assemble.this.myPDBPanel.clear();
                                        List<MyPDBHit> hits = MyPDBQuery.searchInternalLoops(Integer.parseInt(lengths[0]), Integer.parseInt(lengths[1]));
                                        for (MyPDBHit hit : hits) {
                                            MyPDBSearchPanel.this.model.addRow(new Object[]{hit.getPdbID(), hit});
                                            Assemble.this.myPDBPanel.addNewPDBIcon(hit.getPdbID());
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                Assemble.this.messageBar.stopAnimation();
                                return null;
                            }
                        }.execute();
                    } else if ("Apical Loops".equals(choice)) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() throws Exception {
                                try {
                                    String input = JOptionPane.showInputDialog("Length Criteria", (Object)"length");
                                    if (input != null && input.trim().length() != 0) {
                                        Assemble.this.messageBar.printMessage("Searching for Apical Loops...");
                                        Assemble.this.messageBar.startAnimation();
                                        int numrows = MyPDBSearchPanel.this.model.getRowCount();
                                        for (int i = numrows - 1; i >= 0; --i) {
                                            MyPDBSearchPanel.this.model.removeRow(i);
                                        }
                                        Assemble.this.myPDBPanel.clear();
                                        List<MyPDBHit> hits = MyPDBQuery.searchApicalLoops(Integer.parseInt(input.trim()));
                                        for (MyPDBHit hit : hits) {
                                            MyPDBSearchPanel.this.model.addRow(new Object[]{hit.getPdbID(), hit});
                                            Assemble.this.myPDBPanel.addNewPDBIcon(hit.getPdbID());
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                Assemble.this.messageBar.stopAnimation();
                                return null;
                            }
                        }.execute();
                    } else if ("Junctions".equals(choice)) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() throws Exception {
                                try {
                                    String input = JOptionPane.showInputDialog("Length Criteria", (Object)"length");
                                    if (input != null && input.trim().length() != 0) {
                                        Assemble.this.messageBar.printMessage("Searching for Junctions...");
                                        Assemble.this.messageBar.startAnimation();
                                        int numrows = MyPDBSearchPanel.this.model.getRowCount();
                                        for (int i = numrows - 1; i >= 0; --i) {
                                            MyPDBSearchPanel.this.model.removeRow(i);
                                        }
                                        Assemble.this.myPDBPanel.clear();
                                        List<MyPDBHit> hits = MyPDBQuery.searchJunctions(Integer.parseInt(input.trim()));
                                        for (MyPDBHit hit : hits) {
                                            MyPDBSearchPanel.this.model.addRow(new Object[]{hit.getPdbID(), hit});
                                            Assemble.this.myPDBPanel.addNewPDBIcon(hit.getPdbID());
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                Assemble.this.messageBar.stopAnimation();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            buttons.add(search);
            buttons.add(Box.createHorizontalGlue());
            this.add(buttons, "North");
        }
    }

    private class RNAMotif {
        private String name;
        private String category;
        private String pdbID;
        private String pubmedID;
        private String comment;
        private Date date;
        private List<RNAMotifSequence> motifSequences;
        private List<Element> interactions;
        private List<Element> helices;
        private List<List<fr.unistra.ibmc.assemble.structures.Residue>> userChains;

        private RNAMotif(File rnamlFile, String category, String pdbID) throws IOException {
            int i;
            Document doc = null;
            try {
                doc = new SAXBuilder().build(rnamlFile);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List molecules = doc.getRootElement().getChildren("molecule");
            List bases = doc.getRootElement().getChild("tertiary-structure").getChildren("base");
            this.motifSequences = new ArrayList<RNAMotifSequence>(molecules.size());
            this.userChains = new ArrayList<List<fr.unistra.ibmc.assemble.structures.Residue>>();
            this.interactions = doc.getRootElement().getChild("structure-annotation").getChildren("base-pair");
            this.helices = doc.getRootElement().getChild("structure-annotation").getChildren("helix");
            for (i = 0; i < molecules.size(); ++i) {
                this.userChains.add(null);
            }
            for (i = 0; i < molecules.size(); ++i) {
                Element molecule = (Element)molecules.get(i);
                char[] moleculeSequence = molecule.getChild("sequence").getChild("seq-data").getText().toCharArray();
                String moleculeId = molecule.getAttributeValue("id");
                ArrayList<Adenine3D> residues3D = new ArrayList<Adenine3D>();
                for (Object o : bases) {
                    Element base = (Element)o;
                    if (!moleculeId.equals(base.getAttributeValue("molecule-id"))) continue;
                    char symbol = moleculeSequence[Integer.parseInt(base.getAttributeValue("id")) - 1];
                    Adenine3D residue3D = null;
                    switch (symbol) {
                        case 'A': {
                            residue3D = new Adenine3D(null);
                            break;
                        }
                        case 'U': {
                            residue3D = new Uracil3D(null);
                            break;
                        }
                        case 'G': {
                            residue3D = new Guanine3D(null);
                            break;
                        }
                        case 'C': {
                            residue3D = new Cytosine3D(null);
                            break;
                        }
                    }
                    if (residue3D == null) continue;
                    for (Object _o : base.getChildren("atom")) {
                        residue3D.setAtomCoordinates(((Element)_o).getAttributeValue("type"), Float.parseFloat(((Element)_o).getAttributeValue("x")), Float.parseFloat(((Element)_o).getAttributeValue("y")), Float.parseFloat(((Element)_o).getAttributeValue("z")));
                    }
                    residues3D.add(residue3D);
                }
                Attribute start = molecule.getAttribute("start");
                Attribute end = molecule.getAttribute("end");
                if (start == null && end == null) {
                    this.motifSequences.add(new RNAMotifSequence(molecule.getAttributeValue("id"), molecule.getChild("sequence").getChild("seq-data").getText(), residues3D));
                    continue;
                }
                this.motifSequences.add(new RNAMotifSequence(molecule.getAttributeValue("id"), molecule.getChild("sequence").getChild("seq-data").getText(), residues3D, Integer.parseInt(start.getValue()), Integer.parseInt(end.getValue())));
            }
            this.name = rnamlFile.getName().split("\\.rnaml")[0];
            this.category = category;
            this.pdbID = pdbID;
            this.comment = doc.getRootElement().getAttributeValue("comment");
            for (Object ref : doc.getRootElement().getChildren("reference")) {
                Element pmidEl = ((Element)ref).getChild("pubmed-id");
                if (pmidEl == null) continue;
                this.pubmedID = pmidEl.getTextTrim();
            }
            this.date = new Date(rnamlFile.lastModified());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RNAMotifSequence {
            private String sequenceID;
            private String sequence;
            private int startPosition;
            private int endPosition;
            private List<Residue3D> residues3D;

            private RNAMotifSequence(String sequenceID, String sequence, List<Residue3D> residues3D) {
                this(sequenceID, sequence, residues3D, -1, -1);
            }

            private RNAMotifSequence(String sequenceID, String sequence, List<Residue3D> residues3D, int startPosition, int endPosition) {
                this.sequenceID = sequenceID;
                this.sequence = sequence;
                this.residues3D = residues3D;
                this.startPosition = startPosition;
                this.endPosition = endPosition;
            }
        }
    }

    private class RNAMotifDetail
    extends JXPanel {
        private RNAMotif motif;
        private JButton cancel;
        private JButton apply;
        private JXTable sequencesTable;
        private Icon icon;

        public RNAMotifDetail(RNAMotif motif, Icon icon) {
            this.motif = motif;
            this.icon = icon;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setBackground(Color.WHITE);
            JPanel header = new JPanel(new BorderLayout());
            header.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
            header.setBackground(Color.WHITE);
            JPanel iconPanel = new JPanel();
            iconPanel.setBackground(Color.WHITE);
            JLabel iconLabel = new JLabel(this.icon);
            iconPanel.add(iconLabel);
            header.add((Component)iconPanel, "West");
            iconPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
            JPanel description = new JPanel();
            description.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
            description.setBackground(Color.WHITE);
            description.setLayout(new BoxLayout(description, 1));
            description.add(new JLabel("Name: " + this.motif.name));
            description.add(new JLabel("Category: " + this.motif.category));
            description.add(new JLabel("PDB ID: " + this.motif.pdbID));
            if (this.motif.pubmedID != null) {
                description.add(new JLabel("PubMed ID: " + this.motif.pubmedID));
            }
            if (this.motif.comment != null) {
                description.add(new JLabel("Comment: " + this.motif.comment));
            }
            header.add((Component)description, "Center");
            this.add(header, "North");
            this.sequencesTable = new JXTable();
            this.sequencesTable.setBackground(Color.WHITE);
            this.apply = new JButton();
            this.cancel = new JButton();
            Object[][] objects = new Object[this.motif.motifSequences.size()][6];
            for (int i = 0; i < this.motif.motifSequences.size(); ++i) {
                objects[i][0] = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).sequence;
                objects[i][1] = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).startPosition == -1 ? "NA" : "" + ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).startPosition;
                objects[i][2] = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).endPosition == -1 ? "NA" : "" + ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).endPosition;
                objects[i][3] = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).sequence.length();
                objects[i][4] = "???";
                objects[i][5] = "Link";
            }
            this.sequencesTable.setModel((TableModel)new DefaultTableModel(objects, new String[]{"Motif Sequences", "Start", "End", "Length", "Your Selection", "Link"}){
                Class[] types;
                boolean[] canEdit;
                {
                    this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
                    this.canEdit = new boolean[]{false, false, false, false, true, true};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
            this.sequencesTable.getTableHeader().setReorderingAllowed(false);
            this.sequencesTable.getColumn((Object)"Link").setCellRenderer(new ButtonRenderer());
            this.sequencesTable.getColumn((Object)"Link").setCellEditor(new ButtonEditor(new JCheckBox()));
            this.sequencesTable.getColumn((Object)"Link").setMaxWidth(100);
            this.sequencesTable.getColumn((Object)"Link").setMinWidth(100);
            this.sequencesTable.setFillsViewportHeight(true);
            this.add(new JScrollPane((Component)this.sequencesTable), "Center");
            this.apply.setText("Apply");
            this.apply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        RNAMotifDetail.this.applyActionPerformed(evt);
                    }
                    catch (BiologicalSymbolException e) {
                        e.printStackTrace();
                    }
                }
            });
            JPanel footer = new JPanel();
            footer.setBackground(Color.WHITE);
            footer.add(this.apply);
            this.add(footer, "South");
        }

        private void applyActionPerformed(ActionEvent evt) throws BiologicalSymbolException {
            for (List residues : this.motif.userChains) {
                if (residues != null) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "You have to link all the sequences of the motif!!");
                return;
            }
            for (Element interactionEl : this.motif.interactions) {
                String molecule1ID = interactionEl.getAttributeValue("molecule1-id");
                String base5ID = interactionEl.getAttributeValue("base1-id");
                String molecule2ID = interactionEl.getAttributeValue("molecule2-id");
                String base3ID = interactionEl.getAttributeValue("base2-id");
                String edge1 = interactionEl.getAttributeValue("edge1");
                String edge2 = interactionEl.getAttributeValue("edge2");
                String orientation = interactionEl.getAttributeValue("orientation");
                Residue base1 = null;
                Residue base2 = null;
                for (int i = 0; i < this.motif.motifSequences.size(); ++i) {
                    if (((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).sequenceID.equals(molecule1ID)) {
                        base1 = (Residue)((fr.unistra.ibmc.assemble.structures.Residue)((List)this.motif.userChains.get(i)).get(Integer.parseInt(base5ID) - 1)).getResidue3D().getResidues().iterator().next();
                    }
                    if (!((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).sequenceID.equals(molecule2ID)) continue;
                    base2 = (Residue)((fr.unistra.ibmc.assemble.structures.Residue)((List)this.motif.userChains.get(i)).get(Integer.parseInt(base3ID) - 1)).getResidue3D().getResidues().iterator().next();
                }
                if (base1 == null || base2 == null) continue;
                Residue2D base12D = Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D(base1);
                Residue2D base22D = Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D(base2);
                try {
                    boolean found = false;
                    for (BaseBaseInteraction2D interaction : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().getBaseBaseInteractions()) {
                        if (interaction.getResidue().equals(base12D) && interaction.getPartnerResidue().equals(base22D)) {
                            Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().modifyInteractionType(interaction, base12D, edge1.charAt(0), base22D, edge2.charAt(0), orientation.charAt(0), -1);
                            found = true;
                            break;
                        }
                        if (!interaction.getResidue().equals(base22D) || !interaction.getPartnerResidue().equals(base12D)) continue;
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().modifyInteractionType(interaction, base22D, edge2.charAt(0), base12D, edge1.charAt(0), orientation.charAt(0), -1);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().createTertiaryInteraction(base12D, edge1.charAt(0), base22D, edge2.charAt(0), orientation.charAt(0), 1);
                }
                catch (BiologicalSymbolException e) {
                    JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage());
                    return;
                }
            }
            Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().repaint();
            ArrayList<fr.unistra.ibmc.assemble.structures.Residue> assembleResidues = new ArrayList<fr.unistra.ibmc.assemble.structures.Residue>();
            ArrayList referenceResidues = new ArrayList();
            for (int i = 0; i < this.motif.motifSequences.size(); ++i) {
                referenceResidues.addAll(((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).residues3D);
                assembleResidues.addAll((Collection)this.motif.userChains.get(i));
            }
            GuiEvent ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("Apply 3D folds"));
            Parameters parameters = new Parameters();
            for (Residue3D rr : referenceResidues) {
                Parameter p = new Parameter("reference residues");
                p.setFeature((ParadiseFeature)rr);
                parameters.addParameter(p);
            }
            Parameter p = new Parameter("target sequence");
            StringBuffer targetSequence = new StringBuffer();
            for (fr.unistra.ibmc.assemble.structures.Residue r : assembleResidues) {
                targetSequence.append(r.getName().charAt(0));
            }
            p.setValue(targetSequence.toString());
            parameters.addParameter(p);
            ev.addParameter((Object)new Apply3DFoldRequestAnswerBehaviour(new ArrayList<Molecule>(Assemble.this.mediator.get3DModel().getTertiaryStructure().getMolecules()), parameters, assembleResidues));
            ((AssembleAgent)Assemble.this.mediator.getAssemble().getAgent()).postGuiEvent(ev);
        }

        private void cancelActionPerformed(ActionEvent evt) {
        }

        public class ButtonEditor
        extends DefaultCellEditor {
            protected JButton button;
            private String label;
            private boolean isPushed;
            private int selectedRow;

            public ButtonEditor(JCheckBox checkBox) {
                super(checkBox);
                this.button = new JButton();
                this.button.setOpaque(true);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ButtonEditor.this.fireEditingStopped();
                    }
                });
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (isSelected) {
                    this.button.setForeground(table.getSelectionForeground());
                    this.button.setBackground(table.getSelectionBackground());
                } else {
                    this.button.setForeground(table.getForeground());
                    this.button.setBackground(table.getBackground());
                }
                this.label = value == null ? "" : value.toString();
                this.button.setText(this.label);
                this.isPushed = true;
                this.selectedRow = row;
                return this.button;
            }

            public Object getCellEditorValue() {
                if (this.isPushed && Assemble.this.mediator.getGlobalSelection().getSelectedResidues().isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)RNAMotifDetail.this), "No residues selected in the 3D scene!!");
                } else if (this.isPushed && Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 0) {
                    if (((String)RNAMotifDetail.this.sequencesTable.getValueAt(this.selectedRow, 0)).length() != Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size()) {
                        JOptionPane.showMessageDialog((Component)((Object)RNAMotifDetail.this), "Your selection should have the same size than the sequence in the motif!!");
                    } else {
                        StringBuffer buff = new StringBuffer();
                        List<fr.unistra.ibmc.assemble.structures.Residue> sortedResidues = Assemble.this.mediator.getGlobalSelection().getSelectedResidues();
                        Collections.sort(sortedResidues, new Comparator<fr.unistra.ibmc.assemble.structures.Residue>(){

                            @Override
                            public int compare(fr.unistra.ibmc.assemble.structures.Residue residue, fr.unistra.ibmc.assemble.structures.Residue residue1) {
                                return ((Residue)residue.getResidue3D().getResidues().iterator().next()).getAbsolutePosition() - ((Residue)residue1.getResidue3D().getResidues().iterator().next()).getAbsolutePosition();
                            }
                        });
                        for (fr.unistra.ibmc.assemble.structures.Residue r : sortedResidues) {
                            buff.append(r.getName().charAt(0));
                        }
                        RNAMotifDetail.this.sequencesTable.setValueAt((Object)buff.toString(), this.selectedRow, 4);
                        RNAMotifDetail.this.motif.userChains.set(this.selectedRow, new ArrayList<fr.unistra.ibmc.assemble.structures.Residue>(sortedResidues));
                    }
                }
                this.isPushed = false;
                return new String(this.label);
            }

            public boolean stopCellEditing() {
                this.isPushed = false;
                return super.stopCellEditing();
            }

            protected void fireEditingStopped() {
                super.fireEditingStopped();
            }
        }

        public class ButtonRenderer
        extends JButton
        implements TableCellRenderer {
            public ButtonRenderer() {
                this.setOpaque(true);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(UIManager.getColor("Button.background"));
                }
                this.setText(value == null ? "" : value.toString());
                return this;
            }
        }
    }

    private class RNAMotifIcon
    extends JPanel {
        private String pdbID;
        private String motifName;
        private String categoryName;
        private JButton button;
        private JLabel motifNameLabel;
        private JLabel categoryLabel;
        private JLabel pdbIDLabel;

        private RNAMotifIcon(final String pdbID, final String motifName, final String categoryName) throws IOException {
            float ratio;
            this.pdbID = pdbID;
            this.motifName = motifName;
            this.categoryName = categoryName;
            this.setLayout(new BoxLayout(this, 1));
            this.setOpaque(false);
            final File motifCategoryDir = new File(new File(new File(Assemble.getMyPDBDir(), pdbID), "motifs"), categoryName);
            BufferedImage image = ImageIO.read(new File(motifCategoryDir, motifName + ".png"));
            int width = image.getWidth();
            int height = image.getHeight();
            float f = ratio = width >= height ? (float)width / (float)motifsIconSize : (float)height / (float)motifsIconSize;
            if (ratio > 1.0f) {
                this.button = new JButton(new ImageIcon(image.getScaledInstance((int)((float)width / ratio), (int)((float)height / ratio), 4)));
                this.add(Box.createRigidArea(new Dimension(-1, motifsIconSize - (int)((float)height / ratio))));
            } else {
                this.button = new JButton(new ImageIcon(image));
                this.add(Box.createRigidArea(new Dimension(-1, motifsIconSize - height)));
            }
            this.button.setBackground(Color.WHITE);
            this.button.addMouseListener(new MouseListener(){
                private JPopupMenu popupMenu = new JPopupMenu();
                {
                    JMenuItem menuItem = new JMenuItem("Get Details");
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                if (Assemble.this.mediator.getToolWindowManager().getToolWindow((Object)"MotifDetails") != null) {
                                    Assemble.this.mediator.getToolWindowManager().unregisterToolWindow("MotifDetails");
                                }
                                ToolWindow toolWindow = Assemble.this.mediator.getToolWindowManager().registerToolWindow("MotifDetails", "RNA Motif Details", RessourcesUtils.getIcon("16/images.png"), (Component)((Object)new RNAMotifDetail(new RNAMotif(new File(motifCategoryDir, motifName + ".rnaml"), categoryName, pdbID), RNAMotifIcon.this.button.getIcon())), ToolWindowAnchor.RIGHT);
                                DockedTypeDescriptor descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
                                descriptor.setDockLength(300);
                                descriptor.setPreviewEnabled(false);
                                toolWindow.setAvailable(true);
                                toolWindow.aggregate();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                    this.popupMenu.add(menuItem);
                    menuItem = new JMenuItem("Remove Motif");
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete this RNA motif?")) {
                                new File(motifCategoryDir, motifName + ".rnaml").delete();
                                new File(motifCategoryDir, motifName + ".png").delete();
                                Assemble.this.myRNAMotifsPanel.removeIconMotif(pdbID, categoryName, motifName);
                                if (motifCategoryDir.listFiles().length == 0) {
                                    motifCategoryDir.delete();
                                }
                            }
                        }
                    });
                    this.popupMenu.add(menuItem);
                    menuItem = new JMenuItem("Remove Category");
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete this category of motifs?")) {
                                for (RNAMotifIcon icon : new ArrayList((Collection)motifsIcons.get(categoryName))) {
                                    new File(motifCategoryDir, icon.motifName + ".rnaml").delete();
                                    new File(motifCategoryDir, icon.motifName + ".png").delete();
                                    Assemble.this.myRNAMotifsPanel.removeIconMotif(icon.pdbID, icon.categoryName, icon.motifName);
                                }
                                motifCategoryDir.delete();
                            }
                        }
                    });
                    this.popupMenu.add(menuItem);
                }

                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        // empty if block
                    }
                }

                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }
            });
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setAlignmentX(0.5f);
            this.add(this.button);
            this.motifNameLabel = new JLabel(motifName);
            this.motifNameLabel.setAlignmentX(0.5f);
            this.add(this.motifNameLabel);
            this.categoryLabel = new JLabel(categoryName);
            this.categoryLabel.setAlignmentX(0.5f);
            this.add(this.categoryLabel);
            this.pdbIDLabel = new JLabel(pdbID);
            this.pdbIDLabel.setAlignmentX(0.5f);
            this.add(this.pdbIDLabel);
        }

        private void updateImage() throws IOException {
            int height;
            float ratio;
            File motifCategoryDir = new File(new File(new File(Assemble.getMyPDBDir(), this.pdbID), "motifs"), this.categoryName);
            BufferedImage image = ImageIO.read(new File(motifCategoryDir, this.motifName + ".png"));
            int width = image.getWidth();
            float f = ratio = width >= (height = image.getHeight()) ? (float)width / (float)motifsIconSize : (float)height / (float)motifsIconSize;
            if (ratio > 1.0f) {
                this.button.setIcon(new ImageIcon(image.getScaledInstance((int)((float)width / ratio), (int)((float)height / ratio), 4)));
                this.remove(0);
                this.add(Box.createRigidArea(new Dimension(-1, motifsIconSize - (int)((float)height / ratio))), 0);
                this.doLayout();
                this.revalidate();
            } else {
                this.button.setIcon(new ImageIcon(image));
                this.remove(0);
                this.add(Box.createRigidArea(new Dimension(-1, motifsIconSize - height)), 0);
                this.doLayout();
                this.revalidate();
            }
        }
    }

    private class MyRNAMotifsPanel
    extends JPanel {
        private IconsPanel iconsPanel;
        private JPanel buttonsBar;
        private JScrollPane iconsPanelScrollPane;
        private JComboBox motifsCategories;

        private MyRNAMotifsPanel() {
            this.setLayout(new BorderLayout());
            this.iconsPanel = new IconsPanel();
            this.iconsPanelScrollPane = new JScrollPane(this.iconsPanel);
            this.add((Component)this.iconsPanelScrollPane, "Center");
            this.buttonsBar = new JPanel();
            this.buttonsBar.setLayout(new BoxLayout(this.buttonsBar, 0));
            this.add((Component)this.buttonsBar, "South");
            this.buttonsBar.add(Box.createHorizontalGlue());
            this.motifsCategories = new JComboBox(new String[]{"All"}){

                public Dimension getMaximumSize() {
                    return new Dimension(100, 20);
                }
            };
            this.motifsCategories.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    String selectedValue = (String)cb.getSelectedItem();
                    for (Component c : MyRNAMotifsPanel.this.iconsPanel.getComponents()) {
                        if (!RNAMotifIcon.class.isInstance(c)) continue;
                        MyRNAMotifsPanel.this.iconsPanel.remove(c);
                    }
                    if ("All".equals(selectedValue)) {
                        for (List icons : motifsIcons.values()) {
                            for (RNAMotifIcon icon : icons) {
                                MyRNAMotifsPanel.this.iconsPanel.add(icon);
                            }
                        }
                    } else {
                        for (RNAMotifIcon icon : (List)motifsIcons.get(selectedValue)) {
                            MyRNAMotifsPanel.this.iconsPanel.add(icon);
                        }
                    }
                    MyRNAMotifsPanel.this.iconsPanel.doLayout();
                    MyRNAMotifsPanel.this.iconsPanel.revalidate();
                    MyRNAMotifsPanel.this.iconsPanel.repaint();
                    MyRNAMotifsPanel.this.iconsPanelScrollPane.doLayout();
                    MyRNAMotifsPanel.this.iconsPanelScrollPane.revalidate();
                }
            });
            JLabel eye = new JLabel(RessourcesUtils.getIcon("16/eye.png"));
            eye.setToolTipText("Display");
            this.buttonsBar.add(eye);
            this.buttonsBar.add(Box.createRigidArea(new Dimension(5, 0)));
            this.buttonsBar.add(this.motifsCategories);
            this.buttonsBar.add(Box.createRigidArea(new Dimension(20, 0)));
            final JSlider iconsSize = new JSlider(0, 100, 300, motifsIconSize);
            iconsSize.setMaximumSize(new Dimension(200, 20));
            iconsSize.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    for (String category : motifsIcons.keySet()) {
                        for (RNAMotifIcon icon : (List)motifsIcons.get(category)) {
                            try {
                                motifsIconSize = iconsSize.getValue();
                                icon.updateImage();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            });
            JLabel zoom = new JLabel(RessourcesUtils.getIcon("16/zoom_out.png"));
            this.buttonsBar.add(zoom);
            this.buttonsBar.add(iconsSize);
            zoom = new JLabel(RessourcesUtils.getIcon("16/zoom_in.png"));
            this.buttonsBar.add(zoom);
            this.buttonsBar.add(Box.createHorizontalGlue());
            for (String category : motifsIcons.keySet()) {
                this.motifsCategories.addItem(category);
                for (RNAMotifIcon icon : (List)motifsIcons.get(category)) {
                    this.iconsPanel.add(icon);
                }
            }
            this.iconsPanel.doLayout();
            this.iconsPanelScrollPane.revalidate();
        }

        private void removeIconMotif(String pdbID, String categoryName, String motifName) {
            List icons = (List)motifsIcons.get(categoryName);
            for (RNAMotifIcon icon : new ArrayList(icons)) {
                if (!icon.pdbID.equals(pdbID) || !icon.categoryName.equals(categoryName) || !icon.motifName.equals(motifName)) continue;
                icons.remove(icon);
                this.iconsPanel.remove(icon);
                this.iconsPanel.doLayout();
                this.iconsPanel.revalidate();
                this.iconsPanel.repaint();
                this.iconsPanelScrollPane.doLayout();
                this.iconsPanelScrollPane.revalidate();
                break;
            }
            if (((List)motifsIcons.get(categoryName)).isEmpty()) {
                motifsIcons.remove(categoryName);
                this.motifsCategories.removeItem(categoryName);
            }
        }

        private void removeIconMotifsFromPDB(String pdbID) {
            HashSet<String> categories = new HashSet<String>();
            for (List icons : motifsIcons.values()) {
                for (RNAMotifIcon icon : new ArrayList(icons)) {
                    if (!icon.pdbID.equals(pdbID)) continue;
                    categories.add(icon.categoryName);
                    icons.remove(icon);
                    this.iconsPanel.remove(icon);
                    this.iconsPanel.doLayout();
                    this.iconsPanel.revalidate();
                    this.iconsPanel.repaint();
                    this.iconsPanelScrollPane.doLayout();
                    this.iconsPanelScrollPane.revalidate();
                }
            }
            for (String category : categories) {
                if (!((List)motifsIcons.get(category)).isEmpty()) continue;
                motifsIcons.remove(category);
                this.motifsCategories.removeItem(category);
            }
        }

        private void displayMotifs(String pdbID) {
            for (Component c : this.iconsPanel.getComponents()) {
                if (!RNAMotifIcon.class.isInstance(c)) continue;
                this.iconsPanel.remove(c);
            }
            for (List icons : motifsIcons.values()) {
                for (RNAMotifIcon icon : icons) {
                    if (!icon.pdbID.equals(pdbID)) continue;
                    this.iconsPanel.add(icon);
                }
            }
            this.iconsPanel.doLayout();
            this.iconsPanel.revalidate();
            this.iconsPanel.repaint();
            this.iconsPanelScrollPane.doLayout();
            this.iconsPanelScrollPane.revalidate();
        }

        private void addNewIconMotif(String pdbID, String categoryName, String motifName) throws IOException {
            RNAMotifIcon icon = new RNAMotifIcon(pdbID, motifName, categoryName);
            if (motifsIcons.containsKey(categoryName)) {
                ((List)motifsIcons.get(categoryName)).add(icon);
            } else {
                ArrayList<RNAMotifIcon> icons = new ArrayList<RNAMotifIcon>();
                icons.add(icon);
                motifsIcons.put(categoryName, icons);
                this.motifsCategories.addItem(categoryName);
            }
            this.iconsPanel.add(icon);
            this.iconsPanel.doLayout();
            this.iconsPanelScrollPane.revalidate();
        }

        private class IconsPanel
        extends JPanel {
            private static final int GAP = 10;

            private IconsPanel() {
                this.setLayout(new FlowLayout(3, 10, 10));
                this.setBackground(new Color(173, 216, 230));
            }

            protected void paintComponent(Graphics g) {
                if (!this.isOpaque()) {
                    super.paintComponent(g);
                    return;
                }
                Graphics2D g2d = (Graphics2D)g;
                int w = this.getWidth();
                int h = this.getHeight();
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, h, this.getBackground());
                g2d.setPaint(gp);
                g2d.fillRect(0, 0, w, h);
                this.setOpaque(false);
                super.paintComponent(g);
                this.setOpaque(true);
            }
        }
    }

    class PDBIcon
    extends JPanel {
        private String pdbID;

        PDBIcon(final String pdbID) throws IOException {
            this.pdbID = pdbID;
            File pdbDir = new File(Assemble.getMyPDBDir(), pdbID);
            BufferedImage image = ImageIO.read(new File(new File(pdbDir, "icons"), pdbDir.getName() + "_250.jpg"));
            this.setLayout(new BoxLayout(this, 1));
            this.setOpaque(false);
            final JButton button = new JButton(new ImageIcon(image.getScaledInstance(150, 150, 4)));
            button.setPreferredSize(new Dimension(160, 160));
            button.setBackground(Color.WHITE);
            button.addMouseListener(new MouseListener(){
                private JPopupMenu popupMenu = new JPopupMenu();
                {
                    JMenuItem menuItem = new JMenuItem("Load Structure");
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Assemble.this.load3DStructure(pdbID, true, null);
                        }
                    });
                    this.popupMenu.add(menuItem);
                    menuItem = new JMenuItem("Get Details");
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            GeneralUtils.openBrowser((String)("http://www.rcsb.org/pdb/explore/explore.do?structureId=" + pdbID));
                        }
                    });
                    this.popupMenu.add(menuItem);
                    menuItem = new JMenuItem("Display RNA Motifs");
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Assemble.this.myRNAMotifsPanel.displayMotifs(pdbID);
                        }
                    });
                    this.popupMenu.add(menuItem);
                    menuItem = new JMenuItem("Remove Tertiary Structure");
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete this tertiary Structure?")) {
                                Assemble.this.removeTertiaryStructureFromMyPDB(pdbID);
                            }
                        }
                    });
                    this.popupMenu.add(menuItem);
                }

                public void mouseClicked(MouseEvent event) {
                }

                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }
            });
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setAlignmentX(0.5f);
            this.add(button);
            JLabel label = new JLabel(pdbID){

                public Dimension getPreferredSize() {
                    return new Dimension(button.getWidth(), 20);
                }
            };
            label.setAlignmentX(0.5f);
            this.add(label);
        }
    }

    private class MyPDBPanel
    extends JPanel {
        private IconsPanel iconsPanel;
        private JScrollPane iconsPanelScrollPane;
        private int totalStructures;

        private MyPDBPanel() {
            this.setLayout(new BorderLayout());
            this.iconsPanel = new IconsPanel();
            this.iconsPanelScrollPane = new JScrollPane(this.iconsPanel);
            this.add((Component)this.iconsPanelScrollPane, "Center");
            JPanel buttonsBar = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(-1, 30);
                }
            };
            buttonsBar.setLayout(new BoxLayout(buttonsBar, 0));
            this.add((Component)buttonsBar, "South");
            buttonsBar.add(Box.createHorizontalGlue());
            final JTextField pdbIDField = new JTextField(5){

                public Dimension getMaximumSize() {
                    return new Dimension(5, 25);
                }
            };
            pdbIDField.setText("PDB ID");
            buttonsBar.add(pdbIDField);
            buttonsBar.add(Box.createRigidArea(new Dimension(5, 25)));
            final JButton importPDBButton = new JButton(RessourcesUtils.getIcon("16/download.png"));
            importPDBButton.setMargin(new Insets(2, 2, 2, 2));
            importPDBButton.setToolTipText("Click to download a new PDB");
            importPDBButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String pdbID = pdbIDField.getText();
                    if (pdbID != null && (pdbID = pdbID.trim().toLowerCase()).length() != 0) {
                        final String _pdbID = pdbID;
                        if (MyPDBPanel.this.isPDBStored(_pdbID)) {
                            JOptionPane.showMessageDialog(Assemble.this.window, pdbID + " is already in your library");
                            return;
                        }
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() throws Exception {
                                String[] ids = null;
                                ids = "secret".equals(_pdbID) ? selectedStructures : new String[]{_pdbID};
                                for (String id : ids) {
                                    try {
                                        String line;
                                        importPDBButton.setEnabled(false);
                                        Assemble.this.getProgressMonitor().printMessage("Importing " + id + "...");
                                        Assemble.this.getProgressMonitor().startAnimation();
                                        BufferedReader in = new BufferedReader(new InputStreamReader(new URL("http://www.rcsb.org/pdb/download/downloadFile.do?fileFormat=pdb&compression=NO&structureId=" + id).openStream()));
                                        File pdbDir = new File(Assemble.getMyPDBDir(), id.toLowerCase());
                                        pdbDir.mkdir();
                                        new File(pdbDir, "icons").mkdir();
                                        new File(pdbDir, "motifs").mkdir();
                                        PrintWriter pw = new PrintWriter(new File(pdbDir, id.toLowerCase() + ".pdb"));
                                        while ((line = in.readLine()) != null) {
                                            pw.println(line);
                                        }
                                        in.close();
                                        pw.close();
                                        File iconFile = new File(new File(pdbDir, "icons"), id.toLowerCase() + "_250.jpg");
                                        FileUtils.copyURLToFile((URL)new URL("http://www.rcsb.org/pdb/images/" + id + "_asym_r_250.jpg"), (File)iconFile);
                                        PDBIcon icon = MyPDBPanel.this.addNewPDBIcon(id);
                                        if (!"secret".equals(_pdbID)) continue;
                                        Assemble.this.load3DStructure(icon.pdbID, false, null);
                                    }
                                    catch (Exception e) {
                                        ErrorInfo errorInfo = new ErrorInfo("Error", "Problem during the import of " + id, null, null, (Throwable)e, Level.SEVERE, null);
                                        JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                                    }
                                }
                                Assemble.this.getProgressMonitor().stopAnimation();
                                importPDBButton.setEnabled(true);
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            buttonsBar.add(importPDBButton);
            buttonsBar.add(Box.createHorizontalStrut(10));
            JButton importLocalPDBButton = new JButton(RessourcesUtils.getIcon("16/add_local_pdb.png"));
            importLocalPDBButton.setMargin(new Insets(2, 2, 2, 2));
            importLocalPDBButton.setToolTipText("Click to add a new PDB file");
            importLocalPDBButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    FileFilter filter = new FileFilter(){

                        public String getDescription() {
                            return "PDB Files";
                        }

                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().endsWith(".pdb");
                        }
                    };
                    fileChooser.setFileFilter(filter);
                    if (fileChooser.showOpenDialog(null) == 0) {
                        final File pdbFile = fileChooser.getSelectedFile();
                        final String pdbID = pdbFile.getName().split("\\.pdb")[0].toLowerCase();
                        IOUtils.setLastWorkingDirectory((File)pdbFile);
                        if (MyPDBPanel.this.isPDBStored(pdbID)) {
                            JOptionPane.showMessageDialog(Assemble.this.window, pdbID + " is already in your library");
                            return;
                        }
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() throws Exception {
                                Assemble.this.getProgressMonitor().printMessage("Importing " + pdbFile.getName() + "...");
                                Assemble.this.getProgressMonitor().startAnimation();
                                File pdbDir = new File(Assemble.getMyPDBDir(), pdbID);
                                pdbDir.mkdir();
                                new File(pdbDir, "icons").mkdir();
                                new File(pdbDir, "motifs").mkdir();
                                FileUtils.copyFile((File)pdbFile, (File)new File(pdbDir, pdbFile.getName()));
                                FileUtils.copyURLToFile((URL)RessourcesUtils.class.getResource("/fr/unistra/ibmc/assemble/pictures/default_3D_icon_250.jpg"), (File)new File(new File(pdbDir, "icons"), pdbID + "_250.jpg"));
                                MyPDBPanel.this.addNewPDBIcon(pdbID);
                                Assemble.this.getProgressMonitor().stopAnimation();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            buttonsBar.add(importLocalPDBButton);
            buttonsBar.add(Box.createHorizontalStrut(20));
            JButton reload = new JButton(RessourcesUtils.getIcon("16/refresh.png"));
            reload.setMargin(new Insets(2, 2, 2, 2));
            reload.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                        protected Object doInBackground() throws Exception {
                            Assemble.this.messageBar.printMessage("Reload MyPDB...");
                            Assemble.this.messageBar.startAnimation();
                            MyPDBPanel.this.clear();
                            MyPDBPanel.this.reload();
                            Assemble.this.messageBar.stopAnimation();
                            return null;
                        }
                    }.execute();
                }
            });
            reload.setToolTipText("Reload MyPDB");
            buttonsBar.add(reload);
            buttonsBar.add(Box.createHorizontalGlue());
            for (PDBIcon icon : pdbIcons) {
                this.iconsPanel.add(icon);
                ++this.totalStructures;
            }
            this.iconsPanel.doLayout();
            this.iconsPanelScrollPane.revalidate();
        }

        private void clear() {
            this.iconsPanel.removeAll();
            pdbIcons.clear();
            this.totalStructures = 0;
            this.iconsPanel.doLayout();
            this.iconsPanelScrollPane.revalidate();
        }

        private void reload() {
            File[] pdbDirs = Assemble.getMyPDBDir().listFiles(new java.io.FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory();
                }
            });
            int i = 0;
            for (File pdbDir : pdbDirs) {
                ++i;
                try {
                    PDBIcon icon = new PDBIcon(pdbDir.getName());
                    pdbIcons.add(icon);
                    this.iconsPanel.add(icon);
                    ++this.totalStructures;
                    this.iconsPanel.doLayout();
                    this.iconsPanelScrollPane.revalidate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private boolean isPDBStored(String pdbID) {
            pdbID = pdbID.toLowerCase();
            for (PDBIcon icon : pdbIcons) {
                if (!icon.pdbID.equals(pdbID)) continue;
                return true;
            }
            return false;
        }

        private PDBIcon addNewPDBIcon(String pdbID) throws IOException {
            if (!this.isPDBStored(pdbID)) {
                PDBIcon icon = new PDBIcon(pdbID);
                ++this.totalStructures;
                this.iconsPanel.add(icon);
                pdbIcons.add(icon);
                this.iconsPanel.doLayout();
                this.iconsPanelScrollPane.revalidate();
                return icon;
            }
            return null;
        }

        private class IconsPanel
        extends JPanel {
            private static final int GAP = 10;

            private IconsPanel() {
                this.setLayout(new FlowLayout(3, 10, 10));
                this.setBackground(new Color(173, 216, 230));
            }

            protected void paintComponent(Graphics g) {
                if (!this.isOpaque()) {
                    super.paintComponent(g);
                    return;
                }
                Graphics2D g2d = (Graphics2D)g;
                int w = this.getWidth();
                int h = this.getHeight();
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, h, this.getBackground());
                g2d.setPaint(gp);
                g2d.fillRect(0, 0, w, h);
                this.setOpaque(false);
                super.paintComponent(g);
                this.setOpaque(true);
            }

            public Dimension getPreferredSize() {
                if (this.getComponentCount() != 0) {
                    int rows;
                    Component c = this.getComponent(0);
                    int columns = (MyPDBPanel.this.iconsPanelScrollPane.getWidth() - 10) / (c.getWidth() + 10);
                    if (columns == 0) {
                        columns = 1;
                    }
                    if ((rows = (int)Math.ceil((float)MyPDBPanel.this.totalStructures / (float)columns)) == 0) {
                        rows = 1;
                    }
                    return new Dimension(columns * (c.getWidth() + 10) + 10, rows * (c.getHeight() + 10) + 10);
                }
                return new Dimension(-1, -1);
            }
        }
    }

    public class PreferencesPanel
    extends JXTaskPaneContainer {
        public PreferencesPanel() {
            JXTaskPane taskPane = new JXTaskPane();
            taskPane.setTitle("2D Panel Options");
            taskPane.add((Component)((Object)new Model2DRendering()));
            this.add(taskPane);
            taskPane = new JXTaskPane();
            taskPane.setTitle("3D Scene Options");
            taskPane.add((Component)((Object)new Model3DRendering()));
            this.add(taskPane);
        }

        private class Model3DRendering
        extends JXPanel {
            private Model3DRendering() {
                this.setLayout((LayoutManager)new VerticalLayout(5));
                this.add(new JLabel("Covalent Bonds Thickness (pixels)"));
                JXPanel choicesPanel = new JXPanel();
                ButtonGroup group = new ButtonGroup();
                JRadioButton b = new JRadioButton("1");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((Assemble)Assemble.this).mediator.getRenderer().LINE_LINK_WIDTH = 1;
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("2");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((Assemble)Assemble.this).mediator.getRenderer().LINE_LINK_WIDTH = 2;
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
                b.setSelected(true);
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("3");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((Assemble)Assemble.this).mediator.getRenderer().LINE_LINK_WIDTH = 3;
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("4");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((Assemble)Assemble.this).mediator.getRenderer().LINE_LINK_WIDTH = 4;
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                this.add((Component)choicesPanel);
                this.add(new JLabel("Backbone Thickness (pixels)"));
                choicesPanel = new JXPanel();
                group = new ButtonGroup();
                b = new JRadioButton("1");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((Assemble)Assemble.this).mediator.getRenderer().LINE_BACKBONE_WIDTH = 1;
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("2");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((Assemble)Assemble.this).mediator.getRenderer().LINE_BACKBONE_WIDTH = 2;
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
                b.setSelected(true);
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("3");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((Assemble)Assemble.this).mediator.getRenderer().LINE_BACKBONE_WIDTH = 3;
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("4");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((Assemble)Assemble.this).mediator.getRenderer().LINE_BACKBONE_WIDTH = 4;
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                this.add((Component)choicesPanel);
                final JCheckBox checkbox1 = new JCheckBox("Center 3D view on a 2D selection", Assemble.this.mediator.isCenterViewOnSelectionAutomatically());
                this.add(checkbox1);
                checkbox1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Assemble.this.mediator.setCenterViewOnSelectionAutomatically(checkbox1.isSelected());
                    }
                });
                final JCheckBox checkbox2 = new JCheckBox("Draw Backbone between Molecular Chains", DRAW_BACKBONE_BETWEEN_MOLECULAR_CHAINS);
                this.add(checkbox2);
                checkbox2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        DRAW_BACKBONE_BETWEEN_MOLECULAR_CHAINS = checkbox2.isSelected();
                        Assemble.this.mediator.getRenderer().renderingModified();
                    }
                });
            }
        }

        private class Model2DRendering
        extends JXPanel {
            private Model2DRendering() {
                this.setLayout((LayoutManager)new VerticalLayout(5));
                JCheckBox checkbox1 = new JCheckBox("Display Single HBonds", true);
                this.add(checkbox1);
                checkbox1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("SingleHBond");
                    }
                });
                final JCheckBox checkbox2 = new JCheckBox("Display Tertiary Interactions", true);
                this.add(checkbox2);
                checkbox2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().displayTertiaryInteractions(checkbox2.isSelected());
                    }
                });
                final JCheckBox checkbox3 = new JCheckBox("Compute Pseudoknots/InterMolecular Helices as Tertiary Interactions", !Paradise.COPY_PSEUDOKNOTS_AND_INTER_MOLECULAR_HELICES);
                this.add(checkbox3);
                checkbox3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Paradise.COPY_PSEUDOKNOTS_AND_INTER_MOLECULAR_HELICES = !checkbox3.isSelected();
                    }
                });
                final JCheckBox checkbox4 = new JCheckBox("Use Absolute Numbering System", true);
                this.add(checkbox4);
                checkbox4.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        USE_ABSOLUTE_NUMBERING_SYSTEM = checkbox4.isSelected();
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().repaint();
                        Assemble.this.mediator.getSecondaryStructureNavigator().update();
                    }
                });
                this.add(new JLabel("Numbering frequency"));
                JXPanel choicesPanel = new JXPanel();
                ButtonGroup group = new ButtonGroup();
                JRadioButton b = new JRadioButton("1");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        NUMBERING_FREQUENCY = 1;
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().repaint();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("2");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        NUMBERING_FREQUENCY = 2;
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().repaint();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("3");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        NUMBERING_FREQUENCY = 3;
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().repaint();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("4");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        NUMBERING_FREQUENCY = 4;
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().repaint();
                    }
                });
                group.add(b);
                choicesPanel.add((Component)b);
                b = new JRadioButton("5");
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        NUMBERING_FREQUENCY = 5;
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().repaint();
                    }
                });
                b.setSelected(true);
                group.add(b);
                choicesPanel.add((Component)b);
                this.add((Component)choicesPanel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateFrame
    extends JFrame
    implements ZipExtractionPrintingDevice {
        private JProgressBar progressBar;
        private JLabel title;
        private SwingWorker currentTask;
        private List<String> newFiles;
        private List<String> filesToDelete;

        private UpdateFrame(List<Object> versions) throws IOException {
            super("Assemble Update");
            this.setDefaultCloseOperation(0);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.title = new JLabel("Searching first update...");
            panel.add((Component)this.title, "North");
            panel.add((Component)this.progressBar, "Center");
            panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            panel.setPreferredSize(new Dimension(400, 75));
            this.add(panel);
            this.pack();
            this.setResizable(false);
            GeneralUtils.centerOnScreen((Window)this);
            this.setVisible(true);
            boolean foundCurrentVersion = false;
            for (int i = versions.size() - 1; i >= 0; --i) {
                File f;
                Element newVersion = (Element)versions.get(i);
                if (!foundCurrentVersion && newVersion.getChild("name").getText().equals("Assemble 1.0")) {
                    foundCurrentVersion = true;
                    continue;
                }
                if (!foundCurrentVersion) continue;
                if (newVersion.getAttribute("password") != null) {
                    String password = newVersion.getAttribute("password").getValue();
                    String userPassword = JOptionPane.showInputDialog(null, (Object)("Please enter a password to update to " + newVersion.getValue()));
                    if (userPassword == null || !password.equals(userPassword)) {
                        JOptionPane.showMessageDialog(null, "Wrong password");
                        this.dispose();
                        return;
                    }
                }
                this.newFiles = new ArrayList<String>();
                this.filesToDelete = new ArrayList<String>();
                this.setTitle("Update to " + newVersion.getChild("name").getText());
                for (Object _o : newVersion.getChild("files").getChildren("file")) {
                    Element file = (Element)_o;
                    if ("add".equals(file.getAttributeValue("action"))) {
                        this.title.setText("Add " + file.getChild("destination").getText());
                        this.updateFile(file.getChild("url").getText(), Assemble.getInstallPath() + file.getChild("destination").getText().replace('/', System.getProperty("file.separator").charAt(0)));
                        continue;
                    }
                    if (!"delete".equals(file.getAttributeValue("action"))) continue;
                    this.title.setText("Delete " + file.getChild("destination").getText());
                    this.filesToDelete.add(Assemble.getInstallPath() + file.getChild("destination").getText().replace('/', System.getProperty("file.separator").charAt(0)));
                }
                if (this.currentTask != null) {
                    while (!this.currentTask.isDone()) {
                    }
                }
                for (String newFile : this.newFiles) {
                    new File(newFile).delete();
                    new File(newFile + "_tmp").renameTo(new File(newFile));
                    if (!newFile.endsWith(".zip")) continue;
                    f = new File(newFile);
                    IOUtils.extractArchivedFile((String)f.getAbsolutePath(), (File)f, (ZipExtractionPrintingDevice)this);
                }
                for (String fileToDelete : this.filesToDelete) {
                    f = new File(fileToDelete);
                    if (f.isDirectory()) {
                        IOUtils.deleteDirectory((File)f);
                        continue;
                    }
                    f.delete();
                }
            }
            JOptionPane.showMessageDialog(null, "Assemble has been successfully updated to \"" + ((Element)versions.get(0)).getChild("name").getText() + "\"." + "\nRestart it to use the new version." + "\nRead the CHANGELOG file in the Assemble directory for details about this update.");
            this.dispose();
        }

        private void updateFile(final String fileToDownload, final String destination) {
            if (this.currentTask != null) {
                while (!this.currentTask.isDone()) {
                }
            }
            this.currentTask = new SwingWorker(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void doInBackground() {
                    URLConnection connection = null;
                    InputStream is = null;
                    FileOutputStream destinationFile = null;
                    try {
                        int currentPos;
                        URL url = new URL(fileToDownload);
                        connection = url.openConnection();
                        int length = connection.getContentLength();
                        UpdateFrame.this.progressBar.setMinimum(0);
                        UpdateFrame.this.progressBar.setMaximum(length);
                        UpdateFrame.this.progressBar.setValue(0);
                        if (length == -1) {
                            throw new IOException("Empty File");
                        }
                        is = new BufferedInputStream(connection.getInputStream());
                        byte[] data = new byte[length];
                        int currentBit = 0;
                        for (currentPos = 0; currentPos < length; currentPos += currentBit) {
                            UpdateFrame.this.progressBar.setValue(currentPos);
                            currentBit = is.read(data, currentPos, data.length - currentPos);
                            if (currentBit == -1) break;
                        }
                        if (currentPos != length) {
                            throw new IOException("The file has not been recovered completely: " + currentPos + " on " + length + ")");
                        }
                        destinationFile = new FileOutputStream(destination + "_tmp");
                        destinationFile.write(data);
                        destinationFile.flush();
                        UpdateFrame.this.newFiles.add(destination);
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Malformed URL : " + fileToDownload);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            is.close();
                            destinationFile.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            };
            this.currentTask.execute();
        }

        public void setMessage(String message) {
            this.title.setText(message);
        }

        public void setTotalFileToExtract(int total) {
        }
    }

    class MessageBar
    extends JToolBar
    implements ProgressMonitor {
        private JTextField message;
        private JProgressBar progressBar;
        private MemoryMonitor memoryMonitor;
        private JLabel warning;
        private JLabel connectionStatus;
        private Exception currentException;
        private String messageAssociatedToTheException;
        private Timer timer;
        private Icon exclamation = RessourcesUtils.getIcon("16/exclamation.png");
        private Icon noExclamation = RessourcesUtils.getIcon("16/no-exclamation.png");

        MessageBar() {
            this.setFloatable(false);
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout(this, 0));
            this.timer = new Timer(500, new ActionListener(){
                private boolean b = true;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.b) {
                        MessageBar.this.warning.setIcon(MessageBar.this.exclamation);
                    } else {
                        MessageBar.this.warning.setIcon(MessageBar.this.noExclamation);
                    }
                    this.b = !this.b;
                }
            });
            this.message = new JTextField("Assemble ready...");
            this.message.setBackground(Color.white);
            this.message.setEditable(false);
            this.add(this.message);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.progressBar = new JProgressBar(){

                public Dimension getMaximumSize() {
                    return new Dimension(150, 20);
                }

                public Dimension getMinimumSize() {
                    return this.getMaximumSize();
                }

                public Dimension getPreferredSize() {
                    return this.getMaximumSize();
                }
            };
            this.add(this.progressBar);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.warning = new JLabel(this.noExclamation);
            this.warning.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ErrorInfo errorInfo = new ErrorInfo("Error", MessageBar.this.messageAssociatedToTheException, null, null, (Throwable)MessageBar.this.currentException, Level.SEVERE, null);
                    MessageBar.this.timer.stop();
                    MessageBar.this.warning.setIcon(null);
                    MessageBar.this.currentException = null;
                    MessageBar.this.messageAssociatedToTheException = null;
                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                }
            });
            this.add(this.warning);
            if (this.currentException == null) {
                this.warning.setToolTipText("No errors");
            } else {
                this.warning.setToolTipText("Click for error details");
            }
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.connectionStatus = new JLabel(RessourcesUtils.getIcon("16/connect.png"));
            this.connectionStatus.setToolTipText("Connected to " + Assemble.this.workingSession.getPlatformAddress());
            this.add(this.connectionStatus);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.memoryMonitor = new MemoryMonitor();
            this.add((Component)this.memoryMonitor);
            this.memoryMonitor.start();
        }

        public void printMessage(String message) {
            this.timer.stop();
            this.warning.setIcon(null);
            this.currentException = null;
            this.messageAssociatedToTheException = null;
            this.message.setText(message);
        }

        public void printException(Exception e) {
            this.timer.stop();
            this.warning.setIcon(null);
            this.currentException = null;
            this.messageAssociatedToTheException = null;
            if (NoSolutionException.class.isInstance(e)) {
                JOptionPane.showMessageDialog(Assemble.this.window, e.getMessage());
            } else {
                this.message.setText(e.getMessage());
                this.currentException = e;
                this.messageAssociatedToTheException = e.getMessage();
                this.timer.start();
            }
        }

        public void startAnimation() {
            this.progressBar.setIndeterminate(true);
        }

        public void stopAnimation() {
            this.progressBar.setIndeterminate(false);
        }
    }

    private class NewsPanel
    extends JXPanel {
        private static final String feedChannel = "http://serialized-thoughts.blogspot.com/feeds/posts/default";
        private List<Post> posts = new ArrayList<Post>();
        private String lastPostID;
        private AbstractTableModel dataModel;

        private NewsPanel() {
            this.setLayout(new BorderLayout());
            this.dataModel = new AbstractTableModel(){

                public int getColumnCount() {
                    return 2;
                }

                public int getRowCount() {
                    return NewsPanel.this.posts.size();
                }

                public Object getValueAt(int row, int col) {
                    Post p = (Post)NewsPanel.this.posts.get(row);
                    switch (col) {
                        case 0: {
                            return p.title;
                        }
                        case 1: {
                            return new SimpleDateFormat("yyyy.MM.dd HH:mm").format(p.date);
                        }
                    }
                    return null;
                }

                public String getColumnName(int col) {
                    switch (col) {
                        case 0: {
                            return "Post Title";
                        }
                        case 1: {
                            return "Publication Date";
                        }
                    }
                    return "?";
                }
            };
            final JXTable table = new JXTable((TableModel)this.dataModel);
            table.setEditable(false);
            table.setSortable(false);
            table.setColumnControlVisible(false);
            table.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            table.getColumnModel().getColumn(1).setMinWidth(200);
            table.getColumnModel().getColumn(1).setMaxWidth(200);
            table.getColumnModel().getColumn(1).setPreferredWidth(200);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        GeneralUtils.openBrowser((String)((Post)NewsPanel.this.posts.get(table.getSelectedRow())).url.toString());
                    }
                }
            });
            this.add(new JScrollPane((Component)table), "Center");
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    NewsPanel.this.fetchRSSChannel();
                    new Timer(1800000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                NewsPanel.this.fetchRSSChannel();
                            }
                            catch (FeedException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                    return null;
                }
            }.execute();
        }

        private void fetchRSSChannel() throws FeedException, IOException {
            SyndFeedInput sfi = new SyndFeedInput();
            SyndFeed feed = sfi.build((Reader)new XmlReader(new URL(feedChannel)));
            if (this.lastPostID == null) {
                for (Object o : feed.getEntries()) {
                    SyndEntry entry = (SyndEntry)o;
                    Post p = new Post();
                    p.id = entry.getUri();
                    if (this.lastPostID == null) {
                        this.lastPostID = p.id;
                    }
                    p.title = entry.getTitle();
                    p.url = new URL(entry.getLink());
                    p.date = entry.getPublishedDate();
                    this.posts.add(p);
                    this.dataModel.fireTableRowsInserted(this.posts.size() - 1, this.posts.size() - 1);
                }
            } else {
                Object o;
                SyndEntry entry;
                int i = 0;
                Iterator i$ = feed.getEntries().iterator();
                while (i$.hasNext() && !this.lastPostID.equals((entry = (SyndEntry)(o = i$.next())).getUri())) {
                    Post p = new Post();
                    p.id = entry.getUri();
                    if (this.lastPostID == null) {
                        this.lastPostID = p.id;
                    }
                    p.title = entry.getTitle();
                    p.url = new URL(entry.getLink());
                    p.date = entry.getPublishedDate();
                    this.posts.add(i++, p);
                    this.dataModel.fireTableRowsInserted(i - 1, i - 1);
                }
                if (i > 0) {
                    this.lastPostID = this.posts.get(0).id;
                    Assemble.this.mediator.getToolWindowManager().getToolWindow((Object)"News").setFlashing(true);
                }
            }
        }

        private class Post {
            private String title;
            private String id;
            private URL url;
            private Date date;

            private Post() {
            }
        }
    }

    private class UndoHistoryPanel
    extends JXPanel {
        private JXTable table;

        private UndoHistoryPanel() {
            this.setLayout(new BorderLayout());
            this.table = new JXTable();
            this.table.setBackground(Color.WHITE);
            this.table.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            this.table.setSortable(false);
            this.table.setModel((TableModel)new DefaultTableModel(new Object[0][2], new String[]{"Name", "Date"}){
                Class[] types;
                boolean[] canEdit;
                {
                    super(x0, x1);
                    this.types = new Class[]{String.class, Date.class};
                    this.canEdit = new boolean[]{false, false};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Assemble.this.mediator.restoreState((String)UndoHistoryPanel.this.table.getValueAt(UndoHistoryPanel.this.table.getSelectedRow(), 0));
                    }
                }
            });
            this.table.getColumn((Object)"Date").setCellRenderer(new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = new JLabel(new SimpleDateFormat("yyyy.MM.dd HH:mm").format((Date)o));
                    label.setOpaque(true);
                    label.setFont(new Font(label.getFont().getName(), 0, label.getFont().getSize()));
                    if (isSelected) {
                        label.setForeground(table.getSelectionForeground());
                        label.setBackground(table.getSelectionBackground());
                    } else {
                        label.setForeground(table.getForeground());
                        label.setBackground(table.getBackground());
                    }
                    return label;
                }
            });
            this.add(new JScrollPane((Component)this.table), "Center");
        }

        private void restorePreviousState() {
            if (this.table.getSelectedRow() > 0) {
                Assemble.this.mediator.restoreState((String)this.table.getValueAt(this.table.getSelectedRow() - 1, 0));
                this.table.setRowSelectionInterval(this.table.getSelectedRow() - 1, this.table.getSelectedRow() - 1);
            }
        }

        private void restoreNextState() {
            if (this.table.getSelectedRow() > 0 && this.table.getSelectedRow() < this.table.getRowCount() - 1) {
                Assemble.this.mediator.restoreState((String)this.table.getValueAt(this.table.getSelectedRow() + 1, 0));
                this.table.setRowSelectionInterval(this.table.getSelectedRow() - 1, this.table.getSelectedRow() + 1);
            }
        }
    }

    private class AssembleEditionPanel
    extends JXPanel {
        private AssembleEditionPanel() {
            this.setLayout((LayoutManager)new MigLayout("", "[left]"));
            this.setBackground(Color.WHITE);
        }
    }

    private class AssembleSelectionPanel
    extends JXPanel {
        private AssembleSelectionPanel() {
            this.setLayout((LayoutManager)new MigLayout("", "[left]"));
            this.setBackground(Color.WHITE);
        }
    }

    private class AssembleDisplayPanel
    extends JXPanel {
        private AssembleDisplayPanel() {
            this.setLayout((LayoutManager)new MigLayout("", "[left]"));
            this.setBackground(Color.WHITE);
        }
    }

    private class SecondaryStructureDisplayPanel
    extends JXPanel {
        private JCheckBox fiveToThreeCheckBox;
        private JCheckBox labels;

        private SecondaryStructureDisplayPanel() {
            this.setLayout((LayoutManager)new VerticalLayout(5));
            this.setBackground(Color.WHITE);
            JXPanel subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CWW"));
            subPanel.add((Component)new LWFamilyButton("TWW"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CHW"));
            subPanel.add((Component)new LWFamilyButton("THW"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CHH"));
            subPanel.add((Component)new LWFamilyButton("THH"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CHS"));
            subPanel.add((Component)new LWFamilyButton("THS"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CSW"));
            subPanel.add((Component)new LWFamilyButton("TSW"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CSS"));
            subPanel.add((Component)new LWFamilyButton("TSS"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.setLayout((LayoutManager)new VerticalLayout());
            this.fiveToThreeCheckBox = new JCheckBox("5'->3' orientation");
            this.fiveToThreeCheckBox.setBackground(Color.WHITE);
            this.fiveToThreeCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas() != null) {
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().setFiveToThreeOrientationDisplay(!Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().isFiveToThreeOrientationDisplayed());
                    }
                }
            });
            subPanel.add((Component)this.fiveToThreeCheckBox);
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.setLayout((LayoutManager)new VerticalLayout());
            this.labels = new JCheckBox("labels");
            this.labels.setBackground(Color.WHITE);
            this.labels.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas() != null) {
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().setDisplayLabels(SecondaryStructureDisplayPanel.this.labels.isSelected());
                    }
                }
            });
            subPanel.add((Component)this.labels);
            this.add((Component)subPanel);
        }

        private void updateDisplayOptions() {
            if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas() != null) {
                this.fiveToThreeCheckBox.setSelected(Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().isFiveToThreeOrientationDisplayed());
                this.labels.setSelected(Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().isLabelsDisplayed());
                for (Component c : this.getComponents()) {
                    if (!JXPanel.class.isInstance(c)) continue;
                    for (Component _c : ((JXPanel)c).getComponents()) {
                        if (!LWFamilyButton.class.isInstance(_c)) continue;
                        ((LWFamilyButton)_c).update(Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas());
                    }
                }
            }
        }

        private class LWFamilyButton
        extends JButton {
            private String family;

            private LWFamilyButton(final String family) {
                this.family = family;
                this.setIcon(new ImageIcon(RessourcesUtils.getImage(family + ".png")));
                this.setBackground(Color.WHITE);
                this.setToolTipText("Display/Hide this family");
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas() != null) {
                            if (family.equals("CSs")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSS");
                            } else if (family.equals("TSs")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSS");
                            } else if (family.equals("CsS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSS");
                            } else if (family.equals("TsS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSS");
                            } else if (family.equals("CSS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSS");
                            } else if (family.equals("TSS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSS");
                            } else if (family.equals("CWH")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CHW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CWH");
                            } else if (family.equals("CHW")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CHW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CWH");
                            } else if (family.equals("TWH")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("THW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TWH");
                            } else if (family.equals("THW")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("THW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TWH");
                            } else if (family.equals("CHS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CHS");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSH");
                            } else if (family.equals("CSH")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CHS");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSH");
                            } else if (family.equals("THS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("THS");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSH");
                            } else if (family.equals("TSH")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("THS");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSH");
                            } else if (family.equals("CWS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CWS");
                            } else if (family.equals("CSW")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CWS");
                            } else if (family.equals("TWS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TWS");
                            } else if (family.equals("TSW")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TWS");
                            } else {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily(family);
                            }
                            if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().displayFamily(family)) {
                                LWFamilyButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage(family + ".png")));
                            } else {
                                LWFamilyButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage(family + "_hidden.png")));
                            }
                        }
                    }
                });
            }

            private void update(SecondaryCanvas canvas) {
                if (canvas.displayFamily(this.family)) {
                    this.setIcon(new ImageIcon(RessourcesUtils.getImage(this.family + ".png")));
                } else {
                    this.setIcon(new ImageIcon(RessourcesUtils.getImage(this.family + "_hidden.png")));
                }
            }
        }
    }

    private class CreateRNAMotifPanel
    extends JXPanel {
        private JLabel snapshot;
        private BufferedImage image;

        private CreateRNAMotifPanel() {
            this.setLayout((LayoutManager)new MigLayout("", "[left]"));
            this.setBackground(Color.WHITE);
            this.snapshot = new JLabel();
            this.snapshot.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.snapshot.setIcon(new ImageIcon(RessourcesUtils.getImage("no_capture.png")));
            this.add(this.snapshot, "span");
            JButton capture = new JButton("capture");
            capture.setBackground(Color.WHITE);
            capture.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        CreateRNAMotifPanel.this.image = Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getImage(true);
                        if (CreateRNAMotifPanel.this.image != null) {
                            int height;
                            float ratio;
                            int width = CreateRNAMotifPanel.this.image.getWidth();
                            float f = ratio = width >= (height = CreateRNAMotifPanel.this.image.getHeight()) ? (float)width / 300.0f : (float)height / 300.0f;
                            if (ratio > 1.0f) {
                                CreateRNAMotifPanel.this.snapshot.setIcon(new ImageIcon(CreateRNAMotifPanel.this.image.getScaledInstance((int)((float)width / ratio), (int)((float)height / ratio), 4)));
                            } else {
                                CreateRNAMotifPanel.this.snapshot.setIcon(new ImageIcon(CreateRNAMotifPanel.this.image));
                            }
                        }
                    }
                }
            });
            this.add(capture, "span");
            this.add(new JLabel("RNA Motif Details"), "split, span, gaptop 20");
            this.add(new JSeparator(), "growx, wrap, gaptop 20");
            this.add(new JLabel("Name"), "gap 10");
            final JTextField motifName = new JTextField(10);
            this.add(motifName, "span");
            this.add(new JLabel("PubMed ID (Optional)"), "gap 10");
            final JTextField pmid = new JTextField(10);
            this.add(pmid, "span");
            this.add(new JLabel("Category"), "gap 10");
            final ArrayList<String> motifCategories = new ArrayList<String>();
            for (String category : motifsIcons.keySet()) {
                motifCategories.add(category);
            }
            final JComboBox<Object> motifCategory = new JComboBox<Object>(motifCategories.toArray());
            this.add(motifCategory);
            JButton b = new JButton("Create new category");
            b.setBackground(Color.WHITE);
            this.add(b, "wrap");
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    String newCategoryName = JOptionPane.showInputDialog(Assemble.this.window, (Object)"Choose a new category name");
                    if (newCategoryName != null && newCategoryName.length() != 0) {
                        if (motifCategories.contains(newCategoryName)) {
                            JOptionPane.showMessageDialog(Assemble.this.window, "This category already exists!!");
                        } else {
                            motifCategory.addItem(newCategoryName);
                            motifCategory.setSelectedItem(newCategoryName);
                        }
                    }
                }
            });
            this.add(new JLabel("Comment"), "span, gap 10");
            final JTextArea comment = new JTextArea(10, 30);
            this.add(new JScrollPane(comment), "span, gap 10");
            JButton createMotif = new JButton("Create motif");
            createMotif.setBackground(Color.WHITE);
            createMotif.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            try {
                                String _pmid;
                                File rnamlFile2D;
                                List tss = Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().getSecondaryStructure().getParentFeatures(TertiaryStructure.class);
                                if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() == null) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "No Model 2D loaded");
                                    return null;
                                }
                                if (tss.size() == 0) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "No Model 3D loaded");
                                    return null;
                                }
                                TertiaryStructure ts = (TertiaryStructure)tss.get(0);
                                String pdbID = ts.getSource().getId().split("\\.")[0];
                                if (!Assemble.this.myPDBPanel.isPDBStored(pdbID.toLowerCase())) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "You can only create a motif from a structure stored in the \"MyPDB\" panel");
                                    return null;
                                }
                                if (CreateRNAMotifPanel.this.image == null) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "You have to do a capture of your motif");
                                    return null;
                                }
                                if (motifCategory.getSelectedItem() == null) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "You have to choose a valid category for your motif");
                                    return null;
                                }
                                if (motifName == null || motifName.getText().trim().length() == 0) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "You have to choose a valid name for your motif");
                                    return null;
                                }
                                Assemble.this.getProgressMonitor().printMessage("RNA Motif Creation");
                                Assemble.this.getProgressMonitor().startAnimation();
                                File motifCategoryDir = new File(new File(new File(Assemble.getMyPDBDir(), pdbID), "motifs"), (String)motifCategory.getSelectedItem());
                                if (!motifCategoryDir.exists()) {
                                    motifCategoryDir.mkdir();
                                }
                                if ((rnamlFile2D = new File(motifCategoryDir, motifName.getText().trim() + ".rnaml")).exists()) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "A motif with the name " + motifName.getText().trim() + " already exists!!");
                                    Assemble.this.getProgressMonitor().stopAnimation();
                                    return null;
                                }
                                rnamlFile2D.createNewFile();
                                HashMap<Molecule, MyTreeSet> sortedResidues3D = new HashMap<Molecule, MyTreeSet>();
                                for (Residue2D r : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getGraphicContext().getSelectedResiduesFromMotif()) {
                                    Molecule m = (Molecule)r.getResidue2DFeature().getMolecules().iterator().next();
                                    MyTreeSet _residues3D = (MyTreeSet)sortedResidues3D.get(m);
                                    int position = r.getResidue2DFeature().getFullLocation(m).getStart();
                                    if (_residues3D != null) {
                                        _residues3D.add(position, ts.getResidue3DAt(position, m));
                                        continue;
                                    }
                                    _residues3D = new MyTreeSet(m);
                                    _residues3D.add(position, ts.getResidue3DAt(position, m));
                                    sortedResidues3D.put(m, _residues3D);
                                }
                                Element rnaml = new Element("rnaml");
                                Document doc = new Document(rnaml);
                                if (comment.getText() != null && comment.getText().trim().length() != 0) {
                                    rnaml.setAttribute("comment", comment.getText().trim());
                                }
                                if (pmid.getText() != null && (_pmid = pmid.getText().trim()).length() != 0) {
                                    Element reference = new Element("reference");
                                    Element pubmed_id = new Element("pubmed-id");
                                    reference.addContent((Content)pubmed_id);
                                    pubmed_id.addContent(_pmid);
                                    rnaml.addContent((Content)reference);
                                }
                                Element tertiaryStructure = new Element("tertiary-structure");
                                tertiaryStructure.setAttribute("name", motifName.getText());
                                Element structureAnnotation = new Element("structure-annotation");
                                structureAnnotation.setAttribute("name", motifName.getText());
                                StringBuffer moleculeIds = new StringBuffer();
                                for (Map.Entry _e : sortedResidues3D.entrySet()) {
                                    List<LocatedString> subSequences = ((MyTreeSet)_e.getValue()).getSubSequences();
                                    for (LocatedString s : subSequences) {
                                        Element molecule = new Element("molecule");
                                        molecule.setAttribute("id", ((Molecule)_e.getKey()).getName() + subSequences.indexOf(s));
                                        moleculeIds.append(((Molecule)_e.getKey()).getName() + subSequences.indexOf(s) + " ");
                                        molecule.setAttribute("type", "rna");
                                        molecule.setAttribute("start", "" + s.location.getStart());
                                        molecule.setAttribute("end", "" + s.location.getEnd());
                                        rnaml.addContent((Content)molecule);
                                        Element identity = new Element("identity");
                                        molecule.addContent((Content)identity);
                                        Element name = new Element("name");
                                        identity.addContent((Content)name);
                                        name.addContent(((Molecule)_e.getKey()).getName() + subSequences.indexOf(s));
                                        Element sequence = new Element("sequence");
                                        molecule.addContent((Content)sequence);
                                        sequence.setAttribute("length", "" + s.subSequence.length());
                                        Element seqData = new Element("seq-data");
                                        seqData.addContent(s.subSequence);
                                        sequence.addContent((Content)seqData);
                                        for (Residue3D r : (MyTreeSet)_e.getValue()) {
                                            int position = r.getFullLocation((Molecule)_e.getKey()).getStart();
                                            if (!s.location.hasPosition(position)) continue;
                                            Element base = new Element("base");
                                            base.setAttribute("molecule-id", ((Molecule)_e.getKey()).getName() + subSequences.indexOf(s));
                                            tertiaryStructure.addContent((Content)base);
                                            int[] ends = s.location.getBoundaries();
                                            for (int i = 0; i < ends.length - 1; i += 2) {
                                                if (position < ends[i] || position > ends[i + 1]) continue;
                                                base.setAttribute("id", "" + (position - ends[i] + 1));
                                                break;
                                            }
                                            for (Residue3D.Atom a : r.getAtoms()) {
                                                if (!a.hasCoordinatesFilled()) continue;
                                                Element atom = new Element("atom");
                                                atom.setAttribute("type", a.getName());
                                                atom.setAttribute("x", "" + a.getX());
                                                atom.setAttribute("y", "" + a.getY());
                                                atom.setAttribute("z", "" + a.getZ());
                                                base.addContent((Content)atom);
                                            }
                                        }
                                    }
                                }
                                tertiaryStructure.setAttribute("molecule-ids", moleculeIds.toString().trim());
                                rnaml.addContent((Content)tertiaryStructure);
                                structureAnnotation.setAttribute("molecule-ids", moleculeIds.toString().trim());
                                List<Interaction2D> interactionsToExport = Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getGraphicContext().getSelectedInteractionsFromMotif();
                                for (Interaction2D interaction : interactionsToExport) {
                                    int i;
                                    int[] ends;
                                    if (!BaseBaseInteraction2D.class.isInstance(interaction)) continue;
                                    Molecule molecule = (Molecule)interaction.getResidue().getResidues().listIterator().next().getResidue2DFeature().getMolecules().iterator().next();
                                    Molecule partnerMolecule = (Molecule)interaction.getPartnerResidue().getResidues().listIterator().next().getResidue2DFeature().getMolecules().iterator().next();
                                    MyTreeSet treeSet = (MyTreeSet)sortedResidues3D.get(molecule);
                                    MyTreeSet partnerTreeSet = (MyTreeSet)sortedResidues3D.get(partnerMolecule);
                                    Element basePair = new Element("base-pair");
                                    structureAnnotation.addContent((Content)basePair);
                                    List<LocatedString> subSequences = treeSet.getSubSequences();
                                    int position = interaction.getResidue().getAbsolutePosition();
                                    basePair.setAttribute("orientation", "" + ((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().getOrientation());
                                    block9: for (LocatedString s : subSequences) {
                                        if (!s.location.hasPosition(position)) continue;
                                        basePair.setAttribute("molecule1-id", molecule.getName() + subSequences.indexOf(s));
                                        ends = s.location.getBoundaries();
                                        for (i = 0; i < ends.length - 1; i += 2) {
                                            if (position < ends[i] || position > ends[i + 1]) continue;
                                            basePair.setAttribute("base1-id", "" + (position - ends[i] + 1));
                                            break block9;
                                        }
                                    }
                                    basePair.setAttribute("edge1", "" + ((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().getEdge1());
                                    subSequences = partnerTreeSet.getSubSequences();
                                    position = interaction.getPartnerResidue().getAbsolutePosition();
                                    block11: for (LocatedString s : subSequences) {
                                        if (!s.location.hasPosition(position)) continue;
                                        basePair.setAttribute("molecule2-id", molecule.getName() + subSequences.indexOf(s));
                                        ends = s.location.getBoundaries();
                                        for (i = 0; i < ends.length - 1; i += 2) {
                                            if (position < ends[i] || position > ends[i + 1]) continue;
                                            basePair.setAttribute("base2-id", "" + (position - ends[i] + 1));
                                            break block11;
                                        }
                                    }
                                    basePair.setAttribute("edge2", "" + ((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().getEdge2());
                                }
                                rnaml.addContent((Content)structureAnnotation);
                                XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                                FileWriter writer = new FileWriter(rnamlFile2D);
                                outputter.output(doc, (Writer)writer);
                                writer.close();
                                File pngFile = new File(motifCategoryDir, motifName.getText().trim() + ".png");
                                ImageIO.write((RenderedImage)CreateRNAMotifPanel.this.image, "png", pngFile);
                                Assemble.this.myRNAMotifsPanel.addNewIconMotif(pdbID, (String)motifCategory.getSelectedItem(), motifName.getText().trim());
                                Assemble.this.mediator.getToolWindowManager().getToolWindow((Object)"MyMotifs").setActive(true);
                            }
                            catch (IOException e1) {
                                ErrorInfo errorInfo = new ErrorInfo("Error", "Cannot create the RNA motif!!", null, null, (Throwable)e1, Level.SEVERE, null);
                                JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                            }
                            Assemble.this.getProgressMonitor().stopAnimation();
                            return null;
                        }
                    }.execute();
                }

                class LocatedString {
                    private String subSequence;
                    private Location location;

                    LocatedString(String subSequence, Location l) {
                        this.subSequence = subSequence;
                        this.location = l;
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class MyTreeSet
                extends TreeSet<Residue3D> {
                    private Molecule m;
                    private Location location;

                    private MyTreeSet(final Molecule m) {
                        super(new Comparator(){

                            public int compare(Object o1, Object o2) {
                                return ((Residue3D)o1).getFullLocation(m).getStart() - ((Residue3D)o2).getFullLocation(m).getStart();
                            }

                            public boolean equals(Object obj) {
                                return false;
                            }
                        });
                        this.m = m;
                        this.location = new Location();
                    }

                    public void add(int position, Residue3D residue3D) {
                        if (super.add(residue3D)) {
                            this.location.add(position);
                        }
                    }

                    public List<LocatedString> getSubSequences() {
                        ArrayList<LocatedString> subSequences = new ArrayList<LocatedString>();
                        String sequence = this.m.printSequence();
                        int[] boundaries = this.location.getBoundaries();
                        for (int i = 0; i < boundaries.length - 1; i += 2) {
                            subSequences.add(new LocatedString(sequence.substring(boundaries[i] - 1, boundaries[i + 1]), new Location(boundaries[i], boundaries[i + 1])));
                        }
                        return subSequences;
                    }
                }
            });
            this.add(createMotif, "span, gap 10");
        }
    }

    private class FlatButton
    extends JButton {
        private FlatButton(String url, String name) {
            this(RessourcesUtils.getIcon(url), name);
        }

        private FlatButton(Icon image, String name) {
            super(image);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setBackground(Color.WHITE);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    FlatButton.this.setBackground(Color.LIGHT_GRAY);
                    FlatButton.this.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    FlatButton.this.setBackground(Color.WHITE);
                    FlatButton.this.setBorderPainted(false);
                }
            });
            this.setToolTipText(name);
        }

        public Point getToolTipLocation(MouseEvent e) {
            return new Point(0, 0);
        }
    }

    private class PreferencesMenu
    extends JMenu
    implements ActionListener {
        private JMenuItem keyManager;
        private JMenuItem renderingOptions;

        private PreferencesMenu() {
            super("Preferences");
            this.keyManager = new JMenuItem("Keyboard Shortcuts");
            this.renderingOptions = new JMenuItem("3D Rendering Parameters");
            this.add(this.keyManager);
            this.add(this.renderingOptions);
            this.keyManager.addActionListener(this);
            this.renderingOptions.addActionListener(this);
            this.keyManager.setIcon(RessourcesUtils.getIcon("22/keyboard.png"));
            this.renderingOptions.setIcon(RessourcesUtils.getIcon("22/parameters.png"));
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
        }
    }

    private class PluginsMenu
    extends JMenu {
        private PluginsMenu() {
            super("Plugins");
            File pluginsDir = Assemble.getPluginsPath();
            for (File pluginDir : pluginsDir.listFiles(new java.io.FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                File script = new File(pluginDir, "Plugin.groovy");
                if (!script.exists()) continue;
                try {
                    Class pluginClass;
                    GroovyObject plugin;
                    List subMenuTitles;
                    GroovyShell groovyShell = new GroovyShell();
                    groovyShell.setProperty("session", (Object)Assemble.this.getWorkingSession());
                    groovyShell.setProperty("agent", (Object)Assemble.this.agent);
                    File lib = new File(script.getParentFile(), "lib");
                    if (lib.exists()) {
                        for (File f : lib.listFiles(new java.io.FileFilter(){

                            public boolean accept(File file) {
                                return file.getName().endsWith(".jar");
                            }
                        })) {
                            groovyShell.getClassLoader().addURL(f.toURL());
                        }
                    }
                    if ((subMenuTitles = (List)(plugin = (GroovyObject)(pluginClass = groovyShell.getClassLoader().parseClass(script)).newInstance()).invokeMethod("getSubTitles", null)).size() == 0) {
                        this.add(new PluginMenuItem(plugin, (String)plugin.invokeMethod("getMenuTitle", null), (String)plugin.invokeMethod("getMenuToolTip", null)));
                        continue;
                    }
                    JMenu pluginMenu = new JMenu((String)plugin.invokeMethod("getMenuTitle", null));
                    pluginMenu.setToolTipText((String)plugin.invokeMethod("getMenuToolTip", null));
                    this.add(pluginMenu);
                    List subMenuToolTips = (List)plugin.invokeMethod("getSubToolTips", null);
                    for (int i = 0; i < subMenuTitles.size(); ++i) {
                        pluginMenu.add(new PluginMenuItem(plugin, (String)subMenuTitles.get(i), i >= subMenuToolTips.size() ? "" : (String)subMenuToolTips.get(i)));
                    }
                }
                catch (Exception e) {
                    ErrorInfo errorInfo = new ErrorInfo("Error", "Problem to load the plugin " + pluginDir, null, null, (Throwable)e, Level.SEVERE, null);
                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                }
            }
        }

        private class PluginMenuItem
        extends JMenuItem {
            private GroovyObject plugin;

            private PluginMenuItem(final GroovyObject plugin, final String menuTitle, String toolTip) {
                super(menuTitle);
                this.setToolTipText(toolTip);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new SwingWorker(){

                            protected Object doInBackground() {
                                try {
                                    plugin.invokeMethod("run", (Object)new Object[]{Assemble.this, menuTitle});
                                }
                                catch (Exception e) {
                                    ErrorInfo errorInfo = new ErrorInfo("Error", "Problem to execute the plugin", null, null, (Throwable)e, Level.SEVERE, null);
                                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                                }
                                return null;
                            }
                        }.execute();
                    }
                });
            }
        }
    }

    private class EditMenu
    extends JMenu
    implements ActionListener {
        private JMenuItem cut;
        private JMenuItem link;
        private JMenuItem linkAll;
        private JMenuItem superimposeAtom;
        private JMenuItem superimposeStruct;
        private JMenuItem torsion;
        private JMenuItem deleteMolecule;

        private EditMenu() {
            super("Edit");
            this.cut = new JMenuItem("Cut Chain");
            this.link = new JMenuItem("Link Chains");
            this.linkAll = new JMenuItem("Link All Chains");
            this.superimposeAtom = new JMenuItem("Superimpose 2 atoms");
            this.superimposeStruct = new JMenuItem("Superimpose 2 similar structures");
            this.torsion = new JMenuItem("Torsions");
            this.deleteMolecule = new JMenuItem("Delete Molecule");
            this.addSeparator();
            this.add(this.cut);
            this.add(this.link);
            this.add(this.linkAll);
            this.addSeparator();
            this.add(this.superimposeAtom);
            this.add(this.superimposeStruct);
            this.addSeparator();
            this.add(this.torsion);
            this.add(this.deleteMolecule);
            this.cut.addActionListener(this);
            this.link.addActionListener(this);
            this.linkAll.addActionListener(this);
            this.superimposeAtom.addActionListener(this);
            this.superimposeStruct.addActionListener(this);
            this.torsion.addActionListener(this);
            this.deleteMolecule.addActionListener(this);
            this.torsion.setAccelerator(KeyStroke.getKeyStroke(84, 2));
            this.cut.setIcon(RessourcesUtils.getIcon("22/cut.png"));
            this.link.setIcon(RessourcesUtils.getIcon("22/link.png"));
            this.linkAll.setIcon(RessourcesUtils.getIcon("22/link.png"));
            this.superimposeAtom.setIcon(RessourcesUtils.getIcon("22/superimpose.png"));
            this.superimposeStruct.setIcon(RessourcesUtils.getIcon("22/superimpose.png"));
            this.torsion.setIcon(RessourcesUtils.getIcon("22/torsion.png"));
            this.deleteMolecule.setIcon(RessourcesUtils.getIcon("22/unselect.png"));
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.cut) {
                if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 1) {
                    JOptionPane.showMessageDialog(null, "Select only one residue to use this option.");
                } else {
                    fr.unistra.ibmc.assemble.structures.Residue r = Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator().next();
                    if (r.getChain().getLength() > 1) {
                        ((ResidueNA)r).splitChain();
                        Assemble.this.mediator.getRenderer().reComputeNeeded();
                    }
                }
            } else if (source == this.torsion) {
                if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 1) {
                    JOptionPane.showMessageDialog(Assemble.this.window, "Select only one residue to use this option.");
                } else {
                    Assemble.this.mediator.getResidueManager().setResidue((ResidueNA)Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator().next());
                    ToolWindow toolWindow = Assemble.this.mediator.getToolWindowManager().getToolWindow((Object)"ResidueManager");
                    if (toolWindow == null) {
                        toolWindow = Assemble.this.mediator.getToolWindowManager().registerToolWindow("ResidueManager", "Residue Manager", null, (Component)new JScrollPane((Component)((Object)Assemble.this.mediator.getResidueManager())), ToolWindowAnchor.RIGHT);
                    }
                    DockedTypeDescriptor descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
                    descriptor.setDockLength(300);
                    descriptor.setPreviewEnabled(false);
                    toolWindow.setAvailable(true);
                    toolWindow.setVisible(true);
                }
            } else if (source == this.link) {
                if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 2) {
                    JOptionPane.showMessageDialog(Assemble.this.window, "Select only two residues to use this option.");
                } else {
                    Iterator<fr.unistra.ibmc.assemble.structures.Residue> it = Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator();
                    fr.unistra.ibmc.assemble.structures.Residue r1 = it.next();
                    fr.unistra.ibmc.assemble.structures.Residue r2 = it.next();
                    ((ResidueNA)r1).bind((ResidueNA)r2, true);
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            } else if (source == this.linkAll) {
                Assemble.this.mediator.get3DModel().bindAllChains();
                Assemble.this.mediator.get3DModel().fireModelModified();
            } else if (source == this.superimposeAtom) {
                Assemble.this.mediator.getRenderer().setSelectMode(48);
            } else if (source == this.superimposeStruct) {
                Assemble.this.mediator.getRenderer().setSelectMode(50);
            } else if (source == this.deleteMolecule) {
                Assemble.this.mediator.getRenderer().setSelectMode(47);
            }
        }
    }

    private class HelpMenu
    extends JMenu {
        private HelpMenu() {
            super("Help");
            this.add(new UpdateMenuItem());
            this.add(new OpenWebPageItem("The Assemble Website", "http://bioinformatics.org/assemble/"));
            this.add(new OpenWebPageItem("Assemble Reference Cards", "http://bioinformatics.org/assemble/refcards.html"));
            this.add(new OpenWebPageItem("Assemble Video Tutorials", "http://bioinformatics.org/assemble/screencasts.html"));
        }

        private class UpdateMenuItem
        extends JMenuItem
        implements ActionListener {
            private UpdateMenuItem() {
                super("Update Assemble");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        Assemble.updateAssemble();
                        return null;
                    }
                }.execute();
            }
        }

        private class OpenWebPageItem
        extends JMenuItem
        implements ActionListener {
            private String url;

            public OpenWebPageItem(String webPageTitle, String url) {
                super(webPageTitle);
                this.url = url;
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.openBrowser((String)this.url);
            }
        }
    }

    private class ColorMenu
    extends JMenu {
        protected Border unselectedBorder;
        protected Border selectedBorder;
        protected Border activeBorder;
        protected Hashtable paneTable;
        protected ColorPane colorPane;

        public ColorMenu(String name) {
            super(name);
            this.unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
            this.selectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
            this.activeBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
            JPanel p = new JPanel();
            p.setBorder(new EmptyBorder(5, 5, 5, 5));
            p.setLayout(new GridLayout(8, 8));
            this.paneTable = new Hashtable();
            int[] values = new int[]{0, 128, 192, 255};
            for (int r = 0; r < values.length; ++r) {
                for (int g = 0; g < values.length; ++g) {
                    for (int b = 0; b < values.length; ++b) {
                        Color c = new Color(values[r], values[g], values[b]);
                        ColorPane pn = new ColorPane(c);
                        p.add(pn);
                        this.paneTable.put(c, pn);
                    }
                }
            }
            this.add(p);
        }

        public void setColor(Color c) {
            Object obj = this.paneTable.get(c);
            if (obj == null) {
                return;
            }
            if (this.colorPane != null) {
                this.colorPane.setSelected(false);
            }
            this.colorPane = (ColorPane)obj;
            this.colorPane.setSelected(true);
        }

        public Color getColor() {
            if (this.colorPane == null) {
                return null;
            }
            return this.colorPane.getColor();
        }

        public void doSelection() {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private class ColorPane
        extends JPanel
        implements MouseListener {
            protected Color color;
            protected boolean isSelected;

            public ColorPane(Color c) {
                this.color = c;
                this.setBackground(c);
                this.setBorder(ColorMenu.this.unselectedBorder);
                String msg = "R " + c.getRed() + ", G " + c.getGreen() + ", B " + c.getBlue();
                this.setToolTipText(msg);
                this.addMouseListener(this);
            }

            public Color getColor() {
                return this.color;
            }

            public Dimension getPreferredSize() {
                return new Dimension(15, 15);
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public void setSelected(boolean selected) {
                this.isSelected = selected;
                if (this.isSelected) {
                    this.setBorder(ColorMenu.this.selectedBorder);
                } else {
                    this.setBorder(ColorMenu.this.unselectedBorder);
                }
            }

            public boolean isSelected() {
                return this.isSelected;
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                ColorMenu.this.setColor(this.color);
                MenuSelectionManager.defaultManager().clearSelectedPath();
                ColorMenu.this.doSelection();
                Assemble.this.mediator.getGlobalSelection().setColor(this.color);
                Assemble.this.mediator.getRna2DViewer().colorSelectedResidues(this.color);
            }

            public void mouseEntered(MouseEvent e) {
                this.setBorder(ColorMenu.this.activeBorder);
            }

            public void mouseExited(MouseEvent e) {
                this.setBorder(this.isSelected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
            }
        }
    }

    private class TertiarySelectionMenu
    extends JMenu {
        private JMenuItem createUserSelection;
        private JMenuItem showSelectionOnly;
        private JMenuItem hideSelectionOnly;
        private JMenuItem colorByResidueType;
        private JMenuItem colorByAtomType;
        private JMenuItem showLabels;
        private JMenuItem hideLabels;
        private JMenu customColorMenu;

        public TertiarySelectionMenu() {
            super("3D Selection");
            this.createUserSelection = new JMenuItem("Store selection");
            this.add(this.createUserSelection);
            this.createUserSelection.setIcon(RessourcesUtils.getIcon("22/user.png"));
            this.createUserSelection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    String name = JOptionPane.showInputDialog("Choose a name for your selection");
                    if (name != null && name.length() != 0) {
                        UserSelection us = new UserSelection(Assemble.this.mediator, name);
                        for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.getGlobalSelection().getSelectedResidues()) {
                            us.add(r);
                        }
                        for (Atom a : Assemble.this.mediator.getGlobalSelection().getSelectedAtoms()) {
                            us.add(a);
                        }
                        Assemble.this.mediator.addUserSelection(us);
                    }
                }
            });
            JMenu mutateResidues = new JMenu("Mutate as...");
            JMenuItem item = new JMenuItem("A");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    for (fr.unistra.ibmc.assemble.structures.Residue residue : Assemble.this.mediator.getGlobalSelection().getSelectedResidues()) {
                    }
                }
            });
            mutateResidues.add(item);
            item = new JMenuItem("U");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                }
            });
            mutateResidues.add(item);
            item = new JMenuItem("G");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                }
            });
            mutateResidues.add(item);
            item = new JMenuItem("C");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                }
            });
            mutateResidues.add(item);
            item = new JMenuItem("Center View On");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getRenderer().setGeneralPivot(Assemble.this.mediator.getGlobalSelection().getSelectionCenter());
                    Assemble.this.mediator.getGlobalSelection().fireRenderingModified();
                }
            });
            this.add(item);
            this.hideSelectionOnly = new JMenuItem("Hide Selected Residues");
            this.hideSelectionOnly.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.get3DModel().getResidues()) {
                        r.setDisplayed(true);
                    }
                    for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.getGlobalSelection().getSelectedResidues()) {
                        r.setDisplayed(false);
                    }
                    Assemble.this.mediator.get3DModel().fireRenderingModified();
                }
            });
            this.add(this.hideSelectionOnly);
            this.showSelectionOnly = new JMenuItem("Hide Non Selected Residues");
            this.showSelectionOnly.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List<fr.unistra.ibmc.assemble.structures.Residue> allResidues = Assemble.this.mediator.get3DModel().getResidues();
                    allResidues.removeAll(Assemble.this.mediator.getGlobalSelection().getSelectedResidues());
                    for (fr.unistra.ibmc.assemble.structures.Residue r : allResidues) {
                        r.setDisplayed(false);
                    }
                    for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.getGlobalSelection().getSelectedResidues()) {
                        r.setDisplayed(true);
                    }
                    Assemble.this.mediator.get3DModel().fireRenderingModified();
                }
            });
            this.add(this.showSelectionOnly);
            JMenu colorMenu = new JMenu("Color");
            this.colorByAtomType = new JMenuItem("By Atom Type");
            this.colorByAtomType.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setAtomsDefaultColor();
                    Assemble.this.mediator.getRna2DViewer().colorSelectedResiduesAsDefault();
                }
            });
            colorMenu.add(this.colorByAtomType);
            this.colorByResidueType = new JMenuItem("By Residue Type");
            this.colorByResidueType.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setResiduesDefaultColor();
                    Assemble.this.mediator.getRna2DViewer().colorSelectedResiduesAsDefault();
                }
            });
            colorMenu.add(this.colorByResidueType);
            this.customColorMenu = new ColorMenu("Custom Color");
            colorMenu.add(this.customColorMenu);
            this.add(colorMenu);
            JMenu menu = new JMenu("Show");
            this.add(menu);
            JMenu atomsAs = new JMenu("Atoms as");
            menu.add(atomsAs);
            item = new JMenuItem("Lines", RessourcesUtils.getIcon("50/mesh.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(1);
                }
            });
            atomsAs.add(item);
            item = new JMenuItem("Sticks", RessourcesUtils.getIcon("50/stickball.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(3);
                }
            });
            atomsAs.add(item);
            item = new JMenuItem("Covalence radius", RessourcesUtils.getIcon("50/cov.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(2);
                }
            });
            JMenu labels = new JMenu("Labels");
            menu.add(labels);
            this.showLabels = new JMenuItem("Atom");
            this.showLabels.setIcon(RessourcesUtils.getIcon("22/label.png"));
            this.showLabels.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    for (Atom a : Assemble.this.mediator.getGlobalSelection().getSelectedAtoms()) {
                        Assemble.this.mediator.get3DModel().addLabel(new AtomLabel(Assemble.this.mediator, a));
                    }
                }
            });
            labels.add(this.showLabels);
            item = new JMenuItem("Distance");
            item.setIcon(RessourcesUtils.getIcon("22/distance.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    List<Atom> atoms = Assemble.this.mediator.getGlobalSelection().getSelectedAtoms();
                    if (atoms.size() != 2) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select only two atoms to use this option.");
                    } else {
                        Iterator<Atom> it = atoms.iterator();
                        Assemble.this.mediator.get3DModel().addLabel(new DistanceLabel(Assemble.this.mediator, it.next(), it.next()));
                    }
                }
            });
            labels.add(item);
            item = new JMenuItem("Angle");
            item.setIcon(RessourcesUtils.getIcon("22/angle.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    List<Atom> atoms = Assemble.this.mediator.getGlobalSelection().getSelectedAtoms();
                    if (atoms.size() != 3) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select only three atoms to use this option.");
                    } else {
                        Iterator<Atom> it = atoms.iterator();
                        Assemble.this.mediator.get3DModel().addLabel(new AngleLabel(Assemble.this.mediator, it.next(), it.next(), it.next()));
                    }
                }
            });
            labels.add(item);
            item = new JMenuItem("Dihedral");
            item.setIcon(RessourcesUtils.getIcon("22/dihedre.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    List<Atom> atoms = Assemble.this.mediator.getGlobalSelection().getSelectedAtoms();
                    if (atoms.size() != 4) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select only four atoms to use this option.");
                    } else {
                        Iterator<Atom> it = atoms.iterator();
                        Assemble.this.mediator.get3DModel().addLabel(new DihedralLabel(Assemble.this.mediator, it.next(), it.next(), it.next(), it.next()));
                    }
                }
            });
            labels.add(item);
            item = new JMenuItem("BackBone");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setBackBoneDisplayed(true);
                }
            });
            item = new JMenuItem("Plane");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setPlaneDisplayed(true);
                }
            });
            menu = new JMenu("Hide");
            this.add(menu);
            item = new JMenuItem("Atoms");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(7);
                }
            });
            this.hideLabels = new JMenuItem("Labels");
            menu.add(this.hideLabels);
            this.hideLabels.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.get3DModel().hideLabelsForSelection();
                }
            });
            item = new JMenuItem("BackBone");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setBackBoneDisplayed(false);
                }
            });
            item = new JMenuItem("Plane");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setPlaneDisplayed(false);
                }
            });
        }
    }

    private class SecondaryModelMenu
    extends JMenu {
        private SecondaryModelMenu() {
            super("2D Model");
            JMenuItem item = new JMenuItem("Rename...");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String name = JOptionPane.showInputDialog(Assemble.this.window, (Object)"Choose a new 2D Model name");
                    if (name != null && name.length() > 0) {
                        Assemble.this.mediator.get2DModel().getSecondaryStructure().setName(name);
                        Assemble.this.setModelManagerTitle(name);
                    }
                }
            });
            this.add(item);
            item = new JMenuItem("Reorganize helices");
            item.setIcon(RessourcesUtils.getIcon("22/magic.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getRna2DViewer().reorganizeHelices();
                }
            });
            this.add(item);
            item = new JMenuItem("Generate 3D from 2D");
            item.setIcon(RessourcesUtils.getIcon("22/generate3D.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getRna2DViewer().generate3D();
                }
            });
            this.add(item);
            JMenu menu = new JMenu("Import...");
            this.add(menu);
            item = new JMenuItem("RNA molecule");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    final FastaFileIO parser = new FastaFileIO((MoleculeFactory)Assemble.this.workingSession);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)parser));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        IOUtils.setLastWorkingDirectory((File)f);
                        new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                super.finished();
                                List molecules = parser.getMolecules();
                                Molecule m = null;
                                if (molecules.size() == 0) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "No molecules available");
                                } else {
                                    m = molecules.size() > 1 ? (Molecule)JOptionPane.showInputDialog(Assemble.this.window, "Choose a molecule", "Choose a molecule", -1, null, molecules.toArray(), molecules.get(0)) : (Molecule)molecules.get(0);
                                }
                                if (m != null) {
                                    GuiEvent ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("2D prediction"));
                                    ArrayList<Molecule> _molecules = new ArrayList<Molecule>();
                                    _molecules.add((Molecule)molecules.get(0));
                                    ev.addParameter((Object)new SecondaryStructurePredictionRequestAnswerBehaviour(_molecules, new Parameters()));
                                    ((AssembleAgent)Assemble.this.getAgent()).postGuiEvent(ev);
                                }
                            }
                        }.execute();
                    }
                }
            });
            menu.add(item);
            item = new JMenuItem("RNA Secondary Structure");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new BPSeqFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new CTFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        IOUtils.setLastWorkingDirectory((File)f);
                        final CTFileIO parser = (CTFileIO)((OpenFileFilter)fileChooser.getFileFilter()).getParser();
                        new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                super.finished();
                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)parser.getSecondaryStructures().get(0));
                                Assemble.this.mediator.startAnimator();
                            }
                        }.execute();
                    }
                }
            });
            menu.add(item);
        }
    }

    private class StereoMenu
    extends JMenu
    implements ActionListener {
        private ButtonGroup stereoMode;
        private JRadioButtonMenuItem mono;
        private JRadioButtonMenuItem split;
        private JRadioButtonMenuItem overlap;

        public StereoMenu() {
            super("Stereo");
            this.stereoMode = new ButtonGroup();
            this.mono = new JRadioButtonMenuItem("Mono");
            this.split = new JRadioButtonMenuItem("Split Stereo");
            this.overlap = new JRadioButtonMenuItem("Overlap Stereo");
            this.mono.setIcon(RessourcesUtils.getIcon("22/mono.png"));
            this.split.setIcon(RessourcesUtils.getIcon("22/split.png"));
            this.overlap.setIcon(RessourcesUtils.getIcon("22/overlap.png"));
            this.add(this.mono);
            this.add(this.split);
            this.add(this.overlap);
            this.mono.setSelected(true);
            this.mono.addActionListener(this);
            this.split.addActionListener(this);
            this.overlap.addActionListener(this);
            this.stereoMode.add(this.mono);
            this.stereoMode.add(this.split);
            this.stereoMode.add(this.overlap);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.mono) {
                Assemble.this.mediator.getRenderer().setStereoMode(0);
            }
            if (source == this.split) {
                Assemble.this.mediator.getRenderer().setStereoMode(1);
            }
            if (source == this.overlap) {
                Assemble.this.mediator.getRenderer().setStereoMode(2);
            }
        }
    }

    private class TertiaryModelMenu
    extends JMenu
    implements ActionListener {
        private JCheckBoxMenuItem fog;
        private JCheckBoxMenuItem drawSelection;
        private JMenuItem showAll;

        public TertiaryModelMenu() {
            super("3D Model");
            this.fog = new JCheckBoxMenuItem("Fog (Depth-Cueing)");
            this.drawSelection = new JCheckBoxMenuItem("Draw the Selection Mesh");
            JMenuItem item = new JMenuItem("Rename...");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String name = JOptionPane.showInputDialog(Assemble.this.window, (Object)"Choose a new 3D Model name");
                    if (name != null && name.length() > 0) {
                        Assemble.this.mediator.get3DModel().getTertiaryStructure().setName(name);
                        Assemble.this.set3DSceneTitle(name);
                    }
                }
            });
            this.add(item);
            this.fog.setSelected(Assemble.this.mediator.getRenderer().isFog());
            this.add(Assemble.this.stereo);
            this.add(new ColorMenu("3D Background Color"));
            this.showAll = new JMenuItem("Show All Residues");
            this.showAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.get3DModel().getResidues()) {
                        r.setDisplayed(true);
                    }
                    Assemble.this.mediator.get3DModel().fireRenderingModified();
                }
            });
            this.add(this.showAll);
            JMenuItem hideAllLabels = new JMenuItem("Hide All Labels");
            hideAllLabels.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.get3DModel().hideLabels();
                }
            });
            this.add(hideAllLabels);
            this.addSeparator();
            this.add(this.drawSelection);
            this.drawSelection.setSelected(true);
            this.fog.addActionListener(this);
            this.drawSelection.addActionListener(this);
            this.addSeparator();
            item = new JMenuItem("Center on Density Map"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.getDensityMap() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    float[] mapCenter = Assemble.this.mediator.getDensityMap().getCenter();
                    float[] model3DCenter = Assemble.this.mediator.get3DModel().getCenter();
                    if (mapCenter != null) {
                        Assemble.this.mediator.get3DModel().translate(TBMath.vector((float[])model3DCenter, (float[])mapCenter));
                        Assemble.this.mediator.getRenderer().setGeneralPivot(mapCenter);
                        Assemble.this.mediator.get3DModel().fireModelModified();
                    }
                }
            });
            this.add(item);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.fog) {
                Assemble.this.mediator.getRenderer().setFog(this.fog.isSelected());
                Assemble.this.mediator.getRenderer().reComputeNeeded();
            } else if (source == this.drawSelection) {
                Assemble.this.mediator.getRenderer().setDrawSelection(this.drawSelection.isSelected());
            }
        }

        private class ColorMenu
        extends JMenu {
            protected Border unselectedBorder;
            protected Border selectedBorder;
            protected Border activeBorder;
            protected Hashtable paneTable;
            protected ColorPane colorPane;

            public ColorMenu(String name) {
                super(name);
                this.unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
                this.selectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
                this.activeBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
                JPanel p = new JPanel();
                p.setBorder(new EmptyBorder(5, 5, 5, 5));
                p.setLayout(new GridLayout(8, 8));
                this.paneTable = new Hashtable();
                int[] values = new int[]{0, 128, 192, 255};
                for (int r = 0; r < values.length; ++r) {
                    for (int g = 0; g < values.length; ++g) {
                        for (int b = 0; b < values.length; ++b) {
                            Color c = new Color(values[r], values[g], values[b]);
                            ColorPane pn = new ColorPane(c);
                            p.add(pn);
                            this.paneTable.put(c, pn);
                        }
                    }
                }
                this.add(p);
            }

            public void setColor(Color c) {
                Object obj = this.paneTable.get(c);
                if (obj == null) {
                    return;
                }
                if (this.colorPane != null) {
                    this.colorPane.setSelected(false);
                }
                this.colorPane = (ColorPane)obj;
                this.colorPane.setSelected(true);
            }

            public Color getColor() {
                if (this.colorPane == null) {
                    return null;
                }
                return this.colorPane.getColor();
            }

            public void doSelection() {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }

            private class ColorPane
            extends JPanel
            implements MouseListener {
                protected Color color;
                protected boolean isSelected;

                public ColorPane(Color c) {
                    this.color = c;
                    this.setBackground(c);
                    this.setBorder(ColorMenu.this.unselectedBorder);
                    String msg = "R " + c.getRed() + ", G " + c.getGreen() + ", B " + c.getBlue();
                    this.setToolTipText(msg);
                    this.addMouseListener(this);
                }

                public Color getColor() {
                    return this.color;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(15, 15);
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public void setSelected(boolean selected) {
                    this.isSelected = selected;
                    if (this.isSelected) {
                        this.setBorder(ColorMenu.this.selectedBorder);
                    } else {
                        this.setBorder(ColorMenu.this.unselectedBorder);
                    }
                }

                public boolean isSelected() {
                    return this.isSelected;
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                    ColorMenu.this.setColor(this.color);
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    ColorMenu.this.doSelection();
                    Assemble.this.mediator.getRenderer().setBackgroundColor(new OpenGLColor(this.color));
                    Assemble.this.mediator.getRenderer().reComputeNeeded();
                }

                public void mouseEntered(MouseEvent e) {
                    this.setBorder(ColorMenu.this.activeBorder);
                }

                public void mouseExited(MouseEvent e) {
                    this.setBorder(this.isSelected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
                }
            }
        }
    }

    private class FileMenu
    extends JMenu {
        public FileMenu() {
            super("File");
            JMenu load = new JMenu("Load...");
            load.setIcon(RessourcesUtils.getIcon("22/open.png"));
            this.add(load);
            JMenuItem item = new JMenuItem("Assemble Model");
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ((Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(Assemble.this.window, "Are you sure to remove your current Model?")) {
                        return;
                    }
                    if (Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        Assemble.this.mediator.clearSession();
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileView(new FileView(){

                        public Icon getIcon(File f) {
                            if (IOUtils.isParadiseProject((File)f) || f.getName().endsWith(".assemble")) {
                                return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                            }
                            return null;
                        }

                        public Boolean isTraversable(File f) {
                            return f.isDirectory() && !IOUtils.isParadiseProject((File)f);
                        }
                    });
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !IOUtils.isParadiseProject((File)file) || file.getName().endsWith(".assemble");
                        }

                        public String getDescription() {
                            return "Assemble models (binary data)";
                        }
                    });
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !IOUtils.isParadiseProject((File)file) || IOUtils.containsTertiaryStructureData((File)file) || IOUtils.containsSecondaryStructureData((File)file);
                        }

                        public String getDescription() {
                            return "Assemble models (textual data)";
                        }
                    });
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        if (f.getName().endsWith(".assemble")) {
                            IOUtils.setLastWorkingDirectory((File)f);
                            AssembleModelParser parser = new AssembleModelParser((MoleculeFactory)Assemble.this.workingSession);
                            new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession, (ParadiseFileIO)parser){
                                final /* synthetic */ ParadiseFileIO val$parser;
                                {
                                    this.val$parser = paradiseFileIO;
                                    super(x0, x1, x2, x3, x4);
                                }

                                protected void finished() {
                                    new ParadiseTask((Application)Assemble.this, this.monitor){

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        protected Object doInBackground() {
                                            List tss = val$parser.getTertiaryStructures();
                                            List sss = val$parser.getSecondaryStructures();
                                            if (!tss.isEmpty()) {
                                                if (tss.size() > 1) {
                                                    Object[] names = new String[tss.size()];
                                                    for (int i = 0; i < names.length; ++i) {
                                                        names[i] = ((TertiaryStructure)tss.get(i)).getName();
                                                    }
                                                    String name = (String)JOptionPane.showInputDialog(Assemble.this.window, "Choose a 3D model", "Choose 3D model", -1, null, names, names[0]);
                                                    if (name == null) return null;
                                                    for (TertiaryStructure ts : tss) {
                                                        if (!ts.getName().equals(name)) continue;
                                                        Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0));
                                                        Assemble.this.mediator.createModel((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0), ts);
                                                        Assemble.this.mediator.startAnimator();
                                                        return null;
                                                    }
                                                    return null;
                                                }
                                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0));
                                                Assemble.this.mediator.createModel((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0), (TertiaryStructure)tss.get(0));
                                                Assemble.this.mediator.startAnimator();
                                                return null;
                                            }
                                            if (!sss.isEmpty()) {
                                                if (sss.size() > 1) {
                                                    Object[] names = new String[sss.size()];
                                                    for (int i = 0; i < names.length; ++i) {
                                                        names[i] = ((SecondaryStructure)sss.get(i)).getName();
                                                    }
                                                    String name = (String)JOptionPane.showInputDialog(Assemble.this.window, "Choose a 2D model", "Choose 2D model", -1, null, names, names[0]);
                                                    if (name == null) return null;
                                                    for (SecondaryStructure ss : sss) {
                                                        if (!ss.getName().equals(name)) continue;
                                                        Assemble.this.mediator.loadRNASecondaryStructure(ss);
                                                        Assemble.this.mediator.startAnimator();
                                                        return null;
                                                    }
                                                    return null;
                                                }
                                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)sss.get(0));
                                                return null;
                                            }
                                            JOptionPane.showMessageDialog(Assemble.this.window, "Your Assemble model contains no data!!");
                                            return null;
                                        }
                                    }.execute();
                                    super.finished();
                                }
                            }.execute();
                        } else {
                            IOUtils.setLastWorkingDirectory((File)f.getParentFile());
                            ParadiseProjectIO parser = new ParadiseProjectIO((MoleculeFactory)Assemble.this.workingSession);
                            new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession, (ParadiseFileIO)parser){
                                final /* synthetic */ ParadiseFileIO val$parser;
                                {
                                    this.val$parser = paradiseFileIO;
                                    super(x0, x1, x2, x3, x4);
                                }

                                protected void finished() {
                                    new ParadiseTask((Application)Assemble.this, this.monitor){

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        protected Object doInBackground() {
                                            List tss = val$parser.getTertiaryStructures();
                                            List sss = val$parser.getSecondaryStructures();
                                            if (!tss.isEmpty()) {
                                                if (tss.size() > 1) {
                                                    Object[] names = new String[tss.size()];
                                                    for (int i = 0; i < names.length; ++i) {
                                                        names[i] = ((TertiaryStructure)tss.get(i)).getName();
                                                    }
                                                    String name = (String)JOptionPane.showInputDialog(Assemble.this.window, "Choose a 3D model", "Choose 3D model", -1, null, names, names[0]);
                                                    if (name == null) return null;
                                                    for (TertiaryStructure ts : tss) {
                                                        if (!ts.getName().equals(name)) continue;
                                                        Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0));
                                                        Assemble.this.mediator.createModel((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0), ts);
                                                        Assemble.this.mediator.startAnimator();
                                                        return null;
                                                    }
                                                    return null;
                                                }
                                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0));
                                                Assemble.this.mediator.createModel((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0), (TertiaryStructure)tss.get(0));
                                                Assemble.this.mediator.startAnimator();
                                                return null;
                                            }
                                            if (!sss.isEmpty()) {
                                                if (sss.size() > 1) {
                                                    Object[] names = new String[sss.size()];
                                                    for (int i = 0; i < names.length; ++i) {
                                                        names[i] = ((SecondaryStructure)sss.get(i)).getName();
                                                    }
                                                    String name = (String)JOptionPane.showInputDialog(Assemble.this.window, "Choose a 2D model", "Choose 2D model", -1, null, names, names[0]);
                                                    if (name == null) return null;
                                                    for (SecondaryStructure ss : sss) {
                                                        if (!ss.getName().equals(name)) continue;
                                                        Assemble.this.mediator.loadRNASecondaryStructure(ss);
                                                        Assemble.this.mediator.startAnimator();
                                                        return null;
                                                    }
                                                    return null;
                                                }
                                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)sss.get(0));
                                                return null;
                                            }
                                            JOptionPane.showMessageDialog(Assemble.this.window, "Your Assemble model contains no data!!");
                                            return null;
                                        }
                                    }.execute();
                                    super.finished();
                                }
                            }.execute();
                        }
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("RNA molecule");
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ((Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(Assemble.this.window, "Are you sure to remove your current Model?")) {
                        return;
                    }
                    if (Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        Assemble.this.mediator.clearSession();
                    }
                    JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    final FastaFileIO parser = new FastaFileIO((MoleculeFactory)Assemble.this.workingSession);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)parser));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        IOUtils.setLastWorkingDirectory((File)f);
                        new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                new ParadiseTask((Application)Assemble.this, this.monitor){

                                    protected Object doInBackground() {
                                        List molecules = parser.getMolecules();
                                        Molecule m = null;
                                        if (molecules.size() == 0) {
                                            JOptionPane.showMessageDialog(Assemble.this.window, "No molecules available");
                                        } else {
                                            m = molecules.size() > 1 ? (Molecule)JOptionPane.showInputDialog(Assemble.this.window, "Choose a molecule", "Choose a molecule", -1, null, molecules.toArray(), molecules.get(0)) : (Molecule)molecules.get(0);
                                        }
                                        if (m != null) {
                                            GuiEvent ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("2D prediction"));
                                            ArrayList<Molecule> _molecules = new ArrayList<Molecule>();
                                            _molecules.add((Molecule)molecules.get(0));
                                            ev.addParameter((Object)new SecondaryStructurePredictionRequestAnswerBehaviour(_molecules, new Parameters()));
                                            ((AssembleAgent)Assemble.this.getAgent()).postGuiEvent(ev);
                                        }
                                        super.finished();
                                        return null;
                                    }
                                }.execute();
                            }
                        }.execute();
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("RNA Secondary Structure");
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ((Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(Assemble.this.window, "Are you sure to remove your current Model?")) {
                        return;
                    }
                    if (Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        Assemble.this.mediator.clearSession();
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new BPSeqFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new CTFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new FastaFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        IOUtils.setLastWorkingDirectory((File)f);
                        final ParadiseFileIO parser = ((OpenFileFilter)fileChooser.getFileFilter()).getParser();
                        new FileParsingTask((Application)Assemble.this, f, parser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                new ParadiseTask((Application)Assemble.this, this.monitor){

                                    protected Object doInBackground() {
                                        if (parser.getSecondaryStructures().isEmpty()) {
                                            JOptionPane.showMessageDialog(null, "No Secondary Structure found!!");
                                        } else {
                                            Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)parser.getSecondaryStructures().get(0));
                                        }
                                        super.finished();
                                        return null;
                                    }
                                }.execute();
                            }
                        }.execute();
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("RNA Tertiary Structure");
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ((Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(Assemble.this.window, "Are you sure to remove your current Model?")) {
                        return;
                    }
                    if (Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        Assemble.this.mediator.clearSession();
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    final PDBFileIO pdbParser = new PDBFileIO((MoleculeFactory)Assemble.this.workingSession);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)pdbParser));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        IOUtils.setLastWorkingDirectory((File)f);
                        new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)pdbParser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                new ParadiseTask((Application)Assemble.this, this.monitor){

                                    protected Object doInBackground() {
                                        TertiaryStructure ts = (TertiaryStructure)pdbParser.getTertiaryStructures().get(0);
                                        GuiEvent ev = new GuiEvent((Object)this, Paradise.functionnalities.indexOf("3D annotation"));
                                        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                                        for (Molecule m : ts.getMolecules()) {
                                            m.removeAllSelectedFeatures();
                                            for (Residue3D r : ts.getSubFeatures(Residue3D.class, m)) {
                                                m.addSelectedFeature((ParadiseFeature)r);
                                            }
                                            molecules.add(m);
                                        }
                                        ev.addParameter((Object)new TertiaryStructureAnnotationRequestAnswerBehaviour(new ArrayList<Molecule>(molecules), new Parameters()));
                                        ((AssembleAgent)Assemble.this.getAgent()).postGuiEvent(ev);
                                        super.finished();
                                        return null;
                                    }
                                }.execute();
                            }
                        }.execute();
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("Protein Partners");
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Assemble.this.mediator.stopAnimator();
                    Assemble.this.mediator.startAnimator();
                }
            });
            item = new JMenuItem("Electronic Density Map"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.setIcon(RessourcesUtils.getIcon("22/edmap.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith("map");
                        }

                        public String getDescription() {
                            return "MAP files";
                        }
                    });
                    fileChooser.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith("mrc");
                        }

                        public String getDescription() {
                            return "MRC files";
                        }
                    });
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    int op = fileChooser.showOpenDialog(Assemble.this.getFrame());
                    if (op == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                Assemble.this.messageBar.startAnimation();
                                try {
                                    IOUtils.setLastWorkingDirectory((File)fileChooser.getSelectedFile());
                                    String filename = fileChooser.getSelectedFile().getAbsolutePath();
                                    EDMap edmap = new EDMap(Assemble.this.mediator);
                                    int idx = filename.lastIndexOf(46);
                                    if (idx != -1) {
                                        if (filename.substring(idx).equals(".map")) {
                                            edmap.parseXPLORMap(filename);
                                        }
                                        if (filename.substring(idx).equals(".mrc")) {
                                            edmap.parseMRCMap(filename);
                                        }
                                        if (edmap.isValid()) {
                                            Assemble.this.mediator.loadEDMap(edmap);
                                        }
                                        Assemble.this.mediator.startAnimator();
                                    }
                                    this.monitor.printMessage("Electronic Density Map loaded successfully");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("Save Model"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null && Assemble.this.mediator.get3DModel().getTertiaryStructure().getAssociatedFile() != null || Assemble.this.mediator.get2DModel() != null && Assemble.this.mediator.get2DModel().getSecondaryStructure().getAssociatedFile() != null);
                    super.paintComponent(graphics);
                }
            };
            item.setIcon(RessourcesUtils.getIcon("22/saveas.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    final File saveFile = Assemble.this.mediator.get3DModel() != null && Assemble.this.mediator.get3DModel().getTertiaryStructure().getAssociatedFile() != null ? Assemble.this.mediator.get3DModel().getTertiaryStructure().getAssociatedFile() : Assemble.this.mediator.get2DModel().getSecondaryStructure().getAssociatedFile();
                    new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                        protected Object doInBackground() {
                            try {
                                Assemble.this.messageBar.startAnimation();
                                Assemble.this.synchronize();
                                if (saveFile.getName().endsWith(".rnaml")) {
                                    ParadiseProjectIO.saveWorkingSession((File)saveFile.getParentFile().getParentFile(), Arrays.asList(Assemble.this.mediator.get2DModel().getSecondaryStructure()));
                                    IOUtils.setLastWorkingDirectory((File)saveFile.getParentFile().getParentFile().getParentFile());
                                } else if (saveFile.getName().endsWith(".assemble")) {
                                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
                                    oos.writeObject(Assemble.this.mediator.get3DModel().getTertiaryStructure());
                                    oos.flush();
                                    oos.close();
                                    IOUtils.setLastWorkingDirectory((File)saveFile.getParentFile());
                                }
                                Assemble.this.mediator.startAnimator();
                                this.monitor.printMessage("Saving successful");
                            }
                            catch (Exception e) {
                                this.monitor.printException(e);
                            }
                            this.finished();
                            return null;
                        }
                    }.execute();
                }
            });
            this.add(item);
            item = new JMenuItem("Save Model As..."){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.setIcon(RessourcesUtils.getIcon("22/saveas.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileView(new FileView(){

                        public Icon getIcon(File f) {
                            if (IOUtils.isParadiseProject((File)f) || f.getName().endsWith(".assemble")) {
                                return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                            }
                            return null;
                        }

                        public Boolean isTraversable(File f) {
                            return f.isDirectory() && !IOUtils.isParadiseProject((File)f);
                        }
                    });
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !IOUtils.isParadiseProject((File)file) || file.getName().endsWith(".assemble");
                        }

                        public String getDescription() {
                            return "Assemble models (binary data)";
                        }
                    });
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !IOUtils.isParadiseProject((File)file) || IOUtils.containsTertiaryStructureData((File)file) || IOUtils.containsSecondaryStructureData((File)file);
                        }

                        public String getDescription() {
                            return "Assemble models (textual data)";
                        }
                    });
                    if (0 == fileChooser.showSaveDialog(Assemble.this.window)) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    Assemble.this.messageBar.startAnimation();
                                    Assemble.this.synchronize();
                                    if (fileChooser.getFileFilter().getDescription().endsWith("(binary data)")) {
                                        File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".assemble", (Component)Assemble.this.window);
                                        if (savingFile == null) {
                                            this.finished();
                                            Assemble.this.mediator.startAnimator();
                                            this.monitor.printMessage("Saving Canceled");
                                            return null;
                                        }
                                        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(savingFile));
                                        oos.writeObject(Assemble.this.mediator.get3DModel().getTertiaryStructure());
                                        oos.flush();
                                        oos.close();
                                        Assemble.this.mediator.get3DModel().getTertiaryStructure().setAssociatedFile(savingFile);
                                        IOUtils.setLastWorkingDirectory((File)savingFile.getParentFile());
                                    } else {
                                        File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)true, null, (Component)Assemble.this.window);
                                        if (savingFile == null) {
                                            this.finished();
                                            Assemble.this.mediator.startAnimator();
                                            this.monitor.printMessage("Saving canceled");
                                            return null;
                                        }
                                        ParadiseProjectIO.saveWorkingSession((File)savingFile, Arrays.asList(Assemble.this.mediator.get2DModel().getSecondaryStructure()));
                                        IOUtils.setLastWorkingDirectory((File)savingFile.getParentFile());
                                    }
                                    this.monitor.printMessage("Saving successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                Assemble.this.mediator.startAnimator();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            this.add(item);
            JMenu exportMenu = new JMenu("Export...");
            exportMenu.setIcon(RessourcesUtils.getIcon("22/saveas.png"));
            this.add(exportMenu);
            item = new JMenuItem("3D Model as PDB file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    final JCheckBox exportNumberingSystem = new JCheckBox("Keep the Original Numbering System");
                    fileChooser.setAccessory(exportNumberingSystem);
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : PDBFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "PDB files";
                        }
                    });
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    if (fileChooser.showSaveDialog(Assemble.this.window) == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                Assemble.this.messageBar.startAnimation();
                                try {
                                    File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".pdb", (Component)Assemble.this.window);
                                    if (savingFile == null) {
                                        this.finished();
                                        Assemble.this.mediator.startAnimator();
                                        this.monitor.printMessage("Export canceled");
                                        return null;
                                    }
                                    Assemble.this.mediator.get3DModel().exportAsPDB(savingFile, exportNumberingSystem.isSelected());
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                Assemble.this.mediator.startAnimator();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            exportMenu.add(item);
            item = new JMenuItem("2D Model as CT file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : CTFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "CT files";
                        }
                    });
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    if (fileChooser.showSaveDialog(null) == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".ct", (Component)Assemble.this.window);
                                    if (savingFile == null) {
                                        this.finished();
                                        Assemble.this.mediator.startAnimator();
                                        this.monitor.printMessage("Export canceled");
                                        return null;
                                    }
                                    Assemble.this.messageBar.startAnimation();
                                    ArrayList<Residue> residues = new ArrayList<Residue>();
                                    HashSet<BaseBaseInteraction> interactions = new HashSet<BaseBaseInteraction>();
                                    Molecule currentMolecule = null;
                                    for (Residue2D r2D : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().getResidues()) {
                                        Residue r = (Residue)r2D.getResidue2DFeature().getResidues().iterator().next();
                                        if (currentMolecule == null) {
                                            currentMolecule = r.getMolecule();
                                        } else if (currentMolecule != r.getMolecule()) {
                                            JOptionPane.showMessageDialog(Assemble.this.window, "You cannot export several molecules in one CT file");
                                            savingFile.delete();
                                            this.finished();
                                            Assemble.this.mediator.startAnimator();
                                            this.monitor.printMessage("Export canceled");
                                            return null;
                                        }
                                        residues.add(r);
                                        for (BaseBaseInteraction2D interaction : r2D.getInteractions()) {
                                            if (!BaseBaseInteraction2D.class.isInstance(interaction) || !interaction.getBaseBaseInteractionFeature().isSecondaryInteraction()) continue;
                                            interactions.add(interaction.getBaseBaseInteractionFeature());
                                        }
                                    }
                                    Collections.sort(residues, new Comparator(){

                                        public int compare(Object o1, Object o2) {
                                            return ((Residue)o1).getAbsolutePosition() - ((Residue)o2).getAbsolutePosition();
                                        }
                                    });
                                    CTFileIO.writeCTFile(residues, new ArrayList(interactions), (File)savingFile);
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                Assemble.this.mediator.startAnimator();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            exportMenu.add(item);
            item = new JMenuItem("2D Model as SVG file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith("svg");
                        }

                        public String getDescription() {
                            return "SVG files";
                        }
                    });
                    if (fileChooser.showSaveDialog(null) == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                Assemble.this.messageBar.startAnimation();
                                PrintWriter pw = null;
                                try {
                                    File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".svg", (Component)Assemble.this.window);
                                    if (savingFile == null) {
                                        this.finished();
                                        this.monitor.printMessage("Export canceled");
                                        return null;
                                    }
                                    pw = new PrintWriter(savingFile);
                                    pw.print(Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().toSVG());
                                    pw.close();
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                if (pw != null) {
                                    pw.close();
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            exportMenu.add(item);
            item = new JMenuItem("RNA Molecules as FASTA file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : FastaFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "FASTA files";
                        }
                    });
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    if (fileChooser.showSaveDialog(null) == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".fasta", (Component)Assemble.this.window);
                                    if (savingFile == null) {
                                        this.finished();
                                        this.monitor.printMessage("Export canceled");
                                        Assemble.this.mediator.startAnimator();
                                        return null;
                                    }
                                    Assemble.this.messageBar.startAnimation();
                                    ArrayList<String> names = new ArrayList<String>();
                                    ArrayList<String> sequences = new ArrayList<String>();
                                    for (Molecule m : Assemble.this.mediator.get2DModel().getSecondaryStructure().getMolecules()) {
                                        names.add(m.getName());
                                        sequences.add(m.printSequence());
                                    }
                                    FastaFileIO.exportMoleculesAsFastaFile((File)savingFile, names, sequences);
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                Assemble.this.mediator.startAnimator();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            exportMenu.add(item);
            JMenu selectionMenu = new JMenu("Selection..."){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            exportMenu.add(selectionMenu);
            item = new JMenuItem("as PDB file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().isEmpty()) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "No 3D selection available");
                        return;
                    }
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : PDBFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "PDB files";
                        }
                    });
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    if (fileChooser.showSaveDialog(Assemble.this.window) == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".pdb", (Component)Assemble.this.window);
                                    if (savingFile == null) {
                                        this.finished();
                                        Assemble.this.mediator.startAnimator();
                                        this.monitor.printMessage("Export canceled");
                                        return null;
                                    }
                                    Assemble.this.messageBar.startAnimation();
                                    Assemble.this.mediator.getGlobalSelection().exportAsPDB(savingFile);
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                Assemble.this.mediator.startAnimator();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            selectionMenu.add(item);
            item = new JMenuItem("as CT file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getCurrentResidues().isEmpty()) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "No selection available");
                        return;
                    }
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : CTFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "CT files";
                        }
                    });
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    if (fileChooser.showSaveDialog(null) == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".ct", (Component)Assemble.this.window);
                                    if (savingFile == null) {
                                        this.finished();
                                        Assemble.this.mediator.startAnimator();
                                        this.monitor.printMessage("Export canceled");
                                        return null;
                                    }
                                    Assemble.this.messageBar.startAnimation();
                                    ArrayList<Residue> residues = new ArrayList<Residue>();
                                    HashSet<BaseBaseInteraction> interactions = new HashSet<BaseBaseInteraction>();
                                    Molecule currentMolecule = null;
                                    for (Residue2D r2D : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getCurrentResidues()) {
                                        Residue r = (Residue)r2D.getResidue2DFeature().getResidues().iterator().next();
                                        if (currentMolecule == null) {
                                            currentMolecule = r.getMolecule();
                                        } else if (currentMolecule != r.getMolecule()) {
                                            JOptionPane.showMessageDialog(Assemble.this.window, "You cannot export several molecules in one CT file");
                                            savingFile.delete();
                                            Assemble.this.mediator.startAnimator();
                                            this.monitor.printMessage("Export canceled");
                                            return null;
                                        }
                                        residues.add(r);
                                        for (BaseBaseInteraction2D interaction : r2D.getInteractions()) {
                                            if (!BaseBaseInteraction2D.class.isInstance(interaction) || !interaction.getBaseBaseInteractionFeature().isSecondaryInteraction()) continue;
                                            interactions.add(interaction.getBaseBaseInteractionFeature());
                                        }
                                    }
                                    Collections.sort(residues, new Comparator(){

                                        public int compare(Object o1, Object o2) {
                                            return ((Residue)o1).getAbsolutePosition() - ((Residue)o2).getAbsolutePosition();
                                        }
                                    });
                                    CTFileIO.writeCTFile(residues, new ArrayList(interactions), (File)savingFile);
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                Assemble.this.mediator.startAnimator();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            selectionMenu.add(item);
            item = new JMenuItem("as FASTA file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getCurrentResidues().isEmpty()) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "No selection available");
                        return;
                    }
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : FastaFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "FASTA files";
                        }
                    });
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    if (fileChooser.showSaveDialog(null) == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    File savingFile = IOUtils.getFileForSaving((File)fileChooser.getSelectedFile(), (boolean)false, (String)".fasta", (Component)Assemble.this.window);
                                    if (savingFile == null) {
                                        this.finished();
                                        Assemble.this.mediator.startAnimator();
                                        this.monitor.printMessage("Export canceled");
                                        return null;
                                    }
                                    Assemble.this.messageBar.startAnimation();
                                    ArrayList<String> names = new ArrayList<String>();
                                    ArrayList<String> sequences = new ArrayList<String>();
                                    int start = -1;
                                    int currentPosition = -1;
                                    StringBuffer sequence = null;
                                    String currentName = null;
                                    for (Residue2D r : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getCurrentResidues()) {
                                        if (r.getAbsolutePosition() - 1 != currentPosition) {
                                            if (sequence != null) {
                                                names.add(currentName + " (" + start + "-" + currentPosition + ")");
                                                sequences.add(sequence.toString());
                                            }
                                            currentName = ((Residue)r.getResidue2DFeature().getResidues().iterator().next()).getMolecule().getName();
                                            currentPosition = r.getAbsolutePosition();
                                            start = r.getAbsolutePosition();
                                            sequence = new StringBuffer();
                                            sequence.append(r.getSymbol());
                                            continue;
                                        }
                                        sequence.append(r.getSymbol());
                                        currentPosition = r.getAbsolutePosition();
                                    }
                                    if (sequence != null) {
                                        names.add(currentName + " (" + start + "-" + currentPosition + ")");
                                        sequences.add(sequence.toString());
                                    }
                                    FastaFileIO.exportMoleculesAsFastaFile((File)savingFile, names, sequences);
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                Assemble.this.mediator.startAnimator();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            selectionMenu.add(item);
            item = new JMenuItem("Quit");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (JOptionPane.showConfirmDialog(null, "Are you sure you want to exit Assemble?", "Confirm exit", 0) == 0) {
                        for (File f : new File(System.getProperty("user.dir")).listFiles()) {
                            if (!f.getName().startsWith("MTPs-") && !f.getName().equals("APDescription.txt")) continue;
                            f.delete();
                        }
                        try {
                            AssembleConfig.save();
                            DFService.deregister((Agent)((GuiAgent)Assemble.this.agent));
                            Assemble.this.workingSession.getAgentContainer().kill();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        System.exit(0);
                    }
                }
            });
            this.add(item);
        }
    }

    private class AssembleToolBar
    extends JToolBar {
        JButton cut;
        JButton link;
        JButton twist;
        JButton deleteResidues;
        JButton previousMolecularChainCloser;
        JButton nextResiduesCloser;
        JButton previousStructuralDomainCloser;
        JButton nextStructuralDomainCloser;
        JButton restoreAForm;
        JButton pairChain;
        JButton refine;
        JButton snapshot;
        JButton acceptModel;
        JButton deleteModel;

        public AssembleToolBar() {
            this.cut = new FlatButton("22/cut.png", "Cut a Molecular Chain");
            this.link = new FlatButton("22/link.png", "Link Two Molecular Chains");
            this.twist = new FlatButton("22/torsion.png", "Twist Residue Angles");
            this.deleteResidues = new FlatButton("delete-interaction.png", "Delete Selected Residues");
            this.previousMolecularChainCloser = new FlatButton("22/adenine.png", "Bring Molecular Chain of Previous Residue Closer");
            this.nextResiduesCloser = new FlatButton("22/plug.png", "Move Selection closer to...");
            this.previousStructuralDomainCloser = new FlatButton("22/user.png", "Bring Structural Domain of Previous Residue Closer");
            this.nextStructuralDomainCloser = new FlatButton("22/block.png", "Bring Structural Domain of Next Residue Closer");
            this.restoreAForm = new FlatButton("22/aform.png", "Set A-form backbone");
            this.pairChain = new FlatButton("22/block.png", "Pair Two Molecular Chains");
            this.refine = new FlatButton("22/refine.png", "Refine coordinates");
            this.snapshot = new FlatButton("capture.png", "Take a Snapshot");
            this.acceptModel = new FlatButton("22/accept-model.png", "Set As New Undo State");
            this.deleteModel = new FlatButton("22/delete-model.png", "Delete 3D Model");
            this.setBackground(Color.WHITE);
            this.setFloatable(false);
            int height = RessourcesUtils.getIcon("22/open.png").getIconHeight();
            this.add(this.cut);
            this.cut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.edit.cut.doClick();
                }
            });
            this.add(this.link);
            this.link.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.edit.link.doClick();
                }
            });
            this.add(this.twist);
            this.twist.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.edit.torsion.doClick();
                }
            });
            this.add(this.deleteResidues);
            this.deleteResidues.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().isEmpty()) {
                        JOptionPane.showMessageDialog(null, "No Residues Selected");
                        return;
                    }
                    if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete all the Residues selected?")) {
                        for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.getGlobalSelection().getSelectedResidues()) {
                            Assemble.this.mediator.get3DModel().eraseResidue(r);
                        }
                        Assemble.this.mediator.getRenderer().reComputeNeeded();
                        Assemble.this.mediator.getGlobalSelection().clear();
                        Assemble.this.mediator.startAnimator();
                        Assemble.this.mediator.get3DModel().fireModelModified();
                    }
                }
            });
            this.restoreAForm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedChains().size() != 1) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select a single molecular chain to use this option.");
                        return;
                    }
                    Chain c = Assemble.this.mediator.getGlobalSelection().getSelectedChains().iterator().next();
                    if (!RNA.class.isInstance(c.getMolecule())) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "The molecular chain selected is not an RNA molecule");
                        return;
                    }
                    c.restoreAFormConformation();
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.pairChain.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedChains().size() != 2) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select exactly 2 molecular chains to use this option.");
                        return;
                    }
                    Iterator<Chain> it = Assemble.this.mediator.getGlobalSelection().getSelectedChains().iterator();
                    Chain c1 = it.next();
                    Chain c2 = it.next();
                    if (c1.getLength() != c2.getLength()) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "The molecular chains to pair need to have the same length");
                        return;
                    }
                    int length = c1.getLength();
                    for (int i = 0; i < length; ++i) {
                        try {
                            ((ResidueNA)c1.getResidue(i)).setPair((ResidueNA)c2.getResidue(length - (i + 1)));
                            continue;
                        }
                        catch (BiologicalSymbolException e) {
                            e.printStackTrace();
                        }
                    }
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.add(this.nextResiduesCloser);
            this.nextResiduesCloser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() == 0) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select at least one residue to use this option.");
                        return;
                    }
                    if (Assemble.this.mediator.getRenderer().getResidueContainingSelectionPivot() == null) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Alt+right click on a residue to define the magnet");
                        return;
                    }
                    fr.unistra.ibmc.assemble.structures.Residue nextAssembleResidue = Assemble.this.mediator.getAssemble().getAssembleResidue(new Residue(Assemble.this.mediator.getRenderer().getResidueContainingSelectionPivot().getNumber() + 1, Assemble.this.mediator.getRenderer().getResidueContainingSelectionPivot().getChain().getMolecule()));
                    if (!Assemble.this.mediator.getGlobalSelection().getSelectedResidues().contains(nextAssembleResidue)) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "The next residue of your magnet is not in the selection");
                        return;
                    }
                    ((ResidueNA)Assemble.this.mediator.getRenderer().getResidueContainingSelectionPivot()).bringResiduesCloser(Assemble.this.mediator.getGlobalSelection().getSelectedResidues());
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.add(Box.createHorizontalStrut(5));
            JSeparator separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(2, height));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.refine);
            this.refine.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.get3DModel() != null) {
                        Assemble.this.mediator.get3DModel().saveCoordinatesToParadise();
                        for (BaseBaseInteraction interaction : Assemble.this.mediator.get3DModel().getSecondaryStructure().getBaseBaseInteractions()) {
                            interaction.removeAtomAtomInteractions();
                            interaction.generateAtomAtomInteractions();
                        }
                        HashSet<Molecule> molecules = new HashSet<Molecule>();
                        for (Molecule molecule : Assemble.this.mediator.get3DModel().getTertiaryStructure().getMolecules()) {
                            if (!RNA.class.isInstance(molecule)) continue;
                            molecule.addSelectedFeature((ParadiseFeature)Assemble.this.mediator.get3DModel().getTertiaryStructure());
                            molecule.addSelectedFeature((ParadiseFeature)Assemble.this.mediator.get3DModel().getSecondaryStructure());
                            molecules.add(molecule);
                        }
                        new RnartDialog(Assemble.this.mediator, molecules);
                    }
                }
            });
            this.add(this.acceptModel);
            this.acceptModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.addUndoStep("undo");
                    Assemble.this.mediator.addUndoStep("current");
                }
            });
            this.add(this.deleteModel);
            this.deleteModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete your 3D model?")) {
                        Assemble.this.mediator.stopAnimator();
                        for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.get3DModel().getResidues()) {
                            Assemble.this.mediator.get3DModel().eraseResidue(r);
                        }
                        Assemble.this.mediator.getRenderer().reComputeNeeded();
                        Assemble.this.mediator.getGlobalSelection().clear();
                        Assemble.this.mediator.getResidueManager().clear();
                        Assemble.this.mediator.startAnimator();
                        Assemble.this.mediator.get3DModel().fireModelModified();
                    }
                }
            });
            this.snapshot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.get3DModel() != null) {
                        JFileChooser fileChooser = new JFileChooser(IOUtils.getLastWorkingDirectory());
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                return f.isDirectory() || f.getName().endsWith(".png");
                            }

                            public String getDescription() {
                                return "PNG file";
                            }
                        });
                        if (fileChooser.showSaveDialog(Assemble.this.window) == 0) {
                            new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                                protected Object doInBackground() {
                                    return null;
                                }
                            }.execute();
                        }
                    }
                }
            });
        }
    }

    private class AssembleMenu
    extends JMenuBar {
        private AssembleMenu() {
            Assemble.this.file = new FileMenu();
            Assemble.this.stereo = new StereoMenu();
            Assemble.this.tertiarySelection = new TertiarySelectionMenu();
            Assemble.this.secondaryModel = new SecondaryModelMenu();
            Assemble.this.tertiaryModel = new TertiaryModelMenu();
            Assemble.this.edit = new EditMenu();
            Assemble.this.plugins = new PluginsMenu();
            Assemble.this.help = new HelpMenu();
            this.add(Assemble.this.file);
            this.add(Assemble.this.secondaryModel);
            this.add(Assemble.this.tertiaryModel);
            this.add(Assemble.this.tertiarySelection);
            this.add(Assemble.this.plugins);
            this.add(Assemble.this.help);
        }
    }
}

