/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DKnob
extends JComponent {
    private static final float START = 90.0f;
    private static final float PI = 3.1415f;
    private static final float START_ANG = 1.57075f;
    private static final float LENGTH_ANG = 6.283f;
    private static final Color DEFAULT_FOCUS_COLOR = new Color(0x8080FF);
    private Color color = Color.gray;
    private int SHADOWX = 1;
    private int SHADOWY = 1;
    private int middle;
    private static final Dimension MIN_SIZE = new Dimension(40, 40);
    private static final Dimension PREF_SIZE = new Dimension(80, 80);
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private ChangeEvent changeEvent = null;
    private EventListenerList listenerList = new EventListenerList();
    private Arc2D hitArc = new Arc2D.Float(2);
    private float ang = 1.57075f;
    private float val;
    private Color focusColor;

    public DKnob(Color c) {
        this.color = c;
        this.focusColor = DEFAULT_FOCUS_COLOR;
        this.setPreferredSize(PREF_SIZE);
        this.hitArc.setAngleStart(0.0);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent me) {
                if (DKnob.this.isEnabled()) {
                    int xpos = DKnob.this.middle - me.getX();
                    int ypos = DKnob.this.middle - me.getY();
                    double ang = Math.atan2(xpos, ypos);
                    double myAngle = -(ang / (double)6.283f);
                    DKnob.this.setValueDegree((float)myAngle * 360.0f);
                    DKnob.this.fireChangeEvent();
                }
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DKnob.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                DKnob.this.repaint();
            }
        });
    }

    public float getValueDegree() {
        float ret = 360.0f * this.val;
        if (ret > 180.0f) {
            ret -= 360.0f;
        }
        return ret;
    }

    public void setValueDegree(float angle) {
        float val;
        for (val = angle / 360.0f; val < 0.0f; val += 1.0f) {
        }
        while (val > 1.0f) {
            val -= 1.0f;
        }
        this.setValue(val);
    }

    public void setValue(float value) {
        this.val = value;
        this.ang = 1.57075f - 6.283f * this.val;
        this.repaint();
    }

    public float getValue() {
        return this.val;
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int size = Math.min(width, height) - 22;
        this.middle = 10 + size / 2;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(this.getParent().getBackground());
            g2d.addRenderingHints(AALIAS);
            this.hitArc.setFrame(4.0, 4.0, size + 12, size + 12);
        }
        int x2 = 10 + size / 2 + (int)((double)(6 + size / 2) * Math.cos(1.57075f));
        int y2 = 10 + size / 2 - (int)((double)(6 + size / 2) * Math.sin(1.57075f));
        g.drawLine(10 + size / 2 - 1, 10 + size / 2 + 1, x2 - 1, y2 + 1);
        g.drawLine(10 + size / 2, 10 + size / 2, x2, y2);
        g.drawLine(10 + size / 2 + 1, 10 + size / 2 + 1, x2 + 1, y2 + 1);
        for (float a2 = 1.57075f; a2 >= -4.7122498f; a2 -= 0.52358335f) {
            int x = 10 + size / 2 + (int)((double)(6 + size / 2) * Math.cos(a2));
            int y = 10 + size / 2 - (int)((double)(6 + size / 2) * Math.sin(a2));
            g.drawLine(10 + size / 2, 10 + size / 2, x, y);
        }
        if (this.hasFocus()) {
            g.setColor(this.focusColor);
        } else if (this.isEnabled()) {
            g.setColor(Color.white);
        } else {
            g.setColor(this.color);
        }
        g.fillOval(10, 10, size, size);
        g.setColor(Color.gray);
        g.fillOval(14 + this.SHADOWX, 14 + this.SHADOWY, size - 8, size - 8);
        g.setColor(this.color);
        g.drawArc(10, 10, size, size, 0, 360);
        g.fillOval(14, 14, size - 8, size - 8);
        g.setColor(Color.white);
        int x = 10 + size / 2 + (int)((double)(size / 2) * Math.cos(this.ang));
        int y = 10 + size / 2 - (int)((double)(size / 2) * Math.sin(this.ang));
        g.drawLine(10 + size / 2, 10 + size / 2, x, y);
        g.setColor(Color.gray);
        int s2 = Math.max(size / 6, 6);
        g.drawOval(10 + s2, 10 + s2, size - s2 * 2, size - s2 * 2);
        int dx = (int)(2.0 * Math.sin(this.ang));
        int dy = (int)(2.0 * Math.cos(this.ang));
        g.drawLine(10 + dx + size / 2, 10 + dy + size / 2, x, y);
        g.drawLine(10 - dx + size / 2, 10 - dy + size / 2, x, y);
        g.setColor(Color.black);
    }
}

