/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.gui.event.SelectionListener;
import fr.unistra.ibmc.assemble.gui.event.SelectionTransmitter;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomsSelection;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Model3D;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.utils.ParsingException;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSelection
extends AtomsSelection
implements SelectionListener,
SelectionTransmitter {
    private List<Chain> selectedChains = new ArrayList<Chain>();
    private List<fr.unistra.ibmc.assemble.structures.Residue> selectedResidues = new ArrayList<fr.unistra.ibmc.assemble.structures.Residue>();

    public GlobalSelection(Mediator mediator) {
        super(mediator);
    }

    @Override
    public void clear() {
        super.clear();
        this.selectedResidues.clear();
        this.selectedChains.clear();
        this.fireRenderingModified();
    }

    public void setPlaneDisplayed(boolean displayed) {
        for (fr.unistra.ibmc.assemble.structures.Residue r : this.selectedResidues) {
            r.setPlaneDisplayed(displayed);
        }
        this.fireRenderingModified();
    }

    public void setBackBoneDisplayed(boolean displayed) {
        for (fr.unistra.ibmc.assemble.structures.Residue r : this.selectedResidues) {
            r.setBackBoneDisplayed(displayed);
        }
        this.fireRenderingModified();
    }

    public List<Chain> getSelectedChains() {
        return this.selectedChains;
    }

    public void setAtomsDefaultColor() {
        for (Atom a : this.selectedAtoms) {
            a.setColor(a.getDefaultColor());
        }
        this.fireRenderingModified();
    }

    public void setResiduesDefaultColor() {
        for (fr.unistra.ibmc.assemble.structures.Residue r : this.selectedResidues) {
            r.setResidueDefaultColor();
        }
        this.fireRenderingModified();
    }

    @Override
    public void setRenderingMode(int mode) {
        for (fr.unistra.ibmc.assemble.structures.Residue r : this.selectedResidues) {
            r.setRenderingMode(mode);
        }
        this.fireRenderingModified();
    }

    public List<fr.unistra.ibmc.assemble.structures.Residue> getSelectedResidues() {
        return new ArrayList<fr.unistra.ibmc.assemble.structures.Residue>(this.selectedResidues);
    }

    public void add(UserSelection us) {
        for (fr.unistra.ibmc.assemble.structures.Residue r : us.getResidues()) {
            if (this.selectedResidues.contains(r)) continue;
            this.add(r);
        }
        for (Atom a : us.getSelectedAtoms()) {
            this.add(a);
        }
    }

    @Override
    public void add(fr.unistra.ibmc.assemble.structures.Residue r) {
        if (!this.selectedResidues.contains(r)) {
            for (Atom atom : r.getAtoms()) {
                this.add(atom);
            }
            this.selectedResidues.add(r);
        }
    }

    @Override
    public void add(Chain c) {
        if (!this.selectedChains.contains(c)) {
            for (fr.unistra.ibmc.assemble.structures.Residue r : c.getResidues()) {
                this.add(r);
            }
            this.selectedChains.add(c);
        }
    }

    public void remove(fr.unistra.ibmc.assemble.structures.Residue r) {
        for (Atom atom : r.getAtoms()) {
            this.removeAtom(atom);
        }
        this.selectedResidues.remove(r);
        this.fireRenderingModified();
    }

    public void remove(Chain chain) {
        for (fr.unistra.ibmc.assemble.structures.Residue residue : chain.getResidues()) {
            this.remove(residue);
            for (Atom atom : residue.getAtoms()) {
                this.removeAtom(atom);
            }
        }
        this.selectedChains.remove(chain);
        this.fireRenderingModified();
    }

    public void remove(Model3D model3D) {
        for (Chain chain : model3D.getChains()) {
            for (fr.unistra.ibmc.assemble.structures.Residue residue : chain.getResidues()) {
                this.remove(residue);
                for (Atom atom : residue.getAtoms()) {
                    this.removeAtom(atom);
                }
            }
        }
        this.fireRenderingModified();
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        if (this.mediator.get3DModel() != null) {
            if (!isShiftDown) {
                this.clear();
            }
            for (Residue r : residues) {
                fr.unistra.ibmc.assemble.structures.Residue _r = this.mediator.getAssemble().getAssembleResidue(r);
                if (_r == null) continue;
                this.add(_r);
                _r.setRenderingMode(1);
                for (Atom a : _r.getAtoms()) {
                    a.setRenderingMode(1);
                }
            }
            if (this.mediator.isCenterViewOnSelectionAutomatically()) {
                this.mediator.getRenderer().setGeneralPivot(this.getSelectionCenter());
            }
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        if (this.mediator.get3DModel() != null) {
            List<Atom> atoms;
            if (!isShiftDown) {
                this.clear();
            }
            if (!(atoms = this.mediator.getAssemble().getAtomsForStructuralDomain(structuralDomain)).isEmpty()) {
                HashSet<Chain> chains = new HashSet<Chain>();
                for (Atom a : atoms) {
                    chains.add(a.getResidue().getChain());
                    a.setRenderingMode(1);
                }
                for (Chain c : chains) {
                    this.add(c);
                    c.setRenderingMode(1);
                    for (fr.unistra.ibmc.assemble.structures.Residue r : c.getResidues()) {
                        r.setRenderingMode(1);
                    }
                }
                if (this.mediator.isCenterViewOnSelectionAutomatically()) {
                    this.mediator.getRenderer().setGeneralPivot(this.getSelectionCenter());
                }
            }
        }
    }

    @Override
    public void atomsSelected(Collection<Atom> atoms, boolean isShiftDown) {
        if (this.mediator.get3DModel() != null) {
            if (!isShiftDown) {
                this.clear();
            }
            for (Atom a : atoms) {
                this.add(a);
                a.setRenderingMode(1);
            }
            if (this.mediator.isCenterViewOnSelectionAutomatically()) {
                this.mediator.getRenderer().setGeneralPivot(this.getSelectionCenter());
            }
        }
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        if (this.mediator.get3DModel() != null) {
            if (!isShiftDown) {
                this.clear();
            }
            fr.unistra.ibmc.assemble.structures.Residue r = this.mediator.getAssemble().getAssembleResidue(interaction.getResidue());
            fr.unistra.ibmc.assemble.structures.Residue partnerR = this.mediator.getAssemble().getAssembleResidue(interaction.getPartnerResidue());
            if (r != null || partnerR != null) {
                this.add(r);
                r.setRenderingMode(1);
                for (Atom a : r.getAtoms()) {
                    a.setRenderingMode(1);
                }
                this.add(partnerR);
                partnerR.setRenderingMode(1);
                for (Atom a : partnerR.getAtoms()) {
                    a.setRenderingMode(1);
                }
                if (this.mediator.isCenterViewOnSelectionAutomatically()) {
                    this.mediator.getRenderer().setGeneralPivot(this.getSelectionCenter());
                }
            }
        }
    }

    public void exportAsPDB(File f) throws IOException, ParsingException, InterruptedException {
        ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
        for (fr.unistra.ibmc.assemble.structures.Residue residue : this.selectedResidues) {
            residue.saveCoordinatesToParadise();
            residues.add(residue.getResidue3D());
        }
        PDBFileIO.writePDBFile(residues, (boolean)true, (File)f);
    }
}

