/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.gui.event.SelectionListener;
import fr.unistra.ibmc.assemble.gui.event.SelectionTransmitter;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.utils.RessourcesUtils;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryStructureNavigator
extends JXPanel
implements SelectionListener,
SelectionTransmitter {
    private fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator rna2DViewerMediator;
    private Mediator assembleMediator;
    private Explorer explorer;
    private JPopupMenu popupMenu;

    public SecondaryStructureNavigator(fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator rna2DViewerMediator, Mediator assembleMediator) {
        this.setBackground(Color.WHITE);
        this.rna2DViewerMediator = rna2DViewerMediator;
        this.assembleMediator = assembleMediator;
        this.assembleMediator.setSecondaryStructureNavigator(this);
        this.rna2DViewerMediator.setSecondaryStructureNavigator(this);
        this.popupMenu = new JPopupMenu();
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void update() {
        this.explorer.updateUI();
    }

    public void reconstructTree() {
        this.removeAll();
        if (this.rna2DViewerMediator.getSecondaryCanvas().getModel2D() != null) {
            this.explorer = new Explorer(new ExplorerModel(this.rna2DViewerMediator.getSecondaryCanvas().getModel2D().getSecondaryStructure()));
            this.add(this.explorer);
            this.explorer.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent event) {
                    SecondaryStructureNavigator.this.rna2DViewerMediator.getSecondaryCanvas().clearAllSelections();
                    SecondaryStructureNavigator.this.assembleMediator.getGlobalSelection().clear();
                    if (SecondaryStructureNavigator.this.explorer.selectedNodes != null) {
                        for (TreePath path : SecondaryStructureNavigator.this.explorer.selectedNodes) {
                            ExplorerNode nodeSelected = (ExplorerNode)path.getLastPathComponent();
                            if (nodeSelected.wrappedObject instanceof SecondaryStructure) {
                                for (Helix h : ((SecondaryStructure)nodeSelected.wrappedObject).getHelices()) {
                                    SecondaryStructureNavigator.this.assembleMediator.fireStructuralDomainSelected(SecondaryStructureNavigator.this, (StructuralDomain)h, true);
                                }
                                for (SingleStrand ss : ((SecondaryStructure)nodeSelected.wrappedObject).getSingleStrands()) {
                                    SecondaryStructureNavigator.this.assembleMediator.fireStructuralDomainSelected(SecondaryStructureNavigator.this, (StructuralDomain)ss, true);
                                }
                                continue;
                            }
                            if (nodeSelected.wrappedObject instanceof StructuralDomain) {
                                SecondaryStructureNavigator.this.assembleMediator.fireStructuralDomainSelected(SecondaryStructureNavigator.this, (StructuralDomain)nodeSelected.wrappedObject, true);
                                continue;
                            }
                            if (nodeSelected.wrappedObject instanceof BaseBaseInteraction) {
                                SecondaryStructureNavigator.this.assembleMediator.fireInteractionSelected(SecondaryStructureNavigator.this, (BaseBaseInteraction)nodeSelected.wrappedObject, true);
                                continue;
                            }
                            if (!(nodeSelected.wrappedObject instanceof UserSelection)) continue;
                            UserSelection us = (UserSelection)nodeSelected.wrappedObject;
                            ArrayList<Residue> residues = new ArrayList<Residue>();
                            for (fr.unistra.ibmc.assemble.structures.Residue _r : us.getResidues()) {
                                residues.add((Residue)_r.getResidue3D().getResidues().iterator().next());
                            }
                            SecondaryStructureNavigator.this.assembleMediator.fireResiduesSelected(SecondaryStructureNavigator.this, residues, true);
                            SecondaryStructureNavigator.this.assembleMediator.fireAtomsSelected(SecondaryStructureNavigator.this, new ArrayList<Atom>(new ArrayList<Atom>(us.getSelectedAtoms())), true);
                        }
                        SecondaryStructureNavigator.this.rna2DViewerMediator.getSecondaryCanvas().centerViewOnSelection();
                    }
                }

                public void mousePressed(MouseEvent event) {
                    if (SecondaryStructureNavigator.this.explorer.selectedNodes != null && SecondaryStructureNavigator.this.explorer.selectedNodes.length == 1 && UserSelection.class.isInstance(((ExplorerNode)SecondaryStructureNavigator.this.explorer.selectedNodes[0].getLastPathComponent()).wrappedObject)) {
                        SecondaryStructureNavigator.this.popupMenu.removeAll();
                        JMenuItem item = new JMenuItem("Rename");
                        SecondaryStructureNavigator.this.popupMenu.add(item);
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                String name = JOptionPane.showInputDialog(null, (Object)"New name");
                                if (name != null && name.length() != 0) {
                                    ((UserSelection)((ExplorerNode)SecondaryStructureNavigator.this.explorer.selectedNodes[0].getLastPathComponent()).wrappedObject).setName(name);
                                    SecondaryStructureNavigator.this.updateNode(((ExplorerNode)SecondaryStructureNavigator.this.explorer.selectedNodes[0].getParentPath().getLastPathComponent()).wrappedObject, ((ExplorerNode)SecondaryStructureNavigator.this.explorer.selectedNodes[0].getLastPathComponent()).wrappedObject);
                                }
                            }
                        });
                        item = new JMenuItem("Delete");
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete this selection?")) {
                                    SecondaryStructureNavigator.this.assembleMediator.removeUserSelection((UserSelection)((ExplorerNode)SecondaryStructureNavigator.this.explorer.selectedNodes[0].getLastPathComponent()).wrappedObject);
                                    SecondaryStructureNavigator.this.removeNode(((ExplorerNode)SecondaryStructureNavigator.this.explorer.selectedNodes[0].getParentPath().getLastPathComponent()).wrappedObject, ((ExplorerNode)SecondaryStructureNavigator.this.explorer.selectedNodes[0].getLastPathComponent()).wrappedObject);
                                }
                            }
                        });
                        SecondaryStructureNavigator.this.popupMenu.add(item);
                        SecondaryStructureNavigator.this.maybeShowPopup(event);
                    }
                }

                public void mouseReleased(MouseEvent event) {
                    SecondaryStructureNavigator.this.maybeShowPopup(event);
                }

                public void mouseEntered(MouseEvent event) {
                }

                public void mouseExited(MouseEvent event) {
                }
            });
        }
    }

    public void addUserSelection(UserSelection selection) {
        this.insertNode("User Selections", selection);
        this.update();
    }

    public void insertNode(Object parentContent, Object newContent) {
        this.explorer.insertNode(parentContent, newContent);
    }

    public void removeNode(Object parentContent, Object newContent) {
        this.explorer.removeNode(parentContent, newContent);
    }

    public void updateNode(Object parentContent, Object newContent) {
        this.explorer.updateNode(parentContent, newContent);
    }

    public void selectNode(Object content) {
        ExplorerNode hit = this.explorer.search(content, (ExplorerNode)this.explorer.getModel().getRoot());
        if (hit != null) {
            this.explorer.setSelectionPath(hit.getTreePath());
        }
    }

    public void addNode(Object content) {
        ExplorerNode hit = this.explorer.search(content, (ExplorerNode)this.explorer.getModel().getRoot());
        if (hit != null) {
            this.explorer.addSelectionPath(hit.getTreePath());
        }
    }

    public void clearSelections() {
        if (this.explorer != null) {
            this.explorer.clearSelection();
        }
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        if (!isShiftDown) {
            this.clearSelections();
            this.selectNode(interaction);
        } else {
            this.addNode(interaction);
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        if (!isShiftDown) {
            this.clearSelections();
            this.selectNode(structuralDomain);
        } else {
            this.addNode(structuralDomain);
        }
    }

    @Override
    public void atomsSelected(Collection<Atom> atoms, boolean isShiftDown) {
    }

    public void clear() {
        this.removeAll();
    }

    private class ExplorerNode
    implements TreeNode,
    Comparable {
        private ExplorerNode parent;
        private List<ExplorerNode> children = new ArrayList<ExplorerNode>();
        private Object wrappedObject;

        private ExplorerNode(Object o) {
            this.wrappedObject = o;
        }

        public int getIndex(TreeNode child) {
            return this.children.indexOf(child);
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public int getChildCount() {
            return this.children.size();
        }

        public ExplorerNode getChildAt(int index) {
            return this.children.get(index);
        }

        private void addChild(ExplorerNode explorerNode) {
            this.children.add(explorerNode);
            explorerNode.parent = this;
            Collections.sort(this.children);
        }

        private void removeChild(ExplorerNode explorerNode) {
            this.children.remove(explorerNode);
            explorerNode.parent = null;
            Collections.sort(this.children);
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Enumeration children() {
            return Collections.enumeration(this.children);
        }

        public String toString() {
            StringBuffer location = new StringBuffer();
            if (ParadiseFeature.class.isInstance(this.wrappedObject)) {
                Collection molecules = ((ParadiseFeature)this.wrappedObject).getMolecules();
                for (Molecule m : molecules) {
                    if (Assemble.USE_ABSOLUTE_NUMBERING_SYSTEM) {
                        if (molecules.size() != 1) {
                            location.append(m.getName()).append(":").append(((ParadiseFeature)this.wrappedObject).getFullLocation(m).toString()).append(" ");
                            continue;
                        }
                        location.append(((ParadiseFeature)this.wrappedObject).getFullLocation(m).toString());
                        continue;
                    }
                    if (molecules.size() != 1) {
                        location.append(m.getName()).append(":").append(((ParadiseFeature)this.wrappedObject).getFullLocation(m).toString(SecondaryStructureNavigator.this.assembleMediator.getTertiaryStructure().getAllResiduesLabels(m))).append(" ");
                        continue;
                    }
                    location.append(((ParadiseFeature)this.wrappedObject).getFullLocation(m).toString(SecondaryStructureNavigator.this.assembleMediator.getTertiaryStructure().getAllResiduesLabels(m)));
                }
                if (StructuralDomain.class.isInstance(this.wrappedObject)) {
                    return this.wrappedObject.getClass().getSimpleName() + " " + ((StructuralDomain)this.wrappedObject).getName() + " " + location.toString();
                }
                return this.wrappedObject.getClass().getSimpleName() + " " + location.toString();
            }
            if (Molecule.class.isInstance(this.wrappedObject)) {
                return "Molecule " + ((Molecule)this.wrappedObject).getName();
            }
            if (UserSelection.class.isInstance(this.wrappedObject)) {
                return ((UserSelection)this.wrappedObject).getName();
            }
            if (String.class.isInstance(this.wrappedObject)) {
                return (String)this.wrappedObject;
            }
            return "";
        }

        public int compareTo(Object o) {
            if (Helix.class.isInstance(this.wrappedObject) && SingleStrand.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                return -1;
            }
            if (SingleStrand.class.isInstance(this.wrappedObject) && Helix.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                return 1;
            }
            if (Helix.class.isInstance(this.wrappedObject) && BaseBaseInteraction.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                return -1;
            }
            if (BaseBaseInteraction.class.isInstance(this.wrappedObject) && Helix.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                return 1;
            }
            if (BaseBaseInteraction.class.isInstance(this.wrappedObject) && SingleStrand.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                return 1;
            }
            if (SingleStrand.class.isInstance(this.wrappedObject) && BaseBaseInteraction.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                return -1;
            }
            if (Helix.class.isInstance(this.wrappedObject) && Helix.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                Helix h1 = (Helix)this.wrappedObject;
                Helix h2 = (Helix)((ExplorerNode)o).wrappedObject;
                if (h1.getMolecules().size() == 1 && h2.getMolecules().size() == 1) {
                    int diff = h1.getFullLocation((Molecule)h1.getMolecules().iterator().next()).getStart() - h2.getFullLocation((Molecule)h2.getMolecules().iterator().next()).getStart();
                    if (diff < 0) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
            if (BaseBaseInteraction.class.isInstance(this.wrappedObject) && BaseBaseInteraction.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                BaseBaseInteraction bb1 = (BaseBaseInteraction)this.wrappedObject;
                BaseBaseInteraction bb2 = (BaseBaseInteraction)((ExplorerNode)o).wrappedObject;
                if (bb1.getMolecules().size() == 1 && bb2.getMolecules().size() == 1) {
                    int diff = bb1.getResidue().getAbsolutePosition() - bb2.getResidue().getAbsolutePosition();
                    if (diff < 0) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
            if (SingleStrand.class.isInstance(this.wrappedObject) && SingleStrand.class.isInstance(((ExplorerNode)o).wrappedObject)) {
                SingleStrand ss1 = (SingleStrand)this.wrappedObject;
                SingleStrand ss2 = (SingleStrand)((ExplorerNode)o).wrappedObject;
                if (ss1.getMolecules().size() == 1 && ss2.getMolecules().size() == 1) {
                    int diff = ss1.getFullLocation((Molecule)ss1.getMolecules().iterator().next()).getStart() - ss2.getFullLocation((Molecule)ss2.getMolecules().iterator().next()).getStart();
                    if (diff < 0) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
            return 0;
        }

        private TreePath getTreePath() {
            ArrayList<ExplorerNode> parents = new ArrayList<ExplorerNode>();
            parents.add(this);
            ExplorerNode _parent = this.parent;
            while (_parent != null) {
                parents.add(0, _parent);
                _parent = _parent.parent;
            }
            return new TreePath(parents.toArray(new ExplorerNode[0]));
        }
    }

    private class ExplorerRenderer
    extends DefaultTreeCellRenderer {
        private ExplorerRenderer() {
            this.setFont(new Font("Monospaced", 0, 14));
            this.setForeground(Color.black);
            this.setVisible(true);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (selected) {
                this.setOpaque(true);
                this.setBackground(Color.ORANGE);
            } else {
                this.setOpaque(false);
            }
            this.setText(value.toString());
            if (((ExplorerNode)value).wrappedObject instanceof SingleStrand) {
                this.setIcon(new ImageIcon(RessourcesUtils.getImage("sstrand-node.png")));
            } else if (((ExplorerNode)value).wrappedObject instanceof Helix) {
                this.setIcon(new ImageIcon(RessourcesUtils.getImage("helix-node.png")));
            } else if (((ExplorerNode)value).wrappedObject instanceof BaseBaseInteraction) {
                this.setIcon(new ImageIcon(RessourcesUtils.getImage("interaction-node.png")));
            } else if (((ExplorerNode)value).wrappedObject instanceof Molecule) {
                this.setIcon(new ImageIcon(RessourcesUtils.getImage("molecule-node.png")));
            } else if (((ExplorerNode)value).wrappedObject instanceof SecondaryStructure) {
                this.setIcon(new ImageIcon(RessourcesUtils.getImage("secondary-structure-node.png")));
            } else if (((ExplorerNode)value).wrappedObject instanceof String && ((ExplorerNode)value).wrappedObject.equals("User Selections")) {
                this.setIcon(new ImageIcon(RessourcesUtils.getImage("16/workspace.gif")));
            } else if (((ExplorerNode)value).wrappedObject instanceof UserSelection) {
                this.setIcon(new ImageIcon(RessourcesUtils.getImage("16/user.gif")));
            } else {
                this.setIcon(new ImageIcon(RessourcesUtils.getImage("node.png")));
            }
            return this;
        }
    }

    private class ExplorerModel
    extends DefaultTreeModel {
        private ExplorerNode userSelections;
        private ExplorerNode secondaryStructure;
        private List<TreeModelListener> listeners;

        private ExplorerModel(SecondaryStructure secondaryStructure) {
            super(new ExplorerNode("3D Model"));
            this.userSelections = new ExplorerNode("User Selections");
            ((ExplorerNode)this.getRoot()).addChild(this.userSelections);
            this.secondaryStructure = new ExplorerNode(secondaryStructure);
            ((ExplorerNode)this.getRoot()).addChild(this.secondaryStructure);
            this.listeners = new ArrayList<TreeModelListener>();
            for (Molecule m : secondaryStructure.getMolecules()) {
                ExplorerNode moleculeNode = new ExplorerNode(m);
                this.secondaryStructure.addChild(moleculeNode);
                for (Helix h : secondaryStructure.getHelices()) {
                    if (h.getMolecules().size() != 1 || !h.annotates(m)) continue;
                    ExplorerNode helixNode = new ExplorerNode(h);
                    moleculeNode.addChild(helixNode);
                    for (BaseBaseInteraction interaction : h.getBaseBaseInteractions()) {
                        helixNode.addChild(new ExplorerNode(interaction));
                    }
                }
                for (SingleStrand ss : secondaryStructure.getSingleStrands()) {
                    if (!ss.annotates(m)) continue;
                    moleculeNode.addChild(new ExplorerNode(ss));
                }
                for (BaseBaseInteraction interaction : secondaryStructure.getTertiaryInteractions()) {
                    if (interaction.getMolecules().size() != 1 || !interaction.annotates(m)) continue;
                    moleculeNode.addChild(new ExplorerNode(interaction));
                }
            }
            for (Helix h : secondaryStructure.getHelices()) {
                if (h.getMolecules().size() != 2) continue;
                ExplorerNode n = new ExplorerNode(h);
                this.secondaryStructure.addChild(n);
                for (BaseBaseInteraction interaction : h.getBaseBaseInteractions()) {
                    n.addChild(new ExplorerNode(interaction));
                }
            }
            for (BaseBaseInteraction interaction : secondaryStructure.getTertiaryInteractions()) {
                if (interaction.getMolecules().size() != 2) continue;
                this.secondaryStructure.addChild(new ExplorerNode(interaction));
            }
        }

        public Object getChild(Object parent, int index) {
            return ((ExplorerNode)parent).getChildAt(index);
        }

        public int getChildCount(Object parent) {
            return ((ExplorerNode)parent).getChildCount();
        }

        public boolean isLeaf(Object node) {
            return ((ExplorerNode)node).isLeaf();
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((TreeNode)parent).getIndex((TreeNode)child);
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.add(treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.remove(treeModelListener);
        }

        private void addNode(ExplorerNode parent, ExplorerNode child) {
            parent.addChild(child);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesInserted(new TreeModelEvent((Object)this, parent.getTreePath(), new int[]{parent.children.indexOf(child)}, new Object[]{child}));
            }
        }

        private void removeNode(ExplorerNode parent, ExplorerNode child) {
            int index = parent.children.indexOf(child);
            parent.removeChild(child);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesRemoved(new TreeModelEvent((Object)this, parent.getTreePath(), new int[]{index}, new Object[]{child}));
            }
        }

        private void updateNode(ExplorerNode parent, ExplorerNode child) {
            for (TreeModelListener l : this.listeners) {
                l.treeNodesChanged(new TreeModelEvent((Object)this, parent.getTreePath(), new int[]{parent.children.indexOf(child)}, new Object[]{child}));
            }
        }
    }

    private class Explorer
    extends JTree
    implements TreeSelectionListener {
        private TreePath[] selectedNodes;

        Explorer(ExplorerModel treeModel) {
            super(treeModel);
            this.putClientProperty("JTree.lineStyle", "Angled");
            this.setEditable(false);
            this.getSelectionModel().setSelectionMode(4);
            this.addTreeSelectionListener(this);
            this.setCellRenderer(new ExplorerRenderer());
            this.setExpandsSelectedPaths(true);
        }

        public void valueChanged(TreeSelectionEvent e) {
            this.selectedNodes = this.getSelectionPaths();
        }

        private void insertNode(Object parentContent, Object newContent) {
            ExplorerNode parentNode = this.search(parentContent, (ExplorerNode)this.treeModel.getRoot());
            if (parentNode != null) {
                ExplorerNode _newNode = new ExplorerNode(newContent);
                ((ExplorerModel)this.treeModel).addNode(parentNode, _newNode);
                this.setSelectionPath(_newNode.getTreePath());
            }
        }

        private void removeNode(Object parentContent, Object content) {
            ExplorerNode _parentNode = this.search(parentContent, (ExplorerNode)this.treeModel.getRoot());
            ExplorerNode _childNode = this.search(content, (ExplorerNode)this.treeModel.getRoot());
            if (_parentNode != null && _childNode != null) {
                ((ExplorerModel)this.treeModel).removeNode(_parentNode, _childNode);
            }
        }

        private void updateNode(Object parentContent, Object content) {
            ExplorerNode _parentNode = this.search(parentContent, (ExplorerNode)this.treeModel.getRoot());
            ExplorerNode _childNode = this.search(content, (ExplorerNode)this.treeModel.getRoot());
            if (_parentNode != null && _childNode != null) {
                ((ExplorerModel)this.treeModel).updateNode(_parentNode, _childNode);
            }
        }

        private ExplorerNode search(Object content, ExplorerNode node) {
            ExplorerNode hit = null;
            if (node.wrappedObject == content) {
                hit = node;
            } else {
                for (int i = 0; i < node.children.size() && hit == null; ++i) {
                    hit = this.search(content, node.getChildAt(i));
                }
            }
            return hit;
        }
    }
}

