/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.mypdb;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.mypdb.MyPDBHit;
import fr.unistra.ibmc.paradise.core.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyPDBQuery {
    public static final List<MyPDBHit> searchPseudoKnots() throws JDOMException, IOException {
        ArrayList<MyPDBHit> hits = new ArrayList<MyPDBHit>();
        for (File pdbDir : Assemble.getMyPDBDir().listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            File secondaryStructureFile = new File(new File(new File(pdbDir, "model"), "SecondaryStructures"), "Secondary_Structure.rnaml");
            if (!secondaryStructureFile.exists()) continue;
            Document doc = new SAXBuilder().build(secondaryStructureFile);
            XPath query = XPath.newInstance((String)"//helix");
            List results = query.selectNodes((Object)doc.getRootElement());
            for (int i = 0; i < results.size() - 1; ++i) {
                Element helix1 = (Element)results.get(i);
                Element helix2 = (Element)results.get(i + 1);
                int start1 = Integer.parseInt(helix1.getAttributeValue("base5-id"));
                int start2 = Integer.parseInt(helix2.getAttributeValue("base5-id"));
                int end1 = Integer.parseInt(helix1.getAttributeValue("base3-id"));
                int end2 = Integer.parseInt(helix2.getAttributeValue("base3-id"));
                int length1 = Integer.parseInt(helix1.getAttributeValue("length"));
                int length2 = Integer.parseInt(helix2.getAttributeValue("length"));
                if (!helix1.getAttributeValue("molecule1-id").equals(helix1.getAttributeValue("molecule2-id")) || !helix2.getAttributeValue("molecule1-id").equals(helix2.getAttributeValue("molecule2-id")) || !helix1.getAttributeValue("molecule1-id").equals(helix2.getAttributeValue("molecule1-id")) || (start1 + length1 - 1 > start2 || start2 > end1 - length1 + 1 || end2 - length2 + 1 < end1) && (start2 + length2 - 1 > start1 || start1 > end2 - length2 + 1 || end1 - length1 + 1 < end2)) continue;
                MyPDBHit hit = new MyPDBHit(pdbDir.getName());
                hit.addLocation(helix1.getAttributeValue("molecule1-id").split("\\.rnaml")[0], new Location(new Location(new Location(start1, start1 + length1 - 1), new Location(end1 - length1 + 1, end1)), new Location(new Location(start2, start2 + length2 - 1), new Location(end2 - length2 + 1, end2))));
                hits.add(hit);
            }
        }
        return hits;
    }

    public static List<MyPDBHit> searchInternalLoops(int length1, int length2) throws JDOMException, IOException, BiologicalSymbolException, InterruptedException, FileParsingException {
        ArrayList<MyPDBHit> hits = new ArrayList<MyPDBHit>();
        for (File pdbDir : Assemble.getMyPDBDir().listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            File secondaryStructureFile = new File(new File(new File(pdbDir, "model"), "SecondaryStructures"), "Secondary_Structure.rnaml");
            if (!secondaryStructureFile.exists()) continue;
            Document doc = new SAXBuilder().build(secondaryStructureFile);
            XPath query = XPath.newInstance((String)"//single-strand[@type='internal']");
            List singlestrands = query.selectNodes((Object)doc.getRootElement());
            block1: for (int i = 0; i < singlestrands.size(); ++i) {
                Element ss = (Element)singlestrands.get(i);
                Location l = new Location(Integer.parseInt(ss.getAttributeValue("base5-id")), Integer.parseInt(ss.getAttributeValue("base3-id")));
                if (l.getLength() != length1 && l.getLength() != length2) continue;
                MyPDBHit hit = new MyPDBHit(pdbDir.getName());
                query = XPath.newInstance((String)"//helix");
                List helices = query.selectNodes((Object)doc.getRootElement());
                for (int j = 0; j < helices.size(); ++j) {
                    int _length;
                    List _singlestrands;
                    Element h = (Element)helices.get(j);
                    int _5 = Integer.parseInt(ss.getAttributeValue("base5-id")) - 1;
                    if (Integer.parseInt(h.getAttributeValue("base3-id")) == _5 && ss.getAttributeValue("molecule-id").equals(h.getAttributeValue("molecule2-id"))) {
                        query = XPath.newInstance((String)("//single-strand[@type='internal' and @molecule-id='" + h.getAttributeValue("molecule1-id") + "' and @base3-id='" + (Integer.parseInt(h.getAttributeValue("base5-id")) - 1) + "']"));
                        _singlestrands = query.selectNodes((Object)doc.getRootElement());
                        if (!_singlestrands.isEmpty()) {
                            _length = Integer.parseInt(((Element)_singlestrands.get(0)).getAttributeValue("base3-id")) - Integer.parseInt(((Element)_singlestrands.get(0)).getAttributeValue("base5-id")) + 1;
                            if ((l.getLength() != length1 || _length != length2) && (_length != length1 || l.getLength() != length2)) continue block1;
                            l.add(new Location(Integer.parseInt(((Element)_singlestrands.get(0)).getAttributeValue("base5-id")), Integer.parseInt(((Element)_singlestrands.get(0)).getAttributeValue("base3-id"))));
                            singlestrands.remove(_singlestrands.get(0));
                            hit.addLocation(ss.getAttributeValue("molecule-id").split("\\.rnaml")[0], l);
                            hits.add(hit);
                            continue block1;
                        }
                        if (length2 != 0 && length1 != 0) continue;
                        hit.addLocation(ss.getAttributeValue("molecule-id").split("\\.rnaml")[0], l);
                        hits.add(hit);
                        continue block1;
                    }
                    if (Integer.parseInt(h.getAttributeValue("base5-id")) + Integer.parseInt(h.getAttributeValue("length")) - 1 != _5 || !ss.getAttributeValue("molecule-id").equals(h.getAttributeValue("molecule1-id"))) continue;
                    query = XPath.newInstance((String)("//single-strand[@type='internal' and @molecule-id='" + h.getAttributeValue("molecule2-id") + "' and @base3-id='" + (Integer.parseInt(h.getAttributeValue("base3-id")) - Integer.parseInt(h.getAttributeValue("length"))) + "']"));
                    _singlestrands = query.selectNodes((Object)doc.getRootElement());
                    if (!_singlestrands.isEmpty()) {
                        _length = Integer.parseInt(((Element)_singlestrands.get(0)).getAttributeValue("base3-id")) - Integer.parseInt(((Element)_singlestrands.get(0)).getAttributeValue("base5-id")) + 1;
                        if ((l.getLength() != length1 || _length != length2) && (_length != length1 || l.getLength() != length2)) continue block1;
                        l.add(new Location(Integer.parseInt(((Element)_singlestrands.get(0)).getAttributeValue("base5-id")), Integer.parseInt(((Element)_singlestrands.get(0)).getAttributeValue("base3-id"))));
                        singlestrands.remove(_singlestrands.get(0));
                        hit.addLocation(ss.getAttributeValue("molecule-id").split("\\.rnaml")[0], l);
                        hits.add(hit);
                        continue block1;
                    }
                    if ((l.getLength() != length1 || length2 != 0) && (l.getLength() != length2 || length1 != 0)) continue;
                    hit.addLocation(ss.getAttributeValue("molecule-id").split("\\.rnaml")[0], l);
                    hits.add(hit);
                    continue block1;
                }
            }
        }
        return hits;
    }

    public static List<MyPDBHit> searchApicalLoops(int length) throws JDOMException, IOException, BiologicalSymbolException, InterruptedException, FileParsingException {
        ArrayList<MyPDBHit> hits = new ArrayList<MyPDBHit>();
        for (File pdbDir : Assemble.getMyPDBDir().listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            File secondaryStructureFile = new File(new File(new File(pdbDir, "model"), "SecondaryStructures"), "Secondary_Structure.rnaml");
            if (!secondaryStructureFile.exists()) continue;
            Document doc = new SAXBuilder().build(secondaryStructureFile);
            XPath query = XPath.newInstance((String)"//single-strand[@type='apical']");
            List singlestrands = query.selectNodes((Object)doc.getRootElement());
            for (int i = 0; i < singlestrands.size(); ++i) {
                Element ss = (Element)singlestrands.get(i);
                Location l = new Location(Integer.parseInt(ss.getAttributeValue("base5-id")), Integer.parseInt(ss.getAttributeValue("base3-id")));
                if (l.getLength() != length) continue;
                MyPDBHit hit = new MyPDBHit(pdbDir.getName());
                hit.addLocation(ss.getAttributeValue("molecule-id").split("\\.rnaml")[0], l);
                hits.add(hit);
            }
        }
        return hits;
    }

    public static List<MyPDBHit> searchJunctions(int length) throws JDOMException, IOException, BiologicalSymbolException, InterruptedException, FileParsingException {
        ArrayList<MyPDBHit> hits = new ArrayList<MyPDBHit>();
        for (File pdbDir : Assemble.getMyPDBDir().listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            File secondaryStructureFile = new File(new File(new File(pdbDir, "model"), "SecondaryStructures"), "Secondary_Structure.rnaml");
            if (!secondaryStructureFile.exists()) continue;
            Document doc = new SAXBuilder().build(secondaryStructureFile);
            XPath query = XPath.newInstance((String)"//single-strand[@type='junction']");
            List singlestrands = query.selectNodes((Object)doc.getRootElement());
            for (int i = 0; i < singlestrands.size(); ++i) {
                Element ss = (Element)singlestrands.get(i);
                Location l = new Location(Integer.parseInt(ss.getAttributeValue("base5-id")), Integer.parseInt(ss.getAttributeValue("base3-id")));
                if (l.getLength() != length) continue;
                MyPDBHit hit = new MyPDBHit(pdbDir.getName());
                hit.addLocation(ss.getAttributeValue("molecule-id").split("\\.rnaml")[0], l);
                hits.add(hit);
            }
        }
        return hits;
    }

    public static void main(String[] args) throws JDOMException, IOException, BiologicalSymbolException, FileParsingException, InterruptedException {
        System.out.println("Internal Loops found in myPDB: " + MyPDBQuery.searchInternalLoops(3, 3).size());
    }
}

