/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.utils;

import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.Residue2D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class DrawingUtils {
    private DrawingUtils() {
    }

    private static double getA(Point2D p1, Point2D p2) {
        return (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
    }

    public static double getB(Point2D p1, Point2D p2) {
        return p1.getY() - DrawingUtils.getA(p1, p2) * p1.getX();
    }

    public static double crossProduct(Point2D p1, Point2D p2, Point2D p3) {
        return DrawingUtils.crossProduct(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
    }

    public static double crossProduct(double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        double a1 = p2x - p1x;
        double a2 = p2y - p1y;
        double b1 = p3x - p1x;
        double b2 = p3y - p1y;
        return a1 * b2 - a2 * b1;
    }

    public static double getDistance(Point2D p1, Point2D p2) {
        return DrawingUtils.getDistance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        double horizontal = x1 - x2;
        double vertical = y1 - y2;
        return Math.sqrt(horizontal * horizontal + vertical * vertical);
    }

    public static Point2D[] fit(Point2D p1, Point2D p2, double distance) {
        return DrawingUtils.fit(p1.getX(), p1.getY(), p2.getX(), p2.getY(), distance);
    }

    public static Point2D[] fit(double x1, double y1, double x2, double y2, double distance) {
        double newy1;
        double newy2;
        double newx1;
        double newx2;
        Point2D[] drawingPoints = new Point2D[2];
        double angle = DrawingUtils.getAngle(DrawingUtils.getDistance(x1, y1, x1, y2), DrawingUtils.getDistance(x1, y2, x2, y2));
        if (x1 >= x2) {
            newx2 = x2 + DrawingUtils.getAdjacentSide(angle, distance);
            newx1 = x1 - DrawingUtils.getAdjacentSide(angle, distance);
        } else {
            newx2 = x2 - DrawingUtils.getAdjacentSide(angle, distance);
            newx1 = x1 + DrawingUtils.getAdjacentSide(angle, distance);
        }
        if (y1 >= y2) {
            newy2 = y2 + DrawingUtils.getOppositeSide(angle, distance);
            newy1 = y1 - DrawingUtils.getOppositeSide(angle, distance);
        } else {
            newy2 = y2 - DrawingUtils.getOppositeSide(angle, distance);
            newy1 = y1 + DrawingUtils.getOppositeSide(angle, distance);
        }
        drawingPoints[0] = new Point2D.Double(newx1, newy1);
        drawingPoints[1] = new Point2D.Double(newx2, newy2);
        return drawingPoints;
    }

    public static double getAdjacentSide(double angle, double hypothenuse) {
        return Math.cos(angle) * hypothenuse;
    }

    public static double getAngle(double oppositeSide, double adjacentSide) {
        return Math.atan(oppositeSide / adjacentSide);
    }

    public static double getOppositeSide(double angle, double hypothenuse) {
        return Math.sin(angle) * hypothenuse;
    }

    public static Point2D getRotatedPoint(Point2D p, double a, Point2D c) {
        if (a != 0.0) {
            AffineTransform rot = new AffineTransform();
            rot.setToRotation(a, c.getX(), c.getY());
            Point2D pointRot = rot.transform(p, null);
            return new Point2D.Double(pointRot.getX(), pointRot.getY());
        }
        return p;
    }

    public static Point2D[] getPerpendicular(Point2D p0, Point2D p1, Point2D p2, double distance) {
        Point2D[] pp = new Point2D[]{(Point2D)p0.clone(), (Point2D)p0.clone()};
        double angle = DrawingUtils.getAngle(p1.getY() - p2.getY(), p1.getX() - p2.getX());
        pp[0].setLocation(pp[0].getX() + DrawingUtils.getOppositeSide(angle, distance), pp[0].getY() - DrawingUtils.getAdjacentSide(angle, distance));
        pp[1].setLocation(pp[1].getX() - DrawingUtils.getOppositeSide(angle, distance), pp[1].getY() + DrawingUtils.getAdjacentSide(angle, distance));
        return pp;
    }

    public static Point2D getMiddlePoint(Point2D p1, Point2D p2) {
        return new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    public static List getOrientedLine(GraphicContext gc, Point2D firstPoint, Point2D secondPoint) {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        double distance = DrawingUtils.getDistance(firstPoint, secondPoint);
        Point2D[] ip1 = null;
        double size = gc.getCurrentSymbolSize() / 2.0;
        if (distance >= size) {
            ip1 = DrawingUtils.fit(firstPoint.getX(), firstPoint.getY(), secondPoint.getX(), secondPoint.getY(), (distance - size) / 2.0);
        }
        if (ip1 != null) {
            shapes.add(new Line2D.Double(firstPoint, (Point2D)ip1[0]));
            shapes.add(new Line2D.Double(ip1[1], secondPoint));
            GeneralPath triangle = new GeneralPath();
            Point2D[] startPoints = DrawingUtils.getPerpendicular(ip1[0], firstPoint, secondPoint, size / 2.0);
            triangle.moveTo((float)startPoints[0].getX(), (float)startPoints[0].getY());
            triangle.lineTo((float)startPoints[1].getX(), (float)startPoints[1].getY());
            triangle.lineTo((float)ip1[1].getX(), (float)ip1[1].getY());
            triangle.lineTo((float)startPoints[0].getX(), (float)startPoints[0].getY());
            triangle.closePath();
            shapes.add(triangle);
        } else {
            shapes.add(new Line2D.Double(firstPoint, secondPoint));
        }
        return shapes;
    }

    public static void drawString(Point2D center, String s, Graphics2D g) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.drawString(s, (float)(center.getX() - (double)((float)fm.stringWidth(s) / 2.0f)), (float)(center.getY() + (double)((float)(fm.getAscent() + fm.getDescent()) / 2.0f)));
    }

    public static void drawSecondaryStructure(SecondaryStructure ss) {
        StructuralFeatureFactory factory = ss.getFactory();
        SecondaryStructureDisplay display = factory.createSecondaryStructureDisplay(ss, (Molecule)ss.getMolecules().iterator().next(), new Location());
        ArrayList<Residue2D> residues2D = new ArrayList<Residue2D>();
        for (Molecule m : ss.getMolecules()) {
            for (int i = 1; i <= m.getLength(); ++i) {
                residues2D.add(factory.createResidue2D(display, 0.0f, 0.0f, m, i));
            }
            double initialAngle = -1.0;
        }
    }

    public static String colorToString(Color color) {
        return new StringBuffer("rgb(").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(")").toString();
    }
}

