/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomSet
extends AbstractDrawable {
    protected Map<String, Atom> atoms;
    public List<Link> links;
    private OpenGLColor color = new OpenGLColor(Color.white);

    public AtomSet(Mediator mediator, Residue r, Residue3D res3D) {
        this(mediator);
    }

    public AtomSet(Mediator mediator) {
        super(mediator);
        this.atoms = new Hashtable<String, Atom>();
        this.links = new ArrayList<Link>();
    }

    public void clear() {
        this.atoms.clear();
    }

    public Atom getAtom(String atomName) {
        for (Atom atom : this.atoms.values()) {
            if (!atom.getName().equals(atomName)) continue;
            return atom;
        }
        return null;
    }

    public float[] getCenter() {
        float[] center = new float[]{0.0f, 0.0f, 0.0f};
        for (Atom atom : this.atoms.values()) {
            float[] atc = atom.getFloat();
            for (int i = 0; i < 3; ++i) {
                int n = i;
                center[n] = center[n] + atc[i];
            }
        }
        int s = this.atoms.size();
        if (s > 0) {
            for (int i = 0; i < 3; ++i) {
                center[i] = center[i] / (float)s;
            }
        }
        return center;
    }

    public void add(Atom atom) {
        this.atoms.put(atom.getName(), atom);
    }

    public void add(AtomSet set) {
        for (Atom atom : set.getAtoms()) {
            this.add(atom);
        }
    }

    public void removeAtom(Atom atom) {
        this.atoms.remove(atom.getName());
    }

    public boolean containsAtom(Atom atom) {
        return this.atoms.values().contains(atom);
    }

    public Collection<Atom> getAtoms() {
        return this.atoms.values();
    }

    public void add(Collection<Atom> atoms) {
        for (Atom a : atoms) {
            this.atoms.put(a.getName(), a);
        }
    }

    public int atomsCount() {
        return this.atoms.size();
    }

    public void setResidueDefaultColor() {
        for (Atom atom : this.atoms.values()) {
            atom.setColor(this.getColor());
        }
    }

    public void propagateBackboneColor() {
        for (Atom atom : this.atoms.values()) {
            atom.setColor(this.getColor());
        }
    }

    @Override
    public void draw(GL gl) {
        for (Atom atom : this.atoms.values()) {
            atom.draw(gl);
        }
        for (Link link : this.links) {
            link.draw(gl);
        }
    }

    public void drawSelectScene(GL gl) {
        for (Atom atom : this.atoms.values()) {
            atom.drawSelectScene(gl);
        }
    }

    public void drawSphere(GL gl) {
        for (Atom atom : this.atoms.values()) {
            atom.drawSphere(gl);
        }
        gl.glLineWidth(1.0f);
        gl.glBegin(1);
        for (Link link : this.links) {
            link.draw(gl);
        }
        gl.glEnd();
    }

    public void translate(float x, float y, float z) {
        for (Atom atom : this.atoms.values()) {
            atom.translate(x, y, z);
        }
    }

    public OpenGLColor getColor() {
        return this.color;
    }

    public void setColor(OpenGLColor color) {
        this.color = new OpenGLColor(color.getAWTColor());
        if (this.mediator.getRenderer().getColorationStyle() == 0) {
            this.propagateBackboneColor();
        }
    }

    public void setColor(Color color) {
        this.color = new OpenGLColor(color);
        this.propagateBackboneColor();
        this.fireRenderingModified();
    }

    public void removeLinks(Atom at) {
        ArrayList<Link> tmp = new ArrayList<Link>();
        for (Link link : this.links) {
            if (link.getFirst() != at && link.getSecond() != at) continue;
            tmp.add(link);
        }
        for (Link link : tmp) {
            this.links.remove(link);
        }
    }

    public void removeLink(Atom a1, Atom a2) {
        ArrayList<Link> tmp = new ArrayList<Link>();
        for (Link link : this.links) {
            if ((link.getFirst() != a1 || link.getSecond() != a2) && (link.getFirst() != a2 || link.getSecond() != a1)) continue;
            tmp.add(link);
        }
        for (Link link : tmp) {
            this.links.remove(link);
        }
    }
}

