/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.DihedralAngle;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;

public class Beta53
extends DihedralAngle {
    public Beta53(Residue r, String name, Mediator mediator) {
        super(r, name, mediator);
        this.atomsToRotate.add(r);
        Atom a = r.getAtom("P");
        if (a != null) {
            this.atomsToRotate.removeAtom(a);
        }
        if ((a = r.getAtom("O1P")) != null) {
            this.atomsToRotate.removeAtom(a);
        }
        if ((a = r.getAtom("O2P")) != null) {
            this.atomsToRotate.removeAtom(a);
        }
        if ((a = r.getAtom("O5'")) != null) {
            this.atomsToRotate.removeAtom(a);
        }
        if ((a = r.getAtom("C5'")) != null) {
            this.atomsToRotate.removeAtom(a);
        }
    }

    protected float computeValue(boolean upstreamDirection) {
        if (this.isValid()) {
            if (!upstreamDirection) {
                return TBMath.dihedral((float[])this.residue.getAtom("P").getFloat(), (float[])this.residue.getAtom("O5'").getFloat(), (float[])this.residue.getAtom("C5'").getFloat(), (float[])this.residue.getAtom("C4'").getFloat());
            }
            return TBMath.dihedral((float[])this.residue.getAtom("C4'").getFloat(), (float[])this.residue.getAtom("C5'").getFloat(), (float[])this.residue.getAtom("O5'").getFloat(), (float[])this.residue.getAtom("P").getFloat());
        }
        return 0.0f;
    }

    public boolean isValid() {
        return this.residue.getAtom("P") != null && this.residue.getAtom("O5'") != null && this.residue.getAtom("C5'") != null && this.residue.getAtom("C4'") != null;
    }

    public Link getAxis(boolean upstreamDirection) {
        if (!upstreamDirection) {
            return new Link(this.mediator, this.residue.getAtom("O5'"), this.residue.getAtom("C5'"));
        }
        return new Link(this.mediator, this.residue.getAtom("C5'"), this.residue.getAtom("O5'"));
    }

    public void gatherAtomsToRotate(boolean upstreamDirection, boolean rotateTertiaryInteractions) {
        super.gatherAtomsToRotate(upstreamDirection, rotateTertiaryInteractions);
        if (!upstreamDirection) {
            this.atomsToRotate.add(this.residue);
            for (BaseBaseInteraction2D interaction : this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D((fr.unistra.ibmc.paradise.core.utils.Residue)this.residue.getResidue3D().getResidues().iterator().next()).getInteractions()) {
                if (!interaction.getBaseBaseInteractionFeature().isSecondaryInteraction() && !rotateTertiaryInteractions) continue;
                Residue r = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getResidue().getResidue2DFeature().getResidues().iterator().next());
                if (r != this.residue) {
                    this.atomsToRotate.add(r);
                    continue;
                }
                this.atomsToRotate.add(this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getPartnerResidue().getResidue2DFeature().getResidues().iterator().next()));
            }
            Atom a = this.residue.getAtom("P");
            if (a != null) {
                this.atomsToRotate.removeAtom(a);
            }
            if ((a = this.residue.getAtom("O1P")) != null) {
                this.atomsToRotate.removeAtom(a);
            }
            if ((a = this.residue.getAtom("O2P")) != null) {
                this.atomsToRotate.removeAtom(a);
            }
            if ((a = this.residue.getAtom("O5'")) != null) {
                this.atomsToRotate.removeAtom(a);
            }
            if ((a = this.residue.getAtom("C5'")) != null) {
                this.atomsToRotate.removeAtom(a);
            }
        } else {
            Atom a = this.residue.getAtom("P");
            if (a != null) {
                this.atomsToRotate.add(a);
            }
            if ((a = this.residue.getAtom("O1P")) != null) {
                this.atomsToRotate.add(a);
            }
            if ((a = this.residue.getAtom("O2P")) != null) {
                this.atomsToRotate.add(a);
            }
        }
    }
}

