/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.DihedralAngle;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;

public class Chi
extends DihedralAngle {
    private Atom firstChi;
    private Atom secondChi;
    private Atom[] baseAtoms;

    public Chi(Residue r, Atom firstChi, Atom secondChi, Atom[] baseAtoms, String name, Mediator mediator) {
        super(r, name, mediator);
        this.firstChi = firstChi;
        this.secondChi = secondChi;
        this.baseAtoms = baseAtoms;
    }

    protected float computeValue(boolean upstreamDirection) {
        if (this.isValid()) {
            return TBMath.dihedral((float[])this.residue.getAtom("O4'").getFloat(), (float[])this.residue.getAtom("C1'").getFloat(), (float[])this.firstChi.getFloat(), (float[])this.secondChi.getFloat());
        }
        return 0.0f;
    }

    public boolean isValid() {
        return this.residue.getAtom("O4'") != null && this.residue.getAtom("C1'") != null && this.firstChi != null && this.secondChi != null;
    }

    public void gatherAtomsToRotate(boolean upstreamDirection, boolean rotateTertiaryInteractions) {
        for (Atom a : this.baseAtoms) {
            if (a == null) continue;
            this.atomsToRotate.add(a);
        }
    }

    public Link getAxis(boolean upstreamDirection) {
        return new Link(this.mediator, this.residue.getAtom("C1'"), this.firstChi);
    }
}

