/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.DihedralAngle;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.utils.TBMath;

public class Epsilon53
extends DihedralAngle {
    public Epsilon53(Residue r, String name, Mediator mediator) {
        super(r, name, mediator);
    }

    protected float computeValue(boolean upstreamDirection) {
        if (this.isValid()) {
            Residue nextResidue = this.residue.getNext();
            if (!upstreamDirection) {
                return TBMath.dihedral((float[])this.residue.getAtom("C4'").getFloat(), (float[])this.residue.getAtom("C3'").getFloat(), (float[])this.residue.getAtom("O3'").getFloat(), (float[])nextResidue.getAtom("P").getFloat());
            }
            return TBMath.dihedral((float[])nextResidue.getAtom("P").getFloat(), (float[])this.residue.getAtom("O3'").getFloat(), (float[])this.residue.getAtom("C3'").getFloat(), (float[])this.residue.getAtom("C4'").getFloat());
        }
        return 0.0f;
    }

    public boolean isValid() {
        Residue nextResidue = this.residue.getNext();
        if (nextResidue == null) {
            return false;
        }
        return this.residue.getAtom("C4'") != null && this.residue.getAtom("C3'") != null && this.residue.getAtom("O3'") != null && nextResidue.getAtom("P") != null;
    }

    public Link getAxis(boolean upstreamDirection) {
        if (!upstreamDirection) {
            return new Link(this.mediator, this.residue.getAtom("C3'"), this.residue.getAtom("O3'"));
        }
        return new Link(this.mediator, this.residue.getAtom("O3'"), this.residue.getAtom("C3'"));
    }

    public void gatherAtomsToRotate(boolean upstreamDirection, boolean rotateTertiaryInteractions) {
        super.gatherAtomsToRotate(upstreamDirection, rotateTertiaryInteractions);
        if (upstreamDirection) {
            this.atomsToRotate.add(this.residue);
            for (BaseBaseInteraction2D interaction : this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D((fr.unistra.ibmc.paradise.core.utils.Residue)this.residue.getResidue3D().getResidues().iterator().next()).getInteractions()) {
                if (!interaction.getBaseBaseInteractionFeature().isSecondaryInteraction() && !rotateTertiaryInteractions) continue;
                Residue r = this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getResidue().getResidue2DFeature().getResidues().iterator().next());
                if (r != this.residue) {
                    this.atomsToRotate.add(r);
                    continue;
                }
                this.atomsToRotate.add(this.mediator.getAssemble().getAssembleResidue((fr.unistra.ibmc.paradise.core.utils.Residue)interaction.getPartnerResidue().getResidue2DFeature().getResidues().iterator().next()));
            }
            Atom a = this.residue.getAtom("C3'");
            if (a != null) {
                this.atomsToRotate.removeAtom(a);
            }
            if ((a = this.residue.getAtom("O3'")) != null) {
                this.atomsToRotate.removeAtom(a);
            }
        }
    }
}

