/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.NoLink;
import fr.unistra.ibmc.paradise.core.utils.TBMath;
import javax.media.opengl.GL;

public class Link
extends AbstractDrawable {
    private Atom firstAtom;
    private Atom secondAtom;

    public Atom getFirst() {
        return this.firstAtom;
    }

    public Atom getSecond() {
        return this.secondAtom;
    }

    public Link(Mediator mediator, Atom first, Atom second) {
        super(mediator);
        this.firstAtom = first;
        this.secondAtom = second;
    }

    public static Link createLink(Mediator mediator, Atom first, Atom second) {
        if (first == null || second == null) {
            return new NoLink(mediator, first, second);
        }
        return new Link(mediator, first, second);
    }

    public void draw(GL gl) {
        if (this.firstAtom.isDisplayed() && this.secondAtom.isDisplayed()) {
            if (this.firstAtom.renderingMode == 3 && this.secondAtom.renderingMode == 3) {
                gl.glEnable(2896);
                float[] m = TBMath.middle((float[])this.firstAtom.getFloat(), (float[])this.secondAtom.getFloat());
                gl.glColor3fv(this.firstAtom.getColor().getRGBOpenGl(), 0);
                this.mediator.getRenderer().drawCylinder(this.firstAtom.getFloat(), m, this.mediator.getRenderer().getLINK_RADIUS());
                gl.glColor3fv(this.secondAtom.getColor().getRGBOpenGl(), 0);
                this.mediator.getRenderer().drawCylinder(m, this.secondAtom.getFloat(), this.mediator.getRenderer().getLINK_RADIUS());
                gl.glDisable(2896);
            } else {
                gl.glLineWidth((float)this.mediator.getRenderer().getLINE_LINK_WIDTH());
                gl.glBegin(1);
                gl.glColor3fv(this.firstAtom.getColor().getRGBOpenGl(), 0);
                gl.glVertex3fv(this.firstAtom.getFloat(), 0);
                gl.glColor3fv(this.secondAtom.getColor().getRGBOpenGl(), 0);
                gl.glVertex3fv(this.secondAtom.getFloat(), 0);
                gl.glEnd();
            }
        }
    }

    public float[] getVector() {
        float[] fa = this.firstAtom.getFloat();
        float[] fb = this.secondAtom.getFloat();
        return new float[]{fb[0] - fa[0], fb[1] - fa[1], fb[2] - fa[2]};
    }

    public float[] getNormalizedVector() {
        return TBMath.normalized((float[])this.getVector());
    }
}

