/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsObject;
import jade.content.onto.Introspectable;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.schema.ObjectSchema;

public class MicroIntrospector
implements Introspector {
    public AbsObject externalise(Object obj, ObjectSchema schema, Class javaClass, Ontology referenceOnto) throws OntologyException {
        try {
            AbsObject abs = schema.newInstance();
            Introspectable intro = (Introspectable)obj;
            intro.externalise(abs, referenceOnto);
            return abs;
        }
        catch (OntologyException oe) {
            throw oe;
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Object " + obj + " is not Introspectable");
        }
        catch (Throwable t) {
            throw new OntologyException("Schema and Java class do not match", t);
        }
    }

    public Object internalise(AbsObject abs, ObjectSchema schema, Class javaClass, Ontology referenceOnto) throws UngroundedException, OntologyException {
        try {
            Object obj = javaClass.newInstance();
            Introspectable intro = (Introspectable)obj;
            intro.internalise(abs, referenceOnto);
            return intro;
        }
        catch (OntologyException oe) {
            throw oe;
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Class for type " + abs.getTypeName() + " is not Introspectable");
        }
        catch (Throwable t) {
            throw new OntologyException("Schema and Java class do not match", t);
        }
    }

    public void checkClass(ObjectSchema schema, Class javaClass, Ontology onto) throws OntologyException {
    }
}

