/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsTerm;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.content.schema.TermSchema;
import jade.util.leap.Iterator;

public class AggregateSchema
extends TermSchema {
    public static final String BASE_NAME = "Aggregate";
    private static AggregateSchema baseSchema = new AggregateSchema();

    private AggregateSchema() {
        super(BASE_NAME);
    }

    public AggregateSchema(String typeName) {
        super(typeName);
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    public AbsObject newInstance() throws OntologyException {
        return new AbsAggregate(this.getTypeName());
    }

    public void validate(AbsObject abs, Ontology onto) throws OntologyException {
        if (abs.getAbsType() != 5) {
            throw new OntologyException(abs + " is not an AbsAggregate");
        }
        AbsAggregate agg = (AbsAggregate)abs;
        Iterator it = agg.iterator();
        while (it.hasNext()) {
            AbsTerm el = (AbsTerm)it.next();
            ObjectSchema s = onto.getSchema(el.getTypeName());
            s.validate(el, onto);
        }
    }

    protected boolean descendsFrom(ObjectSchema s) {
        if (s != null) {
            if (s.equals(AggregateSchema.getBaseSchema())) {
                return true;
            }
            return super.descendsFrom(s);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o != null) {
            return o instanceof AggregateSchema;
        }
        return false;
    }
}

