/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Service;
import jade.util.leap.Serializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ServiceDescriptor
implements Serializable {
    private String myName;
    private boolean myIsMandatory;
    private transient Service myService;
    private String serviceClass;

    public ServiceDescriptor(String sn, Service svc) {
        this.myName = sn;
        this.myService = svc;
        this.myIsMandatory = false;
    }

    public ServiceDescriptor() {
        this(null, null);
    }

    public void setName(String sn) {
        this.myName = sn;
    }

    public String getName() {
        return this.myName;
    }

    public void setService(Service svc) {
        this.myService = svc;
    }

    public Service getService() {
        return this.myService;
    }

    public void setMandatory(boolean isMandatory) {
        this.myIsMandatory = isMandatory;
    }

    public boolean isMandatory() {
        return this.myIsMandatory;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.myService != null) {
            this.serviceClass = this.myService.getClass().getName();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.serviceClass != null) {
            try {
                this.myService = (Service)Class.forName(this.serviceClass).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw cnfe;
            }
            catch (Throwable t) {
                throw new IOException("Can't create service " + this.serviceClass + ". " + t.getMessage());
            }
        }
    }
}

