/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SerialBehaviour;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.util.Hashtable;

public class FSMBehaviour
extends SerialBehaviour {
    private Map states = new HashMap();
    private Behaviour current = null;
    protected List lastStates = new ArrayList();
    protected String currentName = null;
    private String previousName = null;
    private String firstName = null;
    private int lastExitValue;
    private boolean transitionForced = false;
    private String forcedTransitionDest = null;
    private TransitionTable theTransitionTable = new TransitionTable();
    private Logger myLogger = Logger.getMyLogger((class$jade$core$behaviours$FSMBehaviour == null ? (class$jade$core$behaviours$FSMBehaviour = FSMBehaviour.class$("jade.core.behaviours.FSMBehaviour")) : class$jade$core$behaviours$FSMBehaviour).getName());
    static /* synthetic */ Class class$jade$core$behaviours$FSMBehaviour;

    public FSMBehaviour() {
    }

    public FSMBehaviour(Agent a) {
        super(a);
    }

    public void registerState(Behaviour state, String name) {
        state.setBehaviourName(name);
        state.setParent(this);
        state.setAgent(this.myAgent);
        this.states.put(name, state);
        if (name.equals(this.currentName)) {
            this.current = state;
        }
    }

    public void registerFirstState(Behaviour state, String name) {
        this.registerState(state, name);
        this.firstName = name;
    }

    public void registerLastState(Behaviour state, String name) {
        this.registerState(state, name);
        if (!this.lastStates.contains(name)) {
            this.lastStates.add(name);
        }
    }

    public Behaviour deregisterState(String name) {
        Behaviour b = (Behaviour)this.states.remove(name);
        if (b != null) {
            b.setParent(null);
        }
        this.theTransitionTable.removeTransitionsFromState(name);
        if (name.equals(this.firstName)) {
            this.firstName = null;
        }
        this.lastStates.remove(name);
        return b;
    }

    public void registerTransition(String s1, String s2, int event) {
        this.registerTransition(s1, s2, event, null);
    }

    public void registerTransition(String s1, String s2, int event, String[] toBeReset) {
        Transition t = new Transition(this, s1, s2, event, toBeReset);
        this.theTransitionTable.addTransition(t);
    }

    public void registerDefaultTransition(String s1, String s2) {
        this.registerDefaultTransition(s1, s2, null);
    }

    public void registerDefaultTransition(String s1, String s2, String[] toBeReset) {
        Transition t = new Transition(this, s1, s2, toBeReset);
        this.theTransitionTable.addTransition(t);
    }

    public void deregisterTransition(String source, int event) {
        this.theTransitionTable.removeTransition(source, event);
    }

    public void deregisterDefaultTransition(String source) {
        this.theTransitionTable.removeTransition(source);
    }

    public boolean hasDefaultTransition(String source) {
        return this.theTransitionTable.getTransition(source) != null;
    }

    public Behaviour getState(String name) {
        Behaviour b = null;
        if (name != null) {
            b = (Behaviour)this.states.get(name);
        }
        return b;
    }

    public String getName(Behaviour state) {
        Iterator it = this.states.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Behaviour s = (Behaviour)this.states.get(name);
            if (state != s) continue;
            return name;
        }
        return null;
    }

    public int getLastExitValue() {
        return this.lastExitValue;
    }

    public int onEnd() {
        return this.getLastExitValue();
    }

    protected void scheduleFirst() {
        if (this.transitionForced) {
            this.currentName = this.forcedTransitionDest;
            this.transitionForced = false;
        } else {
            this.currentName = this.firstName;
        }
        this.current = this.getState(this.currentName);
        this.handleStateEntered(this.current);
    }

    protected void scheduleNext(boolean currentDone, int currentResult) {
        block5: {
            if (!currentDone) break block5;
            try {
                this.previousName = this.currentName;
                if (this.transitionForced) {
                    this.currentName = this.forcedTransitionDest;
                    this.transitionForced = false;
                } else {
                    Transition t = this.theTransitionTable.getTransition(this.currentName, currentResult);
                    this.resetStates(t.toBeReset);
                    this.currentName = t.dest;
                }
                this.current = this.getState(this.currentName);
                if (this.current == null) {
                    throw new NullPointerException();
                }
                this.handleStateEntered(this.current);
            }
            catch (NullPointerException npe) {
                this.current = null;
                this.handleInconsistentFSM(this.previousName, currentResult);
            }
        }
    }

    protected void handleInconsistentFSM(String current, int event) {
        throw new RuntimeException("Inconsistent FSM. State: " + current + " event: " + event);
    }

    protected void handleStateEntered(Behaviour state) {
    }

    protected boolean checkTermination(boolean currentDone, int currentResult) {
        boolean ret = false;
        if (currentDone) {
            this.lastExitValue = currentResult;
            ret = this.lastStates.contains(this.currentName);
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "FSM-Behaviour " + this.getBehaviourName() + ": checkTermination() returning " + ret);
        }
        return ret;
    }

    protected Behaviour getCurrent() {
        return this.current;
    }

    public Collection getChildren() {
        return this.states.values();
    }

    protected void forceTransitionTo(String next) {
        Behaviour b = this.getState(next);
        if (b != null) {
            this.transitionForced = true;
            this.forcedTransitionDest = next;
        }
    }

    protected Behaviour getPrevious() {
        return this.getState(this.previousName);
    }

    public void reset() {
        super.reset();
        this.transitionForced = false;
        this.forcedTransitionDest = null;
    }

    public void resetStates(String[] states) {
        if (states != null) {
            int i = 0;
            while (i < states.length) {
                Behaviour b = this.getState(states[i]);
                b.reset();
                ++i;
            }
        }
    }

    public String stringifyTransitionTable() {
        return this.theTransitionTable.transitions.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TransitionsFromState
    extends Hashtable {
        private Transition defaultTransition = null;
        private static final long serialVersionUID = 3487495895819005L;

        TransitionsFromState() {
        }

        void setDefaultTransition(Transition dt) {
            this.defaultTransition = dt;
        }

        Transition getDefaultTransition() {
            return this.defaultTransition;
        }

        public Object get(Object key) {
            Transition t = (Transition)super.get(key);
            if (t == null) {
                t = this.defaultTransition;
            }
            return t;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Transitions: ");
            sb.append(super.toString());
            if (this.defaultTransition != null) {
                sb.append(" defaultTransition: " + this.defaultTransition);
            }
            return sb.toString();
        }
    }

    static class Transition
    implements Serializable {
        private FSMBehaviour fsm;
        private String src;
        private String dest;
        private int trigger;
        private boolean def;
        private String[] toBeReset;
        private static final long serialVersionUID = 3487495895819004L;

        public Transition() {
        }

        public Transition(FSMBehaviour f, String s, String d, int t, String[] rs) {
            this.fsm = f;
            this.src = s;
            this.dest = d;
            this.trigger = t;
            this.def = false;
            this.toBeReset = rs;
        }

        public Transition(FSMBehaviour f, String s, String d, String[] rs) {
            this.fsm = f;
            this.src = s;
            this.dest = d;
            this.trigger = 0;
            this.def = true;
            this.toBeReset = rs;
        }

        public FSMBehaviour getFSM() {
            return this.fsm;
        }

        public void setFSM(FSMBehaviour f) {
            this.fsm = f;
        }

        public String getFromState() {
            return this.src;
        }

        public void setFromState(String f) {
            this.src = f;
        }

        public String getToState() {
            return this.dest;
        }

        public void setToState(String t) {
            this.dest = t;
        }

        public int getTrigger() {
            return this.trigger;
        }

        public void setTrigger(int t) {
            this.trigger = t;
        }

        public boolean isDefault() {
            return this.def;
        }

        public void setDefault(boolean d) {
            this.def = d;
        }

        public String[] getStatesToReset() {
            return this.toBeReset;
        }

        public void setStatesToReset(String[] ss) {
            this.toBeReset = ss;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("(TRANSITION trigger=").append(this.trigger).append(", source=").append(this.src).append(", dest=").append(this.dest).append(")");
            return sb.toString();
        }
    }

    class TransitionTable
    implements Serializable {
        private Hashtable transitions = new Hashtable();
        private static final long serialVersionUID = 3487495895819003L;

        TransitionTable() {
        }

        void clear() {
            this.transitions.clear();
        }

        void addTransition(Transition t) {
            String key1 = t.getFromState();
            TransitionsFromState tfs = (TransitionsFromState)this.transitions.get(key1);
            if (tfs == null) {
                tfs = new TransitionsFromState();
                this.transitions.put(key1, tfs);
            }
            if (t.isDefault()) {
                tfs.setDefaultTransition(t);
            } else {
                Integer key2 = new Integer(t.getTrigger());
                tfs.put(key2, t);
            }
        }

        void removeTransition(String s1, int event) {
            Transition t;
            TransitionsFromState tfs = (TransitionsFromState)this.transitions.get(s1);
            if (tfs != null && (t = (Transition)tfs.remove(new Integer(event))) != null && tfs.isEmpty() && tfs.getDefaultTransition() == null) {
                this.transitions.remove(s1);
            }
        }

        void removeTransition(String s1) {
            TransitionsFromState tfs = (TransitionsFromState)this.transitions.get(s1);
            if (tfs != null) {
                tfs.setDefaultTransition(null);
                if (tfs.isEmpty()) {
                    this.transitions.remove(s1);
                }
            }
        }

        Transition getTransition(String s, int event) {
            TransitionsFromState tfs = (TransitionsFromState)this.transitions.get(s);
            if (tfs != null) {
                Transition t = (Transition)tfs.get(new Integer(event));
                return t;
            }
            return null;
        }

        Transition getTransition(String s) {
            TransitionsFromState tfs = (TransitionsFromState)this.transitions.get(s);
            if (tfs != null) {
                return tfs.getDefaultTransition();
            }
            return null;
        }

        void removeTransitionsFromState(String stateName) {
            this.transitions.remove(stateName);
        }
    }
}

