/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.NotFoundException;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CompositeBehaviour;
import jade.core.behaviours.DataStore;
import jade.util.leap.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class ThreadedBehaviourFactory {
    private static final String CREATED_STATE = "CREATED";
    private static final String RUNNING_STATE = "RUNNING";
    private static final String CHECKING_STATE = "CHECKING";
    private static final String BLOCKED_STATE = "BLOCKED";
    private static final String SUSPENDED_STATE = "SUSPENDED";
    private static final String TERMINATED_STATE = "TERMINATED";
    private static final String INTERRUPTED_STATE = "INTERRUPTED";
    private static final String ERROR_STATE = "ERROR";
    private Vector threadedBehaviours = new Vector();

    public Behaviour wrap(Behaviour b) {
        return new ThreadedBehaviourWrapper(b);
    }

    public int size() {
        return this.threadedBehaviours.size();
    }

    public void interrupt() {
        ThreadedBehaviourWrapper[] tt = this.getWrappers();
        int i = 0;
        while (i < tt.length) {
            tt[i].interrupt();
            ++i;
        }
    }

    public synchronized boolean waitUntilEmpty(long timeout) {
        long time = System.currentTimeMillis();
        long deadline = time + timeout;
        try {
            while (!this.threadedBehaviours.isEmpty()) {
                if (timeout <= 0L || time < deadline) {
                    this.wait(deadline - time);
                    time = System.currentTimeMillis();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ie) {}
        return this.threadedBehaviours.isEmpty();
    }

    public Thread interrupt(Behaviour b) throws NotFoundException {
        ThreadedBehaviourWrapper wrapper = this.getWrapper(b);
        if (wrapper != null) {
            return wrapper.interrupt();
        }
        throw new NotFoundException(b.getBehaviourName());
    }

    public void suspend(Behaviour b) {
        ThreadedBehaviourWrapper wrapper = this.getWrapper(b);
        if (wrapper != null) {
            wrapper.suspend();
        }
    }

    public void resume(Behaviour b) {
        ThreadedBehaviourWrapper wrapper = this.getWrapper(b);
        if (wrapper != null) {
            wrapper.resume();
        }
    }

    public Thread getThread(Behaviour b) {
        ThreadedBehaviourWrapper tb = this.getWrapper(b);
        if (tb != null) {
            return tb.getThread();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadedBehaviourWrapper[] getWrappers() {
        Vector vector = this.threadedBehaviours;
        synchronized (vector) {
            ThreadedBehaviourWrapper[] wrappers = new ThreadedBehaviourWrapper[this.threadedBehaviours.size()];
            int i = 0;
            while (i < wrappers.length) {
                wrappers[i] = (ThreadedBehaviourWrapper)this.threadedBehaviours.elementAt(i);
                ++i;
            }
            return wrappers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadedBehaviourWrapper getWrapper(Behaviour b) {
        Vector vector = this.threadedBehaviours;
        synchronized (vector) {
            Enumeration e = this.threadedBehaviours.elements();
            while (e.hasMoreElements()) {
                ThreadedBehaviourWrapper tb = (ThreadedBehaviourWrapper)e.nextElement();
                if (!tb.getBehaviour().equals(b)) continue;
                return tb;
            }
            return null;
        }
    }

    private void invokeMethod(Object obj, String methodName) {
    }

    private class DummyParentBehaviour
    extends CompositeBehaviour {
        private ThreadedBehaviourWrapper myChild;

        private DummyParentBehaviour(Agent a, ThreadedBehaviourWrapper b) {
            super(a);
            this.myChild = b;
        }

        public boolean isRunnable() {
            return false;
        }

        protected void handle(Behaviour.RunnableChangedEvent rce) {
            if (rce.isRunnable()) {
                this.myChild.go();
            }
        }

        public Behaviour root() {
            Behaviour r = this.myChild.root();
            if (r == this.myChild) {
                return this.myChild.getBehaviour();
            }
            return r;
        }

        protected void scheduleFirst() {
        }

        protected void scheduleNext(boolean currentDone, int currentResult) {
        }

        protected boolean checkTermination(boolean currentDone, int currentResult) {
            return false;
        }

        protected Behaviour getCurrent() {
            return null;
        }

        public Collection getChildren() {
            return null;
        }
    }

    public class ThreadedBehaviourWrapper
    extends Behaviour
    implements Runnable {
        private Thread myThread;
        private Behaviour myBehaviour;
        private volatile boolean restarted = false;
        private boolean finished = false;
        private volatile boolean suspended = false;
        private int exitValue;
        private volatile String threadState = "CREATED";

        private ThreadedBehaviourWrapper(Behaviour b) {
            super(b.myAgent);
            this.myBehaviour = b;
            this.myBehaviour.setParent(new DummyParentBehaviour(this.myAgent, this));
        }

        public void onStart() {
            this.myBehaviour.setAgent(this.myAgent);
            this.myBehaviour.parent.setAgent(this.myAgent);
            this.start();
        }

        private void start() {
            this.myThread = new Thread(this);
            this.myThread.setName(this.myAgent.getLocalName() + "#" + this.myBehaviour.getBehaviourName());
            this.myThread.start();
        }

        public void action() {
            if (!this.finished) {
                this.block();
            }
        }

        public boolean done() {
            return this.finished;
        }

        public int onEnd() {
            if (!this.myBehaviour.isRunnable()) {
                this.block();
            }
            return this.exitValue;
        }

        protected void setParent(CompositeBehaviour parent) {
            super.setParent(parent);
            this.myBehaviour.setThreadedParent(parent);
        }

        public void setDataStore(DataStore ds) {
            this.myBehaviour.setDataStore(ds);
        }

        public DataStore getDataStore() {
            return this.myBehaviour.getDataStore();
        }

        public void reset() {
            this.restarted = false;
            this.finished = false;
            this.suspended = false;
            this.myBehaviour.reset();
            super.reset();
        }

        public void restart() {
            this.myBehaviour.restart();
        }

        protected void handle(Behaviour.RunnableChangedEvent rce) {
            super.handle(rce);
            if (!rce.isUpwards()) {
                this.myBehaviour.handle(rce);
                if (rce.isRunnable()) {
                    this.go();
                }
            }
        }

        private synchronized void go() {
            this.restarted = true;
            this.notifyAll();
        }

        private synchronized void suspend() {
            if (Thread.currentThread() == this.myThread) {
                this.suspended = true;
            }
        }

        private synchronized void resume() {
            if (this.suspended) {
                this.suspended = false;
                if (this.myThread == null) {
                    this.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.threadState == ThreadedBehaviourFactory.CREATED_STATE) {
                ThreadedBehaviourFactory.this.threadedBehaviours.addElement(this);
            } else if (this.threadState == ThreadedBehaviourFactory.SUSPENDED_STATE) {
                ThreadedBehaviourFactory.this.invokeMethod(this.myBehaviour, "handleResumed");
            }
            this.threadState = ThreadedBehaviourFactory.RUNNING_STATE;
            try {
                while (true) {
                    this.restarted = false;
                    this.myBehaviour.actionWrapper();
                    ThreadedBehaviourWrapper threadedBehaviourWrapper = this;
                    synchronized (threadedBehaviourWrapper) {
                        if (this.restarted && !this.myBehaviour.isRunnable()) {
                            this.myBehaviour.myEvent.init(true, 1);
                            this.myBehaviour.handle(this.myBehaviour.myEvent);
                        }
                        if (this.myBehaviour.done()) {
                            break;
                        }
                        if (Thread.currentThread().isInterrupted() || this.threadState == ThreadedBehaviourFactory.INTERRUPTED_STATE) {
                            throw new InterruptedException();
                        }
                        if (this.suspended) {
                            this.threadState = ThreadedBehaviourFactory.SUSPENDED_STATE;
                            this.myThread = null;
                            ThreadedBehaviourFactory.this.invokeMethod(this.myBehaviour, "handleSuspended");
                            return;
                        }
                        if (!this.myBehaviour.isRunnable()) {
                            this.threadState = ThreadedBehaviourFactory.BLOCKED_STATE;
                            this.wait();
                        }
                    }
                    this.threadState = ThreadedBehaviourFactory.RUNNING_STATE;
                }
                this.exitValue = this.myBehaviour.onEnd();
                this.threadState = ThreadedBehaviourFactory.TERMINATED_STATE;
            }
            catch (InterruptedException ie) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                System.out.println("Threaded behaviour " + this.myBehaviour.getBehaviourName() + " interrupted before termination");
            }
            catch (Agent.Interrupted ae) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                System.out.println("Threaded behaviour " + this.myBehaviour.getBehaviourName() + " interrupted before termination");
            }
            catch (ThreadDeath td) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                System.out.println("Threaded behaviour " + this.myBehaviour.getBehaviourName() + " stopped before termination");
                this.terminate();
                throw td;
            }
            catch (Throwable t) {
                this.threadState = ThreadedBehaviourFactory.ERROR_STATE;
                t.printStackTrace();
            }
            this.terminate();
        }

        private synchronized Thread interrupt() {
            if (this.myThread != null) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                this.myThread.interrupt();
                return this.myThread;
            }
            if (this.threadState == ThreadedBehaviourFactory.SUSPENDED_STATE) {
                this.threadState = ThreadedBehaviourFactory.INTERRUPTED_STATE;
                this.terminate();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate() {
            if (Thread.currentThread() == this.myThread && (this.threadState == ThreadedBehaviourFactory.INTERRUPTED_STATE || this.threadState == ThreadedBehaviourFactory.ERROR_STATE)) {
                ThreadedBehaviourFactory.this.invokeMethod(this.myBehaviour, "handleAborted");
            }
            this.finished = true;
            super.restart();
            ThreadedBehaviourFactory.this.threadedBehaviours.removeElement(this);
            ThreadedBehaviourFactory threadedBehaviourFactory = ThreadedBehaviourFactory.this;
            synchronized (threadedBehaviourFactory) {
                ThreadedBehaviourFactory.this.notifyAll();
            }
        }

        public final Thread getThread() {
            return this.myThread;
        }

        public final Behaviour getBehaviour() {
            return this.myBehaviour;
        }

        public final String getThreadState() {
            return this.threadState;
        }
    }
}

