/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.Predicate;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.domain.DFGUIManagement.DeregisterFrom;
import jade.domain.DFGUIManagement.Federate;
import jade.domain.DFGUIManagement.GetDescription;
import jade.domain.DFGUIManagement.GetDescriptionUsed;
import jade.domain.DFGUIManagement.GetParents;
import jade.domain.DFGUIManagement.ModifyOn;
import jade.domain.DFGUIManagement.RegisterWith;
import jade.domain.DFGUIManagement.SearchOn;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.domain.RequestManagementBehaviour;
import jade.domain.df;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.JADESecurityException;
import jade.util.leap.List;

class DFAppletManagementBehaviour
extends RequestManagementBehaviour {
    private df theDF;

    protected DFAppletManagementBehaviour(df a, MessageTemplate mt) {
        super(a, mt);
        this.theDF = a;
    }

    protected ACLMessage performAction(Action slAction, ACLMessage request) throws JADESecurityException, FIPAException {
        Concept action = slAction.getAction();
        List result = null;
        boolean asynchNotificationRequired = false;
        if (action instanceof GetParents) {
            result = this.theDF.getParentsAction((GetParents)action, request.getSender());
        } else if (action instanceof GetDescription) {
            result = this.theDF.getDescriptionAction((GetDescription)action, request.getSender());
        } else if (action instanceof GetDescriptionUsed) {
            result = this.theDF.getDescriptionUsedAction((GetDescriptionUsed)action, request.getSender());
        } else if (action instanceof Federate) {
            this.theDF.federateAction((Federate)action, request.getSender());
            asynchNotificationRequired = true;
        } else if (action instanceof RegisterWith) {
            this.theDF.registerWithAction((RegisterWith)action, request.getSender());
            asynchNotificationRequired = true;
        } else if (action instanceof DeregisterFrom) {
            this.theDF.deregisterFromAction((DeregisterFrom)action, request.getSender());
            asynchNotificationRequired = true;
        } else if (action instanceof ModifyOn) {
            this.theDF.modifyOnAction((ModifyOn)action, request.getSender());
            asynchNotificationRequired = true;
        } else if (action instanceof SearchOn) {
            this.theDF.searchOnAction((SearchOn)action, request.getSender());
            asynchNotificationRequired = true;
        } else {
            throw new UnsupportedFunction();
        }
        if (!asynchNotificationRequired) {
            ACLMessage notification = request.createReply();
            notification.setPerformative(7);
            Predicate p = null;
            p = result != null ? new Result(slAction, result) : new Done(slAction);
            try {
                this.theDF.getContentManager().fillContent(notification, p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return notification;
        }
        this.theDF.storePendingRequest(action, request);
        return null;
    }
}

