/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.KBManagement;

import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.KBManagement.KBIterator;
import jade.domain.KBManagement.LeaseManager;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.List;
import java.util.Enumeration;

public abstract class KB {
    protected LeaseManager lm;
    protected SubscriptionResponder sr;
    protected Logger logger = Logger.getMyLogger(this.getClass().getName());
    private int maxResultLimit = -1;

    public KB(int maxResultLimit) {
        this.maxResultLimit = maxResultLimit;
    }

    public void setSubscriptionResponder(SubscriptionResponder sResp) {
        this.sr = sResp;
    }

    public void setLeaseManager(LeaseManager leaseMng) {
        this.lm = leaseMng;
    }

    public Object register(Object name, Object fact) {
        if (this.lm.isExpired(this.lm.getLeaseTime(fact))) {
            if (this.logger.isLoggable(Logger.WARNING)) {
                this.logger.log(Logger.WARNING, "Fact with lease time already expired");
            }
            return null;
        }
        this.lm.grantLeaseTime(fact);
        Object previous = this.insert(name, fact);
        if (previous != null && this.lm.isExpired(this.lm.getLeaseTime(previous))) {
            previous = null;
        }
        return previous;
    }

    public Object deregister(Object name) {
        Object obj = this.remove(name);
        if (obj != null && this.lm.isExpired(this.lm.getLeaseTime(obj))) {
            obj = null;
        }
        return obj;
    }

    protected abstract Object insert(Object var1, Object var2);

    protected abstract Object remove(Object var1);

    public List search(Object template) {
        return this.search(template, this.maxResultLimit);
    }

    public abstract List search(Object var1, int var2);

    public abstract KBIterator iterator(Object var1);

    public abstract void subscribe(Object var1, SubscriptionResponder.Subscription var2) throws NotUnderstoodException;

    public abstract Enumeration getSubscriptions();

    public abstract void unsubscribe(SubscriptionResponder.Subscription var1);
}

