/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.proto.Initiator;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Vector;

public class AchieveREInitiator
extends Initiator {
    public final String REQUEST_KEY;
    public final String ALL_REQUESTS_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_RESULT_NOTIFICATIONS_KEY;
    protected static final String HANDLE_AGREE = "Handle-agree";
    protected static final String HANDLE_REFUSE = "Handle-refuse";
    protected static final String HANDLE_INFORM = "Handle-inform";
    protected static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    protected static final String HANDLE_ALL_RESULT_NOTIFICATIONS = "Handle-all-result-notifications";
    protected static final String CHECK_AGAIN = "Check-again";
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private static final int ALL_RESULT_NOTIFICATIONS_RECEIVED = 2;
    private boolean allResponsesReceived;
    private String[] toBeReset;

    public AchieveREInitiator(Agent a, ACLMessage msg) {
        this(a, msg, new DataStore());
    }

    public AchieveREInitiator(Agent a, ACLMessage msg, DataStore store) {
        super(a, msg, store);
        this.REQUEST_KEY = this.INITIATION_K;
        this.ALL_REQUESTS_KEY = this.ALL_INITIATIONS_K;
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_RESULT_NOTIFICATIONS_KEY = "__all-result-notifications" + this.hashCode();
        this.allResponsesReceived = false;
        this.toBeReset = null;
        this.registerTransition("Check-in-seq", HANDLE_AGREE, 1);
        this.registerTransition("Check-in-seq", HANDLE_INFORM, 7);
        this.registerTransition("Check-in-seq", HANDLE_REFUSE, 14);
        this.registerDefaultTransition(HANDLE_AGREE, "Check-sessions");
        this.registerDefaultTransition(HANDLE_INFORM, "Check-sessions");
        this.registerDefaultTransition(HANDLE_REFUSE, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerTransition("Check-sessions", HANDLE_ALL_RESULT_NOTIFICATIONS, 2);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, CHECK_AGAIN);
        this.registerTransition(CHECK_AGAIN, HANDLE_ALL_RESULT_NOTIFICATIONS, 0);
        this.registerDefaultTransition(CHECK_AGAIN, "Receive-reply", this.toBeReset);
        OneShotBehaviour b = null;
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818003L;

            public void action() {
                AchieveREInitiator.this.handleAgree((ACLMessage)this.getDataStore().get(AchieveREInitiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_AGREE);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818004L;

            public void action() {
                AchieveREInitiator.this.handleRefuse((ACLMessage)this.getDataStore().get(AchieveREInitiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_REFUSE);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818006L;

            public void action() {
                AchieveREInitiator.this.handleInform((ACLMessage)this.getDataStore().get(AchieveREInitiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_INFORM);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                AchieveREInitiator.this.handleAllResponses((Vector)this.getDataStore().get(AchieveREInitiator.this.ALL_RESPONSES_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                AchieveREInitiator.this.handleAllResultNotifications((Vector)this.getDataStore().get(AchieveREInitiator.this.ALL_RESULT_NOTIFICATIONS_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerLastState(b, HANDLE_ALL_RESULT_NOTIFICATIONS);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
            }

            public int onEnd() {
                return AchieveREInitiator.this.sessions.size();
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, CHECK_AGAIN);
    }

    protected Vector prepareInitiations(ACLMessage initiation) {
        return this.prepareRequests(initiation);
    }

    protected boolean checkInSequence(ACLMessage reply) {
        int perf;
        String inReplyTo = reply.getInReplyTo();
        Session s = (Session)this.sessions.get(inReplyTo);
        if (s != null && s.update(perf = reply.getPerformative())) {
            switch (s.getState()) {
                case 1: 
                case 2: {
                    Vector allRsp = (Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY);
                    allRsp.addElement(reply);
                    break;
                }
                case 3: {
                    Vector allNotif = (Vector)this.getDataStore().get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                    allNotif.addElement(reply);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (s.isCompleted()) {
                this.sessions.remove(inReplyTo);
            }
            return true;
        }
        return false;
    }

    protected int checkSessions(ACLMessage reply) {
        int ret = -1;
        if (this.getLastExitValue() == -1001 && !this.allResponsesReceived) {
            ArrayList sessionsToRemove = new ArrayList(this.sessions.size());
            Iterator i = this.sessions.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Session s = (Session)this.sessions.get(key);
                if (s.getState() != 0) continue;
                sessionsToRemove.add(key);
            }
            Iterator i2 = sessionsToRemove.iterator();
            while (i2.hasNext()) {
                this.sessions.remove(i2.next());
            }
            sessionsToRemove = null;
        } else if (reply == null) {
            this.sessions.clear();
        }
        if (!this.allResponsesReceived) {
            this.allResponsesReceived = true;
            Iterator it = this.sessions.values().iterator();
            while (it.hasNext()) {
                Session s = (Session)it.next();
                if (s.getState() != 0) continue;
                this.allResponsesReceived = false;
                break;
            }
            if (this.allResponsesReceived) {
                this.replyReceiver.setDeadline(-1L);
                ret = 1;
            }
        } else if (this.sessions.size() == 0) {
            ret = 2;
        }
        return ret;
    }

    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_AGREE, HANDLE_REFUSE, "Handle-not-understood", HANDLE_INFORM, "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    protected Vector prepareRequests(ACLMessage request) {
        Vector<ACLMessage> l = new Vector<ACLMessage>(1);
        l.addElement(request);
        return l;
    }

    protected void handleAgree(ACLMessage agree) {
    }

    protected void handleRefuse(ACLMessage refuse) {
    }

    protected void handleInform(ACLMessage inform) {
    }

    protected void handleAllResponses(Vector responses) {
    }

    protected void handleAllResultNotifications(Vector resultNotifications) {
    }

    public void registerPrepareRequests(Behaviour b) {
        this.registerPrepareInitiations(b);
    }

    public void registerHandleAgree(Behaviour b) {
        this.registerState(b, HANDLE_AGREE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleInform(Behaviour b) {
        this.registerState(b, HANDLE_INFORM);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleRefuse(Behaviour b) {
        this.registerState(b, HANDLE_REFUSE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour b) {
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResultNotifications(Behaviour b) {
        this.registerLastState(b, HANDLE_ALL_RESULT_NOTIFICATIONS);
        b.setDataStore(this.getDataStore());
    }

    protected void reinit() {
        this.allResponsesReceived = false;
        super.reinit();
    }

    protected void initializeDataStore(ACLMessage msg) {
        super.initializeDataStore(msg);
        Vector l = new Vector();
        this.getDataStore().put(this.ALL_RESPONSES_KEY, l);
        l = new Vector();
        this.getDataStore().put(this.ALL_RESULT_NOTIFICATIONS_KEY, l);
    }

    protected Initiator.ProtocolSession getSession(ACLMessage msg, int sessionIndex) {
        return new Session();
    }

    private static class Session
    implements Initiator.ProtocolSession,
    Serializable {
        static final int INIT = 0;
        static final int POSITIVE_RESPONSE_RECEIVED = 1;
        static final int NEGATIVE_RESPONSE_RECEIVED = 2;
        static final int RESULT_NOTIFICATION_RECEIVED = 3;
        private int state = 0;

        private Session() {
        }

        public String getId() {
            return null;
        }

        public boolean update(int perf) {
            switch (this.state) {
                case 0: {
                    switch (perf) {
                        case 1: {
                            this.state = 1;
                            return true;
                        }
                        case 10: 
                        case 14: {
                            this.state = 2;
                            return true;
                        }
                        case 6: 
                        case 7: {
                            this.state = 3;
                            return true;
                        }
                    }
                    return false;
                }
                case 1: {
                    switch (perf) {
                        case 6: 
                        case 7: {
                            this.state = 3;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        public int getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return this.state == 2 || this.state == 3;
        }
    }
}

