#!/usr/bin/env groovy
//this script reads all the PDB files in this directory and translates their coordinates to have [0,0,0] as their new center

new File(".").eachFile { sourceFile ->

  if (sourceFile.name.endsWith(".pdb")) {

    def totalX = 0, totalY = 0, totalZ = 0
    List lines = sourceFile.readLines()

    lines.each { line ->
      if (line.startsWith("ATOM")) {
        tokens = line.tokenize()
        totalX += tokens[6].toFloat()
        totalY += tokens[7].toFloat()
        totalZ += tokens[8].toFloat()
      }
    }

    def center = [totalX/(float)lines.size(), totalY/(float)lines.size(), totalZ/(float)lines.size()]

    print center[0]

    sourceFile.delete()

    lines.each { line ->
      if (line.startsWith("ATOM")) {
        tokens = line.tokenize()
        line = line.replace(tokens[6], String.format("%.3f",(tokens[6].toFloat()-center[0])))
        line = line.replace(tokens[7], String.format("%.3f",(tokens[7].toFloat()-center[1])))
        line = line.replace(tokens[8], String.format("%.3f",(tokens[8].toFloat()-center[2])))
      }
      sourceFile << line
      sourceFile << "\n"
    }
  }

}