/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.core.AID;
import jade.domain.introspection.AddedBehaviour;
import jade.domain.introspection.ChangedAgentState;
import jade.domain.introspection.ChangedBehaviourState;
import jade.domain.introspection.PostedMessage;
import jade.domain.introspection.ReceivedMessage;
import jade.domain.introspection.RemovedBehaviour;
import jade.domain.introspection.SentMessage;
import jade.gui.AboutJadeAction;
import jade.gui.AgentTreeModel;
import jade.tools.introspector.Introspector;
import jade.tools.introspector.gui.AboutBoxAction;
import jade.tools.introspector.gui.BehaviourPanel;
import jade.tools.introspector.gui.IntrospectorGUI;
import jade.tools.introspector.gui.MainWindow;
import jade.tools.introspector.gui.MessagePanel;
import jade.tools.introspector.gui.StatePanel;
import jade.tools.introspector.gui.StateUpdater;
import jade.tools.introspector.gui.TableUpdater;
import jade.tools.introspector.gui.TreeAgentPopupMenu;
import jade.tools.introspector.gui.TreePanel;
import jade.tools.introspector.gui.TreeUpdater;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class IntrospectorGUI
extends JFrame
implements WindowListener {
    private Introspector debugger;
    private TreePanel panel;
    private JDesktopPane desk;
    private JSplitPane split;
    private JScrollPane scroll;
    private JMenuBar bar;
    private JMenu menuFile;
    private JMenu menuAbout;
    private JMenuItem item;
    private String logoIntrospector = "images/bug.gif";

    public IntrospectorGUI(Introspector i) {
        this.debugger = i;
        this.panel = new TreePanel(this);
        this.panel.treeAgent.setNewPopupMenu("FIPAAGENT", new TreeAgentPopupMenu(this.debugger, this.panel.treeAgent));
        this.scroll = new JScrollPane();
        this.desk = new JDesktopPane();
        this.split = new JSplitPane();
        this.bar = new JMenuBar();
        this.menuFile = new JMenu();
        this.item = new JMenuItem();
        this.menuAbout = new JMenu();
        this.build();
    }

    public void build() {
        String title = this.debugger.getAID().getName();
        this.setTitle(title);
        Image image = this.getToolkit().getImage(this.getClass().getResource(this.logoIntrospector));
        this.setIconImage(image);
        Font f = new Font("Monospaced", 0, 10);
        this.split.setOrientation(1);
        this.split.setContinuousLayout(true);
        this.getContentPane().add(this.split);
        this.menuFile.setText("File");
        this.item.setText("Exit");
        this.menuFile.add(this.item);
        this.bar.add(this.menuFile);
        this.setJMenuBar(this.bar);
        this.menuAbout.setText("About");
        this.menuAbout.add(new AboutBoxAction(this));
        this.menuAbout.add(new AboutJadeAction(this));
        this.bar.add(this.menuAbout);
        this.item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IntrospectorGUI.this.exit_actionPerformed(e);
            }
        });
        this.scroll.getViewport().add(this.desk);
        this.split.add((Component)this.panel, "left");
        this.split.add((Component)this.scroll, "right");
        this.split.setDividerLocation(180);
        this.addWindowListener(this);
        this.pack();
        this.setSize(new Dimension(680, 435));
        this.panel.adjustDividerLocation();
        this.setVisible(true);
    }

    void exit_actionPerformed(ActionEvent e) {
        this.debugger.doDelete();
    }

    public JDesktopPane getDesktop() {
        return this.desk;
    }

    public void windowClosing(WindowEvent e) {
        this.exit_actionPerformed(null);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void showError(String errMsg) {
        JOptionPane.showMessageDialog(null, errMsg, "Error in " + this.debugger.getName(), 0);
    }

    public void messageSent(MainWindow f, SentMessage sm) {
        MessagePanel mp = f.getMessagePanel();
        SwingUtilities.invokeLater(new TableUpdater(mp, sm));
    }

    public void messagePosted(MainWindow f, PostedMessage pm) {
        MessagePanel mp = f.getMessagePanel();
        SwingUtilities.invokeLater(new TableUpdater(mp, pm));
    }

    public void messageReceived(MainWindow f, ReceivedMessage rm) {
        MessagePanel mp = f.getMessagePanel();
        SwingUtilities.invokeLater(new TableUpdater(mp, rm));
    }

    public void changedAgentState(MainWindow f, ChangedAgentState cas) {
        StatePanel sp = f.getStatePanel();
        SwingUtilities.invokeLater(new StateUpdater(sp, cas));
    }

    public void behaviourAdded(MainWindow f, AddedBehaviour e) {
        BehaviourPanel bp = f.getBehaviourPanel();
        SwingUtilities.invokeLater(new TreeUpdater(e, bp));
    }

    public void behaviourRemoved(MainWindow f, RemovedBehaviour e) {
        BehaviourPanel bp = f.getBehaviourPanel();
        SwingUtilities.invokeLater(new TreeUpdater(e, bp));
    }

    public void behaviourChangeState(MainWindow f, ChangedBehaviourState e) {
        BehaviourPanel bp = f.getBehaviourPanel();
        SwingUtilities.invokeLater(new TreeUpdater(e, bp));
    }

    public void addWindow(MainWindow m) {
        this.desk.add(m);
        m.pack();
        m.setSize(600, 400);
        m.setVisible(true);
        m.adjustDividerLocation();
    }

    public void disposeAsync() {
        class DisposeIt
        implements Runnable {
            private Window toDispose;
            private final /* synthetic */ IntrospectorGUI this$0;

            public DisposeIt(IntrospectorGUI this$0, Window w) {
                this.this$0 = this$0;
                this.toDispose = w;
            }

            public void run() {
                this.toDispose.dispose();
            }
        }
        SwingUtilities.invokeLater(new DisposeIt(this, this));
    }

    public void closeInternal(MainWindow m) {
        class DisposeItMain
        implements Runnable {
            MainWindow wnd;
            private final /* synthetic */ IntrospectorGUI this$0;

            DisposeItMain(IntrospectorGUI this$0, MainWindow l) {
                this.this$0 = this$0;
                this.wnd = l;
            }

            public void run() {
                this.wnd.dispose();
            }
        }
        EventQueue.invokeLater(new DisposeItMain(this, m));
    }

    public void addAgent(final String containerName, final AID agentID) {
        Runnable addIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.addAgentNode(agentName, "agentAddress", containerName);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void removeAgent(final String containerName, final AID agentID) {
        Runnable removeIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.removeAgentNode(containerName, agentName);
            }
        };
        SwingUtilities.invokeLater(removeIt);
    }

    public AgentTreeModel getModel() {
        return this.panel.treeAgent.getModel();
    }

    public void resetTree() {
        Runnable resetIt = new Runnable(){

            public void run() {
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.clearLocalPlatform();
            }
        };
        SwingUtilities.invokeLater(resetIt);
    }

    public void addContainer(final String name, final InetAddress addr) {
        Runnable addIt = new Runnable(){

            public void run() {
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.addContainerNode(name, addr);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void removeContainer(final String name) {
        Runnable removeIt = new Runnable(){

            public void run() {
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.removeContainerNode(name);
            }
        };
        SwingUtilities.invokeLater(removeIt);
    }

    public Introspector getAgent() {
        return this.debugger;
    }
}

