/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.behaviours;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.structures.Model;
import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.Source;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.goloka.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.goloka.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseToolAgent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TertiaryStructurePredictionRequestAnswerBehaviour
extends AnswerBehaviour {
    public TertiaryStructurePredictionRequestAnswerBehaviour(ArrayList<Molecule> selectedMolecules, ArrayList<Parameter> selectedParameters) {
        super(selectedMolecules, selectedParameters);
    }

    public void action() {
        ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
        StructuralFeatureFactory factory = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getStructuralFeatureFactory();
        if (message != null && message.getPerformative() == 11) {
            try {
                Model m = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel();
                if (m != null) {
                    List tss;
                    ArrayList serverMolecules = (ArrayList)message.getContentObject();
                    if (serverMolecules.size() > 0 && (tss = ((Molecule)serverMolecules.get(0)).getSelectedFeatures(TertiaryStructure.class)).size() > 0) {
                        TertiaryStructure remote3D = (TertiaryStructure)tss.get(0);
                        ArrayList<Residue3D> residues3D = new ArrayList<Residue3D>();
                        float[] p = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRenderer().getPivot();
                        for (Residue3D r : remote3D.getAllResidues3D()) {
                            Molecule localMolecule = null;
                            Molecule remoteMolecule = (Molecule)r.getMolecules().iterator().next();
                            for (Molecule _m : this.selectedMolecules) {
                                if (!remoteMolecule.equals(_m)) continue;
                                localMolecule = _m;
                                break;
                            }
                            try {
                                Residue3D r3d = factory.createResidue3D(m.getTertiaryStructure(), localMolecule, r.getFullLocation(remoteMolecule).getStart());
                                for (Residue3D.Atom ra : r.getAtoms()) {
                                    if (!ra.hasCoordinatesFilled()) continue;
                                    Residue3D.Atom la = r3d.getAtom(ra.getName());
                                    la.setCoordinates(ra.getX() + p[0], ra.getY() + p[1], ra.getZ() + p[2]);
                                }
                                residues3D.add(r3d);
                            }
                            catch (BiologicalSymbolException e) {
                                this.monitor.printMessage("The Nahelix service is not able to process your request efficiently", (Exception)((Object)e));
                                return;
                            }
                        }
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().extendModel(residues3D);
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().saveCoord();
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
                    }
                } else {
                    List tss;
                    ArrayList serverMolecules = (ArrayList)message.getContentObject();
                    if (serverMolecules.size() > 0 && (tss = ((Molecule)serverMolecules.get(0)).getSelectedFeatures(TertiaryStructure.class)).size() > 0) {
                        TertiaryStructure remote3D = (TertiaryStructure)tss.get(0);
                        TertiaryStructure local3D = null;
                        for (Residue3D r : remote3D.getAllResidues3D()) {
                            Molecule localMolecule = null;
                            Molecule remoteMolecule = (Molecule)r.getMolecules().iterator().next();
                            for (Molecule _m : this.selectedMolecules) {
                                if (!remoteMolecule.equals(_m)) continue;
                                localMolecule = _m;
                                break;
                            }
                            try {
                                if (local3D == null) {
                                    local3D = remote3D.getFactory().createTertiaryStructure(remote3D.getParadiseID(), "Tertiary Structure", Source.getGraphicalToolAsSource((String)((ParadiseToolAgent)this.myAgent).getParadiseTool().getDescription()), localMolecule, remote3D.getFullLocation(remoteMolecule));
                                }
                                factory.createResidue3D(local3D, r, localMolecule, r.getFullLocation(remoteMolecule).getStart());
                            }
                            catch (BiologicalSymbolException e) {
                                this.monitor.printMessage("The Nahelix service is not able to process your request efficiently", (Exception)((Object)e));
                                return;
                            }
                        }
                        SecondaryStructure ss = ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().getRna2DViewer().getRna2DViewerMediator().getSecondaryCanvas().getModel2D().getSecondaryStructure();
                        local3D.linkSecondaryStructure(ss);
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().createModel(ss, local3D);
                        ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
                    }
                }
                this.monitor.printMessage("End of Analysis");
            }
            catch (Exception e) {
                this.monitor.printMessage("The Nahelix service is not able to process your request efficiently", e);
            }
            this.monitor.stopAnimation();
            this.done = true;
            this.selectedMolecules.clear();
            this.selectedParameters.clear();
        } else if (message != null && message.getPerformative() == 7) {
            this.monitor.printMessage(message.getContent());
        } else if (message != null && message.getPerformative() == 6) {
            try {
                this.monitor.printMessage("The " + this.serviceName + " service is not able to process your request efficiently", (Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
        }
    }
}

