/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.behaviours;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.paradise.goloka.core.Location;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.goloka.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.goloka.tools.ParadiseToolAgent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TertiaryStructureRefinementAnswerBehaviour
extends AnswerBehaviour {
    public TertiaryStructureRefinementAnswerBehaviour(ArrayList<Molecule> selectedMolecules, ArrayList<Parameter> selectedParameters) {
        super(selectedMolecules, selectedParameters);
    }

    public void action() {
        ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
        if (message != null && message.getPerformative() == 11) {
            try {
                ArrayList serverMolecules = (ArrayList)message.getContentObject();
                for (Molecule remoteMolecule : serverMolecules) {
                    Molecule localMolecule = null;
                    for (Molecule m : this.selectedMolecules) {
                        if (!m.getParadiseID().equals((Object)remoteMolecule.getParadiseID())) continue;
                        localMolecule = m;
                        break;
                    }
                    if (localMolecule == null) {
                        this.monitor.printMessage("Could not find a correspondance between remote molecules and local ones");
                        this.monitor.stopAnimation();
                        this.done = true;
                        return;
                    }
                    for (ParadiseFeature feature : remoteMolecule.getSelectedFeatures()) {
                        Residue3D remoteResidue = (Residue3D)feature;
                        Residue3D localResidue = (Residue3D)((Molecule.Annotation)localMolecule.getAnnotations(Residue3D.class, new Location(remoteResidue.getFullLocation(remoteMolecule))).get(0)).getFeature();
                        for (Residue3D.Atom remoteAtom : remoteResidue.getAtoms()) {
                            if (!remoteAtom.hasCoordinatesFilled()) continue;
                            localResidue.getAtom(remoteAtom.getName()).setCoordinates(remoteAtom.getX(), remoteAtom.getY(), remoteAtom.getZ());
                            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).processRnart(localResidue);
                        }
                    }
                    ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().get3DModel().fireModelModified();
                    ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
                }
                this.monitor.printMessage("End of Analysis");
            }
            catch (Exception e) {
                this.monitor.printMessage("The Motif Repository service is not able to process your request efficiently", e);
            }
            this.monitor.stopAnimation();
            this.done = true;
        } else if (message != null && message.getPerformative() == 7) {
            this.monitor.printMessage(message.getContent());
        } else if (message != null && message.getPerformative() == 6) {
            try {
                this.monitor.printMessage("The " + this.serviceName + " service is not able to process your request efficiently", (Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
            ((Assemble)((ParadiseToolAgent)this.myAgent).getParadiseTool()).getMediator().startAnimator();
        }
    }
}

