/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.structures.nucleicAcids.ResidueNA;
import fr.unistra.ibmc.assemble.utils.RessourcesUtils;
import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.Molecule;
import fr.unistra.ibmc.paradise.goloka.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Uridine3D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ChooseDominant
extends JDialog
implements ActionListener {
    private ResidueNA localResidue;
    private ResidueNA remoteResidue;
    private JButton localButton;
    private JButton remoteButton;
    private char localEdge;
    private char remoteEdge;
    private char orientation;

    public ChooseDominant(ResidueNA localResidue, ResidueNA remoteResidue, char localEdge, char remoteEdge, char orientation) {
        this.localEdge = localEdge;
        this.remoteEdge = remoteEdge;
        this.orientation = orientation;
        if (localEdge != remoteEdge) {
            JOptionPane.showMessageDialog(null, "No need for this widget, this interaction is not ambiguous", "Information", 1);
        }
        Residue3D lr = localResidue.getResidue3D();
        Residue3D rr = remoteResidue.getResidue3D();
        Molecule localMol = (Molecule)lr.getMolecules().iterator().next();
        Molecule remoteMol = (Molecule)rr.getMolecules().iterator().next();
        int lp = lr.getFullLocation(localMol).getStart();
        int rp = rr.getFullLocation(remoteMol).getStart();
        this.localResidue = localResidue;
        this.remoteResidue = remoteResidue;
        this.localButton = new JButton(lr.getName() + " " + lp + " (" + localMol.getName() + ")");
        this.remoteButton = new JButton(rr.getName() + " " + rp + " (" + remoteMol.getName() + ")");
        this.localButton.addActionListener(this);
        this.remoteButton.addActionListener(this);
        int l = 0;
        int r = 0;
        if (lr instanceof Adenine3D) {
            l = 65;
        }
        if (lr instanceof Cytosine3D) {
            l = 67;
        }
        if (lr instanceof Guanine3D) {
            l = 71;
        }
        if (lr instanceof Uridine3D) {
            l = 85;
        }
        if (rr instanceof Adenine3D) {
            r = 65;
        }
        if (rr instanceof Cytosine3D) {
            r = 67;
        }
        if (rr instanceof Guanine3D) {
            r = 71;
        }
        if (rr instanceof Uridine3D) {
            r = 85;
        }
        this.setTitle("Choose the dominant residue");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 2));
        buttons.add(this.localButton);
        buttons.add(this.remoteButton);
        JPanel image = new JPanel();
        image.setLayout(new BorderLayout());
        if (l == r) {
            Icon image1 = null;
            if (orientation == 'C') {
                block0 : switch (localEdge) {
                    case 'H': {
                        image1 = RessourcesUtils.getIcon("320x300/chhg.png");
                        break;
                    }
                    case 'S': {
                        switch (l) {
                            case 65: {
                                image1 = RessourcesUtils.getIcon("320x300/cssa.png");
                                break block0;
                            }
                            case 67: {
                                image1 = RessourcesUtils.getIcon("320x300/cssc.png");
                                break block0;
                            }
                            case 71: {
                                image1 = RessourcesUtils.getIcon("320x300/cssg.png");
                                break block0;
                            }
                            case 85: {
                                image1 = RessourcesUtils.getIcon("320x300/cssu.png");
                            }
                        }
                        break;
                    }
                    case 'W': {
                        switch (l) {
                            case 65: {
                                image1 = RessourcesUtils.getIcon("320x300/cwwa.png");
                                break block0;
                            }
                            case 67: {
                                image1 = RessourcesUtils.getIcon("320x300/cwwc.png");
                                break block0;
                            }
                            case 85: {
                                image1 = RessourcesUtils.getIcon("320x300/cwwu.png");
                            }
                        }
                    }
                }
            } else {
                switch (localEdge) {
                    case 'H': {
                        switch (l) {
                            case 65: {
                                image1 = RessourcesUtils.getIcon("320x300/thha.png");
                                break;
                            }
                            case 71: {
                                image1 = RessourcesUtils.getIcon("320x300/thhg.png");
                            }
                        }
                        break;
                    }
                    case 'S': {
                        image1 = RessourcesUtils.getIcon("320x300/tssa.png");
                    }
                }
            }
            image.add((Component)new JLabel(image1), "Center");
        } else {
            Icon image1 = null;
            Icon image2 = null;
            if (orientation == 'C') {
                if (l == 65 && r == 67 || l == 67 && r == 65) {
                    image1 = RessourcesUtils.getIcon("320x300/cssac.png");
                    image2 = RessourcesUtils.getIcon("320x300/cssca.png");
                }
                if (l == 65 && r == 71 || l == 71 && r == 65) {
                    image1 = RessourcesUtils.getIcon("320x300/cssag.png");
                    image2 = RessourcesUtils.getIcon("320x300/cssga.png");
                }
                if (l == 65 && r == 85 || l == 85 && r == 65) {
                    image1 = RessourcesUtils.getIcon("320x300/cssau.png");
                    image2 = RessourcesUtils.getIcon("320x300/cssua.png");
                }
                if (l == 67 && r == 71 || l == 71 && r == 67) {
                    image1 = RessourcesUtils.getIcon("320x300/csscg.png");
                    image2 = RessourcesUtils.getIcon("320x300/cssgc.png");
                }
                if (l == 67 && r == 85 || l == 85 && r == 67) {
                    image1 = RessourcesUtils.getIcon("320x300/csscu.png");
                    image2 = RessourcesUtils.getIcon("320x300/cssuc.png");
                }
                if (l == 71 && r == 85 || l == 85 && r == 71) {
                    image1 = RessourcesUtils.getIcon("320x300/cssgu.png");
                    image2 = RessourcesUtils.getIcon("320x300/cssug.png");
                }
            } else {
                image1 = RessourcesUtils.getIcon("320x300/tssag.png");
                image2 = RessourcesUtils.getIcon("320x300/tssga.png");
            }
            image.add((Component)new JLabel(image1), "West");
            image.add((Component)new JLabel(image2), "East");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Choose which residue is dominant (Blue)"), "North");
        this.add((Component)image, "Center");
        this.add((Component)buttons, "South");
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        try {
            if (source == this.localButton) {
                this.localResidue.setBaseBaseInteraction(this.remoteResidue, this.localEdge, this.remoteEdge, this.orientation, 1);
            } else if (source == this.remoteButton) {
                this.localResidue.setBaseBaseInteraction(this.remoteResidue, this.localEdge, this.remoteEdge, this.orientation, 2);
            }
        }
        catch (BiologicalSymbolException ex) {
            JOptionPane.showMessageDialog(null, "Biological SymbolException !!!");
        }
        this.dispose();
    }
}

