/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.gui.event.SelectionListener;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomSet;
import fr.unistra.ibmc.assemble.structures.AtomsSelection;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Model;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.goloka.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.goloka.utils.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSelection
extends AtomsSelection
implements SelectionListener {
    private List<Chain> selectedChains = new ArrayList<Chain>();
    private List<Residue> selectedResidues = new ArrayList<Residue>();
    private List<SelectionListener> selectionListeners;

    public GlobalSelection(Mediator mediator) {
        super(mediator);
    }

    @Override
    public void clear() {
        super.clear();
        this.selectedResidues.clear();
        this.selectedChains.clear();
        this.fireRenderingModified();
    }

    public void setPlaneDisplayed(boolean displayed) {
        for (Residue r : this.selectedResidues) {
            r.setPlaneDisplayed(displayed);
        }
        this.fireRenderingModified();
    }

    public void setBackBoneDisplayed(boolean displayed) {
        for (Residue r : this.selectedResidues) {
            r.setBackBoneDisplayed(displayed);
        }
        this.fireRenderingModified();
    }

    public List<Chain> getSelectedChains() {
        return this.selectedChains;
    }

    public void setAtomsDefaultColor() {
        for (Atom a : this.selectedAtoms) {
            a.setColor(a.getDefaultColor());
        }
        this.fireRenderingModified();
    }

    public void setResiduesDefaultColor() {
        for (Residue r : this.selectedResidues) {
            r.setResidueDefaultColor();
        }
    }

    @Override
    public void setRenderingMode(int mode) {
        for (Residue r : this.selectedResidues) {
            r.setRenderingMode(mode);
        }
        for (Atom atom : this.selectedAtoms) {
            atom.setRenderingMode(mode);
        }
        this.fireRenderingModified();
    }

    public List<Residue> getSelectedResidues() {
        return this.selectedResidues;
    }

    public void add(UserSelection us) {
        for (Residue r : us.getSelectedResidues()) {
            if (this.selectedResidues.contains(r)) continue;
            this.add(r);
        }
        for (Atom a : us.getSelectedAtoms()) {
            this.add(a);
        }
    }

    @Override
    public void add(Residue r) {
        if (!this.selectedResidues.contains(r)) {
            for (Atom atom : r.getAtoms()) {
                this.add(atom);
            }
            this.selectedResidues.add(r);
        }
    }

    @Override
    public void add(Chain c) {
        if (!this.selectedChains.contains(c)) {
            for (Residue r : c.getResidues()) {
                this.add(r);
            }
            this.selectedChains.add(c);
        }
    }

    public void remove(Residue r) {
        for (Atom atom : r.getAtoms()) {
            this.removeAtom(atom);
        }
        this.selectedResidues.remove(r);
        this.fireRenderingModified();
    }

    public void remove(Chain chain) {
        for (Residue residue : chain.getResidues()) {
            this.remove(residue);
            for (Atom atom : residue.getAtoms()) {
                this.removeAtom(atom);
            }
        }
        this.selectedChains.remove(chain);
        this.fireRenderingModified();
    }

    public void remove(Model model) {
        for (Chain chain : model.getChains()) {
            for (Residue residue : chain.getResidues()) {
                this.remove(residue);
                for (Atom atom : residue.getAtoms()) {
                    this.removeAtom(atom);
                }
            }
        }
        this.fireRenderingModified();
    }

    public void fireSelectResidues(List<Residue> residues, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.residuesSelected(residues, isShiftDown);
        }
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        if (this.mediator.get3DModel() != null) {
            if (!isShiftDown) {
                this.clear();
            }
            for (Residue r : residues) {
                this.add(r);
            }
            this.mediator.getRenderer().setPivot(this.getSelectionCenter());
        }
    }

    public void fireSelectStructuralDomain(StructuralDomain domain, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.structuralDomainSelected(domain, isShiftDown);
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
        if (this.mediator.get3DModel() != null) {
            AtomSet atoms;
            if (!isShiftDown) {
                this.clear();
            }
            if (!(atoms = this.mediator.getAssemble().getAtomsForStructuralDomain(structuralDomain)).getAtoms().isEmpty()) {
                HashSet<Chain> chains = new HashSet<Chain>();
                for (Atom a : atoms.getAtoms()) {
                    chains.add(a.getResidue().getChain());
                }
                for (Chain c : chains) {
                    this.mediator.getGlobalSelection().add(c);
                }
                this.mediator.getRenderer().setPivot(this.getSelectionCenter());
            }
        }
    }

    public void fireSelectAtoms(Collection<Atom> atoms, boolean isShiftDown) {
        for (SelectionListener l : this.selectionListeners) {
            l.atomsSelected(atoms, isShiftDown);
        }
    }

    @Override
    public void atomsSelected(Collection<Atom> atoms, boolean isShiftDown) {
        if (this.mediator.get3DModel() != null) {
            if (!isShiftDown) {
                this.clear();
            }
            for (Atom a : atoms) {
                this.add(a);
            }
            this.mediator.getRenderer().setPivot(this.getSelectionCenter());
        }
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
        if (this.mediator.get3DModel() != null) {
            if (!isShiftDown) {
                this.clear();
            }
            Residue r = this.mediator.getAssemble().getAssembleResidue(interaction.getResidue());
            Residue partnerR = this.mediator.getAssemble().getAssembleResidue(interaction.getPartnerResidue());
            if (r != null || partnerR != null) {
                this.add(r);
                this.add(partnerR);
                this.mediator.getRenderer().setPivot(this.getSelectionCenter());
            }
        }
    }

    public void addSelectionListener(SelectionListener l) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<SelectionListener>();
        }
        this.selectionListeners.add(l);
    }

    public void exportAsPDB(String fileName) throws IOException, ParsingException, InterruptedException {
        this.mediator.get3DModel().saveCoordinatesToParadise();
        ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
        for (Residue residue : this.selectedResidues) {
            residues.add(residue.getResidue3D());
        }
        PDBFileIO.writePDBFile(residues, (boolean)true, (File)new File(fileName));
    }
}

