/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.goloka.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.goloka.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Residue3D;
import fr.unistra.ibmc.paradise.goloka.core.features.Uridine3D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;

public class RNAMotifsBrowser
extends JXTable {
    private JPopupMenu popupMenu;
    private MyTableModel model;
    private Mediator mediator;

    public RNAMotifsBrowser(final Mediator mediator) {
        this.mediator = mediator;
        this.model = new MyTableModel();
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setHorizontalScrollEnabled(true);
        this.setColumnControlVisible(true);
        this.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    MyDoggyToolWindowManager toolWindowManager = mediator.getToolWindowManager();
                    if (toolWindowManager.getToolWindow((Object)"MotifDetails") != null) {
                        toolWindowManager.unregisterToolWindow("MotifDetails");
                    }
                    JScrollPane scrollPane = new JScrollPane((Component)((Object)new RNAMotifDetail(RNAMotifsBrowser.this.model.getRNAMotifAt(RNAMotifsBrowser.this.convertRowIndexToModel(RNAMotifsBrowser.this.getSelectedRow())))));
                    scrollPane.getViewport().setBackground(Color.WHITE);
                    ToolWindow motif = toolWindowManager.registerToolWindow("MotifDetails", "RNA Motif Details", null, (Component)scrollPane, toolWindowManager.getToolWindow((Object)"MotifsRepository").getAnchor());
                    motif.aggregate();
                }
            }

            public void mousePressed(MouseEvent event) {
                RNAMotifsBrowser.this.maybeShowPopup(event);
            }

            public void mouseReleased(MouseEvent event) {
                RNAMotifsBrowser.this.maybeShowPopup(event);
            }

            public void mouseEntered(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Delete RNA Motif");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RNAMotif motif = RNAMotifsBrowser.this.model.getRNAMotifAt(RNAMotifsBrowser.this.convertRowIndexToModel(RNAMotifsBrowser.this.getSelectedRow()));
                if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete the selected motif?")) {
                    new File(Assemble.getMotifsPath() + motif.category + System.getProperty("file.separator") + motif.name + ".rnaml").delete();
                    new File(Assemble.getMotifsPath() + motif.category + System.getProperty("file.separator") + motif.name + ".png").delete();
                    new File(Assemble.getMotifsPath() + motif.category + System.getProperty("file.separator") + motif.name + ".txt").delete();
                    RNAMotifsBrowser.this.model.removeRow(RNAMotifsBrowser.this.convertRowIndexToModel(RNAMotifsBrowser.this.getSelectedRow()));
                }
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem("Delete Motifs Category");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete this category and all its motifs?")) {
                    RNAMotif motif = RNAMotifsBrowser.this.model.getRNAMotifAt(RNAMotifsBrowser.this.convertRowIndexToModel(RNAMotifsBrowser.this.getSelectedRow()));
                    String category = motif.category;
                    for (int i = RNAMotifsBrowser.this.model.getRowCount() - 1; i >= 0; --i) {
                        RNAMotif _motif = RNAMotifsBrowser.this.model.getRNAMotifAt(RNAMotifsBrowser.this.convertRowIndexToModel(i));
                        if (!category.equals(_motif.category)) continue;
                        new File(Assemble.getMotifsPath() + category + System.getProperty("file.separator") + _motif.name + ".rnaml").delete();
                        new File(Assemble.getMotifsPath() + category + System.getProperty("file.separator") + _motif.name + ".png").delete();
                        new File(Assemble.getMotifsPath() + category + System.getProperty("file.separator") + _motif.name + ".txt").delete();
                        RNAMotifsBrowser.this.model.removeRow(RNAMotifsBrowser.this.convertRowIndexToModel(i));
                    }
                    new File(Assemble.getMotifsPath() + motif.category).delete();
                }
            }
        });
        this.popupMenu.add(menuItem);
        this.setOpaque(true);
        this.setVisible(true);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void addNewMotifEntry(File rnamlFile, String categoryName) throws IOException {
        this.model.motifs.add(new RNAMotif(rnamlFile, categoryName));
        this.model.fireTableRowsInserted(this.model.motifs.size() - 1, this.model.motifs.size() - 1);
    }

    private class RNAMotifDetail
    extends JXPanel {
        private RNAMotif motif;
        private JButton cancel;
        private JEditorPane comment;
        private JScrollPane jScrollPane1;
        private JScrollPane jScrollPane2;
        private JButton apply;
        private JXTable sequencesTable;
        private JLabel snapshot;

        public RNAMotifDetail(RNAMotif motif) {
            this.motif = motif;
            this.initComponents();
        }

        private void initComponents() {
            this.setBackground(Color.WHITE);
            this.jScrollPane1 = new JScrollPane();
            this.comment = new JEditorPane();
            this.comment.setEditorKit(new HTMLEditorKit());
            this.comment.setText("<h1><u>" + this.motif.name + "</u></h1>" + this.motif.comment);
            this.jScrollPane2 = new JScrollPane();
            this.sequencesTable = new JXTable();
            this.sequencesTable.setBackground(Color.WHITE);
            this.sequencesTable.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            this.snapshot = new JLabel(new ImageIcon(Assemble.getMotifsPath() + this.motif.category + System.getProperty("file.separator") + this.motif.name + ".png"));
            this.apply = new JButton();
            this.cancel = new JButton();
            this.comment.setBorder(null);
            this.comment.setEditable(false);
            this.jScrollPane1.setViewportView(this.comment);
            this.comment.setCaretPosition(0);
            Object[][] objects = new Object[this.motif.motifSequences.size()][4];
            for (int i = 0; i < this.motif.motifSequences.size(); ++i) {
                objects[i][0] = ((SequenceLinkedToListOfResidues3D)this.motif.motifSequences.get(i)).sequence;
                objects[i][1] = ((SequenceLinkedToListOfResidues3D)this.motif.motifSequences.get(i)).sequence.length();
                objects[i][2] = "???";
                objects[i][3] = "Link";
            }
            this.sequencesTable.setModel((TableModel)new DefaultTableModel(objects, new String[]{"Motif Sequences", "Length", "Your Sequences", "Link Selection"}){
                Class[] types;
                boolean[] canEdit;
                {
                    this.types = new Class[]{String.class, String.class, String.class, String.class};
                    this.canEdit = new boolean[]{false, false, true, true};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
            this.sequencesTable.getTableHeader().setReorderingAllowed(false);
            this.sequencesTable.getColumn((Object)"Link Selection").setCellRenderer(new ButtonRenderer());
            this.sequencesTable.getColumn((Object)"Link Selection").setCellEditor(new ButtonEditor(new JCheckBox()));
            this.sequencesTable.getColumn((Object)"Link Selection").setMaxWidth(150);
            this.jScrollPane2.setViewportView((Component)this.sequencesTable);
            this.snapshot.setBackground(Color.WHITE);
            this.snapshot.setVerticalAlignment(1);
            this.snapshot.setBorder(BorderFactory.createEtchedBorder());
            this.apply.setText("Apply");
            this.apply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        RNAMotifDetail.this.applyActionPerformed(evt);
                    }
                    catch (BiologicalSymbolException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.cancel.setText("Cancel");
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RNAMotifsBrowser.this.mediator.getToolWindowManager().unregisterToolWindow("MotifDetails");
                }
            });
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.snapshot).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, 0, 0, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 345, Short.MAX_VALUE)).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cancel).addPreferredGap(0).add((Component)this.apply).add(38, 38, 38)))));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 188, -2).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 139, Short.MAX_VALUE)).add((Component)this.snapshot, -1, 335, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.cancel).add((Component)this.apply)).addContainerGap()));
        }

        private void applyActionPerformed(ActionEvent evt) throws BiologicalSymbolException {
            int i;
            int i2;
            for (Chain c : this.motif.userChains) {
                if (c != null) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "You have to link all the sequences of the motif!!");
                return;
            }
            float[] center = new float[]{0.0f, 0.0f, 0.0f};
            int atomNb = 0;
            for (i2 = 0; i2 < this.motif.userChains.length; ++i2) {
                for (Residue r : this.motif.userChains[i2].getResidues()) {
                    for (Atom a : r.getAtoms()) {
                        ++atomNb;
                        float[] atc = a.getFloat();
                        for (int j = 0; j < 3; ++j) {
                            int n = j;
                            center[n] = center[n] + atc[j];
                        }
                    }
                }
            }
            if (atomNb > 0) {
                for (i2 = 0; i2 < 3; ++i2) {
                    center[i2] = center[i2] / (float)atomNb;
                }
            }
            for (i2 = 0; i2 < this.motif.motifSequences.size(); ++i2) {
                List residues3D = ((SequenceLinkedToListOfResidues3D)this.motif.motifSequences.get(i2)).residues3D;
                char[] userSequence = this.motif.userChains[i2].getSequence().toCharArray();
                for (int j = 0; j < residues3D.size(); ++j) {
                    Residue3D residue3D = (Residue3D)residues3D.get(j);
                    Residue3D newResidue3D = residue3D.createNewResidue3D(userSequence[j]);
                    Residue assembleResidue = this.motif.userChains[i2].getResidue(j);
                    for (Residue3D.Atom a : newResidue3D.getAtoms()) {
                        Atom _a;
                        if (!a.hasCoordinatesFilled() || (_a = assembleResidue.getAtom(a.getName())) == null) continue;
                        _a.setCoord(a.getX(), a.getY(), a.getZ());
                    }
                }
            }
            float[] newCenter = new float[]{0.0f, 0.0f, 0.0f};
            for (i = 0; i < this.motif.userChains.length; ++i) {
                for (Residue r : this.motif.userChains[i].getResidues()) {
                    for (Atom a : r.getAtoms()) {
                        float[] atc = a.getFloat();
                        for (int j = 0; j < 3; ++j) {
                            int n = j;
                            newCenter[n] = newCenter[n] + atc[j];
                        }
                    }
                }
            }
            if (atomNb > 0) {
                for (i = 0; i < 3; ++i) {
                    newCenter[i] = newCenter[i] / (float)atomNb;
                }
            }
            UserSelection selection = new UserSelection(RNAMotifsBrowser.this.mediator, this.motif.name);
            for (Chain chain : this.motif.userChains) {
                for (Residue assembleResidue : chain.getResidues()) {
                    assembleResidue.translate(center[0] - newCenter[0], center[1] - newCenter[1], center[2] - newCenter[2]);
                    for (Atom a : assembleResidue.getAtoms()) {
                        selection.add(a);
                    }
                }
            }
            RNAMotifsBrowser.this.mediator.get3DModel().fireModelModified();
            RNAMotifsBrowser.this.mediator.getSecondaryStructureNavigator().addUserSelection(selection);
        }

        private void cancelActionPerformed(ActionEvent evt) {
        }

        public class ButtonEditor
        extends DefaultCellEditor {
            protected JButton button;
            private String label;
            private boolean isPushed;
            private int selectedRow;

            public ButtonEditor(JCheckBox checkBox) {
                super(checkBox);
                this.button = new JButton();
                this.button.setOpaque(true);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ButtonEditor.this.fireEditingStopped();
                    }
                });
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (isSelected) {
                    this.button.setForeground(table.getSelectionForeground());
                    this.button.setBackground(table.getSelectionBackground());
                } else {
                    this.button.setForeground(table.getForeground());
                    this.button.setBackground(table.getBackground());
                }
                this.label = value == null ? "" : value.toString();
                this.button.setText(this.label);
                this.isPushed = true;
                this.selectedRow = row;
                return this.button;
            }

            public Object getCellEditorValue() {
                if (this.isPushed && RNAMotifsBrowser.this.mediator.getGlobalSelection().getSelectedChains().size() != 0) {
                    Chain selectedChain = RNAMotifsBrowser.this.mediator.getGlobalSelection().getSelectedChains().iterator().next();
                    if (((String)RNAMotifDetail.this.sequencesTable.getValueAt(this.selectedRow, 0)).length() != selectedChain.getSequence().length()) {
                        JOptionPane.showMessageDialog((Component)((Object)RNAMotifDetail.this), "Your selection should have the same size than the sequence in the motif!!");
                    } else {
                        RNAMotifDetail.this.sequencesTable.setValueAt((Object)selectedChain.getSequence(), this.selectedRow, 2);
                        ((RNAMotif)((RNAMotifDetail)RNAMotifDetail.this).motif).userChains[this.selectedRow] = selectedChain;
                    }
                }
                this.isPushed = false;
                return new String(this.label);
            }

            public boolean stopCellEditing() {
                this.isPushed = false;
                return super.stopCellEditing();
            }

            protected void fireEditingStopped() {
                super.fireEditingStopped();
            }
        }

        public class ButtonRenderer
        extends JButton
        implements TableCellRenderer {
            public ButtonRenderer() {
                this.setOpaque(true);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(UIManager.getColor("Button.background"));
                }
                this.setText(value == null ? "" : value.toString());
                return this;
            }
        }
    }

    private class RNAMotif {
        private String name;
        private String category;
        private String comment;
        private Date date;
        private List<SequenceLinkedToListOfResidues3D> motifSequences;
        private Chain[] userChains;

        private RNAMotif(File rnamlFile, String category) throws IOException {
            Document doc = null;
            try {
                doc = new SAXBuilder().build(rnamlFile);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List molecules = doc.getRootElement().getChildren("molecule");
            List bases = doc.getRootElement().getChild("tertiary-structure").getChildren("base");
            this.motifSequences = new ArrayList<SequenceLinkedToListOfResidues3D>(molecules.size());
            this.userChains = new Chain[molecules.size()];
            for (int i = 0; i < molecules.size(); ++i) {
                Element molecule = (Element)molecules.get(i);
                char[] moleculeSequence = molecule.getChild("sequence").getChild("seq-data").getText().toCharArray();
                String moleculeId = molecule.getAttributeValue("id");
                ArrayList<Adenine3D> residues3D = new ArrayList<Adenine3D>();
                for (Object o : bases) {
                    Element base = (Element)o;
                    if (!moleculeId.equals(base.getAttributeValue("molecule-id"))) continue;
                    char symbol = moleculeSequence[Integer.parseInt(base.getAttributeValue("id")) - 1];
                    Adenine3D residue3D = null;
                    switch (symbol) {
                        case 'A': {
                            residue3D = new Adenine3D(null);
                            break;
                        }
                        case 'U': {
                            residue3D = new Uridine3D(null);
                            break;
                        }
                        case 'G': {
                            residue3D = new Guanine3D(null);
                            break;
                        }
                        case 'C': {
                            residue3D = new Cytosine3D(null);
                            break;
                        }
                    }
                    if (residue3D == null) continue;
                    for (Object _o : base.getChildren("atom")) {
                        residue3D.setAtomCoordinates(((Element)_o).getAttributeValue("type"), Float.parseFloat(((Element)_o).getAttributeValue("x")), Float.parseFloat(((Element)_o).getAttributeValue("y")), Float.parseFloat(((Element)_o).getAttributeValue("z")));
                    }
                    residues3D.add(residue3D);
                }
                this.motifSequences.add(new SequenceLinkedToListOfResidues3D(molecule.getChild("sequence").getChild("seq-data").getText(), residues3D));
            }
            this.name = rnamlFile.getName().split("\\.")[0];
            this.category = category;
            String line = null;
            BufferedReader buff = new BufferedReader(new FileReader(new File(rnamlFile.getParentFile(), this.name + ".txt")));
            StringBuilder _comment = new StringBuilder();
            line = null;
            while ((line = buff.readLine()) != null) {
                _comment.append(line);
                _comment.append("<br>");
            }
            buff.close();
            this.comment = _comment.toString();
            this.date = new Date(rnamlFile.lastModified());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SequenceLinkedToListOfResidues3D {
        private String sequence;
        private List<Residue3D> residues3D;

        private SequenceLinkedToListOfResidues3D(String sequence, List<Residue3D> residues3D) {
            this.sequence = sequence;
            this.residues3D = residues3D;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private List<RNAMotif> motifs;
        private String[] columnNames = new String[]{"Motif Name", "Category", "Date"};

        private MyTableModel() {
            this.motifs = new ArrayList<RNAMotif>();
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    File[] categories;
                    for (File category : categories = new File(Assemble.getMotifsPath()).listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !file.getName().equals(".svn");
                        }
                    })) {
                        File[] rnamlFiles;
                        for (File rnamlFile : rnamlFiles = category.listFiles(new FileFilter(){

                            public boolean accept(File file) {
                                return file.getName().endsWith(".rnaml");
                            }
                        })) {
                            MyTableModel.this.motifs.add(new RNAMotif(rnamlFile, category.getName()));
                        }
                    }
                    return null;
                }
            }.execute();
        }

        public Object getValueAt(int row, int col) {
            RNAMotif m = this.motifs.get(row);
            switch (col) {
                case 0: {
                    return m.name;
                }
                case 1: {
                    return m.category;
                }
                case 2: {
                    return new SimpleDateFormat("yyyy.MM.dd HH:mm").format(m.date);
                }
            }
            return null;
        }

        public RNAMotif getRNAMotifAt(int row) {
            return this.motifs.get(row);
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getRowCount() {
            return this.motifs.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public void removeRow(int row) {
            this.motifs.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }
}

