/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Panel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RenderingDialog
extends JFrame
implements ChangeListener {
    private JPanel main = new JPanel();
    private JPanel down = new JPanel();
    private JPanel buttons = new JPanel();
    private JLabel dotAtomSizeL = new JLabel("Size of the Atoms (Dot)");
    private JLabel lineLinkSizeL = new JLabel("Width of the Atom links (Line)");
    private JLabel lineBackboneSizeL = new JLabel("Width of the backbone (Line)");
    private JLabel ballRadiusL = new JLabel("Atoms ball radius");
    private JLabel linkStickRadiusL = new JLabel("Links stick radius");
    private JLabel pairStickRadiusL = new JLabel("Pairs stick radius");
    private JLabel bbStickRadiusL = new JLabel("Backbone stick radius (Tube)");
    private JLabel mouseSensitivityL = new JLabel("Mouse Sensitivity");
    private JLabel ambientL = new JLabel("Ambient Light");
    private JLabel specularL = new JLabel("Specular Light");
    private JLabel diffuseL = new JLabel("Diffuse Light");
    private JLabel shininessL = new JLabel("Material Shininess");
    private JLabel reflectionL = new JLabel("Specular Reflection");
    private JSlider dotAtomSize;
    private JSlider lineLinkSize;
    private JSlider lineBackboneSize;
    private JSlider ballRadius;
    private JSlider linkStickRadius;
    private JSlider pairStickRadius;
    private JSlider bbStickRadius;
    private JSlider mouseSensitivity;
    private JSlider ambient;
    private JSlider specular;
    private JSlider diffuse;
    private JSlider shininess;
    private JSlider reflection;
    private Renderer renderer;
    Mediator mediator;

    public RenderingDialog(Mediator mediator) {
        this.mediator = mediator;
        this.renderer = mediator.getRenderer();
        this.dotAtomSize = new JSlider(1, 12, mediator.getRenderer().getDOT_ATOM_SIZE());
        this.lineLinkSize = new JSlider(1, 12, mediator.getRenderer().getLINE_LINK_WIDTH());
        this.lineBackboneSize = new JSlider(1, 12, mediator.getRenderer().getLINE_BACKBONE_WIDTH());
        this.ballRadius = new JSlider(1, 20, (int)(10.0f * mediator.getRenderer().getBALL_RADIUS()));
        this.linkStickRadius = new JSlider(1, 20, (int)(10.0f * mediator.getRenderer().getLINK_RADIUS()));
        this.pairStickRadius = new JSlider(1, 40, (int)(10.0f * mediator.getRenderer().getPAIR_RADIUS()));
        this.bbStickRadius = new JSlider(1, 40, (int)(10.0f * mediator.getRenderer().getBB_RADIUS()));
        this.mouseSensitivity = new JSlider(1, 10, mediator.getRenderer().getMouseSensitivity());
        this.ambient = new JSlider(1, 20, (int)(20.0f * this.renderer.getLightAmbient()));
        this.specular = new JSlider(1, 20, (int)(20.0f * this.renderer.getLightSpecular()));
        this.diffuse = new JSlider(1, 20, (int)(20.0f * this.renderer.getLightDiffuse()));
        this.shininess = new JSlider(1, 20, this.renderer.getMaterialShininess() / 5);
        this.reflection = new JSlider(1, 20, (int)(20.0f * this.renderer.getSpecularReflection()));
        SideView sideView = new SideView();
        this.setTitle("Rendering Parameters");
        Container zone = this.getContentPane();
        zone.setLayout(new BorderLayout());
        this.main.setLayout(new GridLayout(0, 2));
        this.down.setLayout(new BorderLayout());
        this.buttons.setLayout(new BorderLayout());
        this.dotAtomSize.setMajorTickSpacing(1);
        this.dotAtomSize.setPaintLabels(true);
        this.dotAtomSize.setPaintTicks(true);
        this.dotAtomSize.setSnapToTicks(true);
        this.dotAtomSize.addChangeListener(this);
        this.lineLinkSize.setMajorTickSpacing(1);
        this.lineLinkSize.setPaintLabels(true);
        this.lineLinkSize.setPaintTicks(true);
        this.lineLinkSize.setSnapToTicks(true);
        this.lineLinkSize.addChangeListener(this);
        this.lineBackboneSize.setMajorTickSpacing(1);
        this.lineBackboneSize.setPaintLabels(true);
        this.lineBackboneSize.setPaintTicks(true);
        this.lineBackboneSize.setSnapToTicks(true);
        this.lineBackboneSize.addChangeListener(this);
        this.ballRadius.setMajorTickSpacing(1);
        this.ballRadius.setPaintTicks(true);
        this.ballRadius.setSnapToTicks(true);
        this.ballRadius.addChangeListener(this);
        this.linkStickRadius.setMajorTickSpacing(1);
        this.linkStickRadius.setPaintTicks(true);
        this.linkStickRadius.setSnapToTicks(true);
        this.linkStickRadius.addChangeListener(this);
        this.pairStickRadius.setMajorTickSpacing(1);
        this.pairStickRadius.setPaintTicks(true);
        this.pairStickRadius.setSnapToTicks(true);
        this.pairStickRadius.addChangeListener(this);
        this.bbStickRadius.setMajorTickSpacing(1);
        this.bbStickRadius.setPaintTicks(true);
        this.bbStickRadius.setSnapToTicks(true);
        this.bbStickRadius.addChangeListener(this);
        this.mouseSensitivity.setMajorTickSpacing(5);
        this.mouseSensitivity.setMinorTickSpacing(1);
        this.mouseSensitivity.setPaintTicks(true);
        this.mouseSensitivity.setSnapToTicks(true);
        this.mouseSensitivity.addChangeListener(this);
        this.ambient.setMajorTickSpacing(5);
        this.ambient.setMinorTickSpacing(1);
        this.ambient.setPaintTicks(true);
        this.ambient.setSnapToTicks(true);
        this.ambient.addChangeListener(this);
        this.specular.setMajorTickSpacing(5);
        this.specular.setMinorTickSpacing(1);
        this.specular.setPaintTicks(true);
        this.specular.setSnapToTicks(true);
        this.specular.addChangeListener(this);
        this.diffuse.setMajorTickSpacing(5);
        this.diffuse.setMinorTickSpacing(1);
        this.diffuse.setPaintTicks(true);
        this.diffuse.setSnapToTicks(true);
        this.diffuse.addChangeListener(this);
        this.shininess.setMajorTickSpacing(5);
        this.shininess.setMinorTickSpacing(1);
        this.shininess.setPaintTicks(true);
        this.shininess.setSnapToTicks(true);
        this.shininess.addChangeListener(this);
        this.reflection.setMajorTickSpacing(5);
        this.reflection.setMinorTickSpacing(1);
        this.reflection.setPaintTicks(true);
        this.reflection.setSnapToTicks(true);
        this.reflection.addChangeListener(this);
        this.main.add(this.dotAtomSizeL);
        this.main.add(this.dotAtomSize);
        this.main.add(this.lineLinkSizeL);
        this.main.add(this.lineLinkSize);
        this.main.add(this.lineBackboneSizeL);
        this.main.add(this.lineBackboneSize);
        this.main.add(this.ballRadiusL);
        this.main.add(this.ballRadius);
        this.main.add(this.linkStickRadiusL);
        this.main.add(this.linkStickRadius);
        this.main.add(this.pairStickRadiusL);
        this.main.add(this.pairStickRadius);
        this.main.add(this.bbStickRadiusL);
        this.main.add(this.bbStickRadius);
        this.main.add(this.mouseSensitivityL);
        this.main.add(this.mouseSensitivity);
        this.main.add(this.ambientL);
        this.main.add(this.ambient);
        this.main.add(this.specularL);
        this.main.add(this.specular);
        this.main.add(this.diffuseL);
        this.main.add(this.diffuse);
        this.main.add(this.shininessL);
        this.main.add(this.shininess);
        this.main.add(this.reflectionL);
        this.main.add(this.reflection);
        this.down.add((Component)this.buttons, "East");
        zone.add((Component)this.main, "North");
        zone.add((Component)sideView, "Center");
        zone.add((Component)this.down, "South");
        this.pack();
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.dotAtomSize) {
            this.mediator.getRenderer().setDOT_ATOM_SIZE(this.dotAtomSize.getValue());
        }
        if (source == this.lineLinkSize) {
            this.mediator.getRenderer().setLINE_LINK_WIDTH(this.lineLinkSize.getValue());
        }
        if (source == this.lineBackboneSize) {
            this.mediator.getRenderer().setLINE_BACKBONE_WIDTH(this.lineBackboneSize.getValue());
        }
        if (source == this.ballRadius) {
            this.mediator.getRenderer().setBALL_RADIUS((float)this.ballRadius.getValue() / 10.0f);
        }
        if (source == this.linkStickRadius) {
            this.mediator.getRenderer().setLINK_RADIUS((float)this.linkStickRadius.getValue() / 10.0f);
        }
        if (source == this.pairStickRadius) {
            this.mediator.getRenderer().setPAIR_RADIUS((float)this.pairStickRadius.getValue() / 10.0f);
        }
        if (source == this.bbStickRadius) {
            this.mediator.getRenderer().setBB_RADIUS((float)this.bbStickRadius.getValue() / 10.0f);
        }
        if (source == this.mouseSensitivity) {
            this.renderer.setMouseSensitivity(this.mouseSensitivity.getValue());
        }
        if (source == this.ambient) {
            this.renderer.setLightAmbient((float)this.ambient.getValue() / 20.0f);
        }
        if (source == this.specular) {
            this.renderer.setLightSpecular((float)this.specular.getValue() / 20.0f);
        }
        if (source == this.diffuse) {
            this.renderer.setLightDiffuse((float)this.diffuse.getValue() / 20.0f);
        }
        if (source == this.shininess) {
            this.renderer.setMaterialShininess(this.shininess.getValue() * 5);
        }
        if (source == this.reflection) {
            this.renderer.setSpecularReflection(this.reflection.getValue() * 5);
        }
    }

    private class SideView
    extends Panel
    implements ChangeListener {
        private JSlider near;
        private JSlider far;

        public SideView() {
            int tmpfar;
            int tmpnear = RenderingDialog.this.renderer.getNear();
            if (tmpnear < 0) {
                tmpnear = 0;
            }
            if ((tmpfar = RenderingDialog.this.renderer.getFar()) < 0) {
                tmpfar = 0;
            }
            this.near = new JSlider(0, 2000, tmpnear);
            this.far = new JSlider(0, 4000, tmpfar);
            this.near.addChangeListener(this);
            this.far.addChangeListener(this);
            this.setLayout(new GridLayout(0, 2));
            this.add(new JLabel("Near Plane"));
            this.add(this.near);
            this.add(new JLabel("Far Plane"));
            this.add(this.far);
        }

        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (source == this.near) {
                RenderingDialog.this.renderer.setNear(this.near.getValue());
            }
            if (source == this.far) {
                RenderingDialog.this.renderer.setFar(this.far.getValue());
            }
        }
    }
}

