/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.DKnob;
import fr.unistra.ibmc.assemble.gui.event.ModelListener;
import fr.unistra.ibmc.assemble.gui.event.SelectionListener;
import fr.unistra.ibmc.assemble.structures.Angle;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.goloka.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.goloka.core.features.StructuralDomain;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidueManager
extends JXPanel
implements SelectionListener,
ModelListener {
    private boolean direction;
    private Residue residue;
    private Residue nextResidue;
    private Residue previousResidue;
    JPanel top = new JPanel();
    JPanel middle = new JPanel();
    JPanel bottom = new JPanel();
    JPanel bottomRight = new JPanel();
    JButton prev = new JButton("3'->5'");
    JButton changeDirection = new JButton("Change Direction");
    JButton next = new JButton("5'->3'");
    Mediator mediator;
    JCheckBox block = new JCheckBox("Affect the Whole Building Block");
    private List<SelectionListener> selectionListeners;

    public ResidueManager(Mediator mediator) {
        this.mediator = mediator;
        this.mediator.setResidueManager(this);
        this.direction = true;
        this.block.setSelected(false);
        this.prev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ResidueManager.this.previousResidue != null) {
                    for (SelectionListener l : ResidueManager.this.selectionListeners) {
                        l.residuesSelected(new ArrayList<Residue>(Arrays.asList(ResidueManager.this.previousResidue)), false);
                    }
                    ResidueManager.this.setResidue(ResidueManager.this.previousResidue);
                }
            }
        });
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ResidueManager.this.nextResidue != null) {
                    for (SelectionListener l : ResidueManager.this.selectionListeners) {
                        l.residuesSelected(new ArrayList<Residue>(Arrays.asList(ResidueManager.this.nextResidue)), false);
                    }
                    ResidueManager.this.setResidue(ResidueManager.this.nextResidue);
                }
            }
        });
        this.changeDirection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ResidueManager.this.residue != null) {
                    ResidueManager.this.direction = !ResidueManager.this.direction;
                    ResidueManager.this.setResidue(ResidueManager.this.residue);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.top.setLayout(new BorderLayout());
        this.top.add((Component)this.prev, "West");
        this.top.add((Component)this.changeDirection, "Center");
        this.top.add((Component)this.next, "East");
        this.bottom.setLayout(new BorderLayout());
        this.bottom.add((Component)this.bottomRight, "East");
        this.bottom.add((Component)this.block, "West");
        this.add(this.top, "North");
        this.add(this.middle, "Center");
        this.add(this.bottom, "South");
    }

    public void addSelectionListener(SelectionListener l) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<SelectionListener>();
        }
        this.selectionListeners.add(l);
    }

    public Residue getResidue() {
        return this.residue;
    }

    public void clear() {
        this.middle.removeAll();
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public void setResidue(Residue r) {
        this.residue = r;
        fr.unistra.ibmc.paradise.goloka.core.utils.Residue paradiseResidue = (fr.unistra.ibmc.paradise.goloka.core.utils.Residue)r.getResidue3D().getResidues().iterator().next();
        fr.unistra.ibmc.paradise.goloka.core.utils.Residue nextParadiseResidue = paradiseResidue.getNextResidue();
        fr.unistra.ibmc.paradise.goloka.core.utils.Residue previousParadiseResidue = paradiseResidue.getPreviousResidue();
        if (nextParadiseResidue != null) {
            this.nextResidue = this.mediator.get3DModel().getResidue(nextParadiseResidue);
            while (this.nextResidue == null && (nextParadiseResidue = nextParadiseResidue.getNextResidue()) != null) {
                this.nextResidue = this.mediator.get3DModel().getResidue(nextParadiseResidue);
            }
        }
        if (previousParadiseResidue != null) {
            this.previousResidue = this.mediator.get3DModel().getResidue(previousParadiseResidue);
            while (this.previousResidue == null && (previousParadiseResidue = previousParadiseResidue.getPreviousResidue()) != null) {
                this.previousResidue = this.mediator.get3DModel().getResidue(previousParadiseResidue);
            }
        }
        this.prev.setEnabled(this.previousResidue != null);
        this.next.setEnabled(this.nextResidue != null);
        int nbAngle = this.direction ? r.anglesDirect.size() + r.anglesInternal.size() : r.anglesIndirect.size() + r.anglesInternal.size();
        int nbRow = nbAngle / 2;
        if (nbAngle % 2 != 0) {
            ++nbRow;
        }
        this.middle.removeAll();
        this.middle.setLayout(new GridLayout(nbRow, 2));
        if (this.direction) {
            for (Angle angle : r.anglesDirect) {
                this.middle.add(new AngleTwister(angle, Color.yellow));
            }
        } else {
            for (Angle angle : r.anglesIndirect) {
                this.middle.add(new AngleTwister(angle, Color.cyan));
            }
        }
        for (Angle angle : r.anglesInternal) {
            this.middle.add(new AngleTwister(angle, Color.green));
        }
        this.doLayout();
        this.validate();
        this.repaint();
    }

    @Override
    public void residuesSelected(Collection<Residue> residues, boolean isShiftDown) {
        if (this.mediator.getGlobalSelection().getSelectedResidues().size() == 1) {
            this.setResidue(residues.iterator().next());
        }
    }

    @Override
    public void structuralDomainSelected(StructuralDomain structuralDomain, boolean isShiftDown) {
    }

    @Override
    public void atomsSelected(Collection<Atom> atoms, boolean isShiftDown) {
    }

    @Override
    public void interactionSelected(BaseBaseInteraction interaction, boolean isShiftDown) {
    }

    @Override
    public void modelRejected() {
        for (Component c : this.middle.getComponents()) {
            ((AngleTwister)c).update();
        }
    }

    @Override
    public void modelModified() {
        for (Component c : this.middle.getComponents()) {
            ((AngleTwister)c).update();
        }
    }

    public class AngleTwister
    extends JPanel
    implements ChangeListener {
        Angle angle;
        DKnob knob;
        JLabel angleValue = new JLabel(" ");

        public AngleTwister(Angle ang, Color color) {
            this.angle = ang;
            this.setLayout(new BorderLayout());
            if (!this.angle.isValid()) {
                this.knob = new DKnob(this.getBackground());
                this.knob.setEnabled(false);
            } else {
                this.knob = new DKnob(color);
                this.knob.addChangeListener(this);
                float value = this.angle.getDegreeValue();
                this.knob.setValueDegree(value);
                DecimalFormat f = new DecimalFormat("###.0");
                String sValue = f.format(value).replace(',', '.');
                this.angleValue.setText(sValue);
            }
            JPanel center = new JPanel();
            FlowLayout fl = new FlowLayout();
            fl.setAlignment(1);
            center.setLayout(fl);
            this.angleValue.setHorizontalAlignment(0);
            center.add(this.knob);
            this.add((Component)this.angleValue, "North");
            this.add((Component)center, "Center");
            this.setBorder(BorderFactory.createTitledBorder(this.angle.getName()));
        }

        public void stateChanged(ChangeEvent e) {
            float future;
            float old = this.angle.getDegreeValue();
            float rot = old - (future = this.knob.getValueDegree());
            if (rot != 0.0f) {
                this.angle.torsDegree(rot, ResidueManager.this.block.isSelected());
            }
        }

        private void update() {
            try {
                float newValue = this.angle.getDegreeValue();
                DecimalFormat f = new DecimalFormat("###.0");
                String value = f.format(newValue).replace(',', '.');
                this.angleValue.setText(value);
                this.knob.setValueDegree(newValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

